/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.moduleconverter;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.descriptor.DefaultArtifact;
import org.apache.ivy.core.module.descriptor.DefaultModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.ArtifactsExtraAttributesStrategy;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.ArtifactsToModuleDescriptorConverter;
import org.gradle.util.GUtil;
import org.gradle.util.WrapUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultArtifactsToModuleDescriptorConverter
implements ArtifactsToModuleDescriptorConverter {
    public static final ArtifactsExtraAttributesStrategy IVY_FILE_STRATEGY = new ArtifactsExtraAttributesStrategy(){

        @Override
        public Map<String, String> createExtraAttributes(PublishArtifact publishArtifact) {
            return new HashMap<String, String>();
        }
    };
    public static final ArtifactsExtraAttributesStrategy RESOLVE_STRATEGY = new ArtifactsExtraAttributesStrategy(){

        @Override
        public Map<String, String> createExtraAttributes(PublishArtifact publishArtifact) {
            return WrapUtil.toMap("filePath", publishArtifact.getFile().getAbsolutePath());
        }
    };
    private ArtifactsExtraAttributesStrategy artifactsExtraAttributesStrategy;

    public DefaultArtifactsToModuleDescriptorConverter(ArtifactsExtraAttributesStrategy artifactsExtraAttributesStrategy) {
        this.artifactsExtraAttributesStrategy = artifactsExtraAttributesStrategy;
    }

    @Override
    public void addArtifacts(DefaultModuleDescriptor moduleDescriptor, Set<Configuration> configurations) {
        for (Configuration configuration : configurations) {
            for (PublishArtifact publishArtifact : configuration.getArtifacts()) {
                Artifact ivyArtifact = this.createIvyArtifact(publishArtifact, moduleDescriptor.getModuleRevisionId());
                moduleDescriptor.addArtifact(configuration.getName(), ivyArtifact);
            }
        }
    }

    public Artifact createIvyArtifact(PublishArtifact publishArtifact, ModuleRevisionId moduleRevisionId) {
        Map<String, String> extraAttributes = this.artifactsExtraAttributesStrategy.createExtraAttributes(publishArtifact);
        if (GUtil.isTrue(publishArtifact.getClassifier())) {
            extraAttributes.put("m:classifier", publishArtifact.getClassifier());
        }
        return new DefaultArtifact(moduleRevisionId, publishArtifact.getDate(), publishArtifact.getName(), publishArtifact.getType(), publishArtifact.getExtension(), extraAttributes);
    }
}

