/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice;

import java.io.File;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.ivy.Ivy;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.gradle.api.GradleException;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ResolveException;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.ResolvedConfiguration;
import org.gradle.api.artifacts.ResolvedDependency;
import org.gradle.api.internal.artifacts.CachingDependencyResolveContext;
import org.gradle.api.internal.artifacts.DependencyInternal;
import org.gradle.api.internal.artifacts.ivyservice.IvyDependencyResolver;
import org.gradle.api.specs.Spec;
import org.gradle.api.specs.Specs;

public class SelfResolvingDependencyResolver
implements IvyDependencyResolver {
    private final IvyDependencyResolver resolver;

    public SelfResolvingDependencyResolver(IvyDependencyResolver resolver) {
        this.resolver = resolver;
    }

    public IvyDependencyResolver getResolver() {
        return this.resolver;
    }

    public ResolvedConfiguration resolve(final Configuration configuration, Ivy ivy, ModuleDescriptor moduleDescriptor) {
        final ResolvedConfiguration resolvedConfiguration = this.resolver.resolve(configuration, ivy, moduleDescriptor);
        final Set<DependencyInternal> dependencies = configuration.getAllDependencies(DependencyInternal.class);
        return new ResolvedConfiguration(){
            private final CachingDependencyResolveContext resolveContext;
            {
                this.resolveContext = new CachingDependencyResolveContext(configuration.isTransitive());
            }

            @Override
            public Set<File> getFiles(Spec<Dependency> dependencySpec) {
                LinkedHashSet<File> files = new LinkedHashSet<File>();
                Set<Dependency> selectedDependencies = Specs.filterIterable(dependencies, dependencySpec);
                for (DependencyInternal dependencyInternal : selectedDependencies) {
                    this.resolveContext.add(dependencyInternal);
                }
                files.addAll(this.resolveContext.resolve().getFiles());
                files.addAll(resolvedConfiguration.getFiles(dependencySpec));
                return files;
            }

            @Override
            public Set<ResolvedArtifact> getResolvedArtifacts() {
                return resolvedConfiguration.getResolvedArtifacts();
            }

            @Override
            public Set<ResolvedDependency> getFirstLevelModuleDependencies() {
                return resolvedConfiguration.getFirstLevelModuleDependencies();
            }

            @Override
            public Set<ResolvedDependency> getFirstLevelModuleDependencies(Spec<Dependency> dependencySpec) throws ResolveException {
                return resolvedConfiguration.getFirstLevelModuleDependencies(dependencySpec);
            }

            @Override
            public boolean hasError() {
                return resolvedConfiguration.hasError();
            }

            @Override
            public void rethrowFailure() throws GradleException {
                resolvedConfiguration.rethrowFailure();
            }
        };
    }
}

