/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.ivy.core.cache.RepositoryCacheManager;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.settings.IvySettings;
import org.apache.ivy.plugins.repository.Repository;
import org.apache.ivy.plugins.repository.TransferEvent;
import org.apache.ivy.plugins.repository.TransferListener;
import org.apache.ivy.plugins.resolver.ChainResolver;
import org.apache.ivy.plugins.resolver.DependencyResolver;
import org.apache.ivy.plugins.resolver.RepositoryResolver;
import org.gradle.api.internal.artifacts.ivyservice.ClientModuleResolver;
import org.gradle.api.internal.artifacts.ivyservice.LocalFileRepositoryCacheManager;
import org.gradle.api.internal.artifacts.ivyservice.NoOpRepositoryCacheManager;
import org.gradle.api.internal.artifacts.ivyservice.SettingsConverter;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.logging.ProgressLogger;
import org.gradle.logging.ProgressLoggerFactory;
import org.gradle.util.Clock;
import org.gradle.util.WrapUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSettingsConverter
implements SettingsConverter {
    private static Logger logger = Logging.getLogger(DefaultSettingsConverter.class);
    private RepositoryCacheManager repositoryCacheManager;
    private IvySettings ivySettings;
    private final ProgressLoggerFactory progressLoggerFactory;
    private final TransferListener transferListener = new ProgressLoggingTransferListener();

    public DefaultSettingsConverter(ProgressLoggerFactory progressLoggerFactory) {
        this.progressLoggerFactory = progressLoggerFactory;
    }

    private static String getLengthText(TransferEvent evt) {
        return DefaultSettingsConverter.getLengthText(evt.isTotalLengthSet() ? Long.valueOf(evt.getTotalLength()) : null);
    }

    private static String getLengthText(Long bytes) {
        if (bytes == null) {
            return "unknown size";
        }
        if (bytes < 1024L) {
            return bytes + " B";
        }
        if (bytes < 0x100000L) {
            return bytes / 1024L + " KB";
        }
        return String.format("%.2f MB", (double)bytes.longValue() / 1048576.0);
    }

    @Override
    public IvySettings convertForPublish(List<DependencyResolver> publishResolvers, File gradleUserHome, DependencyResolver internalRepository) {
        if (this.ivySettings != null) {
            return this.ivySettings;
        }
        Clock clock = new Clock();
        IvySettings ivySettings = this.createIvySettings(gradleUserHome);
        this.initializeResolvers(ivySettings, this.getAllResolvers(Collections.<DependencyResolver>emptyList(), publishResolvers, new DependencyResolver[0]));
        logger.debug("Timing: Ivy convert for publish took {}", clock.getTime());
        return ivySettings;
    }

    @Override
    public IvySettings convertForResolve(List<DependencyResolver> dependencyResolvers, File gradleUserHome, DependencyResolver internalRepository, Map<String, ModuleDescriptor> clientModuleRegistry) {
        if (this.ivySettings != null) {
            return this.ivySettings;
        }
        Clock clock = new Clock();
        ChainResolver userResolverChain = this.createUserResolverChain(dependencyResolvers, internalRepository);
        ClientModuleResolver clientModuleResolver = this.createClientModuleResolver(clientModuleRegistry, userResolverChain);
        ChainResolver outerChain = this.createOuterChain(userResolverChain, clientModuleResolver);
        IvySettings ivySettings = this.createIvySettings(gradleUserHome);
        this.initializeResolvers(ivySettings, this.getAllResolvers(dependencyResolvers, Collections.<DependencyResolver>emptyList(), new DependencyResolver[]{internalRepository, userResolverChain, clientModuleResolver, outerChain}));
        ivySettings.setDefaultResolver("clientModuleChain");
        logger.debug("Timing: Ivy convert for resolve took {}", clock.getTime());
        return ivySettings;
    }

    private List<DependencyResolver> getAllResolvers(List<DependencyResolver> classpathResolvers, List<DependencyResolver> otherResolvers, DependencyResolver ... resolvers) {
        ArrayList<DependencyResolver> allResolvers = new ArrayList<DependencyResolver>(otherResolvers);
        allResolvers.addAll(classpathResolvers);
        allResolvers.addAll(WrapUtil.toList(resolvers));
        return allResolvers;
    }

    private ChainResolver createOuterChain(ChainResolver userResolverChain, ClientModuleResolver clientModuleResolver) {
        ChainResolver clientModuleChain = new ChainResolver();
        clientModuleChain.setName("clientModuleChain");
        clientModuleChain.setReturnFirst(true);
        clientModuleChain.add((DependencyResolver)clientModuleResolver);
        clientModuleChain.add((DependencyResolver)userResolverChain);
        return clientModuleChain;
    }

    private ClientModuleResolver createClientModuleResolver(Map<String, ModuleDescriptor> clientModuleRegistry, ChainResolver userResolverChain) {
        return new ClientModuleResolver("clientModule", clientModuleRegistry, (DependencyResolver)userResolverChain);
    }

    private ChainResolver createUserResolverChain(List<DependencyResolver> classpathResolvers, DependencyResolver internalRepository) {
        ChainResolver chainResolver = new ChainResolver();
        chainResolver.setName("chain");
        chainResolver.add(internalRepository);
        chainResolver.setChangingPattern(".*-SNAPSHOT");
        chainResolver.setChangingMatcher("regexp");
        chainResolver.setReturnFirst(true);
        for (DependencyResolver classpathResolver : classpathResolvers) {
            chainResolver.add(classpathResolver);
        }
        return chainResolver;
    }

    private IvySettings createIvySettings(File gradleUserHome) {
        IvySettings ivySettings = new IvySettings();
        ivySettings.setDefaultCache(new File(gradleUserHome, "cache"));
        ivySettings.setDefaultCacheIvyPattern("[organisation]/[module](/[branch])/ivy-[revision].xml");
        ivySettings.setDefaultCacheArtifactPattern("[organisation]/[module](/[branch])/[type]s/[artifact]-[revision](-[classifier])(.[ext])");
        ivySettings.setVariable("ivy.log.modules.in.use", "false");
        this.setRepositoryCacheManager(ivySettings);
        return ivySettings;
    }

    private void setRepositoryCacheManager(IvySettings ivySettings) {
        if (this.repositoryCacheManager == null) {
            this.repositoryCacheManager = ivySettings.getDefaultRepositoryCacheManager();
        } else {
            ivySettings.setDefaultRepositoryCacheManager(this.repositoryCacheManager);
        }
    }

    private void initializeResolvers(IvySettings ivySettings, List<DependencyResolver> allResolvers) {
        for (DependencyResolver dependencyResolver : allResolvers) {
            Repository repository;
            ivySettings.addResolver(dependencyResolver);
            RepositoryCacheManager cacheManager = dependencyResolver.getRepositoryCacheManager();
            if (cacheManager != ivySettings.getDefaultRepositoryCacheManager() && !(cacheManager instanceof NoOpRepositoryCacheManager) && !(cacheManager instanceof LocalFileRepositoryCacheManager)) {
                throw new IllegalStateException(String.format("Unexpected cache manager %s for repository %s (%s)", cacheManager, dependencyResolver.getName(), dependencyResolver));
            }
            if (!(dependencyResolver instanceof RepositoryResolver) || (repository = ((RepositoryResolver)dependencyResolver).getRepository()).hasTransferListener(this.transferListener)) continue;
            repository.addTransferListener(this.transferListener);
        }
    }

    public IvySettings getIvySettings() {
        return this.ivySettings;
    }

    public void setIvySettings(IvySettings ivySettings) {
        this.ivySettings = ivySettings;
    }

    private class ProgressLoggingTransferListener
    implements TransferListener {
        private ProgressLogger logger;
        private long total;

        private ProgressLoggingTransferListener() {
        }

        public void transferProgress(TransferEvent evt) {
            if (evt.getResource().isLocal()) {
                return;
            }
            if (evt.getEventType() == 1) {
                this.total = 0L;
                this.logger = DefaultSettingsConverter.this.progressLoggerFactory.newOperation(DefaultSettingsConverter.class);
                String description = String.format("%s %s", StringUtils.capitalize((String)this.getRequestType(evt)), evt.getResource().getName());
                this.logger.setDescription(description);
                this.logger.setLoggingHeader(description);
                this.logger.started();
            }
            if (evt.getEventType() == 3) {
                this.total += evt.getLength();
                this.logger.progress(String.format("%s/%s %sed", DefaultSettingsConverter.getLengthText(this.total), DefaultSettingsConverter.getLengthText(evt), this.getRequestType(evt)));
            }
            if (evt.getEventType() == 2) {
                this.logger.completed();
            }
        }

        private String getRequestType(TransferEvent evt) {
            if (evt.getRequestType() == 6) {
                return "upload";
            }
            return "download";
        }
    }
}

