/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.dsl.dependencies;

import java.util.HashMap;
import java.util.Map;
import org.gradle.api.IllegalDependencyNotation;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ExternalDependency;
import org.gradle.api.internal.ClassGenerator;
import org.gradle.api.internal.artifacts.dsl.dependencies.IDependencyImplementationFactory;
import org.gradle.api.internal.artifacts.dsl.dependencies.ModuleFactoryHelper;
import org.gradle.util.ConfigureUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MapModuleNotationParser
implements IDependencyImplementationFactory {
    private final ClassGenerator classGenerator;

    MapModuleNotationParser(ClassGenerator classGenerator) {
        this.classGenerator = classGenerator;
    }

    @Override
    public <T extends Dependency> T createDependency(Class<T> type, Object userDependencyDescription) throws IllegalDependencyNotation {
        HashMap<String, Object> args = new HashMap<String, Object>((Map)userDependencyDescription);
        String group = this.getAndRemove(args, "group");
        String name = this.getAndRemove(args, "name");
        String version = this.getAndRemove(args, "version");
        String configuration = this.getAndRemove(args, "configuration");
        ExternalDependency dependency = (ExternalDependency)this.classGenerator.newInstance(type, group, name, version, configuration);
        ModuleFactoryHelper.addExplicitArtifactsIfDefined(dependency, this.getAndRemove(args, "ext"), this.getAndRemove(args, "classifier"));
        ConfigureUtil.configureByMap(args, dependency);
        return (T)((Dependency)type.cast(dependency));
    }

    private String getAndRemove(Map<String, Object> args, String key) {
        Object value = args.get(key);
        args.remove(key);
        return value != null ? value.toString() : null;
    }
}

