/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.dsl.dependencies;

import org.gradle.api.IllegalDependencyNotation;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.ClassGenerator;
import org.gradle.api.internal.ClassPathRegistry;
import org.gradle.api.internal.artifacts.dependencies.DefaultSelfResolvingDependency;
import org.gradle.api.internal.artifacts.dsl.dependencies.DependencyFactory;
import org.gradle.api.internal.artifacts.dsl.dependencies.IDependencyImplementationFactory;
import org.gradle.api.internal.file.FileResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassPathDependencyFactory
implements IDependencyImplementationFactory {
    private final ClassPathRegistry classPathRegistry;
    private final ClassGenerator classGenerator;
    private final FileResolver fileResolver;

    public ClassPathDependencyFactory(ClassGenerator classGenerator, ClassPathRegistry classPathRegistry, FileResolver fileResolver) {
        this.classGenerator = classGenerator;
        this.classPathRegistry = classPathRegistry;
        this.fileResolver = fileResolver;
    }

    @Override
    public <T extends Dependency> T createDependency(Class<T> type, Object userDependencyDescription) throws IllegalDependencyNotation {
        if (userDependencyDescription instanceof DependencyFactory.ClassPathNotation) {
            DependencyFactory.ClassPathNotation classPathNotation = (DependencyFactory.ClassPathNotation)((Object)userDependencyDescription);
            FileCollection files = this.fileResolver.resolveFiles(this.classPathRegistry.getClassPathFiles(classPathNotation.name()));
            return (T)((Dependency)type.cast(this.classGenerator.newInstance(DefaultSelfResolvingDependency.class, files)));
        }
        throw new IllegalDependencyNotation();
    }
}

