/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.dsl;

import groovy.lang.Closure;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.ivy.plugins.resolver.AbstractResolver;
import org.apache.ivy.plugins.resolver.DependencyResolver;
import org.apache.ivy.plugins.resolver.FileSystemResolver;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.artifacts.dsl.ArtifactRepository;
import org.gradle.api.artifacts.dsl.IvyArtifactRepository;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.artifacts.maven.GroovyMavenDeployer;
import org.gradle.api.artifacts.maven.MavenResolver;
import org.gradle.api.internal.ClassGenerator;
import org.gradle.api.internal.artifacts.DefaultResolverContainer;
import org.gradle.api.internal.artifacts.ivyservice.ResolverFactory;
import org.gradle.api.internal.artifacts.repositories.ArtifactRepositoryInternal;
import org.gradle.util.ConfigureUtil;
import org.gradle.util.GUtil;
import org.gradle.util.HashUtil;
import org.gradle.util.WrapUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultRepositoryHandler
extends DefaultResolverContainer
implements RepositoryHandler {
    public DefaultRepositoryHandler(ResolverFactory resolverFactory, ClassGenerator classGenerator) {
        super(resolverFactory, classGenerator);
    }

    public FileSystemResolver flatDir(Map args) {
        Object[] rootDirPaths = this.getFlatDirRootDirs(args);
        File[] rootDirs = new File[rootDirPaths.length];
        for (int i = 0; i < rootDirPaths.length; ++i) {
            Object rootDirPath = rootDirPaths[i];
            rootDirs[i] = new File(rootDirPath.toString());
        }
        FileSystemResolver resolver = this.getResolverFactory().createFlatDirResolver(this.getNameFromMap(args, HashUtil.createHash(GUtil.join(rootDirPaths, ""))), rootDirs);
        return (FileSystemResolver)this.add(resolver);
    }

    private String getNameFromMap(Map args, String defaultName) {
        Object name = args.get("name");
        return name != null ? name.toString() : defaultName;
    }

    private Object[] getFlatDirRootDirs(Map args) {
        List<String> dirs = this.createStringifiedListFromMapArg(args, "dirs");
        if (dirs == null) {
            throw new InvalidUserDataException("You must specify dirs for the flat dir repository.");
        }
        return dirs.toArray();
    }

    private List<String> createStringifiedListFromMapArg(Map args, String argName) {
        Object dirs = args.get(argName);
        if (dirs == null) {
            return null;
        }
        Set<Object> iterable = dirs instanceof Iterable ? (Set<Object>)dirs : WrapUtil.toSet(dirs);
        ArrayList<String> list = new ArrayList<String>();
        for (Object t : iterable) {
            list.add(t.toString());
        }
        return list;
    }

    @Override
    public DependencyResolver mavenCentral() {
        return this.mavenCentral(Collections.emptyMap());
    }

    public DependencyResolver mavenCentral(Map args) {
        List<String> urls = this.createStringifiedListFromMapArg(args, "urls");
        return this.add(this.getResolverFactory().createMavenRepoResolver(this.getNameFromMap(args, "MavenRepo"), "http://repo1.maven.org/maven2/", urls == null ? new String[]{} : urls.toArray(new String[urls.size()])));
    }

    @Override
    public DependencyResolver mavenLocal() {
        return this.add(this.getResolverFactory().createMavenLocalResolver("MavenLocal"));
    }

    public DependencyResolver mavenRepo(Map args) {
        return this.mavenRepo(args, (Closure)null);
    }

    public DependencyResolver mavenRepo(Map args, Closure configClosure) {
        List<String> urls = this.createStringifiedListFromMapArg(args, "urls");
        if (urls == null) {
            throw new InvalidUserDataException("You must specify a urls for a Maven repo.");
        }
        List<String> extraUrls = urls.subList(1, urls.size());
        AbstractResolver resolver = this.getResolverFactory().createMavenRepoResolver(this.getNameFromMap(args, urls.get(0)), urls.get(0), urls.size() == 1 ? new String[]{} : extraUrls.toArray(new String[extraUrls.size()]));
        return this.add(resolver, configClosure);
    }

    public GroovyMavenDeployer mavenDeployer(Map args) {
        GroovyMavenDeployer mavenDeployer = this.createMavenDeployer(args);
        return (GroovyMavenDeployer)this.add(mavenDeployer);
    }

    private GroovyMavenDeployer createMavenDeployer(Map args) {
        GroovyMavenDeployer mavenDeployer = this.createMavenDeployer("dummyName");
        String defaultName = "mavenDeployer-" + System.identityHashCode(mavenDeployer);
        mavenDeployer.setName(this.getNameFromMap(args, defaultName));
        return mavenDeployer;
    }

    @Override
    public GroovyMavenDeployer mavenDeployer() {
        return this.mavenDeployer(Collections.emptyMap());
    }

    @Override
    public GroovyMavenDeployer mavenDeployer(Closure configureClosure) {
        return this.mavenDeployer(Collections.emptyMap(), configureClosure);
    }

    public GroovyMavenDeployer mavenDeployer(Map args, Closure configureClosure) {
        GroovyMavenDeployer mavenDeployer = this.createMavenDeployer(args);
        return (GroovyMavenDeployer)this.add(mavenDeployer, configureClosure);
    }

    @Override
    public MavenResolver mavenInstaller() {
        return this.mavenInstaller(Collections.emptyMap());
    }

    @Override
    public MavenResolver mavenInstaller(Closure configureClosure) {
        return this.mavenInstaller(Collections.emptyMap(), configureClosure);
    }

    public MavenResolver mavenInstaller(Map args) {
        MavenResolver mavenInstaller = this.createMavenInstaller(args);
        return (MavenResolver)this.add(mavenInstaller);
    }

    public MavenResolver mavenInstaller(Map args, Closure configureClosure) {
        MavenResolver mavenInstaller = this.createMavenInstaller(args);
        return (MavenResolver)this.add(mavenInstaller, configureClosure);
    }

    private MavenResolver createMavenInstaller(Map args) {
        MavenResolver mavenInstaller = this.createMavenInstaller("dummyName");
        String defaultName = "mavenInstaller-" + System.identityHashCode(mavenInstaller);
        mavenInstaller.setName(this.getNameFromMap(args, defaultName));
        return mavenInstaller;
    }

    @Override
    public IvyArtifactRepository ivy(Action<? super IvyArtifactRepository> action) {
        IvyArtifactRepository repository = this.getResolverFactory().createIvyRepository();
        this.addRepository(repository, action);
        return repository;
    }

    @Override
    public IvyArtifactRepository ivy(Closure closure) {
        IvyArtifactRepository repository = this.getResolverFactory().createIvyRepository();
        this.addRepository((ArtifactRepositoryInternal)((Object)repository), closure);
        return repository;
    }

    private <T extends ArtifactRepository> void addRepository(T repository, Action<? super T> action) {
        action.execute(repository);
        this.addRepository((ArtifactRepositoryInternal)repository);
    }

    private void addRepository(ArtifactRepositoryInternal repository, Closure closure) {
        ConfigureUtil.configure(closure, repository);
        this.addRepository(repository);
    }

    private void addRepository(ArtifactRepositoryInternal repository) {
        ArrayList<DependencyResolver> resolvers = new ArrayList<DependencyResolver>();
        repository.createResolvers(resolvers);
        for (DependencyResolver resolver : resolvers) {
            this.add(resolver);
        }
    }
}

