/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.dsl;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ImportNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.SourceUnit;
import org.gradle.api.internal.artifacts.dsl.AbstractScriptTransformer;
import org.gradle.api.specs.NotSpec;
import org.gradle.api.specs.Spec;
import org.gradle.api.specs.Specs;
import org.gradle.groovy.scripts.Transformer;
import org.gradle.util.UncheckedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ClasspathScriptTransformer
extends AbstractScriptTransformer {
    protected abstract String getScriptMethodName();

    @Override
    protected int getPhase() {
        return 3;
    }

    public void call(SourceUnit source) throws CompilationFailedException {
        ImportNode importedClass2;
        Spec<Statement> spec = this.isScriptBlock();
        this.filterStatements(source, spec);
        for (ImportNode importedClass2 : source.getAST().getImports()) {
            if (this.isVisible(source, importedClass2.getClassName())) continue;
            try {
                Field field = ModuleNode.class.getDeclaredField("imports");
                field.setAccessible(true);
                Map value = (Map)field.get(source.getAST());
                value.remove(importedClass2.getAlias());
            }
            catch (Exception e) {
                throw UncheckedException.asUncheckedException(e);
            }
        }
        Iterator<Object> iter = source.getAST().getStaticImports().values().iterator();
        while (iter.hasNext()) {
            importedClass2 = (ImportNode)iter.next();
            if (this.isVisible(source, importedClass2.getClassName())) continue;
            iter.remove();
        }
        iter = source.getAST().getStaticStarImports().values().iterator();
        while (iter.hasNext()) {
            importedClass2 = (ImportNode)iter.next();
            if (this.isVisible(source, importedClass2.getClassName())) continue;
            iter.remove();
        }
        ClassNode scriptClass = this.getScriptClass(source);
        Iterator classes = source.getAST().getClasses().iterator();
        while (classes.hasNext()) {
            ClassNode classNode = (ClassNode)classes.next();
            if (classNode == scriptClass) continue;
            classes.remove();
        }
        if (scriptClass != null) {
            for (MethodNode methodNode : new ArrayList(scriptClass.getMethods())) {
                if (methodNode.getName().equals("run")) continue;
                this.removeMethod(scriptClass, methodNode);
            }
        }
        source.getAST().getMethods().clear();
    }

    private boolean isVisible(SourceUnit source, String className) {
        try {
            source.getClassLoader().loadClass(className);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private void filterStatements(SourceUnit source, Spec<Statement> spec) {
        Iterator statementIterator = source.getAST().getStatementBlock().getStatements().iterator();
        while (statementIterator.hasNext()) {
            Statement statement = (Statement)statementIterator.next();
            if (spec.isSatisfiedBy(statement)) continue;
            statementIterator.remove();
        }
    }

    public Transformer invert() {
        return new AbstractScriptTransformer(){

            protected int getPhase() {
                return 5;
            }

            public String getId() {
                return "no_" + ClasspathScriptTransformer.this.getId();
            }

            public void call(SourceUnit source) throws CompilationFailedException {
                NotSpec<Statement> spec = Specs.not(ClasspathScriptTransformer.this.isScriptBlock());
                ClasspathScriptTransformer.this.filterStatements(source, spec);
            }
        };
    }

    public Spec<Statement> isScriptBlock() {
        return new Spec<Statement>(){

            @Override
            public boolean isSatisfiedBy(Statement statement) {
                if (!(statement instanceof ExpressionStatement)) {
                    return false;
                }
                ExpressionStatement expressionStatement = (ExpressionStatement)statement;
                if (!(expressionStatement.getExpression() instanceof MethodCallExpression)) {
                    return false;
                }
                MethodCallExpression methodCall = (MethodCallExpression)expressionStatement.getExpression();
                if (!ClasspathScriptTransformer.this.isMethodOnThis(methodCall, ClasspathScriptTransformer.this.getScriptMethodName())) {
                    return false;
                }
                if (!(methodCall.getArguments() instanceof ArgumentListExpression)) {
                    return false;
                }
                ArgumentListExpression args = (ArgumentListExpression)methodCall.getArguments();
                return args.getExpressions().size() == 1 && args.getExpression(0) instanceof ClosureExpression;
            }
        };
    }
}

