/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.dependencies;

import org.gradle.api.InvalidUserDataException;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ExternalModuleDependency;
import org.gradle.api.internal.artifacts.dependencies.AbstractExternalDependency;

public class DefaultExternalModuleDependency
extends AbstractExternalDependency
implements ExternalModuleDependency {
    private String group;
    private String name;
    private String version;
    private boolean force;
    private boolean changing;

    public DefaultExternalModuleDependency(String group, String name, String version) {
        this(group, name, version, null);
    }

    public DefaultExternalModuleDependency(String group, String name, String version, String configuration) {
        super(configuration);
        if (name == null) {
            throw new InvalidUserDataException("Name must not be null!");
        }
        this.group = group;
        this.name = name;
        this.version = version;
    }

    public String getGroup() {
        return this.group;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean isForce() {
        return this.force;
    }

    public DefaultExternalModuleDependency setForce(boolean force) {
        this.force = force;
        return this;
    }

    public boolean isChanging() {
        return this.changing;
    }

    public DefaultExternalModuleDependency setChanging(boolean changing) {
        this.changing = changing;
        return this;
    }

    public DefaultExternalModuleDependency copy() {
        DefaultExternalModuleDependency copiedModuleDependency = new DefaultExternalModuleDependency(this.getGroup(), this.getName(), this.getVersion(), this.getConfiguration());
        this.copyTo(copiedModuleDependency);
        copiedModuleDependency.setChanging(this.isChanging());
        return copiedModuleDependency;
    }

    public boolean contentEquals(Dependency dependency) {
        if (this == dependency) {
            return true;
        }
        if (dependency == null || this.getClass() != dependency.getClass()) {
            return false;
        }
        DefaultExternalModuleDependency that = (DefaultExternalModuleDependency)dependency;
        if (!this.isContentEqualsFor(that)) {
            return false;
        }
        return this.changing == that.isChanging();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultExternalModuleDependency that = (DefaultExternalModuleDependency)o;
        return this.isKeyEquals(that);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        return "DefaultExternalModuleDependency{group='" + this.group + '\'' + ", name='" + this.name + '\'' + ", version='" + this.version + '\'' + ", configuration='" + this.getConfiguration() + '\'' + '}';
    }
}

