/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts;

import groovy.lang.Closure;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.ivy.plugins.resolver.DependencyResolver;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.UnknownDomainObjectException;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.ResolverContainer;
import org.gradle.api.artifacts.UnknownRepositoryException;
import org.gradle.api.artifacts.maven.Conf2ScopeMappingContainer;
import org.gradle.api.artifacts.maven.GroovyMavenDeployer;
import org.gradle.api.artifacts.maven.MavenResolver;
import org.gradle.api.internal.ClassGenerator;
import org.gradle.api.internal.DefaultNamedDomainObjectContainer;
import org.gradle.api.internal.artifacts.ivyservice.ResolverFactory;
import org.gradle.api.internal.artifacts.publish.maven.MavenPomMetaInfoProvider;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.util.ConfigureUtil;
import org.gradle.util.GUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultResolverContainer
extends DefaultNamedDomainObjectContainer<DependencyResolver>
implements ResolverContainer,
MavenPomMetaInfoProvider {
    private ResolverFactory resolverFactory;
    private List<String> resolverNames = new ArrayList<String>();
    private File mavenPomDir;
    private FileResolver fileResolver;
    private Conf2ScopeMappingContainer mavenScopeMappings;
    private ConfigurationContainer configurationContainer;

    public DefaultResolverContainer(ResolverFactory resolverFactory, ClassGenerator classGenerator) {
        super(DependencyResolver.class, classGenerator);
        this.resolverFactory = resolverFactory;
    }

    @Override
    public String getTypeDisplayName() {
        return "resolver";
    }

    @Override
    public DependencyResolver add(Object userDescription) {
        return this.add(userDescription, null);
    }

    @Override
    public DependencyResolver add(Object userDescription, Closure configureClosure) {
        return this.addInternal(userDescription, configureClosure, new OrderAction(){

            public void apply(String resolverName) {
                DefaultResolverContainer.this.resolverNames.add(resolverName);
            }
        });
    }

    @Override
    public DependencyResolver addBefore(Object userDescription, String afterResolverName) {
        return this.addBefore(userDescription, afterResolverName, null);
    }

    @Override
    public DependencyResolver addBefore(Object userDescription, final String afterResolverName, Closure configureClosure) {
        if (!GUtil.isTrue(afterResolverName)) {
            throw new InvalidUserDataException("You must specify userDescription and afterResolverName");
        }
        if (this.findByName(afterResolverName) == null) {
            throw new InvalidUserDataException("Resolver $afterResolverName does not exists!");
        }
        return this.addInternal(userDescription, configureClosure, new OrderAction(){

            public void apply(String resolverName) {
                DefaultResolverContainer.this.resolverNames.add(DefaultResolverContainer.this.resolverNames.indexOf(afterResolverName), resolverName);
            }
        });
    }

    @Override
    public DependencyResolver addAfter(Object userDescription, String beforeResolverName) {
        return this.addAfter(userDescription, beforeResolverName, null);
    }

    @Override
    public DependencyResolver addAfter(Object userDescription, final String beforeResolverName, Closure configureClosure) {
        if (!GUtil.isTrue(beforeResolverName)) {
            throw new InvalidUserDataException("You must specify userDescription and beforeResolverName");
        }
        if (this.findByName(beforeResolverName) == null) {
            throw new InvalidUserDataException("Resolver $beforeResolverName does not exists!");
        }
        return this.addInternal(userDescription, configureClosure, new OrderAction(){

            public void apply(String resolverName) {
                int insertPos = DefaultResolverContainer.this.resolverNames.indexOf(beforeResolverName) + 1;
                if (insertPos == DefaultResolverContainer.this.resolverNames.size()) {
                    DefaultResolverContainer.this.resolverNames.add(resolverName);
                } else {
                    DefaultResolverContainer.this.resolverNames.add(insertPos, resolverName);
                }
            }
        });
    }

    @Override
    public DependencyResolver addFirst(Object userDescription) {
        return this.addFirst(userDescription, null);
    }

    @Override
    public DependencyResolver addFirst(Object userDescription, Closure configureClosure) {
        if (!GUtil.isTrue(userDescription)) {
            throw new InvalidUserDataException("You must specify userDescription");
        }
        return this.addInternal(userDescription, configureClosure, new OrderAction(){

            public void apply(String resolverName) {
                if (DefaultResolverContainer.this.resolverNames.size() == 0) {
                    DefaultResolverContainer.this.resolverNames.add(resolverName);
                } else {
                    DefaultResolverContainer.this.resolverNames.add(0, resolverName);
                }
            }
        });
    }

    private DependencyResolver addInternal(Object userDescription, Closure configureClosure, OrderAction orderAction) {
        if (!GUtil.isTrue(userDescription)) {
            throw new InvalidUserDataException("You must specify userDescription");
        }
        DependencyResolver resolver = this.resolverFactory.createResolver(userDescription);
        ConfigureUtil.configure(configureClosure, resolver);
        if (!GUtil.isTrue(resolver.getName())) {
            throw new InvalidUserDataException("You must specify a name for the resolver. Resolver=" + userDescription);
        }
        if (this.findByName(resolver.getName()) != null) {
            throw new InvalidUserDataException(String.format("Cannot add a resolver with name '%s' as a resolver with that name already exists.", resolver.getName()));
        }
        this.addObject(resolver.getName(), resolver);
        orderAction.apply(resolver.getName());
        return resolver;
    }

    @Override
    protected UnknownDomainObjectException createNotFoundException(String name) {
        return new UnknownRepositoryException(String.format("Repository with name '%s' not found.", name));
    }

    @Override
    public List<DependencyResolver> getResolvers() {
        ArrayList<DependencyResolver> returnedResolvers = new ArrayList<DependencyResolver>();
        for (String resolverName : this.resolverNames) {
            returnedResolvers.add((DependencyResolver)this.getByName(resolverName));
        }
        return returnedResolvers;
    }

    public ResolverFactory getResolverFactory() {
        return this.resolverFactory;
    }

    public void setResolverFactory(ResolverFactory resolverFactory) {
        this.resolverFactory = resolverFactory;
    }

    public List<String> getResolverNames() {
        return this.resolverNames;
    }

    public void setResolverNames(List<String> resolverNames) {
        this.resolverNames = resolverNames;
    }

    public FileResolver getFileResolver() {
        return this.fileResolver;
    }

    public void setFileResolver(FileResolver fileResolver) {
        this.fileResolver = fileResolver;
    }

    public ConfigurationContainer getConfigurationContainer() {
        return this.configurationContainer;
    }

    public void setConfigurationContainer(ConfigurationContainer configurationContainer) {
        this.configurationContainer = configurationContainer;
    }

    public GroovyMavenDeployer createMavenDeployer(String name) {
        return this.resolverFactory.createMavenDeployer(name, this, this.getConfigurationContainer(), this.getMavenScopeMappings(), this.getFileResolver());
    }

    public MavenResolver createMavenInstaller(String name) {
        return this.resolverFactory.createMavenInstaller(name, this, this.getConfigurationContainer(), this.getMavenScopeMappings(), this.getFileResolver());
    }

    @Override
    public Conf2ScopeMappingContainer getMavenScopeMappings() {
        return this.mavenScopeMappings;
    }

    public void setMavenScopeMappings(Conf2ScopeMappingContainer mavenScopeMappings) {
        this.mavenScopeMappings = mavenScopeMappings;
    }

    @Override
    public File getMavenPomDir() {
        return this.mavenPomDir;
    }

    @Override
    public void setMavenPomDir(File mavenPomDir) {
        this.mavenPomDir = mavenPomDir;
    }

    private static interface OrderAction {
        public void apply(String var1);
    }
}

