/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal;

import groovy.lang.Closure;
import groovy.util.IndentPrinter;
import groovy.util.Node;
import groovy.util.XmlNodePrinter;
import groovy.util.XmlParser;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang.StringUtils;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.gradle.api.Action;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.maven.XmlProvider;
import org.gradle.util.SystemProperties;
import org.gradle.util.TextUtil;
import org.gradle.util.UncheckedException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlTransformer
implements Transformer<String> {
    private final List<Action<? super XmlProvider>> actions = new ArrayList<Action<? super XmlProvider>>();
    private String indentation = "  ";

    public void addAction(Action<? super XmlProvider> provider) {
        this.actions.add(provider);
    }

    public void setIndentation(String indentation) {
        this.indentation = indentation;
    }

    public void addAction(Closure closure) {
        this.actions.add((Action)DefaultGroovyMethods.asType((Closure)closure, Action.class));
    }

    @Override
    public String transform(String original) {
        return this.doTransform(original).toString();
    }

    public void transform(String original, Writer destination) {
        this.doTransform(original).writeTo(destination);
    }

    public void transform(String original, OutputStream destination) {
        this.doTransform(original).writeTo(destination);
    }

    public void transform(Node original, Writer destination) {
        this.doTransform(original).writeTo(destination);
    }

    public void transform(Node original, OutputStream destination) {
        this.doTransform(original).writeTo(destination);
    }

    private XmlProviderImpl doTransform(String original) {
        XmlProviderImpl provider = new XmlProviderImpl(original);
        provider.apply(this.actions);
        return provider;
    }

    private XmlProviderImpl doTransform(Node original) {
        XmlProviderImpl provider = new XmlProviderImpl(original);
        provider.apply(this.actions);
        return provider;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class XmlProviderImpl
    implements XmlProvider {
        private StringBuilder builder;
        private Node node;
        private String stringValue;
        private Element element;

        public XmlProviderImpl(String original) {
            this.stringValue = original;
        }

        public XmlProviderImpl(Node original) {
            this.node = original;
        }

        public void apply(Iterable<Action<? super XmlProvider>> actions) {
            for (Action<? super XmlProvider> action : actions) {
                action.execute(this);
            }
        }

        public String toString() {
            StringWriter writer = new StringWriter();
            this.writeTo(writer);
            return writer.toString();
        }

        public void writeTo(Writer writer) {
            this.doWriteTo(writer, null);
        }

        public void writeTo(OutputStream stream) {
            try {
                OutputStreamWriter writer = new OutputStreamWriter(stream, "UTF-8");
                this.doWriteTo(writer, "UTF-8");
                ((Writer)writer).flush();
            }
            catch (IOException e) {
                throw UncheckedException.asUncheckedException(e);
            }
        }

        @Override
        public StringBuilder asString() {
            if (this.builder == null) {
                this.builder = new StringBuilder(this.toString());
                this.node = null;
                this.element = null;
            }
            return this.builder;
        }

        @Override
        public Node asNode() {
            if (this.node == null) {
                try {
                    this.node = new XmlParser().parseText(this.toString());
                }
                catch (Exception e) {
                    throw UncheckedException.asUncheckedException(e);
                }
                this.builder = null;
                this.element = null;
            }
            return this.node;
        }

        @Override
        public Element asElement() {
            if (this.element == null) {
                Document document;
                try {
                    document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new InputSource(new StringReader(this.toString())));
                }
                catch (Exception e) {
                    throw UncheckedException.asUncheckedException(e);
                }
                this.element = document.getDocumentElement();
                this.builder = null;
                this.node = null;
            }
            return this.element;
        }

        private void doWriteTo(Writer writer, String encoding) {
            this.writeXmlDeclaration(writer, encoding);
            try {
                if (this.node != null) {
                    final PrintWriter printWriter = new PrintWriter(writer);
                    IndentPrinter indentPrinter = new IndentPrinter(printWriter, XmlTransformer.this.indentation){

                        public void println() {
                            printWriter.println();
                        }
                    };
                    XmlNodePrinter nodePrinter = new XmlNodePrinter(indentPrinter);
                    nodePrinter.setPreserveWhitespace(true);
                    nodePrinter.print(this.node);
                    printWriter.flush();
                } else if (this.element != null) {
                    this.printNode(this.element, writer);
                } else if (this.builder != null) {
                    writer.append(TextUtil.toPlatformLineSeparators(this.stripXmlDeclaration(this.builder)));
                } else {
                    writer.append(TextUtil.toPlatformLineSeparators(this.stripXmlDeclaration(this.stringValue)));
                }
            }
            catch (IOException e) {
                throw UncheckedException.asUncheckedException(e);
            }
        }

        private void printNode(org.w3c.dom.Node node, Writer destination) {
            this.removeEmptyTextNodes(node);
            int indentAmount = this.determineIndentAmount();
            try {
                TransformerFactory factory = TransformerFactory.newInstance();
                try {
                    factory.setAttribute("indent-number", indentAmount);
                }
                catch (IllegalArgumentException ignored) {
                    // empty catch block
                }
                javax.xml.transform.Transformer transformer = factory.newTransformer();
                transformer.setOutputProperty("method", "xml");
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("omit-xml-declaration", "yes");
                try {
                    transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", String.valueOf(indentAmount));
                }
                catch (IllegalArgumentException ignored) {
                    // empty catch block
                }
                transformer.transform(new DOMSource(node), new StreamResult(destination));
            }
            catch (TransformerException e) {
                throw UncheckedException.asUncheckedException(e);
            }
        }

        private int determineIndentAmount() {
            if (XmlTransformer.this.indentation.equals("\t")) {
                return 2;
            }
            return XmlTransformer.this.indentation.length();
        }

        private void removeEmptyTextNodes(org.w3c.dom.Node node) {
            NodeList children = node.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                org.w3c.dom.Node child = children.item(i);
                if (child.getNodeType() == 3 && child.getNodeValue().trim().length() == 0) {
                    node.removeChild(child);
                    continue;
                }
                this.removeEmptyTextNodes(child);
            }
        }

        private void writeXmlDeclaration(Writer writer, String encoding) {
            try {
                writer.write("<?xml version=\"1.0\"");
                if (encoding != null) {
                    writer.write(" encoding=\"");
                    writer.write(encoding);
                    writer.write("\"");
                }
                writer.write("?>");
                writer.write(SystemProperties.getLineSeparator());
            }
            catch (IOException e) {
                throw UncheckedException.asUncheckedException(e);
            }
        }

        private boolean hasXmlDeclaration(String xml) {
            return xml.startsWith("<?xml");
        }

        private String stripXmlDeclaration(CharSequence sequence) {
            String str = ((Object)sequence).toString();
            if (this.hasXmlDeclaration(str)) {
                str = str.substring(str.indexOf("?>") + 2);
                str = StringUtils.stripStart((String)str, null);
            }
            return str;
        }
    }
}

