/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal;

import groovy.lang.Closure;
import groovy.lang.MissingMethodException;
import groovy.lang.MissingPropertyException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.gradle.api.Action;
import org.gradle.api.NamedDomainObjectCollection;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Rule;
import org.gradle.api.UnknownDomainObjectException;
import org.gradle.api.internal.AbstractDomainObjectCollection;
import org.gradle.api.internal.AbstractDynamicObject;
import org.gradle.api.internal.BeanDynamicObject;
import org.gradle.api.internal.ClassGenerator;
import org.gradle.api.internal.CompositeDynamicObject;
import org.gradle.api.internal.DynamicObject;
import org.gradle.api.specs.Spec;
import org.gradle.api.specs.Specs;
import org.gradle.listener.ActionBroadcast;
import org.gradle.util.ConfigureUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultNamedDomainObjectContainer<T>
extends AbstractDomainObjectCollection<T>
implements NamedDomainObjectContainer<T> {
    private final DynamicObject dynamicObject = new ContainerDynamicObject();
    private final List<Rule> rules = new ArrayList<Rule>();
    private final ClassGenerator classGenerator;
    private final NamedObjectStore<T> store;
    private final Class<T> type;
    private Set<String> applyingRulesFor = new HashSet<String>();

    public DefaultNamedDomainObjectContainer(Class<T> type, ClassGenerator classGenerator) {
        this(type, classGenerator, new MapStore());
    }

    public DefaultNamedDomainObjectContainer(Class<T> type, ClassGenerator classGenerator, NamedObjectStore<T> store) {
        super(store);
        this.type = type;
        this.classGenerator = classGenerator;
        this.store = store;
    }

    protected Class<T> getType() {
        return this.type;
    }

    protected ClassGenerator getClassGenerator() {
        return this.classGenerator;
    }

    protected void addObject(String name, T object) {
        assert (object != null && name != null);
        this.store.put(name, object);
    }

    public String getDisplayName() {
        return String.format("%s container", this.getTypeDisplayName());
    }

    @Override
    public Map<String, T> getAsMap() {
        return Collections.unmodifiableMap(this.store.getAsMap());
    }

    @Override
    public T findByName(String name) {
        T value = this.store.find(name);
        if (value != null) {
            return value;
        }
        this.applyRules(name);
        return this.store.find(name);
    }

    protected T findByNameWithoutRules(String name) {
        return this.store.find(name);
    }

    @Override
    public NamedDomainObjectCollection<T> matching(Spec<? super T> spec) {
        return this.classGenerator.newInstance(DefaultNamedDomainObjectContainer.class, this.type, this.classGenerator, this.storeWithSpec(spec));
    }

    @Override
    public NamedDomainObjectCollection<T> matching(Closure spec) {
        return this.matching(Specs.convertClosureToSpec(spec));
    }

    @Override
    public <S extends T> NamedDomainObjectCollection<S> withType(Class<S> type) {
        return this.classGenerator.newInstance(DefaultNamedDomainObjectContainer.class, type, this.classGenerator, this.storeWithType(type));
    }

    protected NamedObjectStore<T> storeWithSpec(Spec<? super T> spec) {
        return new FilteredObjectStore<T>(this.store, this.type, spec);
    }

    protected <S extends T> NamedObjectStore<S> storeWithType(Class<S> type) {
        return new FilteredObjectStore<T>(this.store, type, Specs.satisfyAll());
    }

    @Override
    public T getByName(String name) throws UnknownDomainObjectException {
        T t = this.findByName(name);
        if (t == null) {
            throw this.createNotFoundException(name);
        }
        return t;
    }

    @Override
    public T getByName(String name, Closure configureClosure) throws UnknownDomainObjectException {
        T t = this.getByName(name);
        ConfigureUtil.configure(configureClosure, t);
        return t;
    }

    @Override
    public T getAt(String name) throws UnknownDomainObjectException {
        return this.getByName(name);
    }

    public DynamicObject getAsDynamicObject() {
        return this.dynamicObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyRules(String name) {
        if (this.applyingRulesFor.contains(name)) {
            return;
        }
        this.applyingRulesFor.add(name);
        try {
            for (Rule rule : this.rules) {
                rule.apply(name);
            }
        }
        finally {
            this.applyingRulesFor.remove(name);
        }
    }

    @Override
    public Rule addRule(Rule rule) {
        this.rules.add(rule);
        return rule;
    }

    @Override
    public Rule addRule(final String description, final Closure ruleAction) {
        Rule rule = new Rule(){

            public String getDescription() {
                return description;
            }

            public void apply(String taskName) {
                ruleAction.call((Object)taskName);
            }

            public String toString() {
                return "Rule: " + description;
            }
        };
        this.rules.add(rule);
        return rule;
    }

    @Override
    public List<Rule> getRules() {
        return Collections.unmodifiableList(this.rules);
    }

    protected UnknownDomainObjectException createNotFoundException(String name) {
        return new UnknownDomainObjectException(String.format("%s with name '%s' not found.", this.getTypeDisplayName(), name));
    }

    protected String getTypeDisplayName() {
        return this.type.getSimpleName();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ContainerElementsDynamicObject
    extends AbstractDynamicObject {
        private ContainerElementsDynamicObject() {
        }

        @Override
        protected String getDisplayName() {
            return DefaultNamedDomainObjectContainer.this.getDisplayName();
        }

        @Override
        public boolean hasProperty(String name) {
            return DefaultNamedDomainObjectContainer.this.findByName(name) != null;
        }

        public T getProperty(String name) throws MissingPropertyException {
            Object t = DefaultNamedDomainObjectContainer.this.findByName(name);
            if (t == null) {
                return super.getProperty(name);
            }
            return t;
        }

        public Map<String, T> getProperties() {
            return DefaultNamedDomainObjectContainer.this.getAsMap();
        }

        @Override
        public boolean hasMethod(String name, Object ... arguments) {
            return this.isConfigureMethod(name, arguments);
        }

        @Override
        public Object invokeMethod(String name, Object ... arguments) throws MissingMethodException {
            if (this.isConfigureMethod(name, arguments)) {
                return ConfigureUtil.configure((Closure)arguments[0], DefaultNamedDomainObjectContainer.this.getByName(name));
            }
            return super.invokeMethod(name, arguments);
        }

        private boolean isConfigureMethod(String name, Object ... arguments) {
            return arguments.length == 1 && arguments[0] instanceof Closure && this.hasProperty(name);
        }
    }

    private class ContainerDynamicObject
    extends CompositeDynamicObject {
        private ContainerDynamicObject() {
            this.setObjects(new BeanDynamicObject(DefaultNamedDomainObjectContainer.this), new ContainerElementsDynamicObject());
        }

        protected String getDisplayName() {
            return DefaultNamedDomainObjectContainer.this.getDisplayName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FilteredObjectStore<S>
    extends AbstractDomainObjectCollection.FilteredStore<S>
    implements NamedObjectStore<S> {
        private final NamedObjectStore<? super S> store;

        public FilteredObjectStore(NamedObjectStore<? super S> store, Class<S> type, Spec<? super S> spec) {
            super(store, type, spec);
            this.store = store;
        }

        @Override
        public S put(String name, S value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public S find(String name) {
            return this.filter(this.store.find(name));
        }

        @Override
        public Collection<? extends S> getAll() {
            return this.getAsMap().values();
        }

        @Override
        public Map<String, S> getAsMap() {
            LinkedHashMap filteredMap = new LinkedHashMap();
            for (Map.Entry<String, S> entry : this.store.getAsMap().entrySet()) {
                Object s = this.filter(entry.getValue());
                if (s == null) continue;
                filteredMap.put(entry.getKey(), s);
            }
            return filteredMap;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MapStore<S>
    implements NamedObjectStore<S> {
        private final ActionBroadcast<S> addActions = new ActionBroadcast();
        private final ActionBroadcast<S> removeActions = new ActionBroadcast();
        private final Map<String, S> objects = new TreeMap<String, S>();

        private MapStore() {
        }

        @Override
        public S put(String name, S value) {
            S oldValue = this.objects.put(name, value);
            if (oldValue != null) {
                this.removeActions.execute(oldValue);
            }
            this.addActions.execute(value);
            return oldValue;
        }

        @Override
        public S find(String name) {
            return this.objects.get(name);
        }

        @Override
        public Collection<? extends S> getAll() {
            return this.getAsMap().values();
        }

        @Override
        public Map<String, S> getAsMap() {
            return this.objects;
        }

        @Override
        public void objectAdded(Action<? super S> action) {
            this.addActions.add(action);
        }

        @Override
        public void objectRemoved(Action<? super S> action) {
            this.removeActions.add(action);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static interface NamedObjectStore<S>
    extends AbstractDomainObjectCollection.Store<S> {
        public S put(String var1, S var2);

        public S find(String var1);

        public Map<String, S> getAsMap();
    }
}

