/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal;

import groovy.lang.Closure;
import groovy.lang.MissingPropertyException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.internal.ConventionMapping;
import org.gradle.api.internal.IConventionAware;
import org.gradle.api.plugins.Convention;
import org.gradle.api.tasks.ConventionValue;
import org.gradle.util.ReflectionUtil;
import org.gradle.util.UncheckedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConventionAwareHelper
implements ConventionMapping {
    private Convention convention;
    private IConventionAware source;
    private Map<String, ConventionValue> conventionMapping = new HashMap<String, ConventionValue>();

    public ConventionAwareHelper(IConventionAware source, Convention convention) {
        this.source = source;
        this.convention = convention;
    }

    @Override
    public ConventionMapping.MappedProperty map(String propertyName, ConventionValue value) {
        MappedPropertyImpl property = new MappedPropertyImpl(value);
        this.map(Collections.singletonMap(propertyName, property));
        return property;
    }

    @Override
    public ConventionMapping.MappedProperty map(String propertyName, final Closure value) {
        return this.map(propertyName, new ConventionValue(){

            public Object getValue(Convention convention, IConventionAware conventionAwareObject) {
                switch (value.getMaximumNumberOfParameters()) {
                    case 0: {
                        return value.call();
                    }
                    case 1: {
                        return value.call((Object)convention);
                    }
                }
                return value.call(new Object[]{convention, conventionAwareObject});
            }
        });
    }

    @Override
    public ConventionMapping.MappedProperty map(String propertyName, final Callable<?> value) {
        return this.map(propertyName, new ConventionValue(){

            public Object getValue(Convention convention, IConventionAware conventionAwareObject) {
                try {
                    return value.call();
                }
                catch (Exception e) {
                    throw UncheckedException.asUncheckedException(e);
                }
            }
        });
    }

    @Override
    public ConventionMapping map(Map<String, ? extends ConventionValue> mapping) {
        for (Map.Entry<String, ? extends ConventionValue> entry : mapping.entrySet()) {
            String propertyName = entry.getKey();
            if (!ReflectionUtil.hasProperty(this.source, propertyName)) {
                throw new InvalidUserDataException("You can't map a property that does not exist: propertyName=" + propertyName);
            }
            if (entry.getValue() != null) continue;
            throw new IllegalArgumentException("No convention value provided: propertyName= " + propertyName);
        }
        this.conventionMapping.putAll(mapping);
        return this;
    }

    public void propertyMissing(String name, Object value) {
        if (value instanceof Closure) {
            this.map(name, (Closure)value);
        } else if (value instanceof ConventionValue) {
            this.map(name, (ConventionValue)value);
        } else {
            throw new MissingPropertyException(name, this.getClass());
        }
    }

    public Object getConventionValue(String propertyName) {
        Object value = ReflectionUtil.getProperty(this.source, propertyName);
        return this.getConventionValue(value, propertyName);
    }

    @Override
    public <T> T getConventionValue(T internalValue, String propertyName) {
        boolean useMapping;
        Object returnValue = internalValue;
        boolean bl = useMapping = internalValue == null || internalValue instanceof Collection && ((Collection)internalValue).isEmpty() || internalValue instanceof Map && ((Map)internalValue).isEmpty();
        if (useMapping && this.conventionMapping.keySet().contains(propertyName)) {
            returnValue = this.conventionMapping.get(propertyName).getValue(this.convention, this.source);
        }
        return returnValue;
    }

    @Override
    public <T> T getConventionValue(T actualValue, String propertyName, boolean isExplicitValue) {
        if (isExplicitValue) {
            return actualValue;
        }
        return this.getConventionValue(actualValue, propertyName);
    }

    @Override
    public Convention getConvention() {
        return this.convention;
    }

    @Override
    public void setConvention(Convention convention) {
        this.convention = convention;
    }

    public IConventionAware getSource() {
        return this.source;
    }

    public void setSource(IConventionAware source) {
        this.source = source;
    }

    public Map getConventionMapping() {
        return this.conventionMapping;
    }

    public void setConventionMapping(Map conventionMapping) {
        this.conventionMapping = conventionMapping;
    }

    private static class MappedPropertyImpl
    implements ConventionMapping.MappedProperty,
    ConventionValue {
        private final ConventionValue value;
        private boolean haveValue;
        private boolean cache;
        private Object cachedValue;

        private MappedPropertyImpl(ConventionValue value) {
            this.value = value;
        }

        public Object getValue(Convention convention, IConventionAware conventionAwareObject) {
            if (!this.cache) {
                return this.value.getValue(convention, conventionAwareObject);
            }
            if (!this.haveValue) {
                this.cachedValue = this.value.getValue(convention, conventionAwareObject);
                this.haveValue = true;
            }
            return this.cachedValue;
        }

        public void cache() {
            this.cache = true;
            this.cachedValue = null;
        }
    }
}

