/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.api.internal.DirectedGraph;
import org.gradle.api.internal.DirectedGraphWithEdgeValues;
import org.gradle.util.GUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachingDirectedGraphWalker<N, T> {
    private final DirectedGraphWithEdgeValues<N, T> graph;
    private List<N> startNodes = new LinkedList<N>();
    private final Map<N, Set<T>> cachedNodeValues = new HashMap<N, Set<T>>();

    public CachingDirectedGraphWalker(DirectedGraph<N, T> graph) {
        this.graph = new GraphWithEmpyEdges<N, T>(graph);
    }

    public CachingDirectedGraphWalker(DirectedGraphWithEdgeValues<N, T> graph) {
        this.graph = graph;
    }

    public CachingDirectedGraphWalker<N, T> add(N ... values) {
        this.add((Iterable<? extends N>)Arrays.asList(values));
        return this;
    }

    public CachingDirectedGraphWalker add(Iterable<? extends N> values) {
        GUtil.addToCollection(this.startNodes, values);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<T> findValues() {
        try {
            Set<T> set = this.doSearch();
            return set;
        }
        finally {
            this.startNodes.clear();
        }
    }

    private Set<T> doSearch() {
        int componentCount = 0;
        HashMap seenNodes = new HashMap();
        HashMap components = new HashMap();
        LinkedList<N> queue = new LinkedList<N>(this.startNodes);
        while (!queue.isEmpty()) {
            N node = queue.getFirst();
            NodeDetails details = (NodeDetails)seenNodes.get(node);
            if (details == null) {
                details = new NodeDetails(node, componentCount++);
                seenNodes.put(node, details);
                components.put(details.component, details);
                Set<T> cacheValues = this.cachedNodeValues.get(node);
                if (cacheValues != null) {
                    details.values = cacheValues;
                    details.finished = true;
                    queue.removeFirst();
                    continue;
                }
                this.graph.getNodeValues(node, details.values, details.successors);
                for (Object connectedNode : details.successors) {
                    if (seenNodes.containsKey(connectedNode)) continue;
                    queue.add(0, connectedNode);
                }
                continue;
            }
            queue.removeFirst();
            if (this.cachedNodeValues.containsKey(node)) continue;
            for (Object connectedNode : details.successors) {
                NodeDetails connectedNodeDetails = (NodeDetails)seenNodes.get(connectedNode);
                if (!connectedNodeDetails.finished) {
                    details.minSeen = Math.min(details.minSeen, connectedNodeDetails.minSeen);
                }
                details.values.addAll(connectedNodeDetails.values);
                this.graph.getEdgeValues(node, connectedNode, details.values);
            }
            if (details.minSeen != details.component) {
                NodeDetails rootDetails = (NodeDetails)components.get(details.minSeen);
                rootDetails.values.addAll(details.values);
                details.values.clear();
                rootDetails.strongComponentMembers.addAll(details.strongComponentMembers);
                continue;
            }
            for (NodeDetails componentMember : details.strongComponentMembers) {
                this.cachedNodeValues.put(componentMember.node, details.values);
                componentMember.finished = true;
                components.remove(componentMember.component);
            }
        }
        LinkedHashSet values = new LinkedHashSet();
        for (N startNode : this.startNodes) {
            values.addAll(this.cachedNodeValues.get(startNode));
        }
        return values;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GraphWithEmpyEdges<N, T>
    implements DirectedGraphWithEdgeValues<N, T> {
        private final DirectedGraph<N, T> graph;

        public GraphWithEmpyEdges(DirectedGraph<N, T> graph) {
            this.graph = graph;
        }

        @Override
        public void getEdgeValues(N from, N to, Collection<T> values) {
        }

        @Override
        public void getNodeValues(N node, Collection<T> values, Collection<N> connectedNodes) {
            this.graph.getNodeValues(node, values, connectedNodes);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NodeDetails<N, T> {
        private final int component;
        private final N node;
        private Set<T> values = new LinkedHashSet<T>();
        private List<N> successors = new ArrayList<N>();
        private Set<NodeDetails<N, T>> strongComponentMembers = new LinkedHashSet<NodeDetails<N, T>>();
        private int minSeen;
        private boolean finished;

        public NodeDetails(N node, int component) {
            this.node = node;
            this.component = component;
            this.minSeen = component;
            this.strongComponentMembers.add(this);
        }
    }
}

