/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal;

import groovy.lang.Closure;
import groovy.lang.MissingPropertyException;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.codehaus.groovy.runtime.InvokerInvocationException;
import org.gradle.api.Action;
import org.gradle.api.AntBuilder;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.internal.DynamicObject;
import org.gradle.api.internal.DynamicObjectAware;
import org.gradle.api.internal.DynamicObjectHelper;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.TaskOutputsInternal;
import org.gradle.api.internal.file.TemporaryFileProvider;
import org.gradle.api.internal.plugins.DefaultConvention;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.ServiceRegistry;
import org.gradle.api.internal.tasks.DefaultTaskDependency;
import org.gradle.api.internal.tasks.TaskDependencyInternal;
import org.gradle.api.internal.tasks.TaskExecuter;
import org.gradle.api.internal.tasks.TaskStateInternal;
import org.gradle.api.internal.tasks.execution.TaskValidator;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.logging.LoggingManager;
import org.gradle.api.plugins.Convention;
import org.gradle.api.specs.AndSpec;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.TaskInputs;
import org.gradle.api.tasks.TaskState;
import org.gradle.logging.LoggingManagerInternal;
import org.gradle.logging.StandardOutputCapture;
import org.gradle.util.ConfigureUtil;
import org.gradle.util.DeprecationLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTask
implements TaskInternal,
DynamicObjectAware {
    private static Logger buildLogger = Logging.getLogger(Task.class);
    private static ThreadLocal<TaskInfo> nextInstance = new ThreadLocal();
    private ProjectInternal project;
    private String name;
    private List<Action<? super Task>> actions = new ArrayList<Action<? super Task>>();
    private String path;
    private boolean enabled = true;
    private DefaultTaskDependency dependencies;
    private DynamicObjectHelper dynamicObjectHelper;
    private String description;
    private String group;
    private AndSpec<Task> onlyIfSpec = new AndSpec(this.createNewOnlyIfSpec());
    private final TaskOutputsInternal outputs;
    private final TaskInputs inputs;
    private TaskExecuter executer;
    private final ServiceRegistry services;
    private final TaskStateInternal state;
    private final LoggingManagerInternal loggingManager;
    private List<TaskValidator> validators = new ArrayList<TaskValidator>();

    protected AbstractTask() {
        this(AbstractTask.taskInfo());
    }

    private static TaskInfo taskInfo() {
        TaskInfo taskInfo = nextInstance.get();
        assert (taskInfo != null);
        return taskInfo;
    }

    private AbstractTask(TaskInfo taskInfo) {
        this.project = taskInfo.project;
        this.name = taskInfo.name;
        assert (this.project != null);
        assert (this.name != null);
        this.path = this.project.absoluteProjectPath(this.name);
        this.state = new TaskStateInternal(this.toString());
        this.dynamicObjectHelper = new DynamicObjectHelper(this, (Convention)new DefaultConvention());
        this.dependencies = new DefaultTaskDependency(this.project.getTasks());
        this.services = this.project.getServices().createFor(this);
        this.outputs = this.services.get(TaskOutputsInternal.class);
        this.inputs = this.services.get(TaskInputs.class);
        this.executer = this.services.get(TaskExecuter.class);
        this.loggingManager = this.services.get(LoggingManagerInternal.class);
    }

    public static <T extends Task> T injectIntoNewInstance(ProjectInternal project, String name, Callable<T> factory) {
        nextInstance.set(new TaskInfo(project, name));
        try {
            Task task = (Task)factory.call();
            return (T)task;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            nextInstance.set(null);
        }
    }

    @Override
    public TaskState getState() {
        return this.state;
    }

    @Override
    public AntBuilder getAnt() {
        return this.project.getAnt();
    }

    @Override
    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        this.project = (ProjectInternal)project;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public List<Action<? super Task>> getActions() {
        return this.actions;
    }

    @Override
    public void setActions(List<Action<? super Task>> actions) {
        this.actions = actions;
    }

    @Override
    public TaskDependencyInternal getTaskDependencies() {
        return this.dependencies;
    }

    @Override
    public Set<Object> getDependsOn() {
        return this.dependencies.getValues();
    }

    @Override
    public void setDependsOn(Iterable<?> dependsOn) {
        this.dependencies.setValues(dependsOn);
    }

    @Override
    public void onlyIf(Closure onlyIfClosure) {
        this.onlyIfSpec = this.onlyIfSpec.and(onlyIfClosure);
    }

    @Override
    public void onlyIf(Spec<? super Task> onlyIfSpec) {
        this.onlyIfSpec = this.onlyIfSpec.and(onlyIfSpec);
    }

    @Override
    public void setOnlyIf(Spec<? super Task> spec) {
        this.onlyIfSpec = this.createNewOnlyIfSpec().and(spec);
    }

    @Override
    public void setOnlyIf(Closure onlyIfClosure) {
        this.onlyIfSpec = this.createNewOnlyIfSpec().and(onlyIfClosure);
    }

    private AndSpec<Task> createNewOnlyIfSpec() {
        return new AndSpec<Task>(new Spec<Task>(){

            @Override
            public boolean isSatisfiedBy(Task element) {
                return element == AbstractTask.this && AbstractTask.this.enabled;
            }
        });
    }

    @Override
    public Spec<? super TaskInternal> getOnlyIf() {
        return this.onlyIfSpec;
    }

    @Override
    public boolean getDidWork() {
        return this.state.getDidWork();
    }

    @Override
    public void setDidWork(boolean didWork) {
        this.state.setDidWork(didWork);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public boolean getEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public Task deleteAllActions() {
        this.actions.clear();
        return this;
    }

    @Override
    public void execute() {
        this.executer.execute(this, this.state);
        this.state.rethrowFailure();
    }

    @Override
    public TaskExecuter getExecuter() {
        return this.executer;
    }

    @Override
    public void setExecuter(TaskExecuter executer) {
        this.executer = executer;
    }

    @Override
    public Task dependsOn(Object ... paths) {
        this.dependencies.add(paths);
        return this;
    }

    @Override
    public Task doFirst(Action<? super Task> action) {
        if (action == null) {
            throw new InvalidUserDataException("Action must not be null!");
        }
        this.actions.add(0, action);
        return this;
    }

    @Override
    public Task doLast(Action<? super Task> action) {
        if (action == null) {
            throw new InvalidUserDataException("Action must not be null!");
        }
        this.actions.add(action);
        return this;
    }

    @Override
    public int compareTo(Task otherTask) {
        int depthCompare = this.project.compareTo(otherTask.getProject());
        if (depthCompare == 0) {
            return this.getPath().compareTo(otherTask.getPath());
        }
        return depthCompare;
    }

    public String toString() {
        return String.format("task '%s'", this.path);
    }

    @Override
    public Logger getLogger() {
        return buildLogger;
    }

    @Override
    public Task disableStandardOutputCapture() {
        DeprecationLogger.nagUser("Task.disableStandardOutputCapture()");
        this.loggingManager.disableStandardOutputCapture();
        return this;
    }

    @Override
    public Task captureStandardOutput(LogLevel level) {
        DeprecationLogger.nagUser("Task.captureStandardOutput()", "getLogging().captureStandardOutput()");
        this.loggingManager.captureStandardOutput(level);
        return this;
    }

    @Override
    public LoggingManager getLogging() {
        return this.loggingManager;
    }

    @Override
    public StandardOutputCapture getStandardOutputCapture() {
        return this.loggingManager;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.dynamicObjectHelper.getAdditionalProperties();
    }

    public DynamicObjectHelper getDynamicObjectHelper() {
        return this.dynamicObjectHelper;
    }

    @Override
    public Object property(String propertyName) throws MissingPropertyException {
        return this.dynamicObjectHelper.getProperty(propertyName);
    }

    @Override
    public boolean hasProperty(String propertyName) {
        return this.dynamicObjectHelper.hasProperty(propertyName);
    }

    @Override
    public void setProperty(String name, Object value) {
        this.dynamicObjectHelper.setProperty(name, value);
    }

    @Override
    public Convention getConvention() {
        return this.dynamicObjectHelper.getConvention();
    }

    @Override
    public void setConvention(Convention convention) {
        this.dynamicObjectHelper.setConvention(convention);
    }

    @Override
    public DynamicObject getAsDynamicObject() {
        return this.dynamicObjectHelper;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getGroup() {
        return this.group;
    }

    @Override
    public void setGroup(String group) {
        this.group = group;
    }

    @Override
    public TaskInputs getInputs() {
        return this.inputs;
    }

    @Override
    public TaskOutputsInternal getOutputs() {
        return this.outputs;
    }

    protected ServiceRegistry getServices() {
        return this.services;
    }

    @Override
    public boolean dependsOnTaskDidWork() {
        TaskDependencyInternal dependency = this.getTaskDependencies();
        for (Task task : dependency.getDependencies(this)) {
            if (!task.getDidWork()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Task doFirst(Closure action) {
        if (action == null) {
            throw new InvalidUserDataException("Action must not be null!");
        }
        this.doFirst(this.convertClosureToAction(action));
        return this;
    }

    @Override
    public Task doLast(Closure action) {
        if (action == null) {
            throw new InvalidUserDataException("Action must not be null!");
        }
        this.doLast(this.convertClosureToAction(action));
        return this;
    }

    @Override
    public Task leftShift(Closure action) {
        return this.doLast(action);
    }

    @Override
    public Task configure(Closure closure) {
        return ConfigureUtil.configure(closure, this);
    }

    @Override
    public File getTemporaryDir() {
        File dir = this.getServices().get(TemporaryFileProvider.class).newTemporaryFile(this.getName());
        dir.mkdirs();
        return dir;
    }

    @Override
    public void addValidator(TaskValidator validator) {
        this.validators.add(validator);
    }

    @Override
    public List<TaskValidator> getValidators() {
        return this.validators;
    }

    private Action<Task> convertClosureToAction(Closure actionClosure) {
        actionClosure.setDelegate((Object)this);
        actionClosure.setResolveStrategy(1);
        return new ClosureTaskAction(actionClosure);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ClosureTaskAction
    implements Action<Task> {
        private final Closure closure;

        private ClosureTaskAction(Closure closure) {
            this.closure = closure;
        }

        @Override
        public void execute(Task task) {
            try {
                if (this.closure.getMaximumNumberOfParameters() == 0) {
                    this.closure.call();
                } else {
                    this.closure.call((Object)task);
                }
            }
            catch (InvokerInvocationException e) {
                Throwable cause = e.getCause();
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                throw e;
            }
        }
    }

    private static class TaskInfo {
        private final ProjectInternal project;
        private final String name;

        private TaskInfo(ProjectInternal project, String name) {
            this.name = name;
            this.project = project;
        }
    }
}

