/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.List;
import org.gradle.api.GradleException;
import org.gradle.api.internal.MultiCauseException;
import org.gradle.util.GUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractMultiCauseException
extends GradleException
implements MultiCauseException {
    private List<Throwable> causes;
    private final ThreadLocal<Boolean> hideCause = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };

    public AbstractMultiCauseException(String message, Iterable<? extends Throwable> causes) {
        super(message);
        this.causes = GUtil.addLists(causes);
    }

    @Override
    public List<? extends Throwable> getCauses() {
        return this.causes;
    }

    @Override
    public Throwable getCause() {
        if (this.hideCause.get().booleanValue()) {
            return null;
        }
        return this.causes.isEmpty() ? null : this.causes.get(0);
    }

    @Override
    public void printStackTrace(PrintStream printStream) {
        PrintWriter writer = new PrintWriter(printStream);
        this.printStackTrace(writer);
        writer.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printStackTrace(PrintWriter printWriter) {
        if (this.causes.size() <= 1) {
            super.printStackTrace(printWriter);
            return;
        }
        this.hideCause.set(true);
        try {
            super.printStackTrace(printWriter);
            for (int i = 0; i < this.causes.size(); ++i) {
                Throwable cause = this.causes.get(i);
                printWriter.format("Cause %s: ", i + 1);
                cause.printStackTrace(printWriter);
            }
        }
        finally {
            this.hideCause.set(false);
        }
    }
}

