/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal;

import groovy.lang.Closure;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.DomainObjectCollection;
import org.gradle.api.specs.Spec;
import org.gradle.api.specs.Specs;
import org.gradle.util.ConfigureUtil;
import org.gradle.util.DeprecationLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDomainObjectCollection<T>
implements DomainObjectCollection<T> {
    private final Store<T> store;

    protected AbstractDomainObjectCollection(Store<T> store) {
        this.store = store;
    }

    @Override
    public Set<T> getAll() {
        return new LinkedHashSet<T>(this.store.getAll());
    }

    @Override
    public Set<T> findAll(Spec<? super T> spec) {
        return Specs.filterIterable(this.store.getAll(), spec);
    }

    @Override
    public Iterator<T> iterator() {
        return this.getAll().iterator();
    }

    @Override
    public void allObjects(Action<? super T> action) {
        DeprecationLogger.nagUser("DomainObjectCollection.allObjects()", "all()");
        this.all(action);
    }

    @Override
    public void allObjects(Closure action) {
        DeprecationLogger.nagUser("DomainObjectCollection.allObjects()", "all()");
        this.all(action);
    }

    @Override
    public void all(Action<? super T> action) {
        this.whenObjectAdded(action);
        for (T t : new ArrayList<T>(this.store.getAll())) {
            action.execute(t);
        }
    }

    @Override
    public void all(Closure action) {
        this.all(this.toAction(action));
    }

    @Override
    public <S extends T> DomainObjectCollection<S> withType(Class<S> type, Action<? super S> configureAction) {
        DomainObjectCollection<S> result = this.withType(type);
        result.all(configureAction);
        return result;
    }

    @Override
    public <S extends T> DomainObjectCollection<S> withType(Class<S> type, Closure configureClosure) {
        DomainObjectCollection<S> result = this.withType(type);
        result.all(configureClosure);
        return result;
    }

    @Override
    public Action<? super T> whenObjectAdded(Action<? super T> action) {
        this.store.objectAdded(action);
        return action;
    }

    @Override
    public Action<? super T> whenObjectRemoved(Action<? super T> action) {
        this.store.objectRemoved(action);
        return action;
    }

    @Override
    public void whenObjectAdded(Closure action) {
        this.whenObjectAdded(this.toAction(action));
    }

    private Action<? super T> toAction(final Closure action) {
        return new Action<T>(){

            @Override
            public void execute(T t) {
                ConfigureUtil.configure(action, t);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class FilteredStore<S>
    implements Store<S> {
        private final Store<? super S> store;
        private final Class<S> type;
        private final Spec<? super S> spec;

        public FilteredStore(Store<? super S> store, Class<S> type, Spec<? super S> spec) {
            this.store = store;
            this.type = type;
            this.spec = spec;
        }

        @Override
        public Collection<? extends S> getAll() {
            ArrayList<S> values = new ArrayList<S>();
            for (S s : this.store.getAll()) {
                S filtered = this.filter(s);
                if (filtered == null) continue;
                values.add(filtered);
            }
            return values;
        }

        @Override
        public void objectAdded(Action<? super S> action) {
            this.store.objectAdded(this.filter(action));
        }

        @Override
        public void objectRemoved(Action<? super S> action) {
            this.store.objectRemoved(this.filter(action));
        }

        protected S filter(Object object) {
            if (!this.type.isInstance(object)) {
                return null;
            }
            S s = this.type.cast(object);
            if (!this.spec.isSatisfiedBy(s)) {
                return null;
            }
            return s;
        }

        protected Action<Object> filter(final Action<? super S> action) {
            return new Action<Object>(){

                @Override
                public void execute(Object object) {
                    Object s = FilteredStore.this.filter(object);
                    if (s != null) {
                        action.execute(s);
                    }
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static interface Store<S> {
        public Collection<? extends S> getAll();

        public void objectAdded(Action<? super S> var1);

        public void objectRemoved(Action<? super S> var1);
    }
}

