/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.gradle.api.GradleException;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.internal.ClassPathProvider;
import org.gradle.api.internal.DefaultClassPathProvider;
import org.gradle.api.internal.GradleDistributionLocator;
import org.gradle.util.ClasspathUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractClassPathProvider
implements ClassPathProvider,
GradleDistributionLocator {
    private final List<Pattern> all = Arrays.asList(Pattern.compile(".+"));
    private final Map<String, List<Pattern>> classPaths = new HashMap<String, List<Pattern>>();
    private final Scanner runtimeLibs;
    private final Scanner pluginLibs;
    private final Scanner coreImplLibs;
    private final File gradleHome;

    protected AbstractClassPathProvider() {
        File codeSource = AbstractClassPathProvider.getClasspathForClass(DefaultClassPathProvider.class);
        if (codeSource.isFile()) {
            this.gradleHome = codeSource.getParentFile().getParentFile();
            this.runtimeLibs = new DirScanner(new File(this.gradleHome + "/lib"));
            this.pluginLibs = new DirScanner(new File(this.gradleHome + "/lib/plugins"));
            this.coreImplLibs = new DirScanner(new File(this.gradleHome + "/lib/core-impl"));
        } else {
            this.gradleHome = null;
            this.pluginLibs = this.runtimeLibs = new ClassPathScanner(codeSource);
            this.coreImplLibs = this.runtimeLibs;
        }
    }

    @Override
    public File getGradleHome() {
        return this.gradleHome;
    }

    protected void add(String name, List<Pattern> patterns) {
        this.classPaths.put(name, patterns);
    }

    protected static List<Pattern> toPatterns(String ... patternStrings) {
        ArrayList<Pattern> patterns = new ArrayList<Pattern>();
        for (String patternString : patternStrings) {
            patterns.add(Pattern.compile(patternString + "-.+"));
        }
        return patterns;
    }

    @Override
    public Set<File> findClassPath(String name) {
        LinkedHashSet<File> matches = new LinkedHashSet<File>();
        if (name.equals("GRADLE_RUNTIME")) {
            this.runtimeLibs.find(this.all, matches);
            return matches;
        }
        if (name.equals("GRADLE_PLUGINS")) {
            this.pluginLibs.find(this.all, matches);
            return matches;
        }
        if (name.equals("GRADLE_CORE_IMPL")) {
            this.coreImplLibs.find(this.all, matches);
            return matches;
        }
        List<Pattern> classPathPatterns = this.classPaths.get(name);
        if (classPathPatterns != null) {
            this.runtimeLibs.find(classPathPatterns, matches);
            this.pluginLibs.find(classPathPatterns, matches);
            this.coreImplLibs.find(classPathPatterns, matches);
            return matches;
        }
        return null;
    }

    public static File getClasspathForClass(Class<?> targetClass) {
        URI location;
        try {
            location = targetClass.getProtectionDomain().getCodeSource().getLocation().toURI();
        }
        catch (URISyntaxException e) {
            throw new UncheckedIOException(e);
        }
        if (!location.getScheme().equals("file")) {
            throw new GradleException(String.format("Cannot determine Gradle home using codebase '%s'.", location));
        }
        return new File(location.getPath());
    }

    private static boolean matches(Iterable<Pattern> patterns, String name) {
        for (Pattern pattern : patterns) {
            if (!pattern.matcher(name).matches()) continue;
            return true;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ClassPathScanner
    implements Scanner {
        private final File classesDir;
        private final Collection<URL> classpath;

        private ClassPathScanner(File classesDir) {
            this.classesDir = classesDir;
            this.classpath = ClasspathUtil.getClasspath(this.getClass().getClassLoader());
        }

        @Override
        public void find(Iterable<Pattern> patterns, Collection<File> into) {
            if (AbstractClassPathProvider.matches(patterns, "gradle-core-version.jar")) {
                into.add(this.classesDir);
            }
            for (URL url : this.classpath) {
                if (!url.getProtocol().equals("file")) continue;
                try {
                    File file = new File(url.toURI());
                    if (!AbstractClassPathProvider.matches(patterns, file.getName())) continue;
                    into.add(file);
                }
                catch (URISyntaxException e) {
                    throw new UncheckedIOException(e);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DirScanner
    implements Scanner {
        private final File dir;

        private DirScanner(File dir) {
            this.dir = dir;
        }

        @Override
        public void find(Iterable<Pattern> patterns, Collection<File> into) {
            for (File file : this.dir.listFiles()) {
                if (!AbstractClassPathProvider.matches(patterns, file.getName())) continue;
                into.add(file);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface Scanner {
        public void find(Iterable<Pattern> var1, Collection<File> var2);
    }
}

