/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal;

import groovy.lang.GroovyObject;
import groovy.lang.GroovySystem;
import groovy.lang.MetaBeanProperty;
import groovy.lang.MetaClass;
import groovy.lang.MetaMethod;
import groovy.lang.MetaProperty;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gradle.api.GradleException;
import org.gradle.api.internal.ClassGenerator;
import org.gradle.api.internal.DynamicObjectAware;
import org.gradle.api.internal.IConventionAware;
import org.gradle.api.internal.NoConventionMapping;
import org.gradle.api.internal.NoDynamicObject;
import org.gradle.util.ReflectionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractClassGenerator
implements ClassGenerator {
    private static final Map<Class, Map<Class, Class>> GENERATED_CLASSES = new HashMap<Class, Map<Class, Class>>();

    @Override
    public <T> T newInstance(Class<T> type, Object ... parameters) {
        return type.cast(ReflectionUtil.newInstance(this.generate(type), parameters));
    }

    @Override
    public <T> Class<? extends T> generate(Class<T> type) {
        Class<T> subclass;
        Class generatedClass;
        Map<Class, Class> cache = GENERATED_CLASSES.get(this.getClass());
        if (cache == null) {
            cache = new HashMap<Class, Class>();
            GENERATED_CLASSES.put(this.getClass(), cache);
        }
        if ((generatedClass = cache.get(type)) != null) {
            return generatedClass;
        }
        if (Modifier.isPrivate(type.getModifiers())) {
            throw new GradleException(String.format("Cannot create a proxy class for private class '%s'.", type.getSimpleName()));
        }
        if (Modifier.isAbstract(type.getModifiers())) {
            throw new GradleException(String.format("Cannot create a proxy class for abstract class '%s'.", type.getSimpleName()));
        }
        try {
            ClassBuilder<T> builder = this.start(type);
            boolean isConventionAware = type.getAnnotation(NoConventionMapping.class) == null;
            boolean isDynamicAware = type.getAnnotation(NoDynamicObject.class) == null;
            builder.startClass(isConventionAware, isDynamicAware);
            if (isDynamicAware && !DynamicObjectAware.class.isAssignableFrom(type)) {
                builder.mixInDynamicAware();
            }
            if (isDynamicAware && !GroovyObject.class.isAssignableFrom(type)) {
                builder.mixInGroovyObject();
            }
            if (isDynamicAware) {
                builder.addDynamicMethods();
            }
            if (isConventionAware && !IConventionAware.class.isAssignableFrom(type)) {
                builder.mixInConventionAware();
            }
            Class noMappingClass = Object.class;
            for (Class<T> c = type; c != null && noMappingClass == Object.class; c = c.getSuperclass()) {
                if (c.getAnnotation(NoConventionMapping.class) == null) continue;
                noMappingClass = c;
            }
            List<String> skipProperties = Arrays.asList("metaClass", "conventionMapping", "convention", "asDynamicObject");
            MetaClass metaClass = GroovySystem.getMetaClassRegistry().getMetaClass(type);
            for (MetaProperty property : metaClass.getProperties()) {
                Class declaringClass;
                MetaBeanProperty metaBeanProperty;
                MetaMethod getter;
                if (skipProperties.contains(property.getName()) || !(property instanceof MetaBeanProperty) || (getter = (metaBeanProperty = (MetaBeanProperty)property).getGetter()) == null || Modifier.isFinal(getter.getModifiers()) || Modifier.isPrivate(getter.getModifiers()) || getter.getReturnType().isPrimitive() || (declaringClass = getter.getDeclaringClass().getTheClass()).isAssignableFrom(noMappingClass)) continue;
                builder.addGetter(metaBeanProperty);
                MetaMethod setter = metaBeanProperty.getSetter();
                if (setter == null || Modifier.isFinal(setter.getModifiers()) || Modifier.isPrivate(setter.getModifiers())) continue;
                builder.addSetter(metaBeanProperty);
            }
            for (Constructor<?> constructor : type.getConstructors()) {
                if (!Modifier.isPublic(constructor.getModifiers())) continue;
                builder.addConstructor(constructor);
            }
            subclass = builder.generate();
        }
        catch (Throwable e) {
            throw new GradleException(String.format("Could not generate a proxy class for class %s.", type.getName()), e);
        }
        cache.put(type, subclass);
        return subclass;
    }

    protected abstract <T> ClassBuilder<T> start(Class<T> var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static interface ClassBuilder<T> {
        public void startClass(boolean var1, boolean var2);

        public void addConstructor(Constructor<?> var1) throws Exception;

        public void mixInDynamicAware() throws Exception;

        public void mixInConventionAware() throws Exception;

        public void mixInGroovyObject() throws Exception;

        public void addDynamicMethods() throws Exception;

        public void addGetter(MetaBeanProperty var1) throws Exception;

        public void addSetter(MetaBeanProperty var1) throws Exception;

        public Class<? extends T> generate() throws Exception;
    }
}

