/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.GradleException;
import org.gradle.api.internal.MultiCauseException;
import org.gradle.groovy.scripts.ScriptSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocationAwareException
extends GradleException {
    private final Throwable target;
    private final ScriptSource source;
    private final Integer lineNumber;

    public LocationAwareException(Throwable cause, Throwable target, ScriptSource source, Integer lineNumber) {
        this.source = source;
        this.lineNumber = lineNumber;
        this.target = target;
        this.initCause(cause);
    }

    public Throwable getTarget() {
        return this.target;
    }

    public String getOriginalMessage() {
        return this.target.getMessage();
    }

    public ScriptSource getScriptSource() {
        return this.source;
    }

    public String getLocation() {
        if (this.source == null) {
            return null;
        }
        String sourceMsg = StringUtils.capitalize((String)this.source.getDisplayName());
        if (this.lineNumber == null) {
            return sourceMsg;
        }
        return String.format("%s line: %d", sourceMsg, this.lineNumber);
    }

    public Integer getLineNumber() {
        return this.lineNumber;
    }

    @Override
    public String getMessage() {
        String location = this.getLocation();
        String message = this.target.getMessage();
        if (location == null && message == null) {
            return null;
        }
        if (location == null) {
            return message;
        }
        if (message == null) {
            return location;
        }
        return String.format("%s%n%s", location, message);
    }

    public List<Throwable> getReportableCauses() {
        ArrayList<Throwable> causes = new ArrayList<Throwable>();
        LinkedList<Throwable> queue = new LinkedList<Throwable>();
        this.addCauses(this.target, queue);
        while (!queue.isEmpty()) {
            Throwable t = queue.removeFirst();
            causes.add(t);
            this.addCauses(t, queue);
        }
        return causes;
    }

    private void addCauses(Throwable t, Collection<Throwable> causes) {
        if (t instanceof MultiCauseException) {
            MultiCauseException multiCauseException = (MultiCauseException)((Object)t);
            causes.addAll(multiCauseException.getCauses());
        } else if (t.getCause() != null) {
            causes.add(t.getCause());
        }
    }
}

