/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum JavaVersion {
    VERSION_1_1(false),
    VERSION_1_2(false),
    VERSION_1_3(false),
    VERSION_1_4(false),
    VERSION_1_5(true),
    VERSION_1_6(true),
    VERSION_1_7(true);

    private final boolean hasMajorVersion;

    private JavaVersion(boolean hasMajorVersion) {
        this.hasMajorVersion = hasMajorVersion;
    }

    public static JavaVersion toVersion(Object value) throws IllegalArgumentException {
        int index;
        if (value == null) {
            return null;
        }
        if (value instanceof JavaVersion) {
            return (JavaVersion)((Object)value);
        }
        String name = value.toString();
        if (name.matches("\\d") && (index = Integer.parseInt(name) - 1) < JavaVersion.values().length && JavaVersion.values()[index].hasMajorVersion) {
            return JavaVersion.values()[index];
        }
        Matcher matcher = Pattern.compile("1\\.(\\d)(\\D.*)?").matcher(name);
        if (matcher.matches()) {
            return JavaVersion.values()[Integer.parseInt(matcher.group(1)) - 1];
        }
        throw new IllegalArgumentException(String.format("Could not determine java version from '%s'.", name));
    }

    public String toString() {
        return this.name().substring("VERSION_".length()).replace('_', '.');
    }
}

