/*
 * Decompiled with CFR 0.152.
 */
package org.gradle;

import java.util.ArrayList;
import java.util.List;
import org.codehaus.groovy.runtime.StackTraceUtils;
import org.gradle.BuildAdapter;
import org.gradle.BuildResult;
import org.gradle.StartParameter;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.LocationAwareException;
import org.gradle.api.logging.LogLevel;
import org.gradle.execution.TaskSelectionException;
import org.gradle.initialization.BuildClientMetaData;
import org.gradle.logging.StyledTextOutput;
import org.gradle.logging.StyledTextOutputFactory;
import org.gradle.logging.internal.AbstractStyledTextOutput;
import org.gradle.util.GUtil;

public class BuildExceptionReporter
extends BuildAdapter {
    private final StyledTextOutputFactory textOutputFactory;
    private final StartParameter startParameter;
    private final BuildClientMetaData clientMetaData;

    public BuildExceptionReporter(StyledTextOutputFactory textOutputFactory, StartParameter startParameter, BuildClientMetaData clientMetaData) {
        this.textOutputFactory = textOutputFactory;
        this.startParameter = startParameter;
        this.clientMetaData = clientMetaData;
    }

    public void buildFinished(BuildResult result) {
        Throwable failure = result.getFailure();
        if (failure == null) {
            return;
        }
        this.reportException(failure);
    }

    public void reportException(Throwable failure) {
        FailureDetails details = new FailureDetails(failure);
        if (failure instanceof GradleException) {
            this.reportBuildFailure((GradleException)failure, details);
        } else {
            this.reportInternalError(details);
        }
        this.write(details);
    }

    protected void write(FailureDetails details) {
        StyledTextOutput output = this.textOutputFactory.create(BuildExceptionReporter.class, LogLevel.ERROR);
        output.println();
        output.withStyle(StyledTextOutput.Style.Failure).text("FAILURE: ");
        details.summary.replay(output.withStyle(StyledTextOutput.Style.Failure));
        if (details.location.hasContent) {
            output.println().println();
            output.println("* Where:");
            details.location.replay(output);
        }
        if (details.details.hasContent) {
            output.println().println();
            output.println("* What went wrong:");
            details.details.replay(output);
        }
        if (details.resolution.hasContent) {
            output.println().println();
            output.println("* Try:");
            details.resolution.replay(output);
        }
        Throwable exception = null;
        switch (details.exceptionStyle) {
            case NONE: {
                break;
            }
            case SANITIZED: {
                exception = StackTraceUtils.deepSanitize((Throwable)details.failure);
                break;
            }
            case FULL: {
                exception = details.failure;
            }
        }
        if (exception != null) {
            output.println().println();
            output.println("* Exception is:");
            output.exception(exception);
        }
        output.println();
    }

    public void reportInternalError(FailureDetails details) {
        details.summary.text("Build aborted because of an internal error.");
        details.details.text("Build aborted because of an unexpected internal error. Please file an issue at: http://www.gradle.org.");
        if (this.startParameter.getLogLevel() != LogLevel.DEBUG) {
            details.resolution.text("Run with ");
            details.resolution.withStyle(StyledTextOutput.Style.UserInput).format("--%s", "debug");
            details.resolution.text(" option to get additional debug info.");
            details.exceptionStyle = ExceptionStyle.FULL;
        }
    }

    private void reportBuildFailure(GradleException failure, FailureDetails details) {
        if (this.startParameter.getShowStacktrace() == StartParameter.ShowStacktrace.ALWAYS || this.startParameter.getLogLevel() == LogLevel.DEBUG) {
            details.exceptionStyle = ExceptionStyle.SANITIZED;
        }
        if (this.startParameter.getShowStacktrace() == StartParameter.ShowStacktrace.ALWAYS_FULL) {
            details.exceptionStyle = ExceptionStyle.FULL;
        }
        if (failure instanceof TaskSelectionException) {
            this.formatTaskSelectionFailure((TaskSelectionException)failure, details);
        } else {
            this.formatGenericFailure(failure, details);
        }
    }

    private void formatTaskSelectionFailure(TaskSelectionException failure, FailureDetails details) {
        assert (failure.getCause() == null);
        details.summary.text("Could not determine which tasks to execute.");
        details.details.text(this.getMessage(failure));
        details.resolution.text("Run ");
        this.clientMetaData.describeCommand(details.resolution.withStyle(StyledTextOutput.Style.UserInput), "tasks");
        details.resolution.text(" to get a list of available tasks.");
    }

    private void formatGenericFailure(GradleException failure, FailureDetails details) {
        details.summary.text("Build failed with an exception.");
        this.fillInFailureResolution(details);
        if (failure instanceof LocationAwareException) {
            LocationAwareException scriptException = (LocationAwareException)failure;
            details.failure = scriptException.getCause();
            if (scriptException.getLocation() != null) {
                details.location.text(scriptException.getLocation());
            }
            details.details.text(scriptException.getOriginalMessage());
            for (Throwable cause : scriptException.getReportableCauses()) {
                details.details.format("%nCause: %s", this.getMessage(cause));
            }
        } else {
            details.details.text(this.getMessage(failure));
        }
    }

    private void fillInFailureResolution(FailureDetails details) {
        if (details.exceptionStyle == ExceptionStyle.NONE) {
            details.resolution.text("Run with ");
            details.resolution.withStyle(StyledTextOutput.Style.UserInput).format("--%s", "stacktrace");
            details.resolution.text(" option to get the stack trace. ");
        }
        if (this.startParameter.getLogLevel() != LogLevel.DEBUG) {
            details.resolution.text("Run with ");
            if (this.startParameter.getLogLevel() != LogLevel.INFO) {
                details.resolution.withStyle(StyledTextOutput.Style.UserInput).format("--%s", "info");
                details.resolution.text(" or ");
            }
            details.resolution.withStyle(StyledTextOutput.Style.UserInput).format("--%s", "debug");
            details.resolution.text(" option to get more log output.");
        }
    }

    private String getMessage(Throwable throwable) {
        String message = throwable.getMessage();
        if (GUtil.isTrue(message)) {
            return message;
        }
        return String.format("%s (no error message)", throwable.getClass().getName());
    }

    private static class RecordingStyledTextOutput
    extends AbstractStyledTextOutput {
        private final List<Action<StyledTextOutput>> events = new ArrayList<Action<StyledTextOutput>>();
        private boolean hasContent;

        private RecordingStyledTextOutput() {
        }

        void replay(StyledTextOutput output) {
            for (Action<StyledTextOutput> event : this.events) {
                event.execute(output);
            }
            this.events.clear();
        }

        protected void doStyleChange(StyledTextOutput.Style style) {
            if (!this.events.isEmpty() && this.events.get(this.events.size() - 1) instanceof ChangeStyleAction) {
                this.events.remove(this.events.size() - 1);
            }
            this.events.add(new ChangeStyleAction(style));
        }

        protected void doAppend(final String text) {
            if (text.length() == 0) {
                return;
            }
            this.hasContent = true;
            this.events.add(new Action<StyledTextOutput>(){

                @Override
                public void execute(StyledTextOutput styledTextOutput) {
                    styledTextOutput.text(text);
                }
            });
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class ChangeStyleAction
        implements Action<StyledTextOutput> {
            private final StyledTextOutput.Style style;

            public ChangeStyleAction(StyledTextOutput.Style style) {
                this.style = style;
            }

            @Override
            public void execute(StyledTextOutput styledTextOutput) {
                styledTextOutput.style(this.style);
            }
        }
    }

    private static class FailureDetails {
        Throwable failure;
        final RecordingStyledTextOutput summary = new RecordingStyledTextOutput();
        final RecordingStyledTextOutput details = new RecordingStyledTextOutput();
        final RecordingStyledTextOutput location = new RecordingStyledTextOutput();
        final RecordingStyledTextOutput resolution = new RecordingStyledTextOutput();
        ExceptionStyle exceptionStyle = ExceptionStyle.NONE;

        public FailureDetails(Throwable failure) {
            this.failure = failure;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ExceptionStyle {
        NONE,
        SANITIZED,
        FULL;

    }
}

