/*
 * Decompiled with CFR 0.152.
 */
package org.gradlewebtools.minify.minifier.js;

import com.google.javascript.jscomp.AbstractCommandLineRunner;
import com.google.javascript.jscomp.CommandLineRunner;
import com.google.javascript.jscomp.Compiler;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.Result;
import com.google.javascript.jscomp.SourceFile;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.Collections;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradlewebtools.minify.minifier.Minifier;
import org.gradlewebtools.minify.minifier.js.JsMinifierOptions;
import org.gradlewebtools.minify.minifier.result.Error;
import org.gradlewebtools.minify.minifier.result.Report;
import org.gradlewebtools.minify.minifier.result.Warning;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0014J\b\u0010\u0018\u001a\u00020\u0014H\u0002J\u0010\u0010\u0019\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\nH\u0014R\u001a\u0010\u0002\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0005R\u0014\u0010\t\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/gradlewebtools/minify/minifier/js/JsMinifier;", "Lorg/gradlewebtools/minify/minifier/Minifier;", "minifierOptions", "Lorg/gradlewebtools/minify/minifier/js/JsMinifierOptions;", "<init>", "(Lorg/gradlewebtools/minify/minifier/js/JsMinifierOptions;)V", "getMinifierOptions", "()Lorg/gradlewebtools/minify/minifier/js/JsMinifierOptions;", "setMinifierOptions", "minifierName", "", "getMinifierName", "()Ljava/lang/String;", "acceptedFileExtensions", "", "getAcceptedFileExtensions", "()Ljava/util/List;", "options", "Lcom/google/javascript/jscomp/CompilerOptions;", "minifyFile", "", "srcFile", "Ljava/io/File;", "dstFile", "setOptions", "rename", "oldName", "gradle-minify-plugin"})
@SourceDebugExtension(value={"SMAP\nJsMinifier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsMinifier.kt\norg/gradlewebtools/minify/minifier/js/JsMinifier\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,88:1\n1#2:89\n1855#3,2:90\n1855#3,2:92\n1855#3,2:94\n*S KotlinDebug\n*F\n+ 1 JsMinifier.kt\norg/gradlewebtools/minify/minifier/js/JsMinifier\n*L\n39#1:90,2\n42#1:92,2\n60#1:94,2\n*E\n"})
public final class JsMinifier
extends Minifier {
    @NotNull
    private JsMinifierOptions minifierOptions;
    @NotNull
    private final String minifierName;
    @NotNull
    private final List<String> acceptedFileExtensions;
    @NotNull
    private final CompilerOptions options;

    public JsMinifier(@NotNull JsMinifierOptions minifierOptions) {
        Intrinsics.checkNotNullParameter((Object)minifierOptions, (String)"minifierOptions");
        this.minifierOptions = minifierOptions;
        this.minifierName = "Js Minifier";
        this.acceptedFileExtensions = CollectionsKt.listOf((Object)"js");
        this.options = new CompilerOptions();
    }

    public /* synthetic */ JsMinifier(JsMinifierOptions jsMinifierOptions, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            jsMinifierOptions = new JsMinifierOptions(null, null, null, null, null, null, false, false, false, null, false, null, null, null, false, null, false, null, null, false, null, false, null, false, 0xFFFFFF, null);
        }
        this(jsMinifierOptions);
    }

    @Override
    @NotNull
    public JsMinifierOptions getMinifierOptions() {
        return this.minifierOptions;
    }

    public void setMinifierOptions(@NotNull JsMinifierOptions jsMinifierOptions) {
        Intrinsics.checkNotNullParameter((Object)jsMinifierOptions, (String)"<set-?>");
        this.minifierOptions = jsMinifierOptions;
    }

    @Override
    @NotNull
    public String getMinifierName() {
        return this.minifierName;
    }

    @Override
    @NotNull
    public List<String> getAcceptedFileExtensions() {
        return this.acceptedFileExtensions;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void minifyFile(@NotNull File srcFile, @NotNull File dstFile) {
        Intrinsics.checkNotNullParameter((Object)srcFile, (String)"srcFile");
        Intrinsics.checkNotNullParameter((Object)dstFile, (String)"dstFile");
        Compiler compiler = new Compiler();
        this.setOptions();
        List externals = AbstractCommandLineRunner.getBuiltinExterns((CompilerOptions.Environment)new CompilerOptions().getEnvironment());
        SourceFile sourceFile = SourceFile.fromFile((String)srcFile.getAbsolutePath());
        File sourcemapFile = new File(dstFile.getAbsolutePath() + ".map");
        if (this.getMinifierOptions().getCreateSourceMaps()) {
            this.options.setSourceMapOutputPath(sourcemapFile.getAbsolutePath());
            this.options.setSourceMapLocationMappings(CollectionsKt.listOf(JsMinifier::minifyFile$lambda$1));
        }
        Result result = compiler.compile(externals, Collections.singletonList(sourceFile), this.options);
        if (result.success) {
            Object source = compiler.toSource();
            if (this.getMinifierOptions().getCreateSourceMaps()) {
                void $this$minifyFile_u24lambda_u242;
                StringBuilder stringBuilder;
                StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
                File file = sourcemapFile;
                JsMinifier jsMinifier = this;
                boolean bl = false;
                result.sourceMap.appendTo((Appendable)$this$minifyFile_u24lambda_u242, dstFile.getName());
                Unit unit = Unit.INSTANCE;
                String string = stringBuilder.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                jsMinifier.writeToFile(file, string);
                source = (String)source + "\n//# sourceMappingURL=" + sourcemapFile.getName();
            }
            String string = source;
            Intrinsics.checkNotNull((Object)string);
            this.writeToFile(dstFile, string);
        } else {
            JSError it;
            ImmutableList immutableList = result.errors;
            Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"errors");
            Iterable $this$forEach$iv = (Iterable)immutableList;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (JSError)element$iv;
                boolean bl = false;
                Report report = this.getReport();
                Intrinsics.checkNotNull((Object)it);
                report.add(new Error(it));
            }
            ImmutableList immutableList2 = result.warnings;
            Intrinsics.checkNotNullExpressionValue((Object)immutableList2, (String)"warnings");
            $this$forEach$iv = (Iterable)immutableList2;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (JSError)element$iv;
                boolean bl = false;
                Report report = this.getReport();
                Intrinsics.checkNotNull((Object)it);
                report.add(new Warning(it));
            }
        }
    }

    private final void setOptions() {
        this.getMinifierOptions().getCompilationLevel().setOptionsForCompilationLevel(this.options);
        this.options.setEnvironment(this.getMinifierOptions().getEnv());
        if (this.getMinifierOptions().getLanguageIn() != null) {
            this.options.setLanguageIn(this.getMinifierOptions().getLanguageIn());
        }
        if (this.getMinifierOptions().getLanguageOut() != null) {
            this.options.setLanguageOut(this.getMinifierOptions().getLanguageOut());
        }
        this.getMinifierOptions().getWarningLevel().setOptionsForWarningLevel(this.options);
        this.options.setExtraAnnotationNames((Iterable)this.getMinifierOptions().getExtraAnnotationNames());
        this.options.setStrictModeInput(this.getMinifierOptions().getStrictModeInput());
        this.options.setStrictModeInput(this.getMinifierOptions().getStrictModeInput());
        if (this.getMinifierOptions().getDebug()) {
            this.getMinifierOptions().getCompilationLevel().setDebugOptionsForCompilationLevel(this.options);
        }
        this.options.setExportLocalPropertyDefinitions(this.getMinifierOptions().getExportLocalPropertyDefinitions());
        Iterable $this$forEach$iv = this.getMinifierOptions().getFormatting();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CommandLineRunner.FormattingOption it = (CommandLineRunner.FormattingOption)element$iv;
            boolean bl = false;
            switch (WhenMappings.$EnumSwitchMapping$0[it.ordinal()]) {
                case 1: {
                    this.options.setPrettyPrint(true);
                    break;
                }
                case 2: {
                    this.options.printInputDelimiter = true;
                    break;
                }
                case 3: {
                    this.options.setPreferSingleQuotes(true);
                    break;
                }
                default: {
                    throw new IllegalStateException(("Unknown formatting option: " + this).toString());
                }
            }
        }
        this.options.setGenerateExports(this.getMinifierOptions().getGenerateExports());
        this.options.setRenamePrefixNamespace(this.getMinifierOptions().getRenamePrefixNamespace());
        this.options.setRenamePrefix(this.getMinifierOptions().getRenameVariablePrefix());
        this.options.setModuleResolutionMode(this.getMinifierOptions().getModuleResolution());
        this.options.setProcessCommonJSModules(this.getMinifierOptions().getProcessCommonJsModules());
        this.options.setPackageJsonEntryNames(this.getMinifierOptions().getPackageJsonEntryNames());
        this.options.setAngularPass(this.getMinifierOptions().getAngularPass());
        this.options.setForceLibraryInjection((Iterable)this.getMinifierOptions().getForceInjectLibrary());
        this.options.setPolymerVersion(this.getMinifierOptions().getPolymerVersion());
        this.options.setRewritePolyfills(this.getMinifierOptions().getRewritePolyfills());
        this.options.setOutputCharset(this.getMinifierOptions().getCharset());
        this.options.setChecksOnly(this.getMinifierOptions().getChecksOnly());
        if (this.getMinifierOptions().getBrowserFeaturesetYear() != null) {
            Integer n = this.getMinifierOptions().getBrowserFeaturesetYear();
            Intrinsics.checkNotNull((Object)n);
            this.options.setBrowserFeaturesetYear(n.intValue());
        }
        this.options.setEmitUseStrict(this.getMinifierOptions().getEmitUseStrict());
    }

    @Override
    @NotNull
    protected String rename(@NotNull String oldName) {
        Intrinsics.checkNotNullParameter((Object)oldName, (String)"oldName");
        return StringsKt.replace$default((String)oldName, (String)".js", (String)".min.js", (boolean)false, (int)4, null);
    }

    private static final String minifyFile$lambda$1(String it) {
        String string;
        Intrinsics.checkNotNull((Object)it);
        String it2 = string = StringsKt.substringAfterLast$default((String)it, (String)"/", null, (int)2, null);
        boolean bl = false;
        return ((CharSequence)it2).length() > 0 ? string : null;
    }

    public JsMinifier() {
        this(null, 1, null);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CommandLineRunner.FormattingOption.values().length];
            try {
                nArray[CommandLineRunner.FormattingOption.PRETTY_PRINT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CommandLineRunner.FormattingOption.PRINT_INPUT_DELIMITER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CommandLineRunner.FormattingOption.SINGLE_QUOTES.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

