/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.predefined.wasi.fd;

import com.oracle.truffle.api.TruffleFile;
import java.util.Objects;

final class PreopenedDirectory {
    private final TruffleFile hostPath;
    private final int hostPathLength;
    private final TruffleFile virtualPath;
    private final int virtualPathLength;

    PreopenedDirectory(TruffleFile hostPath, TruffleFile virtualPath) {
        Objects.requireNonNull(hostPath);
        Objects.requireNonNull(virtualPath);
        assert (hostPath.isAbsolute()) : "hostRoot must be absolute";
        this.hostPath = hostPath.normalize();
        this.hostPathLength = this.hostPath.getPath().length();
        this.virtualPath = virtualPath.normalize();
        this.virtualPathLength = this.virtualPath.getPath().length();
    }

    private static String getRelativePath(TruffleFile virtualFile, TruffleFile rootPath, int rootPathLength) {
        String virtualPath = virtualFile.getPath();
        int virtualFileLength = virtualPath.length();
        if (virtualFileLength == rootPathLength) {
            return "";
        }
        if (rootPathLength == 1) {
            if (rootPath.isAbsolute()) {
                return virtualPath.substring(1);
            }
            if (rootPath.getPath().equals(".")) {
                return virtualPath;
            }
        }
        return virtualPath.substring(rootPathLength + 1);
    }

    TruffleFile containedVirtualFile(TruffleFile virtualFile) {
        Objects.requireNonNull(virtualFile);
        TruffleFile result = virtualFile.normalize();
        return result.startsWith(this.virtualPath) || !result.isAbsolute() && this.virtualPathLength == 1 && this.virtualPath.getPath().equals(".") ? result : null;
    }

    TruffleFile containedHostFile(TruffleFile hostFile) {
        Objects.requireNonNull(hostFile);
        TruffleFile result = this.hostPath.resolve(hostFile.getPath()).normalize();
        return result.isAbsolute() && result.startsWith(this.hostPath) ? result : null;
    }

    TruffleFile virtualFileToHostFile(TruffleFile virtualTruffleFile) {
        Objects.requireNonNull(virtualTruffleFile);
        TruffleFile resolvedVirtualTruffleFile = this.containedVirtualFile(virtualTruffleFile);
        if (resolvedVirtualTruffleFile != null) {
            String relativePathToRoot = PreopenedDirectory.getRelativePath(resolvedVirtualTruffleFile, this.virtualPath, this.virtualPathLength);
            return this.containedHostFile(this.hostPath.resolve(relativePathToRoot));
        }
        return null;
    }

    TruffleFile hostFileToVirtualFile(TruffleFile hostTruffleFile) {
        Objects.requireNonNull(hostTruffleFile);
        TruffleFile resolvedHostTruffleFile = this.containedHostFile(hostTruffleFile);
        if (resolvedHostTruffleFile != null) {
            String resolvedPathToRoot = PreopenedDirectory.getRelativePath(resolvedHostTruffleFile, this.hostPath, this.hostPathLength);
            return this.containedVirtualFile(this.virtualPath.resolve(resolvedPathToRoot));
        }
        return null;
    }
}

