/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.predefined.wasi.fd;

import com.oracle.truffle.api.nodes.Node;
import java.io.IOException;
import java.io.OutputStream;
import org.graalvm.wasm.memory.WasmMemory;
import org.graalvm.wasm.predefined.wasi.FlagUtils;
import org.graalvm.wasm.predefined.wasi.fd.Fd;
import org.graalvm.wasm.predefined.wasi.fd.FdUtils;
import org.graalvm.wasm.predefined.wasi.types.Errno;
import org.graalvm.wasm.predefined.wasi.types.Fdflags;
import org.graalvm.wasm.predefined.wasi.types.Filetype;
import org.graalvm.wasm.predefined.wasi.types.Rights;

final class OutputStreamFd
extends Fd {
    private static final long FS_RIGHTS_BASE = FlagUtils.flags(Rights.FdWrite);
    private static final long FS_RIGHTS_INHERITING = 0L;
    private static final short FS_FLAGS = FlagUtils.flagsShort(Fdflags.Append);
    private final OutputStream outputStream;

    OutputStreamFd(OutputStream outputStream) {
        super(Filetype.CharacterDevice, FS_RIGHTS_BASE, 0L, FS_FLAGS);
        this.outputStream = outputStream;
    }

    @Override
    public Errno write(Node node, WasmMemory memory, int iovecArrayAddress, int iovecCount, int sizeAddress) {
        if (!FlagUtils.isSet(this.fsRightsBase, Rights.FdWrite)) {
            return Errno.Notcapable;
        }
        return FdUtils.writeToStream(node, memory, this.outputStream, iovecArrayAddress, iovecCount, sizeAddress);
    }

    @Override
    public Errno pwrite(Node node, WasmMemory memory, int iovecArrayAddress, int iovecCount, long offset, int sizeAddress) {
        if (!FlagUtils.isSet(this.fsRightsBase, Rights.FdWrite)) {
            return Errno.Notcapable;
        }
        return Errno.Spipe;
    }

    @Override
    public Errno datasync() {
        if (!FlagUtils.isSet(this.fsRightsBase, Rights.FdDatasync)) {
            return Errno.Notcapable;
        }
        try {
            this.outputStream.flush();
        }
        catch (IOException e) {
            return Errno.Io;
        }
        return Errno.Success;
    }

    @Override
    public Errno sync() {
        if (!FlagUtils.isSet(this.fsRightsBase, Rights.FdSync)) {
            return Errno.Notcapable;
        }
        try {
            this.outputStream.flush();
        }
        catch (IOException e) {
            return Errno.Io;
        }
        return Errno.Success;
    }
}

