/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.predefined.wasi.fd;

import com.oracle.truffle.api.nodes.Node;
import java.io.InputStream;
import org.graalvm.wasm.memory.WasmMemory;
import org.graalvm.wasm.predefined.wasi.FlagUtils;
import org.graalvm.wasm.predefined.wasi.fd.Fd;
import org.graalvm.wasm.predefined.wasi.fd.FdUtils;
import org.graalvm.wasm.predefined.wasi.types.Errno;
import org.graalvm.wasm.predefined.wasi.types.Fdflags;
import org.graalvm.wasm.predefined.wasi.types.Filetype;
import org.graalvm.wasm.predefined.wasi.types.Rights;

final class InputStreamFd
extends Fd {
    private static final long FS_RIGHTS_BASE = FlagUtils.flags(Rights.FdRead);
    private static final long FS_RIGHTS_INHERITING = 0L;
    private static final short FS_FLAGS = FlagUtils.flagsShort(Fdflags.Append);
    private final InputStream inputStream;

    InputStreamFd(InputStream inputStream) {
        super(Filetype.CharacterDevice, FS_RIGHTS_BASE, 0L, FS_FLAGS);
        this.inputStream = inputStream;
    }

    @Override
    public Errno read(Node node, WasmMemory memory, int iovecArrayAddress, int iovecCount, int sizeAddress) {
        if (!FlagUtils.isSet(this.fsRightsBase, Rights.FdRead)) {
            return Errno.Notcapable;
        }
        return FdUtils.readFromStream(node, memory, this.inputStream, iovecArrayAddress, iovecCount, sizeAddress);
    }

    @Override
    public Errno pread(Node node, WasmMemory memory, int iovecArrayAddress, int iovecCount, long offset, int sizeAddress) {
        if (!FlagUtils.isSet(this.fsRightsBase, Rights.FdRead)) {
            return Errno.Notcapable;
        }
        return Errno.Spipe;
    }
}

