/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.predefined.wasi.fd;

import com.oracle.truffle.api.TruffleFile;
import com.oracle.truffle.api.nodes.Node;
import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.graalvm.wasm.memory.WasmMemory;
import org.graalvm.wasm.predefined.wasi.FlagUtils;
import org.graalvm.wasm.predefined.wasi.WasiClockTimeGetNode;
import org.graalvm.wasm.predefined.wasi.fd.FdUtils;
import org.graalvm.wasm.predefined.wasi.fd.SeekableByteChannelFd;
import org.graalvm.wasm.predefined.wasi.types.Errno;
import org.graalvm.wasm.predefined.wasi.types.Fdflags;
import org.graalvm.wasm.predefined.wasi.types.Filetype;
import org.graalvm.wasm.predefined.wasi.types.Fstflags;
import org.graalvm.wasm.predefined.wasi.types.Oflags;
import org.graalvm.wasm.predefined.wasi.types.Rights;

class FileFd
extends SeekableByteChannelFd {
    private static final int APPEND_GROW_CHUNK_SIZE = 0x100000;
    private final TruffleFile file;
    private final short oflags;

    FileFd(TruffleFile file, short oflags, long fsRightsBase, long fsRightsInheriting, short fdFlags) throws IOException {
        super(file.newByteChannel(FileFd.parseOptions(oflags, fdFlags), new FileAttribute[0]), Filetype.RegularFile, fsRightsBase, fsRightsInheriting, fdFlags);
        this.file = file;
        this.oflags = oflags;
    }

    private static Set<? extends OpenOption> parseOptions(short oflags, short fdFlags) {
        LinkedHashSet<StandardOpenOption> openOptions = new LinkedHashSet<StandardOpenOption>();
        openOptions.add(StandardOpenOption.READ);
        openOptions.add(StandardOpenOption.WRITE);
        if (FlagUtils.isSet(oflags, Oflags.Creat)) {
            openOptions.add(StandardOpenOption.CREATE);
        }
        assert (!FlagUtils.isSet(oflags, Oflags.Directory));
        if (FlagUtils.isSet(oflags, Oflags.Excl)) {
            openOptions.add(StandardOpenOption.CREATE_NEW);
        }
        if (FlagUtils.isSet(oflags, Oflags.Trunc)) {
            openOptions.add(StandardOpenOption.TRUNCATE_EXISTING);
        }
        if (FlagUtils.isSet(fdFlags, Fdflags.Append)) {
            openOptions.add(StandardOpenOption.APPEND);
            openOptions.remove(StandardOpenOption.READ);
        }
        if (FlagUtils.isSet(fdFlags, Fdflags.Dsync)) {
            openOptions.add(StandardOpenOption.DSYNC);
        }
        if (FlagUtils.isSet(fdFlags, Fdflags.Nonblock)) {
            // empty if block
        }
        if (FlagUtils.isSet(fdFlags, Fdflags.Sync)) {
            openOptions.add(StandardOpenOption.SYNC);
        }
        if (FlagUtils.isSet(fdFlags, Fdflags.Rsync)) {
            throw new IllegalArgumentException("Rsync is not supported");
        }
        return openOptions;
    }

    @Override
    public Errno filestatGet(Node node, WasmMemory memory, int resultAddress) {
        if (!FlagUtils.isSet(this.fsRightsBase, Rights.FdFilestatGet)) {
            return Errno.Notcapable;
        }
        return FdUtils.writeFilestat(node, memory, resultAddress, this.file);
    }

    @Override
    public Errno fdstatSetFlags(Node node, WasmMemory memory, short newFsflags) {
        if (!FlagUtils.isSet(this.fsRightsBase, Rights.FdFdstatSetFlags)) {
            return Errno.Notcapable;
        }
        try {
            this.close();
            this.fdFlags = newFsflags;
            this.setChannel(this.file.newByteChannel(FileFd.parseOptions(this.oflags, newFsflags), new FileAttribute[0]));
            return Errno.Success;
        }
        catch (IOException e) {
            return Errno.Io;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Errno filestatSetSize(Node node, long size) {
        block12: {
            if (!FlagUtils.isSet(this.fsRightsBase, Rights.FdFilestatSetSize)) {
                return Errno.Notcapable;
            }
            if (size < 0L) {
                return Errno.Inval;
            }
            try {
                if (size < this.file.size(new LinkOption[0])) {
                    this.getChannel().truncate(size);
                    break block12;
                }
                if (size <= this.file.size(new LinkOption[0])) break block12;
                if (FlagUtils.isSet(this.fdFlags, Fdflags.Append)) {
                    long sizeDifference = size - this.file.size(new LinkOption[0]);
                    if (sizeDifference >= 0x100000L) {
                        byte[] chunk = new byte[0x100000];
                        while (sizeDifference >= 0x100000L) {
                            this.getOutputStream().write(chunk);
                            sizeDifference -= 0x100000L;
                        }
                        this.getOutputStream().write(chunk, 0, (int)sizeDifference);
                    } else {
                        byte[] chunk = new byte[(int)sizeDifference];
                        this.getOutputStream().write(chunk);
                    }
                    this.getOutputStream().write(new byte[(int)(size - this.file.size(new LinkOption[0]))]);
                    break block12;
                }
                long currentPosition = this.getChannel().position();
                try {
                    this.getChannel().position(size - 1L);
                    this.getOutputStream().write(0);
                }
                finally {
                    this.getChannel().position(currentPosition);
                }
            }
            catch (IOException e) {
                return Errno.Io;
            }
        }
        return Errno.Success;
    }

    @Override
    public Errno filestatSetTimes(Node node, long atim, long mtim, int fstFlags) {
        if (!FlagUtils.isSet(this.fsRightsBase, Rights.FdFilestatSetTimes)) {
            return Errno.Notcapable;
        }
        try {
            if (FlagUtils.isSet(fstFlags, Fstflags.Atim)) {
                this.file.setLastAccessTime(FileTime.from(atim, TimeUnit.NANOSECONDS), new LinkOption[0]);
            }
            if (FlagUtils.isSet(fstFlags, Fstflags.AtimNow)) {
                this.file.setLastAccessTime(FileTime.from(WasiClockTimeGetNode.realtimeNow(), TimeUnit.NANOSECONDS), new LinkOption[0]);
            }
            if (FlagUtils.isSet(fstFlags, Fstflags.Mtim)) {
                this.file.setLastModifiedTime(FileTime.from(mtim, TimeUnit.NANOSECONDS), new LinkOption[0]);
            }
            if (FlagUtils.isSet(fstFlags, Fstflags.MtimNow)) {
                this.file.setLastModifiedTime(FileTime.from(WasiClockTimeGetNode.realtimeNow(), TimeUnit.NANOSECONDS), new LinkOption[0]);
            }
        }
        catch (IOException e) {
            return Errno.Io;
        }
        catch (SecurityException e) {
            return Errno.Acces;
        }
        return Errno.Success;
    }
}

