/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.predefined.wasi;

import org.graalvm.wasm.WasmContext;
import org.graalvm.wasm.WasmLanguage;
import org.graalvm.wasm.WasmModule;
import org.graalvm.wasm.predefined.BuiltinModule;
import org.graalvm.wasm.predefined.wasi.WasiArgsGetNode;
import org.graalvm.wasm.predefined.wasi.WasiArgsSizesGetNode;
import org.graalvm.wasm.predefined.wasi.WasiClockResGetNode;
import org.graalvm.wasm.predefined.wasi.WasiClockTimeGetNode;
import org.graalvm.wasm.predefined.wasi.WasiConstantRandomGetNode;
import org.graalvm.wasm.predefined.wasi.WasiEnvironGetNode;
import org.graalvm.wasm.predefined.wasi.WasiEnvironSizesGetNode;
import org.graalvm.wasm.predefined.wasi.WasiFdAdviseNode;
import org.graalvm.wasm.predefined.wasi.WasiFdCloseNode;
import org.graalvm.wasm.predefined.wasi.WasiFdDatasyncNode;
import org.graalvm.wasm.predefined.wasi.WasiFdFdstatGetNode;
import org.graalvm.wasm.predefined.wasi.WasiFdFdstatSetFlagsNode;
import org.graalvm.wasm.predefined.wasi.WasiFdFdstatSetRightsNode;
import org.graalvm.wasm.predefined.wasi.WasiFdFilestatGetNode;
import org.graalvm.wasm.predefined.wasi.WasiFdFilestatSetSizeNode;
import org.graalvm.wasm.predefined.wasi.WasiFdFilestatSetTimesNode;
import org.graalvm.wasm.predefined.wasi.WasiFdPreadNode;
import org.graalvm.wasm.predefined.wasi.WasiFdPrestatDirNameNode;
import org.graalvm.wasm.predefined.wasi.WasiFdPrestatGetNode;
import org.graalvm.wasm.predefined.wasi.WasiFdPwriteNode;
import org.graalvm.wasm.predefined.wasi.WasiFdReadNode;
import org.graalvm.wasm.predefined.wasi.WasiFdReaddirNode;
import org.graalvm.wasm.predefined.wasi.WasiFdRenumberNode;
import org.graalvm.wasm.predefined.wasi.WasiFdSeekNode;
import org.graalvm.wasm.predefined.wasi.WasiFdSyncNode;
import org.graalvm.wasm.predefined.wasi.WasiFdTellNode;
import org.graalvm.wasm.predefined.wasi.WasiFdWriteNode;
import org.graalvm.wasm.predefined.wasi.WasiPathCreateDirectoryNode;
import org.graalvm.wasm.predefined.wasi.WasiPathFileStatGetNode;
import org.graalvm.wasm.predefined.wasi.WasiPathFilestatSetTimesNode;
import org.graalvm.wasm.predefined.wasi.WasiPathLinkNode;
import org.graalvm.wasm.predefined.wasi.WasiPathOpenNode;
import org.graalvm.wasm.predefined.wasi.WasiPathReadLinkNode;
import org.graalvm.wasm.predefined.wasi.WasiPathRemoveDirectoryNode;
import org.graalvm.wasm.predefined.wasi.WasiPathRenameNode;
import org.graalvm.wasm.predefined.wasi.WasiPathSymlinkNode;
import org.graalvm.wasm.predefined.wasi.WasiPathUnlinkFileNode;
import org.graalvm.wasm.predefined.wasi.WasiProcExitNode;
import org.graalvm.wasm.predefined.wasi.WasiRandomGetNode;
import org.graalvm.wasm.predefined.wasi.WasiSchedYieldNode;
import org.graalvm.wasm.predefined.wasi.WasiUnsupportedFunctionNode;

public final class WasiModule
extends BuiltinModule {
    private static final byte POINTER_TYPE = 127;
    private static final byte CONST_POINTER_TYPE = 127;
    private static final byte RECORD_TYPE = 127;
    private static final byte UNION_TYPE = 127;
    private static final byte HANDLE_TYPE = 127;
    private static final byte LIST_ADDRESS_TYPE = 127;
    private static final byte LIST_LENGTH_TYPE = 127;
    private static final byte STRING_ADDRESS_TYPE = 127;
    private static final byte STRING_LENGTH_TYPE = 127;
    private static final byte U8_TYPE = 127;
    private static final byte U16_TYPE = 127;
    private static final byte U32_TYPE = 127;
    private static final byte U64_TYPE = 126;
    private static final byte S64_TYPE = 126;
    private static final byte RETURN_VALUE_ADDRESS_TYPE = 127;
    private static final byte SIZE_TYPE = 127;
    private static final byte FILESIZE_TYPE = 126;
    private static final byte TIMESTAMP_TYPE = 126;
    private static final byte CLOCKID_TYPE = 127;
    private static final byte ERRNO_TYPE = 127;
    private static final byte RIGHTS_TYPE = 126;
    private static final byte FD_TYPE = 127;
    private static final byte IOVEC_TYPE = 127;
    private static final byte CIOVEC_TYPE = 127;
    private static final byte IOVEC_ARRAY_ADDRESS_TYPE = 127;
    private static final byte IOVEC_ARRAY_LENGTH_TYPE = 127;
    private static final byte CIOVEC_ARRAY_ADDRESS_TYPE = 127;
    private static final byte CIOVEC_ARRAY_LENGTH_TYPE = 127;
    private static final byte FILEDELTA_TYPE = 126;
    private static final byte WHENCE_TYPE = 127;
    private static final byte DIRCOOKIE_TYPE = 126;
    private static final byte DIRNAMLEN_TYPE = 127;
    private static final byte INODE_TYPE = 126;
    private static final byte FILETYPE_TYPE = 127;
    private static final byte DIRENT_TYPE = 127;
    private static final byte ADVICE_TYPE = 127;
    private static final byte FDFLAGS_TYPE = 127;
    private static final byte FDSTAT_TYPE = 127;
    private static final byte DEVICE_TYPE = 126;
    private static final byte FSTFLAGS_TYPE = 127;
    private static final byte LOOKUPFLAGS_TYPE = 127;
    private static final byte OFLAGS_TYPE = 127;
    private static final byte LINKCOUNT_TYPE = 126;
    private static final byte FILESTAT_TYPE = 127;
    private static final byte USERDATA_TYPE = 126;
    private static final byte EVENTTYPE_TYPE = 127;
    private static final byte EVENTRWFLAGS_TYPE = 127;
    private static final byte EVENT_FD_READWRITE_TYPE = 127;
    private static final byte EVENT_TYPE = 127;
    private static final byte SUBCLOCKFLAGS_TYPE = 127;
    private static final byte SUBSCRIPTION_CLOCK_TYPE = 127;
    private static final byte SUBSCRIPTION_FD_READWRITE_TYPE = 127;
    private static final byte SUBSCRIPTION_U_TYPE = 127;
    private static final byte SUBSCRIPTION_TYPE = 127;
    private static final byte EXITCODE_TYPE = 127;
    private static final byte SIGNAL_TYPE = 127;
    private static final byte RIFLAGS_TYPE = 127;
    private static final byte ROFLAGS_TYPE = 127;
    private static final byte SIFLAGS_TYPE = 127;
    private static final byte SDFLAGS_TYPE = 127;
    private static final byte PREOPENTYPE_TYPE = 127;
    private static final byte PRESTAT_DIR_TYPE = 127;
    private static final byte PRESTAT_TYPE = 127;

    @Override
    protected WasmModule createModule(WasmLanguage language, WasmContext context, String name) {
        WasmModule module = WasmModule.createBuiltin(name);
        if (context.getContextOptions().supportMemory64()) {
            this.importMemory(context, module, "main", "memory", 0, 0x1000000000000L, true, false);
        } else {
            this.importMemory(context, module, "main", "memory", 0, 65536L, false, false);
        }
        this.defineFunction(context, module, "args_get", WasiModule.types(127, 127), WasiModule.types(127), new WasiArgsGetNode(language, module));
        this.defineFunction(context, module, "args_sizes_get", WasiModule.types(127, 127), WasiModule.types(127), new WasiArgsSizesGetNode(language, module));
        this.defineFunction(context, module, "environ_get", WasiModule.types(127, 127), WasiModule.types(127), new WasiEnvironGetNode(language, module));
        this.defineFunction(context, module, "environ_sizes_get", WasiModule.types(127, 127), WasiModule.types(127), new WasiEnvironSizesGetNode(language, module));
        this.defineFunction(context, module, "clock_res_get", WasiModule.types(127, 127), WasiModule.types(127), new WasiClockResGetNode(language, module));
        this.defineFunction(context, module, "clock_time_get", WasiModule.types(127, 126, 127), WasiModule.types(127), new WasiClockTimeGetNode(language, module));
        this.defineFunction(context, module, "fd_advise", WasiModule.types(127, 126, 126, 127), WasiModule.types(127), new WasiFdAdviseNode(language, module));
        this.defineFunction(context, module, "fd_allocate", WasiModule.types(127, 126, 126), WasiModule.types(127), new WasiUnsupportedFunctionNode(language, module, "__wasi_fd_allocate"));
        this.defineFunction(context, module, "fd_close", WasiModule.types(127), WasiModule.types(127), new WasiFdCloseNode(language, module));
        this.defineFunction(context, module, "fd_datasync", WasiModule.types(127), WasiModule.types(127), new WasiFdDatasyncNode(language, module));
        this.defineFunction(context, module, "fd_fdstat_get", WasiModule.types(127, 127), WasiModule.types(127), new WasiFdFdstatGetNode(language, module));
        this.defineFunction(context, module, "fd_fdstat_set_flags", WasiModule.types(127, 127), WasiModule.types(127), new WasiFdFdstatSetFlagsNode(language, module));
        this.defineFunction(context, module, "fd_fdstat_set_rights", WasiModule.types(127, 126, 126), WasiModule.types(127), new WasiFdFdstatSetRightsNode(language, module));
        this.defineFunction(context, module, "fd_filestat_get", WasiModule.types(127, 127), WasiModule.types(127), new WasiFdFilestatGetNode(language, module));
        this.defineFunction(context, module, "fd_filestat_set_size", WasiModule.types(127, 126), WasiModule.types(127), new WasiFdFilestatSetSizeNode(language, module));
        this.defineFunction(context, module, "fd_filestat_set_times", WasiModule.types(127, 126, 126, 127), WasiModule.types(127), new WasiFdFilestatSetTimesNode(language, module));
        this.defineFunction(context, module, "fd_pread", WasiModule.types(127, 127, 127, 126, 127), WasiModule.types(127), new WasiFdPreadNode(language, module));
        this.defineFunction(context, module, "fd_prestat_get", WasiModule.types(127, 127), WasiModule.types(127), new WasiFdPrestatGetNode(language, module));
        this.defineFunction(context, module, "fd_prestat_dir_name", WasiModule.types(127, 127, 127), WasiModule.types(127), new WasiFdPrestatDirNameNode(language, module));
        this.defineFunction(context, module, "fd_pwrite", WasiModule.types(127, 127, 127, 126, 127), WasiModule.types(127), new WasiFdPwriteNode(language, module));
        this.defineFunction(context, module, "fd_read", WasiModule.types(127, 127, 127, 127), WasiModule.types(127), new WasiFdReadNode(language, module));
        this.defineFunction(context, module, "fd_readdir", WasiModule.types(127, 127, 127, 126, 127), WasiModule.types(127), new WasiFdReaddirNode(language, module));
        this.defineFunction(context, module, "fd_renumber", WasiModule.types(127, 127), WasiModule.types(127), new WasiFdRenumberNode(language, module));
        this.defineFunction(context, module, "fd_seek", WasiModule.types(127, 126, 127, 127), WasiModule.types(127), new WasiFdSeekNode(language, module));
        this.defineFunction(context, module, "fd_sync", WasiModule.types(127), WasiModule.types(127), new WasiFdSyncNode(language, module));
        this.defineFunction(context, module, "fd_tell", WasiModule.types(127, 127), WasiModule.types(127), new WasiFdTellNode(language, module));
        this.defineFunction(context, module, "fd_write", WasiModule.types(127, 127, 127, 127), WasiModule.types(127), new WasiFdWriteNode(language, module));
        this.defineFunction(context, module, "path_create_directory", WasiModule.types(127, 127, 127), WasiModule.types(127), new WasiPathCreateDirectoryNode(language, module));
        this.defineFunction(context, module, "path_filestat_get", WasiModule.types(127, 127, 127, 127, 127), WasiModule.types(127), new WasiPathFileStatGetNode(language, module));
        this.defineFunction(context, module, "path_filestat_set_times", WasiModule.types(127, 127, 127, 127, 126, 126, 127), WasiModule.types(127), new WasiPathFilestatSetTimesNode(language, module));
        this.defineFunction(context, module, "path_link", WasiModule.types(127, 127, 127, 127, 127, 127, 127), WasiModule.types(127), new WasiPathLinkNode(language, module));
        this.defineFunction(context, module, "path_open", WasiModule.types(127, 127, 127, 127, 127, 126, 126, 127, 127), WasiModule.types(127), new WasiPathOpenNode(language, module));
        this.defineFunction(context, module, "path_readlink", WasiModule.types(127, 127, 127, 127, 127, 127), WasiModule.types(127), new WasiPathReadLinkNode(language, module));
        this.defineFunction(context, module, "path_remove_directory", WasiModule.types(127, 127, 127), WasiModule.types(127), new WasiPathRemoveDirectoryNode(language, module));
        this.defineFunction(context, module, "path_rename", WasiModule.types(127, 127, 127, 127, 127, 127), WasiModule.types(127), new WasiPathRenameNode(language, module));
        this.defineFunction(context, module, "path_symlink", WasiModule.types(127, 127, 127, 127, 127), WasiModule.types(127), new WasiPathSymlinkNode(language, module));
        this.defineFunction(context, module, "path_unlink_file", WasiModule.types(127, 127, 127), WasiModule.types(127), new WasiPathUnlinkFileNode(language, module));
        this.defineFunction(context, module, "poll_oneoff", WasiModule.types(127, 127, 127, 127), WasiModule.types(127), new WasiUnsupportedFunctionNode(language, module, "__wasi_poll_oneoff"));
        this.defineFunction(context, module, "proc_exit", WasiModule.types(127), WasiModule.types(new byte[0]), new WasiProcExitNode(language, module));
        this.defineFunction(context, module, "proc_raise", WasiModule.types(127), WasiModule.types(127), new WasiUnsupportedFunctionNode(language, module, "__wasi_proc_raise"));
        this.defineFunction(context, module, "sched_yield", WasiModule.types(new byte[0]), WasiModule.types(127), new WasiSchedYieldNode(language, module));
        if (context.getContextOptions().constantRandomGet()) {
            this.defineFunction(context, module, "random_get", WasiModule.types(127, 127), WasiModule.types(127), new WasiConstantRandomGetNode(language, module));
        } else {
            this.defineFunction(context, module, "random_get", WasiModule.types(127, 127), WasiModule.types(127), new WasiRandomGetNode(language, module));
        }
        this.defineFunction(context, module, "sock_accept", WasiModule.types(127, 127, 127), WasiModule.types(127), new WasiUnsupportedFunctionNode(language, module, "__wasi_sock_accept"));
        this.defineFunction(context, module, "sock_recv", WasiModule.types(127, 127, 127, 127, 127, 127), WasiModule.types(127), new WasiUnsupportedFunctionNode(language, module, "__wasi_sock_recv"));
        this.defineFunction(context, module, "sock_send", WasiModule.types(127, 127, 127, 127, 127), WasiModule.types(127), new WasiUnsupportedFunctionNode(language, module, "__wasi_sock_send"));
        this.defineFunction(context, module, "sock_shutdown", WasiModule.types(127, 127), WasiModule.types(127), new WasiUnsupportedFunctionNode(language, module, "__wasi_sock_shutdown"));
        return module;
    }
}

