/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.predefined.wasi;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import org.graalvm.wasm.WasmArguments;
import org.graalvm.wasm.WasmInstance;
import org.graalvm.wasm.WasmLanguage;
import org.graalvm.wasm.WasmModule;
import org.graalvm.wasm.WasmStore;
import org.graalvm.wasm.memory.WasmMemory;
import org.graalvm.wasm.predefined.WasmBuiltinRootNode;
import org.graalvm.wasm.predefined.wasi.fd.Fd;
import org.graalvm.wasm.predefined.wasi.types.Errno;

public final class WasiFdWriteNode
extends WasmBuiltinRootNode {
    public WasiFdWriteNode(WasmLanguage language, WasmModule module) {
        super(language, module);
    }

    @Override
    public Object executeWithInstance(VirtualFrame frame, WasmInstance instance) {
        Object[] args = frame.getArguments();
        return this.fdWrite(instance.store(), this.memory(frame), (Integer)WasmArguments.getArgument(args, 0), (Integer)WasmArguments.getArgument(args, 1), (Integer)WasmArguments.getArgument(args, 2), (Integer)WasmArguments.getArgument(args, 3));
    }

    @CompilerDirectives.TruffleBoundary
    private int fdWrite(WasmStore store, WasmMemory memory, int fd, int iov, int iovcnt, int sizeAddress) {
        Fd handle = store.fdManager().get(fd);
        if (handle == null) {
            return Errno.Badf.ordinal();
        }
        return handle.write((Node)this, memory, iov, iovcnt, sizeAddress).ordinal();
    }

    @Override
    public String builtinNodeName() {
        return "__wasi_fd_write";
    }
}

