/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.predefined.wasi;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import org.graalvm.wasm.WasmArguments;
import org.graalvm.wasm.WasmInstance;
import org.graalvm.wasm.WasmLanguage;
import org.graalvm.wasm.WasmModule;
import org.graalvm.wasm.WasmStore;
import org.graalvm.wasm.predefined.WasmBuiltinRootNode;
import org.graalvm.wasm.predefined.wasi.fd.Fd;
import org.graalvm.wasm.predefined.wasi.types.Errno;

public class WasiFdFilestatSetSizeNode
extends WasmBuiltinRootNode {
    protected WasiFdFilestatSetSizeNode(WasmLanguage language, WasmModule module) {
        super(language, module);
    }

    @Override
    public Object executeWithInstance(VirtualFrame frame, WasmInstance instance) {
        Object[] args = frame.getArguments();
        return this.fdstatSetSize(instance.store(), (Integer)WasmArguments.getArgument(args, 0), (Long)WasmArguments.getArgument(args, 1));
    }

    @CompilerDirectives.TruffleBoundary
    private int fdstatSetSize(WasmStore store, int fd, long size) {
        Fd handle = store.fdManager().get(fd);
        if (handle == null) {
            return Errno.Badf.ordinal();
        }
        return handle.filestatSetSize((Node)this, size).ordinal();
    }

    @Override
    public String builtinNodeName() {
        return "__wasi_fd_filestat_set_size";
    }
}

