/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.predefined.wasi;

public final class FlagUtils {
    public static short set(short value, Enum<?> e) {
        assert (((Enum[])e.getClass().getEnumConstants()).length < 16);
        return (short)FlagUtils.set((long)value, e);
    }

    public static long set(long value, Enum<?> e) {
        return value | 1L << e.ordinal();
    }

    public static boolean isSet(short value, Enum<?> e) {
        return FlagUtils.isSet((long)value, e);
    }

    public static boolean isSet(long value, Enum<?> e) {
        return (value & 1L << e.ordinal()) != 0L;
    }

    public static short remove(short value, Enum<?> e) {
        assert (((Enum[])e.getClass().getEnumConstants()).length < 16);
        return (short)FlagUtils.remove((long)value, e);
    }

    public static long remove(long value, Enum<?> e) {
        return value & (1L << e.ordinal() ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public static boolean isSubsetOf(long a, long b) {
        return (a & b) == a;
    }

    @SafeVarargs
    public static <E extends Enum<E>> short flagsShort(Enum<E> ... flagsSet) {
        assert (flagsSet.length == 0 || ((Enum[])flagsSet[0].getClass().getEnumConstants()).length < 16);
        return (short)FlagUtils.flags(flagsSet);
    }

    @SafeVarargs
    public static <E extends Enum<E>> long flags(Enum<E> ... flagsSet) {
        long result = 0L;
        for (Enum<E> flag : flagsSet) {
            result = FlagUtils.set(result, flag);
        }
        return result;
    }

    public static <E extends Enum<E>> long allFlagsSet(Class<E> flagsEnum) {
        return (1L << ((Enum[])flagsEnum.getEnumConstants()).length) - 1L;
    }
}

