/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.parser.validation;

import com.oracle.truffle.api.CompilerDirectives;
import java.util.StringJoiner;
import org.graalvm.wasm.exception.Failure;
import org.graalvm.wasm.exception.WasmException;

public class ValidationErrors {
    private static String getValueTypeString(byte valueType) {
        switch (valueType) {
            case 64: {
                return "";
            }
            case 127: {
                return "i32";
            }
            case 126: {
                return "i64";
            }
            case 125: {
                return "f32";
            }
            case 124: {
                return "f64";
            }
            case 123: {
                return "v128";
            }
            case 112: {
                return "funcref";
            }
            case 111: {
                return "externref";
            }
        }
        return "unknown";
    }

    private static String getValueTypesString(byte[] valueTypes) {
        StringJoiner stringJoiner = new StringJoiner(",");
        for (byte valueType : valueTypes) {
            stringJoiner.add(ValidationErrors.getValueTypeString(valueType));
        }
        return stringJoiner.toString();
    }

    private static WasmException create(String message, Object expected, Object actual) {
        return WasmException.format(Failure.TYPE_MISMATCH, message, expected, actual);
    }

    @CompilerDirectives.TruffleBoundary
    public static WasmException createTypeMismatch(byte expectedType, byte actualType) {
        String expectedTypeString = ValidationErrors.getValueTypeString(expectedType);
        String actualTypeString = ValidationErrors.getValueTypeString(actualType);
        return ValidationErrors.create("Expected type [%s], but got [%s].", expectedTypeString, actualTypeString);
    }

    @CompilerDirectives.TruffleBoundary
    public static WasmException createResultTypesMismatch(byte[] expectedTypes, byte[] actualTypes) {
        String expectedTypesString = ValidationErrors.getValueTypesString(expectedTypes);
        String actualTypesString = ValidationErrors.getValueTypesString(actualTypes);
        return ValidationErrors.create("Expected result types [%s], but got [%s].", expectedTypesString, actualTypesString);
    }

    @CompilerDirectives.TruffleBoundary
    public static WasmException createLabelTypesMismatch(byte[] expectedTypes, byte[] actualTypes) {
        String expectedTypesString = ValidationErrors.getValueTypesString(expectedTypes);
        String actualTypesString = ValidationErrors.getValueTypesString(actualTypes);
        return ValidationErrors.create("Inconsistent label types. Expected [%s], but got [%s].", expectedTypesString, actualTypesString);
    }

    @CompilerDirectives.TruffleBoundary
    public static WasmException createParamTypesMismatch(byte[] expectedTypes, byte[] actualTypes) {
        String expectedTypesString = ValidationErrors.getValueTypesString(expectedTypes);
        String actualTypesString = ValidationErrors.getValueTypesString(actualTypes);
        return ValidationErrors.create("Expected param types [%s], but got [%s].", expectedTypesString, actualTypesString);
    }

    @CompilerDirectives.TruffleBoundary
    public static WasmException createMissingLabel(int expected, int max) {
        return WasmException.format(Failure.UNKNOWN_LABEL, "Unknown branch label %d (max %d).", expected, max);
    }

    @CompilerDirectives.TruffleBoundary
    public static WasmException createMissingFunctionType(int expected, int max) {
        return WasmException.format(Failure.UNKNOWN_TYPE, "Function type variable %d out of range. (max %d)", expected, max);
    }

    @CompilerDirectives.TruffleBoundary
    public static WasmException createExpectedAnyOnEmptyStack() {
        return WasmException.create(Failure.TYPE_MISMATCH, "Expected type [any], but got [].");
    }

    @CompilerDirectives.TruffleBoundary
    public static WasmException createExpectedTypeOnEmptyStack(byte expectedType) {
        String expectedTypeString = ValidationErrors.getValueTypeString(expectedType);
        return ValidationErrors.create("Expected type [%s], but got [].", expectedTypeString, "");
    }
}

