/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.memory;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.library.Library;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.library.Message;
import com.oracle.truffle.api.library.ReflectionLibrary;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnadoptableNode;
import com.oracle.truffle.api.utilities.FinalBitSet;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.MethodHandles;
import java.nio.ByteBuffer;
import java.util.BitSet;
import java.util.List;
import java.util.concurrent.locks.Lock;
import org.graalvm.wasm.memory.WasmMemory;
import org.graalvm.wasm.memory.WasmMemoryLibrary;

@GeneratedBy(value=WasmMemoryLibrary.class)
final class WasmMemoryLibraryGen
extends LibraryFactory<WasmMemoryLibrary> {
    private static final Class<WasmMemoryLibrary> LIBRARY_CLASS = WasmMemoryLibraryGen.lazyLibraryClass();
    private static final Message SIZE = new MessageImpl("size", 0, false, Long.TYPE, WasmMemory.class);
    private static final Message BYTE_SIZE = new MessageImpl("byteSize", 1, false, Long.TYPE, WasmMemory.class);
    private static final Message GROW = new MessageImpl("grow", 2, false, Long.TYPE, WasmMemory.class, Long.TYPE);
    private static final Message INITIALIZE = new MessageImpl("initialize", 3, false, Void.TYPE, WasmMemory.class, Node.class, byte[].class, Integer.TYPE, Long.TYPE, Integer.TYPE);
    private static final Message FILL = new MessageImpl("fill", 4, false, Void.TYPE, WasmMemory.class, Node.class, Long.TYPE, Long.TYPE, Byte.TYPE);
    private static final Message COPY_FROM = new MessageImpl("copyFrom", 5, false, Void.TYPE, WasmMemory.class, Node.class, WasmMemory.class, Long.TYPE, Long.TYPE, Long.TYPE);
    private static final Message COPY_FROM_STREAM = new MessageImpl("copyFromStream", 6, false, Integer.TYPE, WasmMemory.class, Node.class, InputStream.class, Integer.TYPE, Integer.TYPE);
    private static final Message COPY_TO_STREAM = new MessageImpl("copyToStream", 7, false, Void.TYPE, WasmMemory.class, Node.class, OutputStream.class, Integer.TYPE, Integer.TYPE);
    private static final Message COPY_TO_BUFFER = new MessageImpl("copyToBuffer", 8, false, Void.TYPE, WasmMemory.class, Node.class, byte[].class, Long.TYPE, Integer.TYPE, Integer.TYPE);
    private static final Message LOAD_I32 = new MessageImpl("load_i32", 9, false, Integer.TYPE, WasmMemory.class, Node.class, Long.TYPE);
    private static final Message LOAD_I64 = new MessageImpl("load_i64", 10, false, Long.TYPE, WasmMemory.class, Node.class, Long.TYPE);
    private static final Message LOAD_F32 = new MessageImpl("load_f32", 11, false, Float.TYPE, WasmMemory.class, Node.class, Long.TYPE);
    private static final Message LOAD_F64 = new MessageImpl("load_f64", 12, false, Double.TYPE, WasmMemory.class, Node.class, Long.TYPE);
    private static final Message LOAD_I32_8S = new MessageImpl("load_i32_8s", 13, false, Integer.TYPE, WasmMemory.class, Node.class, Long.TYPE);
    private static final Message LOAD_I32_8U = new MessageImpl("load_i32_8u", 14, false, Integer.TYPE, WasmMemory.class, Node.class, Long.TYPE);
    private static final Message LOAD_I32_16S = new MessageImpl("load_i32_16s", 15, false, Integer.TYPE, WasmMemory.class, Node.class, Long.TYPE);
    private static final Message LOAD_I32_16U = new MessageImpl("load_i32_16u", 16, false, Integer.TYPE, WasmMemory.class, Node.class, Long.TYPE);
    private static final Message LOAD_I64_8S = new MessageImpl("load_i64_8s", 17, false, Long.TYPE, WasmMemory.class, Node.class, Long.TYPE);
    private static final Message LOAD_I64_8U = new MessageImpl("load_i64_8u", 18, false, Long.TYPE, WasmMemory.class, Node.class, Long.TYPE);
    private static final Message LOAD_I64_16S = new MessageImpl("load_i64_16s", 19, false, Long.TYPE, WasmMemory.class, Node.class, Long.TYPE);
    private static final Message LOAD_I64_16U = new MessageImpl("load_i64_16u", 20, false, Long.TYPE, WasmMemory.class, Node.class, Long.TYPE);
    private static final Message LOAD_I64_32S = new MessageImpl("load_i64_32s", 21, false, Long.TYPE, WasmMemory.class, Node.class, Long.TYPE);
    private static final Message LOAD_I64_32U = new MessageImpl("load_i64_32u", 22, false, Long.TYPE, WasmMemory.class, Node.class, Long.TYPE);
    private static final Message LOAD_I128 = new MessageImpl("load_i128", 23, false, Object.class, WasmMemory.class, Node.class, Long.TYPE);
    private static final Message STORE_I32 = new MessageImpl("store_i32", 24, false, Void.TYPE, WasmMemory.class, Node.class, Long.TYPE, Integer.TYPE);
    private static final Message STORE_I64 = new MessageImpl("store_i64", 25, false, Void.TYPE, WasmMemory.class, Node.class, Long.TYPE, Long.TYPE);
    private static final Message STORE_F32 = new MessageImpl("store_f32", 26, false, Void.TYPE, WasmMemory.class, Node.class, Long.TYPE, Float.TYPE);
    private static final Message STORE_F64 = new MessageImpl("store_f64", 27, false, Void.TYPE, WasmMemory.class, Node.class, Long.TYPE, Double.TYPE);
    private static final Message STORE_I32_8 = new MessageImpl("store_i32_8", 28, false, Void.TYPE, WasmMemory.class, Node.class, Long.TYPE, Byte.TYPE);
    private static final Message STORE_I32_16 = new MessageImpl("store_i32_16", 29, false, Void.TYPE, WasmMemory.class, Node.class, Long.TYPE, Short.TYPE);
    private static final Message STORE_I64_8 = new MessageImpl("store_i64_8", 30, false, Void.TYPE, WasmMemory.class, Node.class, Long.TYPE, Byte.TYPE);
    private static final Message STORE_I64_16 = new MessageImpl("store_i64_16", 31, false, Void.TYPE, WasmMemory.class, Node.class, Long.TYPE, Short.TYPE);
    private static final Message STORE_I64_32 = new MessageImpl("store_i64_32", 32, false, Void.TYPE, WasmMemory.class, Node.class, Long.TYPE, Integer.TYPE);
    private static final Message STORE_I128 = new MessageImpl("store_i128", 33, false, Void.TYPE, WasmMemory.class, Node.class, Long.TYPE, Object.class);
    private static final Message ATOMIC_LOAD_I32 = new MessageImpl("atomic_load_i32", 34, false, Integer.TYPE, WasmMemory.class, Node.class, Long.TYPE);
    private static final Message ATOMIC_LOAD_I64 = new MessageImpl("atomic_load_i64", 35, false, Long.TYPE, WasmMemory.class, Node.class, Long.TYPE);
    private static final Message ATOMIC_LOAD_I32_8U = new MessageImpl("atomic_load_i32_8u", 36, false, Integer.TYPE, WasmMemory.class, Node.class, Long.TYPE);
    private static final Message ATOMIC_LOAD_I32_16U = new MessageImpl("atomic_load_i32_16u", 37, false, Integer.TYPE, WasmMemory.class, Node.class, Long.TYPE);
    private static final Message ATOMIC_LOAD_I64_8U = new MessageImpl("atomic_load_i64_8u", 38, false, Long.TYPE, WasmMemory.class, Node.class, Long.TYPE);
    private static final Message ATOMIC_LOAD_I64_16U = new MessageImpl("atomic_load_i64_16u", 39, false, Long.TYPE, WasmMemory.class, Node.class, Long.TYPE);
    private static final Message ATOMIC_LOAD_I64_32U = new MessageImpl("atomic_load_i64_32u", 40, false, Long.TYPE, WasmMemory.class, Node.class, Long.TYPE);
    private static final Message ATOMIC_STORE_I32 = new MessageImpl("atomic_store_i32", 41, false, Void.TYPE, WasmMemory.class, Node.class, Long.TYPE, Integer.TYPE);
    private static final Message ATOMIC_STORE_I64 = new MessageImpl("atomic_store_i64", 42, false, Void.TYPE, WasmMemory.class, Node.class, Long.TYPE, Long.TYPE);
    private static final Message ATOMIC_STORE_I32_8 = new MessageImpl("atomic_store_i32_8", 43, false, Void.TYPE, WasmMemory.class, Node.class, Long.TYPE, Byte.TYPE);
    private static final Message ATOMIC_STORE_I32_16 = new MessageImpl("atomic_store_i32_16", 44, false, Void.TYPE, WasmMemory.class, Node.class, Long.TYPE, Short.TYPE);
    private static final Message ATOMIC_STORE_I64_8 = new MessageImpl("atomic_store_i64_8", 45, false, Void.TYPE, WasmMemory.class, Node.class, Long.TYPE, Byte.TYPE);
    private static final Message ATOMIC_STORE_I64_16 = new MessageImpl("atomic_store_i64_16", 46, false, Void.TYPE, WasmMemory.class, Node.class, Long.TYPE, Short.TYPE);
    private static final Message ATOMIC_STORE_I64_32 = new MessageImpl("atomic_store_i64_32", 47, false, Void.TYPE, WasmMemory.class, Node.class, Long.TYPE, Integer.TYPE);
    private static final Message ATOMIC_RMW_ADD_I32_8U = new MessageImpl("atomic_rmw_add_i32_8u", 48, false, Integer.TYPE, WasmMemory.class, Node.class, Long.TYPE, Byte.TYPE);
    private static final Message ATOMIC_RMW_ADD_I32_16U = new MessageImpl("atomic_rmw_add_i32_16u", 49, false, Integer.TYPE, WasmMemory.class, Node.class, Long.TYPE, Short.TYPE);
    private static final Message ATOMIC_RMW_ADD_I32 = new MessageImpl("atomic_rmw_add_i32", 50, false, Integer.TYPE, WasmMemory.class, Node.class, Long.TYPE, Integer.TYPE);
    private static final Message ATOMIC_RMW_ADD_I64_8U = new MessageImpl("atomic_rmw_add_i64_8u", 51, false, Long.TYPE, WasmMemory.class, Node.class, Long.TYPE, Byte.TYPE);
    private static final Message ATOMIC_RMW_ADD_I64_16U = new MessageImpl("atomic_rmw_add_i64_16u", 52, false, Long.TYPE, WasmMemory.class, Node.class, Long.TYPE, Short.TYPE);
    private static final Message ATOMIC_RMW_ADD_I64_32U = new MessageImpl("atomic_rmw_add_i64_32u", 53, false, Long.TYPE, WasmMemory.class, Node.class, Long.TYPE, Integer.TYPE);
    private static final Message ATOMIC_RMW_ADD_I64 = new MessageImpl("atomic_rmw_add_i64", 54, false, Long.TYPE, WasmMemory.class, Node.class, Long.TYPE, Long.TYPE);
    private static final Message ATOMIC_RMW_SUB_I32_8U = new MessageImpl("atomic_rmw_sub_i32_8u", 55, false, Integer.TYPE, WasmMemory.class, Node.class, Long.TYPE, Byte.TYPE);
    private static final Message ATOMIC_RMW_SUB_I32_16U = new MessageImpl("atomic_rmw_sub_i32_16u", 56, false, Integer.TYPE, WasmMemory.class, Node.class, Long.TYPE, Short.TYPE);
    private static final Message ATOMIC_RMW_SUB_I32 = new MessageImpl("atomic_rmw_sub_i32", 57, false, Integer.TYPE, WasmMemory.class, Node.class, Long.TYPE, Integer.TYPE);
    private static final Message ATOMIC_RMW_SUB_I64_8U = new MessageImpl("atomic_rmw_sub_i64_8u", 58, false, Long.TYPE, WasmMemory.class, Node.class, Long.TYPE, Byte.TYPE);
    private static final Message ATOMIC_RMW_SUB_I64_16U = new MessageImpl("atomic_rmw_sub_i64_16u", 59, false, Long.TYPE, WasmMemory.class, Node.class, Long.TYPE, Short.TYPE);
    private static final Message ATOMIC_RMW_SUB_I64_32U = new MessageImpl("atomic_rmw_sub_i64_32u", 60, false, Long.TYPE, WasmMemory.class, Node.class, Long.TYPE, Integer.TYPE);
    private static final Message ATOMIC_RMW_SUB_I64 = new MessageImpl("atomic_rmw_sub_i64", 61, false, Long.TYPE, WasmMemory.class, Node.class, Long.TYPE, Long.TYPE);
    private static final Message ATOMIC_RMW_AND_I32_8U = new MessageImpl("atomic_rmw_and_i32_8u", 62, false, Integer.TYPE, WasmMemory.class, Node.class, Long.TYPE, Byte.TYPE);
    private static final Message ATOMIC_RMW_AND_I32_16U = new MessageImpl("atomic_rmw_and_i32_16u", 63, false, Integer.TYPE, WasmMemory.class, Node.class, Long.TYPE, Short.TYPE);
    private static final Message ATOMIC_RMW_AND_I32 = new MessageImpl("atomic_rmw_and_i32", 64, false, Integer.TYPE, WasmMemory.class, Node.class, Long.TYPE, Integer.TYPE);
    private static final Message ATOMIC_RMW_AND_I64_8U = new MessageImpl("atomic_rmw_and_i64_8u", 65, false, Long.TYPE, WasmMemory.class, Node.class, Long.TYPE, Byte.TYPE);
    private static final Message ATOMIC_RMW_AND_I64_16U = new MessageImpl("atomic_rmw_and_i64_16u", 66, false, Long.TYPE, WasmMemory.class, Node.class, Long.TYPE, Short.TYPE);
    private static final Message ATOMIC_RMW_AND_I64_32U = new MessageImpl("atomic_rmw_and_i64_32u", 67, false, Long.TYPE, WasmMemory.class, Node.class, Long.TYPE, Integer.TYPE);
    private static final Message ATOMIC_RMW_AND_I64 = new MessageImpl("atomic_rmw_and_i64", 68, false, Long.TYPE, WasmMemory.class, Node.class, Long.TYPE, Long.TYPE);
    private static final Message ATOMIC_RMW_OR_I32_8U = new MessageImpl("atomic_rmw_or_i32_8u", 69, false, Integer.TYPE, WasmMemory.class, Node.class, Long.TYPE, Byte.TYPE);
    private static final Message ATOMIC_RMW_OR_I32_16U = new MessageImpl("atomic_rmw_or_i32_16u", 70, false, Integer.TYPE, WasmMemory.class, Node.class, Long.TYPE, Short.TYPE);
    private static final Message ATOMIC_RMW_OR_I32 = new MessageImpl("atomic_rmw_or_i32", 71, false, Integer.TYPE, WasmMemory.class, Node.class, Long.TYPE, Integer.TYPE);
    private static final Message ATOMIC_RMW_OR_I64_8U = new MessageImpl("atomic_rmw_or_i64_8u", 72, false, Long.TYPE, WasmMemory.class, Node.class, Long.TYPE, Byte.TYPE);
    private static final Message ATOMIC_RMW_OR_I64_16U = new MessageImpl("atomic_rmw_or_i64_16u", 73, false, Long.TYPE, WasmMemory.class, Node.class, Long.TYPE, Short.TYPE);
    private static final Message ATOMIC_RMW_OR_I64_32U = new MessageImpl("atomic_rmw_or_i64_32u", 74, false, Long.TYPE, WasmMemory.class, Node.class, Long.TYPE, Integer.TYPE);
    private static final Message ATOMIC_RMW_OR_I64 = new MessageImpl("atomic_rmw_or_i64", 75, false, Long.TYPE, WasmMemory.class, Node.class, Long.TYPE, Long.TYPE);
    private static final Message ATOMIC_RMW_XOR_I32_8U = new MessageImpl("atomic_rmw_xor_i32_8u", 76, false, Integer.TYPE, WasmMemory.class, Node.class, Long.TYPE, Byte.TYPE);
    private static final Message ATOMIC_RMW_XOR_I32_16U = new MessageImpl("atomic_rmw_xor_i32_16u", 77, false, Integer.TYPE, WasmMemory.class, Node.class, Long.TYPE, Short.TYPE);
    private static final Message ATOMIC_RMW_XOR_I32 = new MessageImpl("atomic_rmw_xor_i32", 78, false, Integer.TYPE, WasmMemory.class, Node.class, Long.TYPE, Integer.TYPE);
    private static final Message ATOMIC_RMW_XOR_I64_8U = new MessageImpl("atomic_rmw_xor_i64_8u", 79, false, Long.TYPE, WasmMemory.class, Node.class, Long.TYPE, Byte.TYPE);
    private static final Message ATOMIC_RMW_XOR_I64_16U = new MessageImpl("atomic_rmw_xor_i64_16u", 80, false, Long.TYPE, WasmMemory.class, Node.class, Long.TYPE, Short.TYPE);
    private static final Message ATOMIC_RMW_XOR_I64_32U = new MessageImpl("atomic_rmw_xor_i64_32u", 81, false, Long.TYPE, WasmMemory.class, Node.class, Long.TYPE, Integer.TYPE);
    private static final Message ATOMIC_RMW_XOR_I64 = new MessageImpl("atomic_rmw_xor_i64", 82, false, Long.TYPE, WasmMemory.class, Node.class, Long.TYPE, Long.TYPE);
    private static final Message ATOMIC_RMW_XCHG_I32_8U = new MessageImpl("atomic_rmw_xchg_i32_8u", 83, false, Integer.TYPE, WasmMemory.class, Node.class, Long.TYPE, Byte.TYPE);
    private static final Message ATOMIC_RMW_XCHG_I32_16U = new MessageImpl("atomic_rmw_xchg_i32_16u", 84, false, Integer.TYPE, WasmMemory.class, Node.class, Long.TYPE, Short.TYPE);
    private static final Message ATOMIC_RMW_XCHG_I32 = new MessageImpl("atomic_rmw_xchg_i32", 85, false, Integer.TYPE, WasmMemory.class, Node.class, Long.TYPE, Integer.TYPE);
    private static final Message ATOMIC_RMW_XCHG_I64_8U = new MessageImpl("atomic_rmw_xchg_i64_8u", 86, false, Long.TYPE, WasmMemory.class, Node.class, Long.TYPE, Byte.TYPE);
    private static final Message ATOMIC_RMW_XCHG_I64_16U = new MessageImpl("atomic_rmw_xchg_i64_16u", 87, false, Long.TYPE, WasmMemory.class, Node.class, Long.TYPE, Short.TYPE);
    private static final Message ATOMIC_RMW_XCHG_I64_32U = new MessageImpl("atomic_rmw_xchg_i64_32u", 88, false, Long.TYPE, WasmMemory.class, Node.class, Long.TYPE, Integer.TYPE);
    private static final Message ATOMIC_RMW_XCHG_I64 = new MessageImpl("atomic_rmw_xchg_i64", 89, false, Long.TYPE, WasmMemory.class, Node.class, Long.TYPE, Long.TYPE);
    private static final Message ATOMIC_RMW_CMPXCHG_I32_8U = new MessageImpl("atomic_rmw_cmpxchg_i32_8u", 90, false, Integer.TYPE, WasmMemory.class, Node.class, Long.TYPE, Byte.TYPE, Byte.TYPE);
    private static final Message ATOMIC_RMW_CMPXCHG_I32_16U = new MessageImpl("atomic_rmw_cmpxchg_i32_16u", 91, false, Integer.TYPE, WasmMemory.class, Node.class, Long.TYPE, Short.TYPE, Short.TYPE);
    private static final Message ATOMIC_RMW_CMPXCHG_I32 = new MessageImpl("atomic_rmw_cmpxchg_i32", 92, false, Integer.TYPE, WasmMemory.class, Node.class, Long.TYPE, Integer.TYPE, Integer.TYPE);
    private static final Message ATOMIC_RMW_CMPXCHG_I64_8U = new MessageImpl("atomic_rmw_cmpxchg_i64_8u", 93, false, Long.TYPE, WasmMemory.class, Node.class, Long.TYPE, Byte.TYPE, Byte.TYPE);
    private static final Message ATOMIC_RMW_CMPXCHG_I64_16U = new MessageImpl("atomic_rmw_cmpxchg_i64_16u", 94, false, Long.TYPE, WasmMemory.class, Node.class, Long.TYPE, Short.TYPE, Short.TYPE);
    private static final Message ATOMIC_RMW_CMPXCHG_I64_32U = new MessageImpl("atomic_rmw_cmpxchg_i64_32u", 95, false, Long.TYPE, WasmMemory.class, Node.class, Long.TYPE, Integer.TYPE, Integer.TYPE);
    private static final Message ATOMIC_RMW_CMPXCHG_I64 = new MessageImpl("atomic_rmw_cmpxchg_i64", 96, false, Long.TYPE, WasmMemory.class, Node.class, Long.TYPE, Long.TYPE, Long.TYPE);
    private static final Message ATOMIC_NOTIFY = new MessageImpl("atomic_notify", 97, false, Integer.TYPE, WasmMemory.class, Node.class, Long.TYPE, Integer.TYPE);
    private static final Message ATOMIC_WAIT32 = new MessageImpl("atomic_wait32", 98, false, Integer.TYPE, WasmMemory.class, Node.class, Long.TYPE, Integer.TYPE, Long.TYPE);
    private static final Message ATOMIC_WAIT64 = new MessageImpl("atomic_wait64", 99, false, Integer.TYPE, WasmMemory.class, Node.class, Long.TYPE, Long.TYPE, Long.TYPE);
    private static final Message CLOSE = new MessageImpl("close", 100, false, Void.TYPE, WasmMemory.class);
    private static final Message RESET = new MessageImpl("reset", 101, false, Void.TYPE, WasmMemory.class);
    private static final Message AS_BYTE_BUFFER = new MessageImpl("asByteBuffer", 102, false, ByteBuffer.class, WasmMemory.class);
    private static final Message DUPLICATE = new MessageImpl("duplicate", 103, false, WasmMemory.class, WasmMemory.class);
    private static final Message FREED = new MessageImpl("freed", 104, false, Boolean.TYPE, WasmMemory.class);
    private static final WasmMemoryLibraryGen INSTANCE = new WasmMemoryLibraryGen();

    private WasmMemoryLibraryGen() {
        super(LIBRARY_CLASS, List.of(SIZE, BYTE_SIZE, GROW, INITIALIZE, FILL, COPY_FROM, COPY_FROM_STREAM, COPY_TO_STREAM, COPY_TO_BUFFER, LOAD_I32, LOAD_I64, LOAD_F32, LOAD_F64, LOAD_I32_8S, LOAD_I32_8U, LOAD_I32_16S, LOAD_I32_16U, LOAD_I64_8S, LOAD_I64_8U, LOAD_I64_16S, LOAD_I64_16U, LOAD_I64_32S, LOAD_I64_32U, LOAD_I128, STORE_I32, STORE_I64, STORE_F32, STORE_F64, STORE_I32_8, STORE_I32_16, STORE_I64_8, STORE_I64_16, STORE_I64_32, STORE_I128, ATOMIC_LOAD_I32, ATOMIC_LOAD_I64, ATOMIC_LOAD_I32_8U, ATOMIC_LOAD_I32_16U, ATOMIC_LOAD_I64_8U, ATOMIC_LOAD_I64_16U, ATOMIC_LOAD_I64_32U, ATOMIC_STORE_I32, ATOMIC_STORE_I64, ATOMIC_STORE_I32_8, ATOMIC_STORE_I32_16, ATOMIC_STORE_I64_8, ATOMIC_STORE_I64_16, ATOMIC_STORE_I64_32, ATOMIC_RMW_ADD_I32_8U, ATOMIC_RMW_ADD_I32_16U, ATOMIC_RMW_ADD_I32, ATOMIC_RMW_ADD_I64_8U, ATOMIC_RMW_ADD_I64_16U, ATOMIC_RMW_ADD_I64_32U, ATOMIC_RMW_ADD_I64, ATOMIC_RMW_SUB_I32_8U, ATOMIC_RMW_SUB_I32_16U, ATOMIC_RMW_SUB_I32, ATOMIC_RMW_SUB_I64_8U, ATOMIC_RMW_SUB_I64_16U, ATOMIC_RMW_SUB_I64_32U, ATOMIC_RMW_SUB_I64, ATOMIC_RMW_AND_I32_8U, ATOMIC_RMW_AND_I32_16U, ATOMIC_RMW_AND_I32, ATOMIC_RMW_AND_I64_8U, ATOMIC_RMW_AND_I64_16U, ATOMIC_RMW_AND_I64_32U, ATOMIC_RMW_AND_I64, ATOMIC_RMW_OR_I32_8U, ATOMIC_RMW_OR_I32_16U, ATOMIC_RMW_OR_I32, ATOMIC_RMW_OR_I64_8U, ATOMIC_RMW_OR_I64_16U, ATOMIC_RMW_OR_I64_32U, ATOMIC_RMW_OR_I64, ATOMIC_RMW_XOR_I32_8U, ATOMIC_RMW_XOR_I32_16U, ATOMIC_RMW_XOR_I32, ATOMIC_RMW_XOR_I64_8U, ATOMIC_RMW_XOR_I64_16U, ATOMIC_RMW_XOR_I64_32U, ATOMIC_RMW_XOR_I64, ATOMIC_RMW_XCHG_I32_8U, ATOMIC_RMW_XCHG_I32_16U, ATOMIC_RMW_XCHG_I32, ATOMIC_RMW_XCHG_I64_8U, ATOMIC_RMW_XCHG_I64_16U, ATOMIC_RMW_XCHG_I64_32U, ATOMIC_RMW_XCHG_I64, ATOMIC_RMW_CMPXCHG_I32_8U, ATOMIC_RMW_CMPXCHG_I32_16U, ATOMIC_RMW_CMPXCHG_I32, ATOMIC_RMW_CMPXCHG_I64_8U, ATOMIC_RMW_CMPXCHG_I64_16U, ATOMIC_RMW_CMPXCHG_I64_32U, ATOMIC_RMW_CMPXCHG_I64, ATOMIC_NOTIFY, ATOMIC_WAIT32, ATOMIC_WAIT64, CLOSE, RESET, AS_BYTE_BUFFER, DUPLICATE, FREED));
    }

    protected Class<?> getDefaultClass(Object receiver) {
        return WasmMemoryLibrary.class;
    }

    protected MethodHandles.Lookup getLookup() {
        return MethodHandles.lookup();
    }

    protected WasmMemoryLibrary createProxy(ReflectionLibrary library) {
        return new Proxy(library);
    }

    protected FinalBitSet createMessageBitSet(Message ... messages) {
        BitSet bitSet = new BitSet(2);
        for (Message message : messages) {
            bitSet.set(message.getId());
        }
        return FinalBitSet.valueOf((BitSet)bitSet);
    }

    protected WasmMemoryLibrary createDelegate(WasmMemoryLibrary delegateLibrary) {
        return new Delegate(delegateLibrary);
    }

    protected Object genericDispatch(Library originalLib, Object receiver, Message message, Object[] args, int offset) throws Exception {
        WasmMemoryLibrary lib = (WasmMemoryLibrary)originalLib;
        if (message.getParameterCount() - 1 != args.length - offset) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new IllegalArgumentException("Invalid number of arguments.");
        }
        switch (message.getId()) {
            case 0: {
                return lib.size((WasmMemory)receiver);
            }
            case 1: {
                return lib.byteSize((WasmMemory)receiver);
            }
            case 2: {
                return lib.grow((WasmMemory)receiver, (Long)args[offset]);
            }
            case 3: {
                lib.initialize((WasmMemory)receiver, (Node)args[offset], (byte[])args[offset + 1], (Integer)args[offset + 2], (Long)args[offset + 3], (Integer)args[offset + 4]);
                return null;
            }
            case 4: {
                lib.fill((WasmMemory)receiver, (Node)args[offset], (Long)args[offset + 1], (Long)args[offset + 2], (Byte)args[offset + 3]);
                return null;
            }
            case 5: {
                lib.copyFrom((WasmMemory)receiver, (Node)args[offset], (WasmMemory)args[offset + 1], (Long)args[offset + 2], (Long)args[offset + 3], (Long)args[offset + 4]);
                return null;
            }
            case 6: {
                return lib.copyFromStream((WasmMemory)receiver, (Node)args[offset], (InputStream)args[offset + 1], (Integer)args[offset + 2], (Integer)args[offset + 3]);
            }
            case 7: {
                lib.copyToStream((WasmMemory)receiver, (Node)args[offset], (OutputStream)args[offset + 1], (Integer)args[offset + 2], (Integer)args[offset + 3]);
                return null;
            }
            case 8: {
                lib.copyToBuffer((WasmMemory)receiver, (Node)args[offset], (byte[])args[offset + 1], (Long)args[offset + 2], (Integer)args[offset + 3], (Integer)args[offset + 4]);
                return null;
            }
            case 9: {
                return lib.load_i32((WasmMemory)receiver, (Node)args[offset], (Long)args[offset + 1]);
            }
            case 10: {
                return lib.load_i64((WasmMemory)receiver, (Node)args[offset], (Long)args[offset + 1]);
            }
            case 11: {
                return Float.valueOf(lib.load_f32((WasmMemory)receiver, (Node)args[offset], (Long)args[offset + 1]));
            }
            case 12: {
                return lib.load_f64((WasmMemory)receiver, (Node)args[offset], (Long)args[offset + 1]);
            }
            case 13: {
                return lib.load_i32_8s((WasmMemory)receiver, (Node)args[offset], (Long)args[offset + 1]);
            }
            case 14: {
                return lib.load_i32_8u((WasmMemory)receiver, (Node)args[offset], (Long)args[offset + 1]);
            }
            case 15: {
                return lib.load_i32_16s((WasmMemory)receiver, (Node)args[offset], (Long)args[offset + 1]);
            }
            case 16: {
                return lib.load_i32_16u((WasmMemory)receiver, (Node)args[offset], (Long)args[offset + 1]);
            }
            case 17: {
                return lib.load_i64_8s((WasmMemory)receiver, (Node)args[offset], (Long)args[offset + 1]);
            }
            case 18: {
                return lib.load_i64_8u((WasmMemory)receiver, (Node)args[offset], (Long)args[offset + 1]);
            }
            case 19: {
                return lib.load_i64_16s((WasmMemory)receiver, (Node)args[offset], (Long)args[offset + 1]);
            }
            case 20: {
                return lib.load_i64_16u((WasmMemory)receiver, (Node)args[offset], (Long)args[offset + 1]);
            }
            case 21: {
                return lib.load_i64_32s((WasmMemory)receiver, (Node)args[offset], (Long)args[offset + 1]);
            }
            case 22: {
                return lib.load_i64_32u((WasmMemory)receiver, (Node)args[offset], (Long)args[offset + 1]);
            }
            case 23: {
                return lib.load_i128((WasmMemory)receiver, (Node)args[offset], (Long)args[offset + 1]);
            }
            case 24: {
                lib.store_i32((WasmMemory)receiver, (Node)args[offset], (Long)args[offset + 1], (Integer)args[offset + 2]);
                return null;
            }
            case 25: {
                lib.store_i64((WasmMemory)receiver, (Node)args[offset], (Long)args[offset + 1], (Long)args[offset + 2]);
                return null;
            }
            case 26: {
                lib.store_f32((WasmMemory)receiver, (Node)args[offset], (Long)args[offset + 1], ((Float)args[offset + 2]).floatValue());
                return null;
            }
            case 27: {
                lib.store_f64((WasmMemory)receiver, (Node)args[offset], (Long)args[offset + 1], (Double)args[offset + 2]);
                return null;
            }
            case 28: {
                lib.store_i32_8((WasmMemory)receiver, (Node)args[offset], (Long)args[offset + 1], (Byte)args[offset + 2]);
                return null;
            }
            case 29: {
                lib.store_i32_16((WasmMemory)receiver, (Node)args[offset], (Long)args[offset + 1], (Short)args[offset + 2]);
                return null;
            }
            case 30: {
                lib.store_i64_8((WasmMemory)receiver, (Node)args[offset], (Long)args[offset + 1], (Byte)args[offset + 2]);
                return null;
            }
            case 31: {
                lib.store_i64_16((WasmMemory)receiver, (Node)args[offset], (Long)args[offset + 1], (Short)args[offset + 2]);
                return null;
            }
            case 32: {
                lib.store_i64_32((WasmMemory)receiver, (Node)args[offset], (Long)args[offset + 1], (Integer)args[offset + 2]);
                return null;
            }
            case 33: {
                lib.store_i128((WasmMemory)receiver, (Node)args[offset], (Long)args[offset + 1], args[offset + 2]);
                return null;
            }
            case 34: {
                return lib.atomic_load_i32((WasmMemory)receiver, (Node)args[offset], (Long)args[offset + 1]);
            }
            case 35: {
                return lib.atomic_load_i64((WasmMemory)receiver, (Node)args[offset], (Long)args[offset + 1]);
            }
            case 36: {
                return lib.atomic_load_i32_8u((WasmMemory)receiver, (Node)args[offset], (Long)args[offset + 1]);
            }
            case 37: {
                return lib.atomic_load_i32_16u((WasmMemory)receiver, (Node)args[offset], (Long)args[offset + 1]);
            }
            case 38: {
                return lib.atomic_load_i64_8u((WasmMemory)receiver, (Node)args[offset], (Long)args[offset + 1]);
            }
            case 39: {
                return lib.atomic_load_i64_16u((WasmMemory)receiver, (Node)args[offset], (Long)args[offset + 1]);
            }
            case 40: {
                return lib.atomic_load_i64_32u((WasmMemory)receiver, (Node)args[offset], (Long)args[offset + 1]);
            }
            case 41: {
                lib.atomic_store_i32((WasmMemory)receiver, (Node)args[offset], (Long)args[offset + 1], (Integer)args[offset + 2]);
                return null;
            }
            case 42: {
                lib.atomic_store_i64((WasmMemory)receiver, (Node)args[offset], (Long)args[offset + 1], (Long)args[offset + 2]);
                return null;
            }
            case 43: {
                lib.atomic_store_i32_8((WasmMemory)receiver, (Node)args[offset], (Long)args[offset + 1], (Byte)args[offset + 2]);
                return null;
            }
            case 44: {
                lib.atomic_store_i32_16((WasmMemory)receiver, (Node)args[offset], (Long)args[offset + 1], (Short)args[offset + 2]);
                return null;
            }
            case 45: {
                lib.atomic_store_i64_8((WasmMemory)receiver, (Node)args[offset], (Long)args[offset + 1], (Byte)args[offset + 2]);
                return null;
            }
            case 46: {
                lib.atomic_store_i64_16((WasmMemory)receiver, (Node)args[offset], (Long)args[offset + 1], (Short)args[offset + 2]);
                return null;
            }
            case 47: {
                lib.atomic_store_i64_32((WasmMemory)receiver, (Node)args[offset], (Long)args[offset + 1], (Integer)args[offset + 2]);
                return null;
            }
            case 48: {
                return lib.atomic_rmw_add_i32_8u((WasmMemory)receiver, (Node)args[offset], (Long)args[offset + 1], (Byte)args[offset + 2]);
            }
            case 49: {
                return lib.atomic_rmw_add_i32_16u((WasmMemory)receiver, (Node)args[offset], (Long)args[offset + 1], (Short)args[offset + 2]);
            }
            case 50: {
                return lib.atomic_rmw_add_i32((WasmMemory)receiver, (Node)args[offset], (Long)args[offset + 1], (Integer)args[offset + 2]);
            }
            case 51: {
                return lib.atomic_rmw_add_i64_8u((WasmMemory)receiver, (Node)args[offset], (Long)args[offset + 1], (Byte)args[offset + 2]);
            }
            case 52: {
                return lib.atomic_rmw_add_i64_16u((WasmMemory)receiver, (Node)args[offset], (Long)args[offset + 1], (Short)args[offset + 2]);
            }
            case 53: {
                return lib.atomic_rmw_add_i64_32u((WasmMemory)receiver, (Node)args[offset], (Long)args[offset + 1], (Integer)args[offset + 2]);
            }
            case 54: {
                return lib.atomic_rmw_add_i64((WasmMemory)receiver, (Node)args[offset], (Long)args[offset + 1], (Long)args[offset + 2]);
            }
            case 55: {
                return lib.atomic_rmw_sub_i32_8u((WasmMemory)receiver, (Node)args[offset], (Long)args[offset + 1], (Byte)args[offset + 2]);
            }
            case 56: {
                return lib.atomic_rmw_sub_i32_16u((WasmMemory)receiver, (Node)args[offset], (Long)args[offset + 1], (Short)args[offset + 2]);
            }
            case 57: {
                return lib.atomic_rmw_sub_i32((WasmMemory)receiver, (Node)args[offset], (Long)args[offset + 1], (Integer)args[offset + 2]);
            }
            case 58: {
                return lib.atomic_rmw_sub_i64_8u((WasmMemory)receiver, (Node)args[offset], (Long)args[offset + 1], (Byte)args[offset + 2]);
            }
            case 59: {
                return lib.atomic_rmw_sub_i64_16u((WasmMemory)receiver, (Node)args[offset], (Long)args[offset + 1], (Short)args[offset + 2]);
            }
            case 60: {
                return lib.atomic_rmw_sub_i64_32u((WasmMemory)receiver, (Node)args[offset], (Long)args[offset + 1], (Integer)args[offset + 2]);
            }
            case 61: {
                return lib.atomic_rmw_sub_i64((WasmMemory)receiver, (Node)args[offset], (Long)args[offset + 1], (Long)args[offset + 2]);
            }
            case 62: {
                return lib.atomic_rmw_and_i32_8u((WasmMemory)receiver, (Node)args[offset], (Long)args[offset + 1], (Byte)args[offset + 2]);
            }
            case 63: {
                return lib.atomic_rmw_and_i32_16u((WasmMemory)receiver, (Node)args[offset], (Long)args[offset + 1], (Short)args[offset + 2]);
            }
            case 64: {
                return lib.atomic_rmw_and_i32((WasmMemory)receiver, (Node)args[offset], (Long)args[offset + 1], (Integer)args[offset + 2]);
            }
            case 65: {
                return lib.atomic_rmw_and_i64_8u((WasmMemory)receiver, (Node)args[offset], (Long)args[offset + 1], (Byte)args[offset + 2]);
            }
            case 66: {
                return lib.atomic_rmw_and_i64_16u((WasmMemory)receiver, (Node)args[offset], (Long)args[offset + 1], (Short)args[offset + 2]);
            }
            case 67: {
                return lib.atomic_rmw_and_i64_32u((WasmMemory)receiver, (Node)args[offset], (Long)args[offset + 1], (Integer)args[offset + 2]);
            }
            case 68: {
                return lib.atomic_rmw_and_i64((WasmMemory)receiver, (Node)args[offset], (Long)args[offset + 1], (Long)args[offset + 2]);
            }
            case 69: {
                return lib.atomic_rmw_or_i32_8u((WasmMemory)receiver, (Node)args[offset], (Long)args[offset + 1], (Byte)args[offset + 2]);
            }
            case 70: {
                return lib.atomic_rmw_or_i32_16u((WasmMemory)receiver, (Node)args[offset], (Long)args[offset + 1], (Short)args[offset + 2]);
            }
            case 71: {
                return lib.atomic_rmw_or_i32((WasmMemory)receiver, (Node)args[offset], (Long)args[offset + 1], (Integer)args[offset + 2]);
            }
            case 72: {
                return lib.atomic_rmw_or_i64_8u((WasmMemory)receiver, (Node)args[offset], (Long)args[offset + 1], (Byte)args[offset + 2]);
            }
            case 73: {
                return lib.atomic_rmw_or_i64_16u((WasmMemory)receiver, (Node)args[offset], (Long)args[offset + 1], (Short)args[offset + 2]);
            }
            case 74: {
                return lib.atomic_rmw_or_i64_32u((WasmMemory)receiver, (Node)args[offset], (Long)args[offset + 1], (Integer)args[offset + 2]);
            }
            case 75: {
                return lib.atomic_rmw_or_i64((WasmMemory)receiver, (Node)args[offset], (Long)args[offset + 1], (Long)args[offset + 2]);
            }
            case 76: {
                return lib.atomic_rmw_xor_i32_8u((WasmMemory)receiver, (Node)args[offset], (Long)args[offset + 1], (Byte)args[offset + 2]);
            }
            case 77: {
                return lib.atomic_rmw_xor_i32_16u((WasmMemory)receiver, (Node)args[offset], (Long)args[offset + 1], (Short)args[offset + 2]);
            }
            case 78: {
                return lib.atomic_rmw_xor_i32((WasmMemory)receiver, (Node)args[offset], (Long)args[offset + 1], (Integer)args[offset + 2]);
            }
            case 79: {
                return lib.atomic_rmw_xor_i64_8u((WasmMemory)receiver, (Node)args[offset], (Long)args[offset + 1], (Byte)args[offset + 2]);
            }
            case 80: {
                return lib.atomic_rmw_xor_i64_16u((WasmMemory)receiver, (Node)args[offset], (Long)args[offset + 1], (Short)args[offset + 2]);
            }
            case 81: {
                return lib.atomic_rmw_xor_i64_32u((WasmMemory)receiver, (Node)args[offset], (Long)args[offset + 1], (Integer)args[offset + 2]);
            }
            case 82: {
                return lib.atomic_rmw_xor_i64((WasmMemory)receiver, (Node)args[offset], (Long)args[offset + 1], (Long)args[offset + 2]);
            }
            case 83: {
                return lib.atomic_rmw_xchg_i32_8u((WasmMemory)receiver, (Node)args[offset], (Long)args[offset + 1], (Byte)args[offset + 2]);
            }
            case 84: {
                return lib.atomic_rmw_xchg_i32_16u((WasmMemory)receiver, (Node)args[offset], (Long)args[offset + 1], (Short)args[offset + 2]);
            }
            case 85: {
                return lib.atomic_rmw_xchg_i32((WasmMemory)receiver, (Node)args[offset], (Long)args[offset + 1], (Integer)args[offset + 2]);
            }
            case 86: {
                return lib.atomic_rmw_xchg_i64_8u((WasmMemory)receiver, (Node)args[offset], (Long)args[offset + 1], (Byte)args[offset + 2]);
            }
            case 87: {
                return lib.atomic_rmw_xchg_i64_16u((WasmMemory)receiver, (Node)args[offset], (Long)args[offset + 1], (Short)args[offset + 2]);
            }
            case 88: {
                return lib.atomic_rmw_xchg_i64_32u((WasmMemory)receiver, (Node)args[offset], (Long)args[offset + 1], (Integer)args[offset + 2]);
            }
            case 89: {
                return lib.atomic_rmw_xchg_i64((WasmMemory)receiver, (Node)args[offset], (Long)args[offset + 1], (Long)args[offset + 2]);
            }
            case 90: {
                return lib.atomic_rmw_cmpxchg_i32_8u((WasmMemory)receiver, (Node)args[offset], (Long)args[offset + 1], (Byte)args[offset + 2], (Byte)args[offset + 3]);
            }
            case 91: {
                return lib.atomic_rmw_cmpxchg_i32_16u((WasmMemory)receiver, (Node)args[offset], (Long)args[offset + 1], (Short)args[offset + 2], (Short)args[offset + 3]);
            }
            case 92: {
                return lib.atomic_rmw_cmpxchg_i32((WasmMemory)receiver, (Node)args[offset], (Long)args[offset + 1], (Integer)args[offset + 2], (Integer)args[offset + 3]);
            }
            case 93: {
                return lib.atomic_rmw_cmpxchg_i64_8u((WasmMemory)receiver, (Node)args[offset], (Long)args[offset + 1], (Byte)args[offset + 2], (Byte)args[offset + 3]);
            }
            case 94: {
                return lib.atomic_rmw_cmpxchg_i64_16u((WasmMemory)receiver, (Node)args[offset], (Long)args[offset + 1], (Short)args[offset + 2], (Short)args[offset + 3]);
            }
            case 95: {
                return lib.atomic_rmw_cmpxchg_i64_32u((WasmMemory)receiver, (Node)args[offset], (Long)args[offset + 1], (Integer)args[offset + 2], (Integer)args[offset + 3]);
            }
            case 96: {
                return lib.atomic_rmw_cmpxchg_i64((WasmMemory)receiver, (Node)args[offset], (Long)args[offset + 1], (Long)args[offset + 2], (Long)args[offset + 3]);
            }
            case 97: {
                return lib.atomic_notify((WasmMemory)receiver, (Node)args[offset], (Long)args[offset + 1], (Integer)args[offset + 2]);
            }
            case 98: {
                return lib.atomic_wait32((WasmMemory)receiver, (Node)args[offset], (Long)args[offset + 1], (Integer)args[offset + 2], (Long)args[offset + 3]);
            }
            case 99: {
                return lib.atomic_wait64((WasmMemory)receiver, (Node)args[offset], (Long)args[offset + 1], (Long)args[offset + 2], (Long)args[offset + 3]);
            }
            case 100: {
                lib.close((WasmMemory)receiver);
                return null;
            }
            case 101: {
                lib.reset((WasmMemory)receiver);
                return null;
            }
            case 102: {
                return lib.asByteBuffer((WasmMemory)receiver);
            }
            case 103: {
                return lib.duplicate((WasmMemory)receiver);
            }
            case 104: {
                return lib.freed((WasmMemory)receiver);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new AbstractMethodError(message.toString());
    }

    protected WasmMemoryLibrary createDispatchImpl(int limit) {
        return new CachedDispatchFirst(null, null, limit);
    }

    protected WasmMemoryLibrary createUncachedDispatch() {
        return new UncachedDispatch();
    }

    private static Class<WasmMemoryLibrary> lazyLibraryClass() {
        try {
            return Class.forName("org.graalvm.wasm.memory.WasmMemoryLibrary", false, WasmMemoryLibraryGen.class.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw CompilerDirectives.shouldNotReachHere((Throwable)e);
        }
    }

    static {
        LibraryExport.register(LIBRARY_CLASS, (LibraryExport[])new LibraryExport[]{new Default()});
        LibraryFactory.register(LIBRARY_CLASS, (LibraryFactory)INSTANCE);
    }

    @GeneratedBy(value=WasmMemoryLibrary.class)
    private static final class Proxy
    extends WasmMemoryLibrary {
        @Node.Child
        private ReflectionLibrary lib;

        Proxy(ReflectionLibrary lib) {
            this.lib = lib;
        }

        @Override
        public long size(WasmMemory receiver_) {
            try {
                return (Long)this.lib.send((Object)receiver_, SIZE, new Object[0]);
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public long byteSize(WasmMemory receiver_) {
            try {
                return (Long)this.lib.send((Object)receiver_, BYTE_SIZE, new Object[0]);
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public long grow(WasmMemory receiver_, long extraPageSize) {
            try {
                return (Long)this.lib.send((Object)receiver_, GROW, new Object[]{extraPageSize});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public void initialize(WasmMemory receiver_, Node node, byte[] source, int sourceOffset, long destinationOffset, int length) {
            try {
                this.lib.send((Object)receiver_, INITIALIZE, new Object[]{node, source, sourceOffset, destinationOffset, length});
                return;
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public void fill(WasmMemory receiver_, Node node, long offset, long length, byte value) {
            try {
                this.lib.send((Object)receiver_, FILL, new Object[]{node, offset, length, value});
                return;
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public void copyFrom(WasmMemory receiver_, Node node, WasmMemory source, long sourceOffset, long destinationOffset, long length) {
            try {
                this.lib.send((Object)receiver_, COPY_FROM, new Object[]{node, source, sourceOffset, destinationOffset, length});
                return;
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public int copyFromStream(WasmMemory receiver_, Node node, InputStream stream, int offset, int length) throws IOException {
            try {
                return (Integer)this.lib.send((Object)receiver_, COPY_FROM_STREAM, new Object[]{node, stream, offset, length});
            }
            catch (IOException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public void copyToStream(WasmMemory receiver_, Node node, OutputStream stream, int offset, int length) throws IOException {
            try {
                this.lib.send((Object)receiver_, COPY_TO_STREAM, new Object[]{node, stream, offset, length});
                return;
            }
            catch (IOException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public void copyToBuffer(WasmMemory receiver_, Node node, byte[] dst, long srcOffset, int dstOffset, int length) {
            try {
                this.lib.send((Object)receiver_, COPY_TO_BUFFER, new Object[]{node, dst, srcOffset, dstOffset, length});
                return;
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public int load_i32(WasmMemory receiver_, Node node, long address) {
            try {
                return (Integer)this.lib.send((Object)receiver_, LOAD_I32, new Object[]{node, address});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public long load_i64(WasmMemory receiver_, Node node, long address) {
            try {
                return (Long)this.lib.send((Object)receiver_, LOAD_I64, new Object[]{node, address});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public float load_f32(WasmMemory receiver_, Node node, long address) {
            try {
                return ((Float)this.lib.send((Object)receiver_, LOAD_F32, new Object[]{node, address})).floatValue();
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public double load_f64(WasmMemory receiver_, Node node, long address) {
            try {
                return (Double)this.lib.send((Object)receiver_, LOAD_F64, new Object[]{node, address});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public int load_i32_8s(WasmMemory receiver_, Node node, long address) {
            try {
                return (Integer)this.lib.send((Object)receiver_, LOAD_I32_8S, new Object[]{node, address});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public int load_i32_8u(WasmMemory receiver_, Node node, long address) {
            try {
                return (Integer)this.lib.send((Object)receiver_, LOAD_I32_8U, new Object[]{node, address});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public int load_i32_16s(WasmMemory receiver_, Node node, long address) {
            try {
                return (Integer)this.lib.send((Object)receiver_, LOAD_I32_16S, new Object[]{node, address});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public int load_i32_16u(WasmMemory receiver_, Node node, long address) {
            try {
                return (Integer)this.lib.send((Object)receiver_, LOAD_I32_16U, new Object[]{node, address});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public long load_i64_8s(WasmMemory receiver_, Node node, long address) {
            try {
                return (Long)this.lib.send((Object)receiver_, LOAD_I64_8S, new Object[]{node, address});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public long load_i64_8u(WasmMemory receiver_, Node node, long address) {
            try {
                return (Long)this.lib.send((Object)receiver_, LOAD_I64_8U, new Object[]{node, address});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public long load_i64_16s(WasmMemory receiver_, Node node, long address) {
            try {
                return (Long)this.lib.send((Object)receiver_, LOAD_I64_16S, new Object[]{node, address});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public long load_i64_16u(WasmMemory receiver_, Node node, long address) {
            try {
                return (Long)this.lib.send((Object)receiver_, LOAD_I64_16U, new Object[]{node, address});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public long load_i64_32s(WasmMemory receiver_, Node node, long address) {
            try {
                return (Long)this.lib.send((Object)receiver_, LOAD_I64_32S, new Object[]{node, address});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public long load_i64_32u(WasmMemory receiver_, Node node, long address) {
            try {
                return (Long)this.lib.send((Object)receiver_, LOAD_I64_32U, new Object[]{node, address});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public Object load_i128(WasmMemory receiver_, Node node, long address) {
            try {
                return this.lib.send((Object)receiver_, LOAD_I128, new Object[]{node, address});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public void store_i32(WasmMemory receiver_, Node node, long address, int value) {
            try {
                this.lib.send((Object)receiver_, STORE_I32, new Object[]{node, address, value});
                return;
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public void store_i64(WasmMemory receiver_, Node node, long address, long value) {
            try {
                this.lib.send((Object)receiver_, STORE_I64, new Object[]{node, address, value});
                return;
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public void store_f32(WasmMemory receiver_, Node node, long address, float value) {
            try {
                this.lib.send((Object)receiver_, STORE_F32, new Object[]{node, address, Float.valueOf(value)});
                return;
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public void store_f64(WasmMemory receiver_, Node node, long address, double value) {
            try {
                this.lib.send((Object)receiver_, STORE_F64, new Object[]{node, address, value});
                return;
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public void store_i32_8(WasmMemory receiver_, Node node, long address, byte value) {
            try {
                this.lib.send((Object)receiver_, STORE_I32_8, new Object[]{node, address, value});
                return;
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public void store_i32_16(WasmMemory receiver_, Node node, long address, short value) {
            try {
                this.lib.send((Object)receiver_, STORE_I32_16, new Object[]{node, address, value});
                return;
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public void store_i64_8(WasmMemory receiver_, Node node, long address, byte value) {
            try {
                this.lib.send((Object)receiver_, STORE_I64_8, new Object[]{node, address, value});
                return;
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public void store_i64_16(WasmMemory receiver_, Node node, long address, short value) {
            try {
                this.lib.send((Object)receiver_, STORE_I64_16, new Object[]{node, address, value});
                return;
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public void store_i64_32(WasmMemory receiver_, Node node, long address, int value) {
            try {
                this.lib.send((Object)receiver_, STORE_I64_32, new Object[]{node, address, value});
                return;
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public void store_i128(WasmMemory receiver_, Node node, long address, Object value) {
            try {
                this.lib.send((Object)receiver_, STORE_I128, new Object[]{node, address, value});
                return;
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public int atomic_load_i32(WasmMemory receiver_, Node node, long address) {
            try {
                return (Integer)this.lib.send((Object)receiver_, ATOMIC_LOAD_I32, new Object[]{node, address});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public long atomic_load_i64(WasmMemory receiver_, Node node, long address) {
            try {
                return (Long)this.lib.send((Object)receiver_, ATOMIC_LOAD_I64, new Object[]{node, address});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public int atomic_load_i32_8u(WasmMemory receiver_, Node node, long address) {
            try {
                return (Integer)this.lib.send((Object)receiver_, ATOMIC_LOAD_I32_8U, new Object[]{node, address});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public int atomic_load_i32_16u(WasmMemory receiver_, Node node, long address) {
            try {
                return (Integer)this.lib.send((Object)receiver_, ATOMIC_LOAD_I32_16U, new Object[]{node, address});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public long atomic_load_i64_8u(WasmMemory receiver_, Node node, long address) {
            try {
                return (Long)this.lib.send((Object)receiver_, ATOMIC_LOAD_I64_8U, new Object[]{node, address});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public long atomic_load_i64_16u(WasmMemory receiver_, Node node, long address) {
            try {
                return (Long)this.lib.send((Object)receiver_, ATOMIC_LOAD_I64_16U, new Object[]{node, address});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public long atomic_load_i64_32u(WasmMemory receiver_, Node node, long address) {
            try {
                return (Long)this.lib.send((Object)receiver_, ATOMIC_LOAD_I64_32U, new Object[]{node, address});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public void atomic_store_i32(WasmMemory receiver_, Node node, long address, int value) {
            try {
                this.lib.send((Object)receiver_, ATOMIC_STORE_I32, new Object[]{node, address, value});
                return;
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public void atomic_store_i64(WasmMemory receiver_, Node node, long address, long value) {
            try {
                this.lib.send((Object)receiver_, ATOMIC_STORE_I64, new Object[]{node, address, value});
                return;
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public void atomic_store_i32_8(WasmMemory receiver_, Node node, long address, byte value) {
            try {
                this.lib.send((Object)receiver_, ATOMIC_STORE_I32_8, new Object[]{node, address, value});
                return;
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public void atomic_store_i32_16(WasmMemory receiver_, Node node, long address, short value) {
            try {
                this.lib.send((Object)receiver_, ATOMIC_STORE_I32_16, new Object[]{node, address, value});
                return;
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public void atomic_store_i64_8(WasmMemory receiver_, Node node, long address, byte value) {
            try {
                this.lib.send((Object)receiver_, ATOMIC_STORE_I64_8, new Object[]{node, address, value});
                return;
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public void atomic_store_i64_16(WasmMemory receiver_, Node node, long address, short value) {
            try {
                this.lib.send((Object)receiver_, ATOMIC_STORE_I64_16, new Object[]{node, address, value});
                return;
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public void atomic_store_i64_32(WasmMemory receiver_, Node node, long address, int value) {
            try {
                this.lib.send((Object)receiver_, ATOMIC_STORE_I64_32, new Object[]{node, address, value});
                return;
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public int atomic_rmw_add_i32_8u(WasmMemory receiver_, Node node, long address, byte value) {
            try {
                return (Integer)this.lib.send((Object)receiver_, ATOMIC_RMW_ADD_I32_8U, new Object[]{node, address, value});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public int atomic_rmw_add_i32_16u(WasmMemory receiver_, Node node, long address, short value) {
            try {
                return (Integer)this.lib.send((Object)receiver_, ATOMIC_RMW_ADD_I32_16U, new Object[]{node, address, value});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public int atomic_rmw_add_i32(WasmMemory receiver_, Node node, long address, int value) {
            try {
                return (Integer)this.lib.send((Object)receiver_, ATOMIC_RMW_ADD_I32, new Object[]{node, address, value});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public long atomic_rmw_add_i64_8u(WasmMemory receiver_, Node node, long address, byte value) {
            try {
                return (Long)this.lib.send((Object)receiver_, ATOMIC_RMW_ADD_I64_8U, new Object[]{node, address, value});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public long atomic_rmw_add_i64_16u(WasmMemory receiver_, Node node, long address, short value) {
            try {
                return (Long)this.lib.send((Object)receiver_, ATOMIC_RMW_ADD_I64_16U, new Object[]{node, address, value});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public long atomic_rmw_add_i64_32u(WasmMemory receiver_, Node node, long address, int value) {
            try {
                return (Long)this.lib.send((Object)receiver_, ATOMIC_RMW_ADD_I64_32U, new Object[]{node, address, value});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public long atomic_rmw_add_i64(WasmMemory receiver_, Node node, long address, long value) {
            try {
                return (Long)this.lib.send((Object)receiver_, ATOMIC_RMW_ADD_I64, new Object[]{node, address, value});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public int atomic_rmw_sub_i32_8u(WasmMemory receiver_, Node node, long address, byte value) {
            try {
                return (Integer)this.lib.send((Object)receiver_, ATOMIC_RMW_SUB_I32_8U, new Object[]{node, address, value});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public int atomic_rmw_sub_i32_16u(WasmMemory receiver_, Node node, long address, short value) {
            try {
                return (Integer)this.lib.send((Object)receiver_, ATOMIC_RMW_SUB_I32_16U, new Object[]{node, address, value});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public int atomic_rmw_sub_i32(WasmMemory receiver_, Node node, long address, int value) {
            try {
                return (Integer)this.lib.send((Object)receiver_, ATOMIC_RMW_SUB_I32, new Object[]{node, address, value});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public long atomic_rmw_sub_i64_8u(WasmMemory receiver_, Node node, long address, byte value) {
            try {
                return (Long)this.lib.send((Object)receiver_, ATOMIC_RMW_SUB_I64_8U, new Object[]{node, address, value});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public long atomic_rmw_sub_i64_16u(WasmMemory receiver_, Node node, long address, short value) {
            try {
                return (Long)this.lib.send((Object)receiver_, ATOMIC_RMW_SUB_I64_16U, new Object[]{node, address, value});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public long atomic_rmw_sub_i64_32u(WasmMemory receiver_, Node node, long address, int value) {
            try {
                return (Long)this.lib.send((Object)receiver_, ATOMIC_RMW_SUB_I64_32U, new Object[]{node, address, value});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public long atomic_rmw_sub_i64(WasmMemory receiver_, Node node, long address, long value) {
            try {
                return (Long)this.lib.send((Object)receiver_, ATOMIC_RMW_SUB_I64, new Object[]{node, address, value});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public int atomic_rmw_and_i32_8u(WasmMemory receiver_, Node node, long address, byte value) {
            try {
                return (Integer)this.lib.send((Object)receiver_, ATOMIC_RMW_AND_I32_8U, new Object[]{node, address, value});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public int atomic_rmw_and_i32_16u(WasmMemory receiver_, Node node, long address, short value) {
            try {
                return (Integer)this.lib.send((Object)receiver_, ATOMIC_RMW_AND_I32_16U, new Object[]{node, address, value});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public int atomic_rmw_and_i32(WasmMemory receiver_, Node node, long address, int value) {
            try {
                return (Integer)this.lib.send((Object)receiver_, ATOMIC_RMW_AND_I32, new Object[]{node, address, value});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public long atomic_rmw_and_i64_8u(WasmMemory receiver_, Node node, long address, byte value) {
            try {
                return (Long)this.lib.send((Object)receiver_, ATOMIC_RMW_AND_I64_8U, new Object[]{node, address, value});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public long atomic_rmw_and_i64_16u(WasmMemory receiver_, Node node, long address, short value) {
            try {
                return (Long)this.lib.send((Object)receiver_, ATOMIC_RMW_AND_I64_16U, new Object[]{node, address, value});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public long atomic_rmw_and_i64_32u(WasmMemory receiver_, Node node, long address, int value) {
            try {
                return (Long)this.lib.send((Object)receiver_, ATOMIC_RMW_AND_I64_32U, new Object[]{node, address, value});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public long atomic_rmw_and_i64(WasmMemory receiver_, Node node, long address, long value) {
            try {
                return (Long)this.lib.send((Object)receiver_, ATOMIC_RMW_AND_I64, new Object[]{node, address, value});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public int atomic_rmw_or_i32_8u(WasmMemory receiver_, Node node, long address, byte value) {
            try {
                return (Integer)this.lib.send((Object)receiver_, ATOMIC_RMW_OR_I32_8U, new Object[]{node, address, value});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public int atomic_rmw_or_i32_16u(WasmMemory receiver_, Node node, long address, short value) {
            try {
                return (Integer)this.lib.send((Object)receiver_, ATOMIC_RMW_OR_I32_16U, new Object[]{node, address, value});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public int atomic_rmw_or_i32(WasmMemory receiver_, Node node, long address, int value) {
            try {
                return (Integer)this.lib.send((Object)receiver_, ATOMIC_RMW_OR_I32, new Object[]{node, address, value});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public long atomic_rmw_or_i64_8u(WasmMemory receiver_, Node node, long address, byte value) {
            try {
                return (Long)this.lib.send((Object)receiver_, ATOMIC_RMW_OR_I64_8U, new Object[]{node, address, value});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public long atomic_rmw_or_i64_16u(WasmMemory receiver_, Node node, long address, short value) {
            try {
                return (Long)this.lib.send((Object)receiver_, ATOMIC_RMW_OR_I64_16U, new Object[]{node, address, value});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public long atomic_rmw_or_i64_32u(WasmMemory receiver_, Node node, long address, int value) {
            try {
                return (Long)this.lib.send((Object)receiver_, ATOMIC_RMW_OR_I64_32U, new Object[]{node, address, value});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public long atomic_rmw_or_i64(WasmMemory receiver_, Node node, long address, long value) {
            try {
                return (Long)this.lib.send((Object)receiver_, ATOMIC_RMW_OR_I64, new Object[]{node, address, value});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public int atomic_rmw_xor_i32_8u(WasmMemory receiver_, Node node, long address, byte value) {
            try {
                return (Integer)this.lib.send((Object)receiver_, ATOMIC_RMW_XOR_I32_8U, new Object[]{node, address, value});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public int atomic_rmw_xor_i32_16u(WasmMemory receiver_, Node node, long address, short value) {
            try {
                return (Integer)this.lib.send((Object)receiver_, ATOMIC_RMW_XOR_I32_16U, new Object[]{node, address, value});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public int atomic_rmw_xor_i32(WasmMemory receiver_, Node node, long address, int value) {
            try {
                return (Integer)this.lib.send((Object)receiver_, ATOMIC_RMW_XOR_I32, new Object[]{node, address, value});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public long atomic_rmw_xor_i64_8u(WasmMemory receiver_, Node node, long address, byte value) {
            try {
                return (Long)this.lib.send((Object)receiver_, ATOMIC_RMW_XOR_I64_8U, new Object[]{node, address, value});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public long atomic_rmw_xor_i64_16u(WasmMemory receiver_, Node node, long address, short value) {
            try {
                return (Long)this.lib.send((Object)receiver_, ATOMIC_RMW_XOR_I64_16U, new Object[]{node, address, value});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public long atomic_rmw_xor_i64_32u(WasmMemory receiver_, Node node, long address, int value) {
            try {
                return (Long)this.lib.send((Object)receiver_, ATOMIC_RMW_XOR_I64_32U, new Object[]{node, address, value});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public long atomic_rmw_xor_i64(WasmMemory receiver_, Node node, long address, long value) {
            try {
                return (Long)this.lib.send((Object)receiver_, ATOMIC_RMW_XOR_I64, new Object[]{node, address, value});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public int atomic_rmw_xchg_i32_8u(WasmMemory receiver_, Node node, long address, byte value) {
            try {
                return (Integer)this.lib.send((Object)receiver_, ATOMIC_RMW_XCHG_I32_8U, new Object[]{node, address, value});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public int atomic_rmw_xchg_i32_16u(WasmMemory receiver_, Node node, long address, short value) {
            try {
                return (Integer)this.lib.send((Object)receiver_, ATOMIC_RMW_XCHG_I32_16U, new Object[]{node, address, value});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public int atomic_rmw_xchg_i32(WasmMemory receiver_, Node node, long address, int value) {
            try {
                return (Integer)this.lib.send((Object)receiver_, ATOMIC_RMW_XCHG_I32, new Object[]{node, address, value});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public long atomic_rmw_xchg_i64_8u(WasmMemory receiver_, Node node, long address, byte value) {
            try {
                return (Long)this.lib.send((Object)receiver_, ATOMIC_RMW_XCHG_I64_8U, new Object[]{node, address, value});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public long atomic_rmw_xchg_i64_16u(WasmMemory receiver_, Node node, long address, short value) {
            try {
                return (Long)this.lib.send((Object)receiver_, ATOMIC_RMW_XCHG_I64_16U, new Object[]{node, address, value});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public long atomic_rmw_xchg_i64_32u(WasmMemory receiver_, Node node, long address, int value) {
            try {
                return (Long)this.lib.send((Object)receiver_, ATOMIC_RMW_XCHG_I64_32U, new Object[]{node, address, value});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public long atomic_rmw_xchg_i64(WasmMemory receiver_, Node node, long address, long value) {
            try {
                return (Long)this.lib.send((Object)receiver_, ATOMIC_RMW_XCHG_I64, new Object[]{node, address, value});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public int atomic_rmw_cmpxchg_i32_8u(WasmMemory receiver_, Node node, long address, byte expected, byte replacement) {
            try {
                return (Integer)this.lib.send((Object)receiver_, ATOMIC_RMW_CMPXCHG_I32_8U, new Object[]{node, address, expected, replacement});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public int atomic_rmw_cmpxchg_i32_16u(WasmMemory receiver_, Node node, long address, short expected, short replacement) {
            try {
                return (Integer)this.lib.send((Object)receiver_, ATOMIC_RMW_CMPXCHG_I32_16U, new Object[]{node, address, expected, replacement});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public int atomic_rmw_cmpxchg_i32(WasmMemory receiver_, Node node, long address, int expected, int replacement) {
            try {
                return (Integer)this.lib.send((Object)receiver_, ATOMIC_RMW_CMPXCHG_I32, new Object[]{node, address, expected, replacement});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public long atomic_rmw_cmpxchg_i64_8u(WasmMemory receiver_, Node node, long address, byte expected, byte replacement) {
            try {
                return (Long)this.lib.send((Object)receiver_, ATOMIC_RMW_CMPXCHG_I64_8U, new Object[]{node, address, expected, replacement});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public long atomic_rmw_cmpxchg_i64_16u(WasmMemory receiver_, Node node, long address, short expected, short replacement) {
            try {
                return (Long)this.lib.send((Object)receiver_, ATOMIC_RMW_CMPXCHG_I64_16U, new Object[]{node, address, expected, replacement});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public long atomic_rmw_cmpxchg_i64_32u(WasmMemory receiver_, Node node, long address, int expected, int replacement) {
            try {
                return (Long)this.lib.send((Object)receiver_, ATOMIC_RMW_CMPXCHG_I64_32U, new Object[]{node, address, expected, replacement});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public long atomic_rmw_cmpxchg_i64(WasmMemory receiver_, Node node, long address, long expected, long replacement) {
            try {
                return (Long)this.lib.send((Object)receiver_, ATOMIC_RMW_CMPXCHG_I64, new Object[]{node, address, expected, replacement});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public int atomic_notify(WasmMemory receiver_, Node node, long address, int count) {
            try {
                return (Integer)this.lib.send((Object)receiver_, ATOMIC_NOTIFY, new Object[]{node, address, count});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public int atomic_wait32(WasmMemory receiver_, Node node, long address, int expected, long timeout) {
            try {
                return (Integer)this.lib.send((Object)receiver_, ATOMIC_WAIT32, new Object[]{node, address, expected, timeout});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public int atomic_wait64(WasmMemory receiver_, Node node, long address, long expected, long timeout) {
            try {
                return (Integer)this.lib.send((Object)receiver_, ATOMIC_WAIT64, new Object[]{node, address, expected, timeout});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public void close(WasmMemory receiver_) {
            try {
                this.lib.send((Object)receiver_, CLOSE, new Object[0]);
                return;
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public void reset(WasmMemory receiver_) {
            try {
                this.lib.send((Object)receiver_, RESET, new Object[0]);
                return;
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public ByteBuffer asByteBuffer(WasmMemory receiver_) {
            try {
                return (ByteBuffer)this.lib.send((Object)receiver_, AS_BYTE_BUFFER, new Object[0]);
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public WasmMemory duplicate(WasmMemory receiver_) {
            try {
                return (WasmMemory)this.lib.send((Object)receiver_, DUPLICATE, new Object[0]);
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public boolean freed(WasmMemory receiver_) {
            try {
                return (Boolean)this.lib.send((Object)receiver_, FREED, new Object[0]);
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        public boolean accepts(Object receiver_) {
            return this.lib.accepts(receiver_);
        }
    }

    @GeneratedBy(value=WasmMemoryLibrary.class)
    private static final class Delegate
    extends WasmMemoryLibrary {
        @Node.Child
        private WasmMemoryLibrary delegateLibrary;

        Delegate(WasmMemoryLibrary delegateLibrary) {
            this.delegateLibrary = delegateLibrary;
        }

        @Override
        public long size(WasmMemory receiver_) {
            if (WasmMemoryLibraryGen.isDelegated((Library)this.delegateLibrary, (int)0)) {
                Object delegate = WasmMemoryLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((WasmMemoryLibrary)WasmMemoryLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).size((WasmMemory)delegate);
            }
            return this.delegateLibrary.size(receiver_);
        }

        @Override
        public long byteSize(WasmMemory receiver_) {
            if (WasmMemoryLibraryGen.isDelegated((Library)this.delegateLibrary, (int)1)) {
                Object delegate = WasmMemoryLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((WasmMemoryLibrary)WasmMemoryLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).byteSize((WasmMemory)delegate);
            }
            return this.delegateLibrary.byteSize(receiver_);
        }

        @Override
        public long grow(WasmMemory receiver_, long extraPageSize) {
            if (WasmMemoryLibraryGen.isDelegated((Library)this.delegateLibrary, (int)2)) {
                Object delegate = WasmMemoryLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((WasmMemoryLibrary)WasmMemoryLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).grow((WasmMemory)delegate, extraPageSize);
            }
            return this.delegateLibrary.grow(receiver_, extraPageSize);
        }

        @Override
        public void initialize(WasmMemory receiver_, Node node, byte[] source, int sourceOffset, long destinationOffset, int length) {
            if (WasmMemoryLibraryGen.isDelegated((Library)this.delegateLibrary, (int)3)) {
                Object delegate = WasmMemoryLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                ((WasmMemoryLibrary)WasmMemoryLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).initialize((WasmMemory)delegate, node, source, sourceOffset, destinationOffset, length);
                return;
            }
            this.delegateLibrary.initialize(receiver_, node, source, sourceOffset, destinationOffset, length);
        }

        @Override
        public void fill(WasmMemory receiver_, Node node, long offset, long length, byte value) {
            if (WasmMemoryLibraryGen.isDelegated((Library)this.delegateLibrary, (int)4)) {
                Object delegate = WasmMemoryLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                ((WasmMemoryLibrary)WasmMemoryLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).fill((WasmMemory)delegate, node, offset, length, value);
                return;
            }
            this.delegateLibrary.fill(receiver_, node, offset, length, value);
        }

        @Override
        public void copyFrom(WasmMemory receiver_, Node node, WasmMemory source, long sourceOffset, long destinationOffset, long length) {
            if (WasmMemoryLibraryGen.isDelegated((Library)this.delegateLibrary, (int)5)) {
                Object delegate = WasmMemoryLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                ((WasmMemoryLibrary)WasmMemoryLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).copyFrom((WasmMemory)delegate, node, source, sourceOffset, destinationOffset, length);
                return;
            }
            this.delegateLibrary.copyFrom(receiver_, node, source, sourceOffset, destinationOffset, length);
        }

        @Override
        public int copyFromStream(WasmMemory receiver_, Node node, InputStream stream, int offset, int length) throws IOException {
            if (WasmMemoryLibraryGen.isDelegated((Library)this.delegateLibrary, (int)6)) {
                Object delegate = WasmMemoryLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((WasmMemoryLibrary)WasmMemoryLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).copyFromStream((WasmMemory)delegate, node, stream, offset, length);
            }
            return this.delegateLibrary.copyFromStream(receiver_, node, stream, offset, length);
        }

        @Override
        public void copyToStream(WasmMemory receiver_, Node node, OutputStream stream, int offset, int length) throws IOException {
            if (WasmMemoryLibraryGen.isDelegated((Library)this.delegateLibrary, (int)7)) {
                Object delegate = WasmMemoryLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                ((WasmMemoryLibrary)WasmMemoryLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).copyToStream((WasmMemory)delegate, node, stream, offset, length);
                return;
            }
            this.delegateLibrary.copyToStream(receiver_, node, stream, offset, length);
        }

        @Override
        public void copyToBuffer(WasmMemory receiver_, Node node, byte[] dst, long srcOffset, int dstOffset, int length) {
            if (WasmMemoryLibraryGen.isDelegated((Library)this.delegateLibrary, (int)8)) {
                Object delegate = WasmMemoryLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                ((WasmMemoryLibrary)WasmMemoryLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).copyToBuffer((WasmMemory)delegate, node, dst, srcOffset, dstOffset, length);
                return;
            }
            this.delegateLibrary.copyToBuffer(receiver_, node, dst, srcOffset, dstOffset, length);
        }

        @Override
        public int load_i32(WasmMemory receiver_, Node node, long address) {
            if (WasmMemoryLibraryGen.isDelegated((Library)this.delegateLibrary, (int)9)) {
                Object delegate = WasmMemoryLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((WasmMemoryLibrary)WasmMemoryLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).load_i32((WasmMemory)delegate, node, address);
            }
            return this.delegateLibrary.load_i32(receiver_, node, address);
        }

        @Override
        public long load_i64(WasmMemory receiver_, Node node, long address) {
            if (WasmMemoryLibraryGen.isDelegated((Library)this.delegateLibrary, (int)10)) {
                Object delegate = WasmMemoryLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((WasmMemoryLibrary)WasmMemoryLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).load_i64((WasmMemory)delegate, node, address);
            }
            return this.delegateLibrary.load_i64(receiver_, node, address);
        }

        @Override
        public float load_f32(WasmMemory receiver_, Node node, long address) {
            if (WasmMemoryLibraryGen.isDelegated((Library)this.delegateLibrary, (int)11)) {
                Object delegate = WasmMemoryLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((WasmMemoryLibrary)WasmMemoryLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).load_f32((WasmMemory)delegate, node, address);
            }
            return this.delegateLibrary.load_f32(receiver_, node, address);
        }

        @Override
        public double load_f64(WasmMemory receiver_, Node node, long address) {
            if (WasmMemoryLibraryGen.isDelegated((Library)this.delegateLibrary, (int)12)) {
                Object delegate = WasmMemoryLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((WasmMemoryLibrary)WasmMemoryLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).load_f64((WasmMemory)delegate, node, address);
            }
            return this.delegateLibrary.load_f64(receiver_, node, address);
        }

        @Override
        public int load_i32_8s(WasmMemory receiver_, Node node, long address) {
            if (WasmMemoryLibraryGen.isDelegated((Library)this.delegateLibrary, (int)13)) {
                Object delegate = WasmMemoryLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((WasmMemoryLibrary)WasmMemoryLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).load_i32_8s((WasmMemory)delegate, node, address);
            }
            return this.delegateLibrary.load_i32_8s(receiver_, node, address);
        }

        @Override
        public int load_i32_8u(WasmMemory receiver_, Node node, long address) {
            if (WasmMemoryLibraryGen.isDelegated((Library)this.delegateLibrary, (int)14)) {
                Object delegate = WasmMemoryLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((WasmMemoryLibrary)WasmMemoryLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).load_i32_8u((WasmMemory)delegate, node, address);
            }
            return this.delegateLibrary.load_i32_8u(receiver_, node, address);
        }

        @Override
        public int load_i32_16s(WasmMemory receiver_, Node node, long address) {
            if (WasmMemoryLibraryGen.isDelegated((Library)this.delegateLibrary, (int)15)) {
                Object delegate = WasmMemoryLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((WasmMemoryLibrary)WasmMemoryLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).load_i32_16s((WasmMemory)delegate, node, address);
            }
            return this.delegateLibrary.load_i32_16s(receiver_, node, address);
        }

        @Override
        public int load_i32_16u(WasmMemory receiver_, Node node, long address) {
            if (WasmMemoryLibraryGen.isDelegated((Library)this.delegateLibrary, (int)16)) {
                Object delegate = WasmMemoryLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((WasmMemoryLibrary)WasmMemoryLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).load_i32_16u((WasmMemory)delegate, node, address);
            }
            return this.delegateLibrary.load_i32_16u(receiver_, node, address);
        }

        @Override
        public long load_i64_8s(WasmMemory receiver_, Node node, long address) {
            if (WasmMemoryLibraryGen.isDelegated((Library)this.delegateLibrary, (int)17)) {
                Object delegate = WasmMemoryLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((WasmMemoryLibrary)WasmMemoryLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).load_i64_8s((WasmMemory)delegate, node, address);
            }
            return this.delegateLibrary.load_i64_8s(receiver_, node, address);
        }

        @Override
        public long load_i64_8u(WasmMemory receiver_, Node node, long address) {
            if (WasmMemoryLibraryGen.isDelegated((Library)this.delegateLibrary, (int)18)) {
                Object delegate = WasmMemoryLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((WasmMemoryLibrary)WasmMemoryLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).load_i64_8u((WasmMemory)delegate, node, address);
            }
            return this.delegateLibrary.load_i64_8u(receiver_, node, address);
        }

        @Override
        public long load_i64_16s(WasmMemory receiver_, Node node, long address) {
            if (WasmMemoryLibraryGen.isDelegated((Library)this.delegateLibrary, (int)19)) {
                Object delegate = WasmMemoryLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((WasmMemoryLibrary)WasmMemoryLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).load_i64_16s((WasmMemory)delegate, node, address);
            }
            return this.delegateLibrary.load_i64_16s(receiver_, node, address);
        }

        @Override
        public long load_i64_16u(WasmMemory receiver_, Node node, long address) {
            if (WasmMemoryLibraryGen.isDelegated((Library)this.delegateLibrary, (int)20)) {
                Object delegate = WasmMemoryLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((WasmMemoryLibrary)WasmMemoryLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).load_i64_16u((WasmMemory)delegate, node, address);
            }
            return this.delegateLibrary.load_i64_16u(receiver_, node, address);
        }

        @Override
        public long load_i64_32s(WasmMemory receiver_, Node node, long address) {
            if (WasmMemoryLibraryGen.isDelegated((Library)this.delegateLibrary, (int)21)) {
                Object delegate = WasmMemoryLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((WasmMemoryLibrary)WasmMemoryLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).load_i64_32s((WasmMemory)delegate, node, address);
            }
            return this.delegateLibrary.load_i64_32s(receiver_, node, address);
        }

        @Override
        public long load_i64_32u(WasmMemory receiver_, Node node, long address) {
            if (WasmMemoryLibraryGen.isDelegated((Library)this.delegateLibrary, (int)22)) {
                Object delegate = WasmMemoryLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((WasmMemoryLibrary)WasmMemoryLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).load_i64_32u((WasmMemory)delegate, node, address);
            }
            return this.delegateLibrary.load_i64_32u(receiver_, node, address);
        }

        @Override
        public Object load_i128(WasmMemory receiver_, Node node, long address) {
            if (WasmMemoryLibraryGen.isDelegated((Library)this.delegateLibrary, (int)23)) {
                Object delegate = WasmMemoryLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((WasmMemoryLibrary)WasmMemoryLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).load_i128((WasmMemory)delegate, node, address);
            }
            return this.delegateLibrary.load_i128(receiver_, node, address);
        }

        @Override
        public void store_i32(WasmMemory receiver_, Node node, long address, int value) {
            if (WasmMemoryLibraryGen.isDelegated((Library)this.delegateLibrary, (int)24)) {
                Object delegate = WasmMemoryLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                ((WasmMemoryLibrary)WasmMemoryLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).store_i32((WasmMemory)delegate, node, address, value);
                return;
            }
            this.delegateLibrary.store_i32(receiver_, node, address, value);
        }

        @Override
        public void store_i64(WasmMemory receiver_, Node node, long address, long value) {
            if (WasmMemoryLibraryGen.isDelegated((Library)this.delegateLibrary, (int)25)) {
                Object delegate = WasmMemoryLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                ((WasmMemoryLibrary)WasmMemoryLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).store_i64((WasmMemory)delegate, node, address, value);
                return;
            }
            this.delegateLibrary.store_i64(receiver_, node, address, value);
        }

        @Override
        public void store_f32(WasmMemory receiver_, Node node, long address, float value) {
            if (WasmMemoryLibraryGen.isDelegated((Library)this.delegateLibrary, (int)26)) {
                Object delegate = WasmMemoryLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                ((WasmMemoryLibrary)WasmMemoryLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).store_f32((WasmMemory)delegate, node, address, value);
                return;
            }
            this.delegateLibrary.store_f32(receiver_, node, address, value);
        }

        @Override
        public void store_f64(WasmMemory receiver_, Node node, long address, double value) {
            if (WasmMemoryLibraryGen.isDelegated((Library)this.delegateLibrary, (int)27)) {
                Object delegate = WasmMemoryLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                ((WasmMemoryLibrary)WasmMemoryLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).store_f64((WasmMemory)delegate, node, address, value);
                return;
            }
            this.delegateLibrary.store_f64(receiver_, node, address, value);
        }

        @Override
        public void store_i32_8(WasmMemory receiver_, Node node, long address, byte value) {
            if (WasmMemoryLibraryGen.isDelegated((Library)this.delegateLibrary, (int)28)) {
                Object delegate = WasmMemoryLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                ((WasmMemoryLibrary)WasmMemoryLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).store_i32_8((WasmMemory)delegate, node, address, value);
                return;
            }
            this.delegateLibrary.store_i32_8(receiver_, node, address, value);
        }

        @Override
        public void store_i32_16(WasmMemory receiver_, Node node, long address, short value) {
            if (WasmMemoryLibraryGen.isDelegated((Library)this.delegateLibrary, (int)29)) {
                Object delegate = WasmMemoryLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                ((WasmMemoryLibrary)WasmMemoryLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).store_i32_16((WasmMemory)delegate, node, address, value);
                return;
            }
            this.delegateLibrary.store_i32_16(receiver_, node, address, value);
        }

        @Override
        public void store_i64_8(WasmMemory receiver_, Node node, long address, byte value) {
            if (WasmMemoryLibraryGen.isDelegated((Library)this.delegateLibrary, (int)30)) {
                Object delegate = WasmMemoryLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                ((WasmMemoryLibrary)WasmMemoryLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).store_i64_8((WasmMemory)delegate, node, address, value);
                return;
            }
            this.delegateLibrary.store_i64_8(receiver_, node, address, value);
        }

        @Override
        public void store_i64_16(WasmMemory receiver_, Node node, long address, short value) {
            if (WasmMemoryLibraryGen.isDelegated((Library)this.delegateLibrary, (int)31)) {
                Object delegate = WasmMemoryLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                ((WasmMemoryLibrary)WasmMemoryLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).store_i64_16((WasmMemory)delegate, node, address, value);
                return;
            }
            this.delegateLibrary.store_i64_16(receiver_, node, address, value);
        }

        @Override
        public void store_i64_32(WasmMemory receiver_, Node node, long address, int value) {
            if (WasmMemoryLibraryGen.isDelegated((Library)this.delegateLibrary, (int)32)) {
                Object delegate = WasmMemoryLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                ((WasmMemoryLibrary)WasmMemoryLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).store_i64_32((WasmMemory)delegate, node, address, value);
                return;
            }
            this.delegateLibrary.store_i64_32(receiver_, node, address, value);
        }

        @Override
        public void store_i128(WasmMemory receiver_, Node node, long address, Object value) {
            if (WasmMemoryLibraryGen.isDelegated((Library)this.delegateLibrary, (int)33)) {
                Object delegate = WasmMemoryLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                ((WasmMemoryLibrary)WasmMemoryLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).store_i128((WasmMemory)delegate, node, address, value);
                return;
            }
            this.delegateLibrary.store_i128(receiver_, node, address, value);
        }

        @Override
        public int atomic_load_i32(WasmMemory receiver_, Node node, long address) {
            if (WasmMemoryLibraryGen.isDelegated((Library)this.delegateLibrary, (int)34)) {
                Object delegate = WasmMemoryLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((WasmMemoryLibrary)WasmMemoryLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).atomic_load_i32((WasmMemory)delegate, node, address);
            }
            return this.delegateLibrary.atomic_load_i32(receiver_, node, address);
        }

        @Override
        public long atomic_load_i64(WasmMemory receiver_, Node node, long address) {
            if (WasmMemoryLibraryGen.isDelegated((Library)this.delegateLibrary, (int)35)) {
                Object delegate = WasmMemoryLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((WasmMemoryLibrary)WasmMemoryLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).atomic_load_i64((WasmMemory)delegate, node, address);
            }
            return this.delegateLibrary.atomic_load_i64(receiver_, node, address);
        }

        @Override
        public int atomic_load_i32_8u(WasmMemory receiver_, Node node, long address) {
            if (WasmMemoryLibraryGen.isDelegated((Library)this.delegateLibrary, (int)36)) {
                Object delegate = WasmMemoryLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((WasmMemoryLibrary)WasmMemoryLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).atomic_load_i32_8u((WasmMemory)delegate, node, address);
            }
            return this.delegateLibrary.atomic_load_i32_8u(receiver_, node, address);
        }

        @Override
        public int atomic_load_i32_16u(WasmMemory receiver_, Node node, long address) {
            if (WasmMemoryLibraryGen.isDelegated((Library)this.delegateLibrary, (int)37)) {
                Object delegate = WasmMemoryLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((WasmMemoryLibrary)WasmMemoryLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).atomic_load_i32_16u((WasmMemory)delegate, node, address);
            }
            return this.delegateLibrary.atomic_load_i32_16u(receiver_, node, address);
        }

        @Override
        public long atomic_load_i64_8u(WasmMemory receiver_, Node node, long address) {
            if (WasmMemoryLibraryGen.isDelegated((Library)this.delegateLibrary, (int)38)) {
                Object delegate = WasmMemoryLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((WasmMemoryLibrary)WasmMemoryLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).atomic_load_i64_8u((WasmMemory)delegate, node, address);
            }
            return this.delegateLibrary.atomic_load_i64_8u(receiver_, node, address);
        }

        @Override
        public long atomic_load_i64_16u(WasmMemory receiver_, Node node, long address) {
            if (WasmMemoryLibraryGen.isDelegated((Library)this.delegateLibrary, (int)39)) {
                Object delegate = WasmMemoryLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((WasmMemoryLibrary)WasmMemoryLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).atomic_load_i64_16u((WasmMemory)delegate, node, address);
            }
            return this.delegateLibrary.atomic_load_i64_16u(receiver_, node, address);
        }

        @Override
        public long atomic_load_i64_32u(WasmMemory receiver_, Node node, long address) {
            if (WasmMemoryLibraryGen.isDelegated((Library)this.delegateLibrary, (int)40)) {
                Object delegate = WasmMemoryLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((WasmMemoryLibrary)WasmMemoryLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).atomic_load_i64_32u((WasmMemory)delegate, node, address);
            }
            return this.delegateLibrary.atomic_load_i64_32u(receiver_, node, address);
        }

        @Override
        public void atomic_store_i32(WasmMemory receiver_, Node node, long address, int value) {
            if (WasmMemoryLibraryGen.isDelegated((Library)this.delegateLibrary, (int)41)) {
                Object delegate = WasmMemoryLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                ((WasmMemoryLibrary)WasmMemoryLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).atomic_store_i32((WasmMemory)delegate, node, address, value);
                return;
            }
            this.delegateLibrary.atomic_store_i32(receiver_, node, address, value);
        }

        @Override
        public void atomic_store_i64(WasmMemory receiver_, Node node, long address, long value) {
            if (WasmMemoryLibraryGen.isDelegated((Library)this.delegateLibrary, (int)42)) {
                Object delegate = WasmMemoryLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                ((WasmMemoryLibrary)WasmMemoryLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).atomic_store_i64((WasmMemory)delegate, node, address, value);
                return;
            }
            this.delegateLibrary.atomic_store_i64(receiver_, node, address, value);
        }

        @Override
        public void atomic_store_i32_8(WasmMemory receiver_, Node node, long address, byte value) {
            if (WasmMemoryLibraryGen.isDelegated((Library)this.delegateLibrary, (int)43)) {
                Object delegate = WasmMemoryLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                ((WasmMemoryLibrary)WasmMemoryLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).atomic_store_i32_8((WasmMemory)delegate, node, address, value);
                return;
            }
            this.delegateLibrary.atomic_store_i32_8(receiver_, node, address, value);
        }

        @Override
        public void atomic_store_i32_16(WasmMemory receiver_, Node node, long address, short value) {
            if (WasmMemoryLibraryGen.isDelegated((Library)this.delegateLibrary, (int)44)) {
                Object delegate = WasmMemoryLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                ((WasmMemoryLibrary)WasmMemoryLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).atomic_store_i32_16((WasmMemory)delegate, node, address, value);
                return;
            }
            this.delegateLibrary.atomic_store_i32_16(receiver_, node, address, value);
        }

        @Override
        public void atomic_store_i64_8(WasmMemory receiver_, Node node, long address, byte value) {
            if (WasmMemoryLibraryGen.isDelegated((Library)this.delegateLibrary, (int)45)) {
                Object delegate = WasmMemoryLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                ((WasmMemoryLibrary)WasmMemoryLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).atomic_store_i64_8((WasmMemory)delegate, node, address, value);
                return;
            }
            this.delegateLibrary.atomic_store_i64_8(receiver_, node, address, value);
        }

        @Override
        public void atomic_store_i64_16(WasmMemory receiver_, Node node, long address, short value) {
            if (WasmMemoryLibraryGen.isDelegated((Library)this.delegateLibrary, (int)46)) {
                Object delegate = WasmMemoryLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                ((WasmMemoryLibrary)WasmMemoryLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).atomic_store_i64_16((WasmMemory)delegate, node, address, value);
                return;
            }
            this.delegateLibrary.atomic_store_i64_16(receiver_, node, address, value);
        }

        @Override
        public void atomic_store_i64_32(WasmMemory receiver_, Node node, long address, int value) {
            if (WasmMemoryLibraryGen.isDelegated((Library)this.delegateLibrary, (int)47)) {
                Object delegate = WasmMemoryLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                ((WasmMemoryLibrary)WasmMemoryLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).atomic_store_i64_32((WasmMemory)delegate, node, address, value);
                return;
            }
            this.delegateLibrary.atomic_store_i64_32(receiver_, node, address, value);
        }

        @Override
        public int atomic_rmw_add_i32_8u(WasmMemory receiver_, Node node, long address, byte value) {
            if (WasmMemoryLibraryGen.isDelegated((Library)this.delegateLibrary, (int)48)) {
                Object delegate = WasmMemoryLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((WasmMemoryLibrary)WasmMemoryLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).atomic_rmw_add_i32_8u((WasmMemory)delegate, node, address, value);
            }
            return this.delegateLibrary.atomic_rmw_add_i32_8u(receiver_, node, address, value);
        }

        @Override
        public int atomic_rmw_add_i32_16u(WasmMemory receiver_, Node node, long address, short value) {
            if (WasmMemoryLibraryGen.isDelegated((Library)this.delegateLibrary, (int)49)) {
                Object delegate = WasmMemoryLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((WasmMemoryLibrary)WasmMemoryLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).atomic_rmw_add_i32_16u((WasmMemory)delegate, node, address, value);
            }
            return this.delegateLibrary.atomic_rmw_add_i32_16u(receiver_, node, address, value);
        }

        @Override
        public int atomic_rmw_add_i32(WasmMemory receiver_, Node node, long address, int value) {
            if (WasmMemoryLibraryGen.isDelegated((Library)this.delegateLibrary, (int)50)) {
                Object delegate = WasmMemoryLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((WasmMemoryLibrary)WasmMemoryLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).atomic_rmw_add_i32((WasmMemory)delegate, node, address, value);
            }
            return this.delegateLibrary.atomic_rmw_add_i32(receiver_, node, address, value);
        }

        @Override
        public long atomic_rmw_add_i64_8u(WasmMemory receiver_, Node node, long address, byte value) {
            if (WasmMemoryLibraryGen.isDelegated((Library)this.delegateLibrary, (int)51)) {
                Object delegate = WasmMemoryLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((WasmMemoryLibrary)WasmMemoryLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).atomic_rmw_add_i64_8u((WasmMemory)delegate, node, address, value);
            }
            return this.delegateLibrary.atomic_rmw_add_i64_8u(receiver_, node, address, value);
        }

        @Override
        public long atomic_rmw_add_i64_16u(WasmMemory receiver_, Node node, long address, short value) {
            if (WasmMemoryLibraryGen.isDelegated((Library)this.delegateLibrary, (int)52)) {
                Object delegate = WasmMemoryLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((WasmMemoryLibrary)WasmMemoryLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).atomic_rmw_add_i64_16u((WasmMemory)delegate, node, address, value);
            }
            return this.delegateLibrary.atomic_rmw_add_i64_16u(receiver_, node, address, value);
        }

        @Override
        public long atomic_rmw_add_i64_32u(WasmMemory receiver_, Node node, long address, int value) {
            if (WasmMemoryLibraryGen.isDelegated((Library)this.delegateLibrary, (int)53)) {
                Object delegate = WasmMemoryLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((WasmMemoryLibrary)WasmMemoryLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).atomic_rmw_add_i64_32u((WasmMemory)delegate, node, address, value);
            }
            return this.delegateLibrary.atomic_rmw_add_i64_32u(receiver_, node, address, value);
        }

        @Override
        public long atomic_rmw_add_i64(WasmMemory receiver_, Node node, long address, long value) {
            if (WasmMemoryLibraryGen.isDelegated((Library)this.delegateLibrary, (int)54)) {
                Object delegate = WasmMemoryLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((WasmMemoryLibrary)WasmMemoryLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).atomic_rmw_add_i64((WasmMemory)delegate, node, address, value);
            }
            return this.delegateLibrary.atomic_rmw_add_i64(receiver_, node, address, value);
        }

        @Override
        public int atomic_rmw_sub_i32_8u(WasmMemory receiver_, Node node, long address, byte value) {
            if (WasmMemoryLibraryGen.isDelegated((Library)this.delegateLibrary, (int)55)) {
                Object delegate = WasmMemoryLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((WasmMemoryLibrary)WasmMemoryLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).atomic_rmw_sub_i32_8u((WasmMemory)delegate, node, address, value);
            }
            return this.delegateLibrary.atomic_rmw_sub_i32_8u(receiver_, node, address, value);
        }

        @Override
        public int atomic_rmw_sub_i32_16u(WasmMemory receiver_, Node node, long address, short value) {
            if (WasmMemoryLibraryGen.isDelegated((Library)this.delegateLibrary, (int)56)) {
                Object delegate = WasmMemoryLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((WasmMemoryLibrary)WasmMemoryLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).atomic_rmw_sub_i32_16u((WasmMemory)delegate, node, address, value);
            }
            return this.delegateLibrary.atomic_rmw_sub_i32_16u(receiver_, node, address, value);
        }

        @Override
        public int atomic_rmw_sub_i32(WasmMemory receiver_, Node node, long address, int value) {
            if (WasmMemoryLibraryGen.isDelegated((Library)this.delegateLibrary, (int)57)) {
                Object delegate = WasmMemoryLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((WasmMemoryLibrary)WasmMemoryLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).atomic_rmw_sub_i32((WasmMemory)delegate, node, address, value);
            }
            return this.delegateLibrary.atomic_rmw_sub_i32(receiver_, node, address, value);
        }

        @Override
        public long atomic_rmw_sub_i64_8u(WasmMemory receiver_, Node node, long address, byte value) {
            if (WasmMemoryLibraryGen.isDelegated((Library)this.delegateLibrary, (int)58)) {
                Object delegate = WasmMemoryLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((WasmMemoryLibrary)WasmMemoryLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).atomic_rmw_sub_i64_8u((WasmMemory)delegate, node, address, value);
            }
            return this.delegateLibrary.atomic_rmw_sub_i64_8u(receiver_, node, address, value);
        }

        @Override
        public long atomic_rmw_sub_i64_16u(WasmMemory receiver_, Node node, long address, short value) {
            if (WasmMemoryLibraryGen.isDelegated((Library)this.delegateLibrary, (int)59)) {
                Object delegate = WasmMemoryLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((WasmMemoryLibrary)WasmMemoryLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).atomic_rmw_sub_i64_16u((WasmMemory)delegate, node, address, value);
            }
            return this.delegateLibrary.atomic_rmw_sub_i64_16u(receiver_, node, address, value);
        }

        @Override
        public long atomic_rmw_sub_i64_32u(WasmMemory receiver_, Node node, long address, int value) {
            if (WasmMemoryLibraryGen.isDelegated((Library)this.delegateLibrary, (int)60)) {
                Object delegate = WasmMemoryLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((WasmMemoryLibrary)WasmMemoryLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).atomic_rmw_sub_i64_32u((WasmMemory)delegate, node, address, value);
            }
            return this.delegateLibrary.atomic_rmw_sub_i64_32u(receiver_, node, address, value);
        }

        @Override
        public long atomic_rmw_sub_i64(WasmMemory receiver_, Node node, long address, long value) {
            if (WasmMemoryLibraryGen.isDelegated((Library)this.delegateLibrary, (int)61)) {
                Object delegate = WasmMemoryLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((WasmMemoryLibrary)WasmMemoryLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).atomic_rmw_sub_i64((WasmMemory)delegate, node, address, value);
            }
            return this.delegateLibrary.atomic_rmw_sub_i64(receiver_, node, address, value);
        }

        @Override
        public int atomic_rmw_and_i32_8u(WasmMemory receiver_, Node node, long address, byte value) {
            if (WasmMemoryLibraryGen.isDelegated((Library)this.delegateLibrary, (int)62)) {
                Object delegate = WasmMemoryLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((WasmMemoryLibrary)WasmMemoryLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).atomic_rmw_and_i32_8u((WasmMemory)delegate, node, address, value);
            }
            return this.delegateLibrary.atomic_rmw_and_i32_8u(receiver_, node, address, value);
        }

        @Override
        public int atomic_rmw_and_i32_16u(WasmMemory receiver_, Node node, long address, short value) {
            if (WasmMemoryLibraryGen.isDelegated((Library)this.delegateLibrary, (int)63)) {
                Object delegate = WasmMemoryLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((WasmMemoryLibrary)WasmMemoryLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).atomic_rmw_and_i32_16u((WasmMemory)delegate, node, address, value);
            }
            return this.delegateLibrary.atomic_rmw_and_i32_16u(receiver_, node, address, value);
        }

        @Override
        public int atomic_rmw_and_i32(WasmMemory receiver_, Node node, long address, int value) {
            if (WasmMemoryLibraryGen.isDelegated((Library)this.delegateLibrary, (int)64)) {
                Object delegate = WasmMemoryLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((WasmMemoryLibrary)WasmMemoryLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).atomic_rmw_and_i32((WasmMemory)delegate, node, address, value);
            }
            return this.delegateLibrary.atomic_rmw_and_i32(receiver_, node, address, value);
        }

        @Override
        public long atomic_rmw_and_i64_8u(WasmMemory receiver_, Node node, long address, byte value) {
            if (WasmMemoryLibraryGen.isDelegated((Library)this.delegateLibrary, (int)65)) {
                Object delegate = WasmMemoryLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((WasmMemoryLibrary)WasmMemoryLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).atomic_rmw_and_i64_8u((WasmMemory)delegate, node, address, value);
            }
            return this.delegateLibrary.atomic_rmw_and_i64_8u(receiver_, node, address, value);
        }

        @Override
        public long atomic_rmw_and_i64_16u(WasmMemory receiver_, Node node, long address, short value) {
            if (WasmMemoryLibraryGen.isDelegated((Library)this.delegateLibrary, (int)66)) {
                Object delegate = WasmMemoryLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((WasmMemoryLibrary)WasmMemoryLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).atomic_rmw_and_i64_16u((WasmMemory)delegate, node, address, value);
            }
            return this.delegateLibrary.atomic_rmw_and_i64_16u(receiver_, node, address, value);
        }

        @Override
        public long atomic_rmw_and_i64_32u(WasmMemory receiver_, Node node, long address, int value) {
            if (WasmMemoryLibraryGen.isDelegated((Library)this.delegateLibrary, (int)67)) {
                Object delegate = WasmMemoryLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((WasmMemoryLibrary)WasmMemoryLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).atomic_rmw_and_i64_32u((WasmMemory)delegate, node, address, value);
            }
            return this.delegateLibrary.atomic_rmw_and_i64_32u(receiver_, node, address, value);
        }

        @Override
        public long atomic_rmw_and_i64(WasmMemory receiver_, Node node, long address, long value) {
            if (WasmMemoryLibraryGen.isDelegated((Library)this.delegateLibrary, (int)68)) {
                Object delegate = WasmMemoryLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((WasmMemoryLibrary)WasmMemoryLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).atomic_rmw_and_i64((WasmMemory)delegate, node, address, value);
            }
            return this.delegateLibrary.atomic_rmw_and_i64(receiver_, node, address, value);
        }

        @Override
        public int atomic_rmw_or_i32_8u(WasmMemory receiver_, Node node, long address, byte value) {
            if (WasmMemoryLibraryGen.isDelegated((Library)this.delegateLibrary, (int)69)) {
                Object delegate = WasmMemoryLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((WasmMemoryLibrary)WasmMemoryLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).atomic_rmw_or_i32_8u((WasmMemory)delegate, node, address, value);
            }
            return this.delegateLibrary.atomic_rmw_or_i32_8u(receiver_, node, address, value);
        }

        @Override
        public int atomic_rmw_or_i32_16u(WasmMemory receiver_, Node node, long address, short value) {
            if (WasmMemoryLibraryGen.isDelegated((Library)this.delegateLibrary, (int)70)) {
                Object delegate = WasmMemoryLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((WasmMemoryLibrary)WasmMemoryLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).atomic_rmw_or_i32_16u((WasmMemory)delegate, node, address, value);
            }
            return this.delegateLibrary.atomic_rmw_or_i32_16u(receiver_, node, address, value);
        }

        @Override
        public int atomic_rmw_or_i32(WasmMemory receiver_, Node node, long address, int value) {
            if (WasmMemoryLibraryGen.isDelegated((Library)this.delegateLibrary, (int)71)) {
                Object delegate = WasmMemoryLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((WasmMemoryLibrary)WasmMemoryLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).atomic_rmw_or_i32((WasmMemory)delegate, node, address, value);
            }
            return this.delegateLibrary.atomic_rmw_or_i32(receiver_, node, address, value);
        }

        @Override
        public long atomic_rmw_or_i64_8u(WasmMemory receiver_, Node node, long address, byte value) {
            if (WasmMemoryLibraryGen.isDelegated((Library)this.delegateLibrary, (int)72)) {
                Object delegate = WasmMemoryLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((WasmMemoryLibrary)WasmMemoryLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).atomic_rmw_or_i64_8u((WasmMemory)delegate, node, address, value);
            }
            return this.delegateLibrary.atomic_rmw_or_i64_8u(receiver_, node, address, value);
        }

        @Override
        public long atomic_rmw_or_i64_16u(WasmMemory receiver_, Node node, long address, short value) {
            if (WasmMemoryLibraryGen.isDelegated((Library)this.delegateLibrary, (int)73)) {
                Object delegate = WasmMemoryLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((WasmMemoryLibrary)WasmMemoryLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).atomic_rmw_or_i64_16u((WasmMemory)delegate, node, address, value);
            }
            return this.delegateLibrary.atomic_rmw_or_i64_16u(receiver_, node, address, value);
        }

        @Override
        public long atomic_rmw_or_i64_32u(WasmMemory receiver_, Node node, long address, int value) {
            if (WasmMemoryLibraryGen.isDelegated((Library)this.delegateLibrary, (int)74)) {
                Object delegate = WasmMemoryLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((WasmMemoryLibrary)WasmMemoryLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).atomic_rmw_or_i64_32u((WasmMemory)delegate, node, address, value);
            }
            return this.delegateLibrary.atomic_rmw_or_i64_32u(receiver_, node, address, value);
        }

        @Override
        public long atomic_rmw_or_i64(WasmMemory receiver_, Node node, long address, long value) {
            if (WasmMemoryLibraryGen.isDelegated((Library)this.delegateLibrary, (int)75)) {
                Object delegate = WasmMemoryLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((WasmMemoryLibrary)WasmMemoryLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).atomic_rmw_or_i64((WasmMemory)delegate, node, address, value);
            }
            return this.delegateLibrary.atomic_rmw_or_i64(receiver_, node, address, value);
        }

        @Override
        public int atomic_rmw_xor_i32_8u(WasmMemory receiver_, Node node, long address, byte value) {
            if (WasmMemoryLibraryGen.isDelegated((Library)this.delegateLibrary, (int)76)) {
                Object delegate = WasmMemoryLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((WasmMemoryLibrary)WasmMemoryLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).atomic_rmw_xor_i32_8u((WasmMemory)delegate, node, address, value);
            }
            return this.delegateLibrary.atomic_rmw_xor_i32_8u(receiver_, node, address, value);
        }

        @Override
        public int atomic_rmw_xor_i32_16u(WasmMemory receiver_, Node node, long address, short value) {
            if (WasmMemoryLibraryGen.isDelegated((Library)this.delegateLibrary, (int)77)) {
                Object delegate = WasmMemoryLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((WasmMemoryLibrary)WasmMemoryLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).atomic_rmw_xor_i32_16u((WasmMemory)delegate, node, address, value);
            }
            return this.delegateLibrary.atomic_rmw_xor_i32_16u(receiver_, node, address, value);
        }

        @Override
        public int atomic_rmw_xor_i32(WasmMemory receiver_, Node node, long address, int value) {
            if (WasmMemoryLibraryGen.isDelegated((Library)this.delegateLibrary, (int)78)) {
                Object delegate = WasmMemoryLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((WasmMemoryLibrary)WasmMemoryLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).atomic_rmw_xor_i32((WasmMemory)delegate, node, address, value);
            }
            return this.delegateLibrary.atomic_rmw_xor_i32(receiver_, node, address, value);
        }

        @Override
        public long atomic_rmw_xor_i64_8u(WasmMemory receiver_, Node node, long address, byte value) {
            if (WasmMemoryLibraryGen.isDelegated((Library)this.delegateLibrary, (int)79)) {
                Object delegate = WasmMemoryLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((WasmMemoryLibrary)WasmMemoryLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).atomic_rmw_xor_i64_8u((WasmMemory)delegate, node, address, value);
            }
            return this.delegateLibrary.atomic_rmw_xor_i64_8u(receiver_, node, address, value);
        }

        @Override
        public long atomic_rmw_xor_i64_16u(WasmMemory receiver_, Node node, long address, short value) {
            if (WasmMemoryLibraryGen.isDelegated((Library)this.delegateLibrary, (int)80)) {
                Object delegate = WasmMemoryLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((WasmMemoryLibrary)WasmMemoryLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).atomic_rmw_xor_i64_16u((WasmMemory)delegate, node, address, value);
            }
            return this.delegateLibrary.atomic_rmw_xor_i64_16u(receiver_, node, address, value);
        }

        @Override
        public long atomic_rmw_xor_i64_32u(WasmMemory receiver_, Node node, long address, int value) {
            if (WasmMemoryLibraryGen.isDelegated((Library)this.delegateLibrary, (int)81)) {
                Object delegate = WasmMemoryLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((WasmMemoryLibrary)WasmMemoryLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).atomic_rmw_xor_i64_32u((WasmMemory)delegate, node, address, value);
            }
            return this.delegateLibrary.atomic_rmw_xor_i64_32u(receiver_, node, address, value);
        }

        @Override
        public long atomic_rmw_xor_i64(WasmMemory receiver_, Node node, long address, long value) {
            if (WasmMemoryLibraryGen.isDelegated((Library)this.delegateLibrary, (int)82)) {
                Object delegate = WasmMemoryLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((WasmMemoryLibrary)WasmMemoryLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).atomic_rmw_xor_i64((WasmMemory)delegate, node, address, value);
            }
            return this.delegateLibrary.atomic_rmw_xor_i64(receiver_, node, address, value);
        }

        @Override
        public int atomic_rmw_xchg_i32_8u(WasmMemory receiver_, Node node, long address, byte value) {
            if (WasmMemoryLibraryGen.isDelegated((Library)this.delegateLibrary, (int)83)) {
                Object delegate = WasmMemoryLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((WasmMemoryLibrary)WasmMemoryLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).atomic_rmw_xchg_i32_8u((WasmMemory)delegate, node, address, value);
            }
            return this.delegateLibrary.atomic_rmw_xchg_i32_8u(receiver_, node, address, value);
        }

        @Override
        public int atomic_rmw_xchg_i32_16u(WasmMemory receiver_, Node node, long address, short value) {
            if (WasmMemoryLibraryGen.isDelegated((Library)this.delegateLibrary, (int)84)) {
                Object delegate = WasmMemoryLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((WasmMemoryLibrary)WasmMemoryLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).atomic_rmw_xchg_i32_16u((WasmMemory)delegate, node, address, value);
            }
            return this.delegateLibrary.atomic_rmw_xchg_i32_16u(receiver_, node, address, value);
        }

        @Override
        public int atomic_rmw_xchg_i32(WasmMemory receiver_, Node node, long address, int value) {
            if (WasmMemoryLibraryGen.isDelegated((Library)this.delegateLibrary, (int)85)) {
                Object delegate = WasmMemoryLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((WasmMemoryLibrary)WasmMemoryLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).atomic_rmw_xchg_i32((WasmMemory)delegate, node, address, value);
            }
            return this.delegateLibrary.atomic_rmw_xchg_i32(receiver_, node, address, value);
        }

        @Override
        public long atomic_rmw_xchg_i64_8u(WasmMemory receiver_, Node node, long address, byte value) {
            if (WasmMemoryLibraryGen.isDelegated((Library)this.delegateLibrary, (int)86)) {
                Object delegate = WasmMemoryLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((WasmMemoryLibrary)WasmMemoryLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).atomic_rmw_xchg_i64_8u((WasmMemory)delegate, node, address, value);
            }
            return this.delegateLibrary.atomic_rmw_xchg_i64_8u(receiver_, node, address, value);
        }

        @Override
        public long atomic_rmw_xchg_i64_16u(WasmMemory receiver_, Node node, long address, short value) {
            if (WasmMemoryLibraryGen.isDelegated((Library)this.delegateLibrary, (int)87)) {
                Object delegate = WasmMemoryLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((WasmMemoryLibrary)WasmMemoryLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).atomic_rmw_xchg_i64_16u((WasmMemory)delegate, node, address, value);
            }
            return this.delegateLibrary.atomic_rmw_xchg_i64_16u(receiver_, node, address, value);
        }

        @Override
        public long atomic_rmw_xchg_i64_32u(WasmMemory receiver_, Node node, long address, int value) {
            if (WasmMemoryLibraryGen.isDelegated((Library)this.delegateLibrary, (int)88)) {
                Object delegate = WasmMemoryLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((WasmMemoryLibrary)WasmMemoryLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).atomic_rmw_xchg_i64_32u((WasmMemory)delegate, node, address, value);
            }
            return this.delegateLibrary.atomic_rmw_xchg_i64_32u(receiver_, node, address, value);
        }

        @Override
        public long atomic_rmw_xchg_i64(WasmMemory receiver_, Node node, long address, long value) {
            if (WasmMemoryLibraryGen.isDelegated((Library)this.delegateLibrary, (int)89)) {
                Object delegate = WasmMemoryLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((WasmMemoryLibrary)WasmMemoryLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).atomic_rmw_xchg_i64((WasmMemory)delegate, node, address, value);
            }
            return this.delegateLibrary.atomic_rmw_xchg_i64(receiver_, node, address, value);
        }

        @Override
        public int atomic_rmw_cmpxchg_i32_8u(WasmMemory receiver_, Node node, long address, byte expected, byte replacement) {
            if (WasmMemoryLibraryGen.isDelegated((Library)this.delegateLibrary, (int)90)) {
                Object delegate = WasmMemoryLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((WasmMemoryLibrary)WasmMemoryLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).atomic_rmw_cmpxchg_i32_8u((WasmMemory)delegate, node, address, expected, replacement);
            }
            return this.delegateLibrary.atomic_rmw_cmpxchg_i32_8u(receiver_, node, address, expected, replacement);
        }

        @Override
        public int atomic_rmw_cmpxchg_i32_16u(WasmMemory receiver_, Node node, long address, short expected, short replacement) {
            if (WasmMemoryLibraryGen.isDelegated((Library)this.delegateLibrary, (int)91)) {
                Object delegate = WasmMemoryLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((WasmMemoryLibrary)WasmMemoryLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).atomic_rmw_cmpxchg_i32_16u((WasmMemory)delegate, node, address, expected, replacement);
            }
            return this.delegateLibrary.atomic_rmw_cmpxchg_i32_16u(receiver_, node, address, expected, replacement);
        }

        @Override
        public int atomic_rmw_cmpxchg_i32(WasmMemory receiver_, Node node, long address, int expected, int replacement) {
            if (WasmMemoryLibraryGen.isDelegated((Library)this.delegateLibrary, (int)92)) {
                Object delegate = WasmMemoryLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((WasmMemoryLibrary)WasmMemoryLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).atomic_rmw_cmpxchg_i32((WasmMemory)delegate, node, address, expected, replacement);
            }
            return this.delegateLibrary.atomic_rmw_cmpxchg_i32(receiver_, node, address, expected, replacement);
        }

        @Override
        public long atomic_rmw_cmpxchg_i64_8u(WasmMemory receiver_, Node node, long address, byte expected, byte replacement) {
            if (WasmMemoryLibraryGen.isDelegated((Library)this.delegateLibrary, (int)93)) {
                Object delegate = WasmMemoryLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((WasmMemoryLibrary)WasmMemoryLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).atomic_rmw_cmpxchg_i64_8u((WasmMemory)delegate, node, address, expected, replacement);
            }
            return this.delegateLibrary.atomic_rmw_cmpxchg_i64_8u(receiver_, node, address, expected, replacement);
        }

        @Override
        public long atomic_rmw_cmpxchg_i64_16u(WasmMemory receiver_, Node node, long address, short expected, short replacement) {
            if (WasmMemoryLibraryGen.isDelegated((Library)this.delegateLibrary, (int)94)) {
                Object delegate = WasmMemoryLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((WasmMemoryLibrary)WasmMemoryLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).atomic_rmw_cmpxchg_i64_16u((WasmMemory)delegate, node, address, expected, replacement);
            }
            return this.delegateLibrary.atomic_rmw_cmpxchg_i64_16u(receiver_, node, address, expected, replacement);
        }

        @Override
        public long atomic_rmw_cmpxchg_i64_32u(WasmMemory receiver_, Node node, long address, int expected, int replacement) {
            if (WasmMemoryLibraryGen.isDelegated((Library)this.delegateLibrary, (int)95)) {
                Object delegate = WasmMemoryLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((WasmMemoryLibrary)WasmMemoryLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).atomic_rmw_cmpxchg_i64_32u((WasmMemory)delegate, node, address, expected, replacement);
            }
            return this.delegateLibrary.atomic_rmw_cmpxchg_i64_32u(receiver_, node, address, expected, replacement);
        }

        @Override
        public long atomic_rmw_cmpxchg_i64(WasmMemory receiver_, Node node, long address, long expected, long replacement) {
            if (WasmMemoryLibraryGen.isDelegated((Library)this.delegateLibrary, (int)96)) {
                Object delegate = WasmMemoryLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((WasmMemoryLibrary)WasmMemoryLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).atomic_rmw_cmpxchg_i64((WasmMemory)delegate, node, address, expected, replacement);
            }
            return this.delegateLibrary.atomic_rmw_cmpxchg_i64(receiver_, node, address, expected, replacement);
        }

        @Override
        public int atomic_notify(WasmMemory receiver_, Node node, long address, int count) {
            if (WasmMemoryLibraryGen.isDelegated((Library)this.delegateLibrary, (int)97)) {
                Object delegate = WasmMemoryLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((WasmMemoryLibrary)WasmMemoryLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).atomic_notify((WasmMemory)delegate, node, address, count);
            }
            return this.delegateLibrary.atomic_notify(receiver_, node, address, count);
        }

        @Override
        public int atomic_wait32(WasmMemory receiver_, Node node, long address, int expected, long timeout) {
            if (WasmMemoryLibraryGen.isDelegated((Library)this.delegateLibrary, (int)98)) {
                Object delegate = WasmMemoryLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((WasmMemoryLibrary)WasmMemoryLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).atomic_wait32((WasmMemory)delegate, node, address, expected, timeout);
            }
            return this.delegateLibrary.atomic_wait32(receiver_, node, address, expected, timeout);
        }

        @Override
        public int atomic_wait64(WasmMemory receiver_, Node node, long address, long expected, long timeout) {
            if (WasmMemoryLibraryGen.isDelegated((Library)this.delegateLibrary, (int)99)) {
                Object delegate = WasmMemoryLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((WasmMemoryLibrary)WasmMemoryLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).atomic_wait64((WasmMemory)delegate, node, address, expected, timeout);
            }
            return this.delegateLibrary.atomic_wait64(receiver_, node, address, expected, timeout);
        }

        @Override
        public void close(WasmMemory receiver_) {
            if (WasmMemoryLibraryGen.isDelegated((Library)this.delegateLibrary, (int)100)) {
                Object delegate = WasmMemoryLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                ((WasmMemoryLibrary)WasmMemoryLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).close((WasmMemory)delegate);
                return;
            }
            this.delegateLibrary.close(receiver_);
        }

        @Override
        public void reset(WasmMemory receiver_) {
            if (WasmMemoryLibraryGen.isDelegated((Library)this.delegateLibrary, (int)101)) {
                Object delegate = WasmMemoryLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                ((WasmMemoryLibrary)WasmMemoryLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).reset((WasmMemory)delegate);
                return;
            }
            this.delegateLibrary.reset(receiver_);
        }

        @Override
        public ByteBuffer asByteBuffer(WasmMemory receiver_) {
            if (WasmMemoryLibraryGen.isDelegated((Library)this.delegateLibrary, (int)102)) {
                Object delegate = WasmMemoryLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((WasmMemoryLibrary)WasmMemoryLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).asByteBuffer((WasmMemory)delegate);
            }
            return this.delegateLibrary.asByteBuffer(receiver_);
        }

        @Override
        public WasmMemory duplicate(WasmMemory receiver_) {
            if (WasmMemoryLibraryGen.isDelegated((Library)this.delegateLibrary, (int)103)) {
                Object delegate = WasmMemoryLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((WasmMemoryLibrary)WasmMemoryLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).duplicate((WasmMemory)delegate);
            }
            return this.delegateLibrary.duplicate(receiver_);
        }

        @Override
        public boolean freed(WasmMemory receiver_) {
            if (WasmMemoryLibraryGen.isDelegated((Library)this.delegateLibrary, (int)104)) {
                Object delegate = WasmMemoryLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((WasmMemoryLibrary)WasmMemoryLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).freed((WasmMemory)delegate);
            }
            return this.delegateLibrary.freed(receiver_);
        }

        public boolean accepts(Object receiver_) {
            return this.delegateLibrary.accepts(receiver_);
        }

        public boolean isAdoptable() {
            return this.delegateLibrary.isAdoptable();
        }
    }

    @GeneratedBy(value=WasmMemoryLibrary.class)
    private static final class CachedDispatchFirst
    extends CachedDispatch {
        private final int limit_;

        CachedDispatchFirst(WasmMemoryLibrary library, CachedDispatch next, int limit_) {
            super(library, next);
            this.limit_ = limit_;
        }

        @Override
        int getLimit() {
            return this.limit_;
        }
    }

    @GeneratedBy(value=WasmMemoryLibrary.class)
    private static abstract class CachedDispatch
    extends WasmMemoryLibrary {
        @Node.Child
        WasmMemoryLibrary library;
        @Node.Child
        CachedDispatch next;

        CachedDispatch(WasmMemoryLibrary library, CachedDispatch next) {
            this.library = library;
            this.next = next;
        }

        abstract int getLimit();

        @Override
        @ExplodeLoop
        public long size(WasmMemory receiver_) {
            while (true) {
                CachedDispatch current = this;
                do {
                    WasmMemoryLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.size(receiver_);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public long byteSize(WasmMemory receiver_) {
            while (true) {
                CachedDispatch current = this;
                do {
                    WasmMemoryLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.byteSize(receiver_);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public long grow(WasmMemory receiver_, long extraPageSize) {
            while (true) {
                CachedDispatch current = this;
                do {
                    WasmMemoryLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.grow(receiver_, extraPageSize);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public void initialize(WasmMemory receiver_, Node node, byte[] source, int sourceOffset, long destinationOffset, int length) {
            while (true) {
                CachedDispatch current = this;
                do {
                    WasmMemoryLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    thisLibrary.initialize(receiver_, node, source, sourceOffset, destinationOffset, length);
                    return;
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public void fill(WasmMemory receiver_, Node node, long offset, long length, byte value) {
            while (true) {
                CachedDispatch current = this;
                do {
                    WasmMemoryLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    thisLibrary.fill(receiver_, node, offset, length, value);
                    return;
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public void copyFrom(WasmMemory receiver_, Node node, WasmMemory source, long sourceOffset, long destinationOffset, long length) {
            while (true) {
                CachedDispatch current = this;
                do {
                    WasmMemoryLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    thisLibrary.copyFrom(receiver_, node, source, sourceOffset, destinationOffset, length);
                    return;
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public int copyFromStream(WasmMemory receiver_, Node node, InputStream stream, int offset, int length) throws IOException {
            while (true) {
                CachedDispatch current = this;
                do {
                    WasmMemoryLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.copyFromStream(receiver_, node, stream, offset, length);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public void copyToStream(WasmMemory receiver_, Node node, OutputStream stream, int offset, int length) throws IOException {
            while (true) {
                CachedDispatch current = this;
                do {
                    WasmMemoryLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    thisLibrary.copyToStream(receiver_, node, stream, offset, length);
                    return;
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public void copyToBuffer(WasmMemory receiver_, Node node, byte[] dst, long srcOffset, int dstOffset, int length) {
            while (true) {
                CachedDispatch current = this;
                do {
                    WasmMemoryLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    thisLibrary.copyToBuffer(receiver_, node, dst, srcOffset, dstOffset, length);
                    return;
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public int load_i32(WasmMemory receiver_, Node node, long address) {
            while (true) {
                CachedDispatch current = this;
                do {
                    WasmMemoryLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.load_i32(receiver_, node, address);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public long load_i64(WasmMemory receiver_, Node node, long address) {
            while (true) {
                CachedDispatch current = this;
                do {
                    WasmMemoryLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.load_i64(receiver_, node, address);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public float load_f32(WasmMemory receiver_, Node node, long address) {
            while (true) {
                CachedDispatch current = this;
                do {
                    WasmMemoryLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.load_f32(receiver_, node, address);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public double load_f64(WasmMemory receiver_, Node node, long address) {
            while (true) {
                CachedDispatch current = this;
                do {
                    WasmMemoryLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.load_f64(receiver_, node, address);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public int load_i32_8s(WasmMemory receiver_, Node node, long address) {
            while (true) {
                CachedDispatch current = this;
                do {
                    WasmMemoryLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.load_i32_8s(receiver_, node, address);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public int load_i32_8u(WasmMemory receiver_, Node node, long address) {
            while (true) {
                CachedDispatch current = this;
                do {
                    WasmMemoryLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.load_i32_8u(receiver_, node, address);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public int load_i32_16s(WasmMemory receiver_, Node node, long address) {
            while (true) {
                CachedDispatch current = this;
                do {
                    WasmMemoryLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.load_i32_16s(receiver_, node, address);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public int load_i32_16u(WasmMemory receiver_, Node node, long address) {
            while (true) {
                CachedDispatch current = this;
                do {
                    WasmMemoryLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.load_i32_16u(receiver_, node, address);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public long load_i64_8s(WasmMemory receiver_, Node node, long address) {
            while (true) {
                CachedDispatch current = this;
                do {
                    WasmMemoryLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.load_i64_8s(receiver_, node, address);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public long load_i64_8u(WasmMemory receiver_, Node node, long address) {
            while (true) {
                CachedDispatch current = this;
                do {
                    WasmMemoryLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.load_i64_8u(receiver_, node, address);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public long load_i64_16s(WasmMemory receiver_, Node node, long address) {
            while (true) {
                CachedDispatch current = this;
                do {
                    WasmMemoryLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.load_i64_16s(receiver_, node, address);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public long load_i64_16u(WasmMemory receiver_, Node node, long address) {
            while (true) {
                CachedDispatch current = this;
                do {
                    WasmMemoryLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.load_i64_16u(receiver_, node, address);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public long load_i64_32s(WasmMemory receiver_, Node node, long address) {
            while (true) {
                CachedDispatch current = this;
                do {
                    WasmMemoryLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.load_i64_32s(receiver_, node, address);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public long load_i64_32u(WasmMemory receiver_, Node node, long address) {
            while (true) {
                CachedDispatch current = this;
                do {
                    WasmMemoryLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.load_i64_32u(receiver_, node, address);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public Object load_i128(WasmMemory receiver_, Node node, long address) {
            while (true) {
                CachedDispatch current = this;
                do {
                    WasmMemoryLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.load_i128(receiver_, node, address);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public void store_i32(WasmMemory receiver_, Node node, long address, int value) {
            while (true) {
                CachedDispatch current = this;
                do {
                    WasmMemoryLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    thisLibrary.store_i32(receiver_, node, address, value);
                    return;
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public void store_i64(WasmMemory receiver_, Node node, long address, long value) {
            while (true) {
                CachedDispatch current = this;
                do {
                    WasmMemoryLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    thisLibrary.store_i64(receiver_, node, address, value);
                    return;
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public void store_f32(WasmMemory receiver_, Node node, long address, float value) {
            while (true) {
                CachedDispatch current = this;
                do {
                    WasmMemoryLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    thisLibrary.store_f32(receiver_, node, address, value);
                    return;
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public void store_f64(WasmMemory receiver_, Node node, long address, double value) {
            while (true) {
                CachedDispatch current = this;
                do {
                    WasmMemoryLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    thisLibrary.store_f64(receiver_, node, address, value);
                    return;
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public void store_i32_8(WasmMemory receiver_, Node node, long address, byte value) {
            while (true) {
                CachedDispatch current = this;
                do {
                    WasmMemoryLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    thisLibrary.store_i32_8(receiver_, node, address, value);
                    return;
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public void store_i32_16(WasmMemory receiver_, Node node, long address, short value) {
            while (true) {
                CachedDispatch current = this;
                do {
                    WasmMemoryLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    thisLibrary.store_i32_16(receiver_, node, address, value);
                    return;
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public void store_i64_8(WasmMemory receiver_, Node node, long address, byte value) {
            while (true) {
                CachedDispatch current = this;
                do {
                    WasmMemoryLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    thisLibrary.store_i64_8(receiver_, node, address, value);
                    return;
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public void store_i64_16(WasmMemory receiver_, Node node, long address, short value) {
            while (true) {
                CachedDispatch current = this;
                do {
                    WasmMemoryLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    thisLibrary.store_i64_16(receiver_, node, address, value);
                    return;
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public void store_i64_32(WasmMemory receiver_, Node node, long address, int value) {
            while (true) {
                CachedDispatch current = this;
                do {
                    WasmMemoryLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    thisLibrary.store_i64_32(receiver_, node, address, value);
                    return;
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public void store_i128(WasmMemory receiver_, Node node, long address, Object value) {
            while (true) {
                CachedDispatch current = this;
                do {
                    WasmMemoryLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    thisLibrary.store_i128(receiver_, node, address, value);
                    return;
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public int atomic_load_i32(WasmMemory receiver_, Node node, long address) {
            while (true) {
                CachedDispatch current = this;
                do {
                    WasmMemoryLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.atomic_load_i32(receiver_, node, address);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public long atomic_load_i64(WasmMemory receiver_, Node node, long address) {
            while (true) {
                CachedDispatch current = this;
                do {
                    WasmMemoryLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.atomic_load_i64(receiver_, node, address);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public int atomic_load_i32_8u(WasmMemory receiver_, Node node, long address) {
            while (true) {
                CachedDispatch current = this;
                do {
                    WasmMemoryLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.atomic_load_i32_8u(receiver_, node, address);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public int atomic_load_i32_16u(WasmMemory receiver_, Node node, long address) {
            while (true) {
                CachedDispatch current = this;
                do {
                    WasmMemoryLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.atomic_load_i32_16u(receiver_, node, address);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public long atomic_load_i64_8u(WasmMemory receiver_, Node node, long address) {
            while (true) {
                CachedDispatch current = this;
                do {
                    WasmMemoryLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.atomic_load_i64_8u(receiver_, node, address);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public long atomic_load_i64_16u(WasmMemory receiver_, Node node, long address) {
            while (true) {
                CachedDispatch current = this;
                do {
                    WasmMemoryLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.atomic_load_i64_16u(receiver_, node, address);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public long atomic_load_i64_32u(WasmMemory receiver_, Node node, long address) {
            while (true) {
                CachedDispatch current = this;
                do {
                    WasmMemoryLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.atomic_load_i64_32u(receiver_, node, address);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public void atomic_store_i32(WasmMemory receiver_, Node node, long address, int value) {
            while (true) {
                CachedDispatch current = this;
                do {
                    WasmMemoryLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    thisLibrary.atomic_store_i32(receiver_, node, address, value);
                    return;
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public void atomic_store_i64(WasmMemory receiver_, Node node, long address, long value) {
            while (true) {
                CachedDispatch current = this;
                do {
                    WasmMemoryLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    thisLibrary.atomic_store_i64(receiver_, node, address, value);
                    return;
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public void atomic_store_i32_8(WasmMemory receiver_, Node node, long address, byte value) {
            while (true) {
                CachedDispatch current = this;
                do {
                    WasmMemoryLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    thisLibrary.atomic_store_i32_8(receiver_, node, address, value);
                    return;
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public void atomic_store_i32_16(WasmMemory receiver_, Node node, long address, short value) {
            while (true) {
                CachedDispatch current = this;
                do {
                    WasmMemoryLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    thisLibrary.atomic_store_i32_16(receiver_, node, address, value);
                    return;
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public void atomic_store_i64_8(WasmMemory receiver_, Node node, long address, byte value) {
            while (true) {
                CachedDispatch current = this;
                do {
                    WasmMemoryLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    thisLibrary.atomic_store_i64_8(receiver_, node, address, value);
                    return;
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public void atomic_store_i64_16(WasmMemory receiver_, Node node, long address, short value) {
            while (true) {
                CachedDispatch current = this;
                do {
                    WasmMemoryLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    thisLibrary.atomic_store_i64_16(receiver_, node, address, value);
                    return;
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public void atomic_store_i64_32(WasmMemory receiver_, Node node, long address, int value) {
            while (true) {
                CachedDispatch current = this;
                do {
                    WasmMemoryLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    thisLibrary.atomic_store_i64_32(receiver_, node, address, value);
                    return;
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public int atomic_rmw_add_i32_8u(WasmMemory receiver_, Node node, long address, byte value) {
            while (true) {
                CachedDispatch current = this;
                do {
                    WasmMemoryLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.atomic_rmw_add_i32_8u(receiver_, node, address, value);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public int atomic_rmw_add_i32_16u(WasmMemory receiver_, Node node, long address, short value) {
            while (true) {
                CachedDispatch current = this;
                do {
                    WasmMemoryLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.atomic_rmw_add_i32_16u(receiver_, node, address, value);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public int atomic_rmw_add_i32(WasmMemory receiver_, Node node, long address, int value) {
            while (true) {
                CachedDispatch current = this;
                do {
                    WasmMemoryLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.atomic_rmw_add_i32(receiver_, node, address, value);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public long atomic_rmw_add_i64_8u(WasmMemory receiver_, Node node, long address, byte value) {
            while (true) {
                CachedDispatch current = this;
                do {
                    WasmMemoryLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.atomic_rmw_add_i64_8u(receiver_, node, address, value);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public long atomic_rmw_add_i64_16u(WasmMemory receiver_, Node node, long address, short value) {
            while (true) {
                CachedDispatch current = this;
                do {
                    WasmMemoryLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.atomic_rmw_add_i64_16u(receiver_, node, address, value);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public long atomic_rmw_add_i64_32u(WasmMemory receiver_, Node node, long address, int value) {
            while (true) {
                CachedDispatch current = this;
                do {
                    WasmMemoryLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.atomic_rmw_add_i64_32u(receiver_, node, address, value);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public long atomic_rmw_add_i64(WasmMemory receiver_, Node node, long address, long value) {
            while (true) {
                CachedDispatch current = this;
                do {
                    WasmMemoryLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.atomic_rmw_add_i64(receiver_, node, address, value);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public int atomic_rmw_sub_i32_8u(WasmMemory receiver_, Node node, long address, byte value) {
            while (true) {
                CachedDispatch current = this;
                do {
                    WasmMemoryLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.atomic_rmw_sub_i32_8u(receiver_, node, address, value);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public int atomic_rmw_sub_i32_16u(WasmMemory receiver_, Node node, long address, short value) {
            while (true) {
                CachedDispatch current = this;
                do {
                    WasmMemoryLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.atomic_rmw_sub_i32_16u(receiver_, node, address, value);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public int atomic_rmw_sub_i32(WasmMemory receiver_, Node node, long address, int value) {
            while (true) {
                CachedDispatch current = this;
                do {
                    WasmMemoryLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.atomic_rmw_sub_i32(receiver_, node, address, value);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public long atomic_rmw_sub_i64_8u(WasmMemory receiver_, Node node, long address, byte value) {
            while (true) {
                CachedDispatch current = this;
                do {
                    WasmMemoryLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.atomic_rmw_sub_i64_8u(receiver_, node, address, value);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public long atomic_rmw_sub_i64_16u(WasmMemory receiver_, Node node, long address, short value) {
            while (true) {
                CachedDispatch current = this;
                do {
                    WasmMemoryLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.atomic_rmw_sub_i64_16u(receiver_, node, address, value);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public long atomic_rmw_sub_i64_32u(WasmMemory receiver_, Node node, long address, int value) {
            while (true) {
                CachedDispatch current = this;
                do {
                    WasmMemoryLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.atomic_rmw_sub_i64_32u(receiver_, node, address, value);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public long atomic_rmw_sub_i64(WasmMemory receiver_, Node node, long address, long value) {
            while (true) {
                CachedDispatch current = this;
                do {
                    WasmMemoryLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.atomic_rmw_sub_i64(receiver_, node, address, value);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public int atomic_rmw_and_i32_8u(WasmMemory receiver_, Node node, long address, byte value) {
            while (true) {
                CachedDispatch current = this;
                do {
                    WasmMemoryLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.atomic_rmw_and_i32_8u(receiver_, node, address, value);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public int atomic_rmw_and_i32_16u(WasmMemory receiver_, Node node, long address, short value) {
            while (true) {
                CachedDispatch current = this;
                do {
                    WasmMemoryLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.atomic_rmw_and_i32_16u(receiver_, node, address, value);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public int atomic_rmw_and_i32(WasmMemory receiver_, Node node, long address, int value) {
            while (true) {
                CachedDispatch current = this;
                do {
                    WasmMemoryLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.atomic_rmw_and_i32(receiver_, node, address, value);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public long atomic_rmw_and_i64_8u(WasmMemory receiver_, Node node, long address, byte value) {
            while (true) {
                CachedDispatch current = this;
                do {
                    WasmMemoryLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.atomic_rmw_and_i64_8u(receiver_, node, address, value);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public long atomic_rmw_and_i64_16u(WasmMemory receiver_, Node node, long address, short value) {
            while (true) {
                CachedDispatch current = this;
                do {
                    WasmMemoryLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.atomic_rmw_and_i64_16u(receiver_, node, address, value);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public long atomic_rmw_and_i64_32u(WasmMemory receiver_, Node node, long address, int value) {
            while (true) {
                CachedDispatch current = this;
                do {
                    WasmMemoryLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.atomic_rmw_and_i64_32u(receiver_, node, address, value);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public long atomic_rmw_and_i64(WasmMemory receiver_, Node node, long address, long value) {
            while (true) {
                CachedDispatch current = this;
                do {
                    WasmMemoryLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.atomic_rmw_and_i64(receiver_, node, address, value);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public int atomic_rmw_or_i32_8u(WasmMemory receiver_, Node node, long address, byte value) {
            while (true) {
                CachedDispatch current = this;
                do {
                    WasmMemoryLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.atomic_rmw_or_i32_8u(receiver_, node, address, value);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public int atomic_rmw_or_i32_16u(WasmMemory receiver_, Node node, long address, short value) {
            while (true) {
                CachedDispatch current = this;
                do {
                    WasmMemoryLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.atomic_rmw_or_i32_16u(receiver_, node, address, value);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public int atomic_rmw_or_i32(WasmMemory receiver_, Node node, long address, int value) {
            while (true) {
                CachedDispatch current = this;
                do {
                    WasmMemoryLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.atomic_rmw_or_i32(receiver_, node, address, value);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public long atomic_rmw_or_i64_8u(WasmMemory receiver_, Node node, long address, byte value) {
            while (true) {
                CachedDispatch current = this;
                do {
                    WasmMemoryLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.atomic_rmw_or_i64_8u(receiver_, node, address, value);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public long atomic_rmw_or_i64_16u(WasmMemory receiver_, Node node, long address, short value) {
            while (true) {
                CachedDispatch current = this;
                do {
                    WasmMemoryLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.atomic_rmw_or_i64_16u(receiver_, node, address, value);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public long atomic_rmw_or_i64_32u(WasmMemory receiver_, Node node, long address, int value) {
            while (true) {
                CachedDispatch current = this;
                do {
                    WasmMemoryLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.atomic_rmw_or_i64_32u(receiver_, node, address, value);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public long atomic_rmw_or_i64(WasmMemory receiver_, Node node, long address, long value) {
            while (true) {
                CachedDispatch current = this;
                do {
                    WasmMemoryLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.atomic_rmw_or_i64(receiver_, node, address, value);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public int atomic_rmw_xor_i32_8u(WasmMemory receiver_, Node node, long address, byte value) {
            while (true) {
                CachedDispatch current = this;
                do {
                    WasmMemoryLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.atomic_rmw_xor_i32_8u(receiver_, node, address, value);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public int atomic_rmw_xor_i32_16u(WasmMemory receiver_, Node node, long address, short value) {
            while (true) {
                CachedDispatch current = this;
                do {
                    WasmMemoryLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.atomic_rmw_xor_i32_16u(receiver_, node, address, value);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public int atomic_rmw_xor_i32(WasmMemory receiver_, Node node, long address, int value) {
            while (true) {
                CachedDispatch current = this;
                do {
                    WasmMemoryLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.atomic_rmw_xor_i32(receiver_, node, address, value);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public long atomic_rmw_xor_i64_8u(WasmMemory receiver_, Node node, long address, byte value) {
            while (true) {
                CachedDispatch current = this;
                do {
                    WasmMemoryLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.atomic_rmw_xor_i64_8u(receiver_, node, address, value);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public long atomic_rmw_xor_i64_16u(WasmMemory receiver_, Node node, long address, short value) {
            while (true) {
                CachedDispatch current = this;
                do {
                    WasmMemoryLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.atomic_rmw_xor_i64_16u(receiver_, node, address, value);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public long atomic_rmw_xor_i64_32u(WasmMemory receiver_, Node node, long address, int value) {
            while (true) {
                CachedDispatch current = this;
                do {
                    WasmMemoryLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.atomic_rmw_xor_i64_32u(receiver_, node, address, value);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public long atomic_rmw_xor_i64(WasmMemory receiver_, Node node, long address, long value) {
            while (true) {
                CachedDispatch current = this;
                do {
                    WasmMemoryLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.atomic_rmw_xor_i64(receiver_, node, address, value);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public int atomic_rmw_xchg_i32_8u(WasmMemory receiver_, Node node, long address, byte value) {
            while (true) {
                CachedDispatch current = this;
                do {
                    WasmMemoryLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.atomic_rmw_xchg_i32_8u(receiver_, node, address, value);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public int atomic_rmw_xchg_i32_16u(WasmMemory receiver_, Node node, long address, short value) {
            while (true) {
                CachedDispatch current = this;
                do {
                    WasmMemoryLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.atomic_rmw_xchg_i32_16u(receiver_, node, address, value);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public int atomic_rmw_xchg_i32(WasmMemory receiver_, Node node, long address, int value) {
            while (true) {
                CachedDispatch current = this;
                do {
                    WasmMemoryLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.atomic_rmw_xchg_i32(receiver_, node, address, value);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public long atomic_rmw_xchg_i64_8u(WasmMemory receiver_, Node node, long address, byte value) {
            while (true) {
                CachedDispatch current = this;
                do {
                    WasmMemoryLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.atomic_rmw_xchg_i64_8u(receiver_, node, address, value);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public long atomic_rmw_xchg_i64_16u(WasmMemory receiver_, Node node, long address, short value) {
            while (true) {
                CachedDispatch current = this;
                do {
                    WasmMemoryLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.atomic_rmw_xchg_i64_16u(receiver_, node, address, value);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public long atomic_rmw_xchg_i64_32u(WasmMemory receiver_, Node node, long address, int value) {
            while (true) {
                CachedDispatch current = this;
                do {
                    WasmMemoryLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.atomic_rmw_xchg_i64_32u(receiver_, node, address, value);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public long atomic_rmw_xchg_i64(WasmMemory receiver_, Node node, long address, long value) {
            while (true) {
                CachedDispatch current = this;
                do {
                    WasmMemoryLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.atomic_rmw_xchg_i64(receiver_, node, address, value);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public int atomic_rmw_cmpxchg_i32_8u(WasmMemory receiver_, Node node, long address, byte expected, byte replacement) {
            while (true) {
                CachedDispatch current = this;
                do {
                    WasmMemoryLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.atomic_rmw_cmpxchg_i32_8u(receiver_, node, address, expected, replacement);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public int atomic_rmw_cmpxchg_i32_16u(WasmMemory receiver_, Node node, long address, short expected, short replacement) {
            while (true) {
                CachedDispatch current = this;
                do {
                    WasmMemoryLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.atomic_rmw_cmpxchg_i32_16u(receiver_, node, address, expected, replacement);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public int atomic_rmw_cmpxchg_i32(WasmMemory receiver_, Node node, long address, int expected, int replacement) {
            while (true) {
                CachedDispatch current = this;
                do {
                    WasmMemoryLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.atomic_rmw_cmpxchg_i32(receiver_, node, address, expected, replacement);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public long atomic_rmw_cmpxchg_i64_8u(WasmMemory receiver_, Node node, long address, byte expected, byte replacement) {
            while (true) {
                CachedDispatch current = this;
                do {
                    WasmMemoryLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.atomic_rmw_cmpxchg_i64_8u(receiver_, node, address, expected, replacement);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public long atomic_rmw_cmpxchg_i64_16u(WasmMemory receiver_, Node node, long address, short expected, short replacement) {
            while (true) {
                CachedDispatch current = this;
                do {
                    WasmMemoryLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.atomic_rmw_cmpxchg_i64_16u(receiver_, node, address, expected, replacement);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public long atomic_rmw_cmpxchg_i64_32u(WasmMemory receiver_, Node node, long address, int expected, int replacement) {
            while (true) {
                CachedDispatch current = this;
                do {
                    WasmMemoryLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.atomic_rmw_cmpxchg_i64_32u(receiver_, node, address, expected, replacement);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public long atomic_rmw_cmpxchg_i64(WasmMemory receiver_, Node node, long address, long expected, long replacement) {
            while (true) {
                CachedDispatch current = this;
                do {
                    WasmMemoryLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.atomic_rmw_cmpxchg_i64(receiver_, node, address, expected, replacement);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public int atomic_notify(WasmMemory receiver_, Node node, long address, int count) {
            while (true) {
                CachedDispatch current = this;
                do {
                    WasmMemoryLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.atomic_notify(receiver_, node, address, count);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public int atomic_wait32(WasmMemory receiver_, Node node, long address, int expected, long timeout) {
            while (true) {
                CachedDispatch current = this;
                do {
                    WasmMemoryLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.atomic_wait32(receiver_, node, address, expected, timeout);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public int atomic_wait64(WasmMemory receiver_, Node node, long address, long expected, long timeout) {
            while (true) {
                CachedDispatch current = this;
                do {
                    WasmMemoryLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.atomic_wait64(receiver_, node, address, expected, timeout);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public void close(WasmMemory receiver_) {
            while (true) {
                CachedDispatch current = this;
                do {
                    WasmMemoryLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    thisLibrary.close(receiver_);
                    return;
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public void reset(WasmMemory receiver_) {
            while (true) {
                CachedDispatch current = this;
                do {
                    WasmMemoryLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    thisLibrary.reset(receiver_);
                    return;
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public ByteBuffer asByteBuffer(WasmMemory receiver_) {
            while (true) {
                CachedDispatch current = this;
                do {
                    WasmMemoryLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.asByteBuffer(receiver_);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public WasmMemory duplicate(WasmMemory receiver_) {
            while (true) {
                CachedDispatch current = this;
                do {
                    WasmMemoryLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.duplicate(receiver_);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public boolean freed(WasmMemory receiver_) {
            while (true) {
                CachedDispatch current = this;
                do {
                    WasmMemoryLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.freed(receiver_);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        public boolean accepts(Object receiver_) {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void specialize(WasmMemory receiver_) {
            Lock lock = this.getLock();
            lock.lock();
            try {
                CachedDispatch current = this;
                WasmMemoryLibrary thisLibrary = current.library;
                if (thisLibrary == null) {
                    this.library = (WasmMemoryLibrary)this.insert((Node)((WasmMemoryLibrary)INSTANCE.create(receiver_)));
                } else {
                    int count = 0;
                    do {
                        WasmMemoryLibrary currentLibrary;
                        if ((currentLibrary = current.library) != null && currentLibrary.accepts(receiver_)) {
                            return;
                        }
                        ++count;
                    } while ((current = current.next) != null);
                    if (count >= this.getLimit()) {
                        this.library = (WasmMemoryLibrary)this.insert((Node)new CachedToUncachedDispatch());
                        this.next = null;
                    } else {
                        this.next = (CachedDispatch)this.insert((Node)new CachedDispatchNext((WasmMemoryLibrary)INSTANCE.create(receiver_), this.next));
                    }
                }
            }
            finally {
                lock.unlock();
            }
        }
    }

    @GeneratedBy(value=WasmMemoryLibrary.class)
    @DenyReplace
    private static final class UncachedDispatch
    extends WasmMemoryLibrary
    implements UnadoptableNode {
        private UncachedDispatch() {
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public long size(WasmMemory receiver_) {
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).size(receiver_);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public long byteSize(WasmMemory receiver_) {
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).byteSize(receiver_);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public long grow(WasmMemory receiver_, long extraPageSize) {
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).grow(receiver_, extraPageSize);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void initialize(WasmMemory receiver_, Node node, byte[] source, int sourceOffset, long destinationOffset, int length) {
            ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).initialize(receiver_, node, source, sourceOffset, destinationOffset, length);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void fill(WasmMemory receiver_, Node node, long offset, long length, byte value) {
            ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).fill(receiver_, node, offset, length, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void copyFrom(WasmMemory receiver_, Node node, WasmMemory source, long sourceOffset, long destinationOffset, long length) {
            ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).copyFrom(receiver_, node, source, sourceOffset, destinationOffset, length);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public int copyFromStream(WasmMemory receiver_, Node node, InputStream stream, int offset, int length) throws IOException {
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).copyFromStream(receiver_, node, stream, offset, length);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void copyToStream(WasmMemory receiver_, Node node, OutputStream stream, int offset, int length) throws IOException {
            ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).copyToStream(receiver_, node, stream, offset, length);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void copyToBuffer(WasmMemory receiver_, Node node, byte[] dst, long srcOffset, int dstOffset, int length) {
            ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).copyToBuffer(receiver_, node, dst, srcOffset, dstOffset, length);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public int load_i32(WasmMemory receiver_, Node node, long address) {
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).load_i32(receiver_, node, address);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public long load_i64(WasmMemory receiver_, Node node, long address) {
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).load_i64(receiver_, node, address);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public float load_f32(WasmMemory receiver_, Node node, long address) {
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).load_f32(receiver_, node, address);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public double load_f64(WasmMemory receiver_, Node node, long address) {
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).load_f64(receiver_, node, address);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public int load_i32_8s(WasmMemory receiver_, Node node, long address) {
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).load_i32_8s(receiver_, node, address);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public int load_i32_8u(WasmMemory receiver_, Node node, long address) {
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).load_i32_8u(receiver_, node, address);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public int load_i32_16s(WasmMemory receiver_, Node node, long address) {
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).load_i32_16s(receiver_, node, address);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public int load_i32_16u(WasmMemory receiver_, Node node, long address) {
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).load_i32_16u(receiver_, node, address);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public long load_i64_8s(WasmMemory receiver_, Node node, long address) {
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).load_i64_8s(receiver_, node, address);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public long load_i64_8u(WasmMemory receiver_, Node node, long address) {
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).load_i64_8u(receiver_, node, address);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public long load_i64_16s(WasmMemory receiver_, Node node, long address) {
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).load_i64_16s(receiver_, node, address);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public long load_i64_16u(WasmMemory receiver_, Node node, long address) {
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).load_i64_16u(receiver_, node, address);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public long load_i64_32s(WasmMemory receiver_, Node node, long address) {
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).load_i64_32s(receiver_, node, address);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public long load_i64_32u(WasmMemory receiver_, Node node, long address) {
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).load_i64_32u(receiver_, node, address);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public Object load_i128(WasmMemory receiver_, Node node, long address) {
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).load_i128(receiver_, node, address);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void store_i32(WasmMemory receiver_, Node node, long address, int value) {
            ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).store_i32(receiver_, node, address, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void store_i64(WasmMemory receiver_, Node node, long address, long value) {
            ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).store_i64(receiver_, node, address, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void store_f32(WasmMemory receiver_, Node node, long address, float value) {
            ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).store_f32(receiver_, node, address, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void store_f64(WasmMemory receiver_, Node node, long address, double value) {
            ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).store_f64(receiver_, node, address, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void store_i32_8(WasmMemory receiver_, Node node, long address, byte value) {
            ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).store_i32_8(receiver_, node, address, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void store_i32_16(WasmMemory receiver_, Node node, long address, short value) {
            ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).store_i32_16(receiver_, node, address, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void store_i64_8(WasmMemory receiver_, Node node, long address, byte value) {
            ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).store_i64_8(receiver_, node, address, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void store_i64_16(WasmMemory receiver_, Node node, long address, short value) {
            ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).store_i64_16(receiver_, node, address, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void store_i64_32(WasmMemory receiver_, Node node, long address, int value) {
            ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).store_i64_32(receiver_, node, address, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void store_i128(WasmMemory receiver_, Node node, long address, Object value) {
            ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).store_i128(receiver_, node, address, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public int atomic_load_i32(WasmMemory receiver_, Node node, long address) {
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).atomic_load_i32(receiver_, node, address);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public long atomic_load_i64(WasmMemory receiver_, Node node, long address) {
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).atomic_load_i64(receiver_, node, address);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public int atomic_load_i32_8u(WasmMemory receiver_, Node node, long address) {
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).atomic_load_i32_8u(receiver_, node, address);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public int atomic_load_i32_16u(WasmMemory receiver_, Node node, long address) {
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).atomic_load_i32_16u(receiver_, node, address);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public long atomic_load_i64_8u(WasmMemory receiver_, Node node, long address) {
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).atomic_load_i64_8u(receiver_, node, address);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public long atomic_load_i64_16u(WasmMemory receiver_, Node node, long address) {
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).atomic_load_i64_16u(receiver_, node, address);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public long atomic_load_i64_32u(WasmMemory receiver_, Node node, long address) {
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).atomic_load_i64_32u(receiver_, node, address);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void atomic_store_i32(WasmMemory receiver_, Node node, long address, int value) {
            ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).atomic_store_i32(receiver_, node, address, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void atomic_store_i64(WasmMemory receiver_, Node node, long address, long value) {
            ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).atomic_store_i64(receiver_, node, address, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void atomic_store_i32_8(WasmMemory receiver_, Node node, long address, byte value) {
            ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).atomic_store_i32_8(receiver_, node, address, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void atomic_store_i32_16(WasmMemory receiver_, Node node, long address, short value) {
            ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).atomic_store_i32_16(receiver_, node, address, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void atomic_store_i64_8(WasmMemory receiver_, Node node, long address, byte value) {
            ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).atomic_store_i64_8(receiver_, node, address, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void atomic_store_i64_16(WasmMemory receiver_, Node node, long address, short value) {
            ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).atomic_store_i64_16(receiver_, node, address, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void atomic_store_i64_32(WasmMemory receiver_, Node node, long address, int value) {
            ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).atomic_store_i64_32(receiver_, node, address, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public int atomic_rmw_add_i32_8u(WasmMemory receiver_, Node node, long address, byte value) {
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).atomic_rmw_add_i32_8u(receiver_, node, address, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public int atomic_rmw_add_i32_16u(WasmMemory receiver_, Node node, long address, short value) {
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).atomic_rmw_add_i32_16u(receiver_, node, address, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public int atomic_rmw_add_i32(WasmMemory receiver_, Node node, long address, int value) {
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).atomic_rmw_add_i32(receiver_, node, address, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public long atomic_rmw_add_i64_8u(WasmMemory receiver_, Node node, long address, byte value) {
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).atomic_rmw_add_i64_8u(receiver_, node, address, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public long atomic_rmw_add_i64_16u(WasmMemory receiver_, Node node, long address, short value) {
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).atomic_rmw_add_i64_16u(receiver_, node, address, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public long atomic_rmw_add_i64_32u(WasmMemory receiver_, Node node, long address, int value) {
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).atomic_rmw_add_i64_32u(receiver_, node, address, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public long atomic_rmw_add_i64(WasmMemory receiver_, Node node, long address, long value) {
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).atomic_rmw_add_i64(receiver_, node, address, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public int atomic_rmw_sub_i32_8u(WasmMemory receiver_, Node node, long address, byte value) {
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).atomic_rmw_sub_i32_8u(receiver_, node, address, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public int atomic_rmw_sub_i32_16u(WasmMemory receiver_, Node node, long address, short value) {
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).atomic_rmw_sub_i32_16u(receiver_, node, address, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public int atomic_rmw_sub_i32(WasmMemory receiver_, Node node, long address, int value) {
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).atomic_rmw_sub_i32(receiver_, node, address, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public long atomic_rmw_sub_i64_8u(WasmMemory receiver_, Node node, long address, byte value) {
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).atomic_rmw_sub_i64_8u(receiver_, node, address, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public long atomic_rmw_sub_i64_16u(WasmMemory receiver_, Node node, long address, short value) {
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).atomic_rmw_sub_i64_16u(receiver_, node, address, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public long atomic_rmw_sub_i64_32u(WasmMemory receiver_, Node node, long address, int value) {
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).atomic_rmw_sub_i64_32u(receiver_, node, address, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public long atomic_rmw_sub_i64(WasmMemory receiver_, Node node, long address, long value) {
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).atomic_rmw_sub_i64(receiver_, node, address, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public int atomic_rmw_and_i32_8u(WasmMemory receiver_, Node node, long address, byte value) {
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).atomic_rmw_and_i32_8u(receiver_, node, address, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public int atomic_rmw_and_i32_16u(WasmMemory receiver_, Node node, long address, short value) {
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).atomic_rmw_and_i32_16u(receiver_, node, address, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public int atomic_rmw_and_i32(WasmMemory receiver_, Node node, long address, int value) {
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).atomic_rmw_and_i32(receiver_, node, address, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public long atomic_rmw_and_i64_8u(WasmMemory receiver_, Node node, long address, byte value) {
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).atomic_rmw_and_i64_8u(receiver_, node, address, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public long atomic_rmw_and_i64_16u(WasmMemory receiver_, Node node, long address, short value) {
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).atomic_rmw_and_i64_16u(receiver_, node, address, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public long atomic_rmw_and_i64_32u(WasmMemory receiver_, Node node, long address, int value) {
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).atomic_rmw_and_i64_32u(receiver_, node, address, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public long atomic_rmw_and_i64(WasmMemory receiver_, Node node, long address, long value) {
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).atomic_rmw_and_i64(receiver_, node, address, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public int atomic_rmw_or_i32_8u(WasmMemory receiver_, Node node, long address, byte value) {
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).atomic_rmw_or_i32_8u(receiver_, node, address, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public int atomic_rmw_or_i32_16u(WasmMemory receiver_, Node node, long address, short value) {
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).atomic_rmw_or_i32_16u(receiver_, node, address, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public int atomic_rmw_or_i32(WasmMemory receiver_, Node node, long address, int value) {
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).atomic_rmw_or_i32(receiver_, node, address, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public long atomic_rmw_or_i64_8u(WasmMemory receiver_, Node node, long address, byte value) {
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).atomic_rmw_or_i64_8u(receiver_, node, address, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public long atomic_rmw_or_i64_16u(WasmMemory receiver_, Node node, long address, short value) {
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).atomic_rmw_or_i64_16u(receiver_, node, address, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public long atomic_rmw_or_i64_32u(WasmMemory receiver_, Node node, long address, int value) {
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).atomic_rmw_or_i64_32u(receiver_, node, address, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public long atomic_rmw_or_i64(WasmMemory receiver_, Node node, long address, long value) {
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).atomic_rmw_or_i64(receiver_, node, address, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public int atomic_rmw_xor_i32_8u(WasmMemory receiver_, Node node, long address, byte value) {
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).atomic_rmw_xor_i32_8u(receiver_, node, address, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public int atomic_rmw_xor_i32_16u(WasmMemory receiver_, Node node, long address, short value) {
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).atomic_rmw_xor_i32_16u(receiver_, node, address, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public int atomic_rmw_xor_i32(WasmMemory receiver_, Node node, long address, int value) {
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).atomic_rmw_xor_i32(receiver_, node, address, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public long atomic_rmw_xor_i64_8u(WasmMemory receiver_, Node node, long address, byte value) {
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).atomic_rmw_xor_i64_8u(receiver_, node, address, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public long atomic_rmw_xor_i64_16u(WasmMemory receiver_, Node node, long address, short value) {
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).atomic_rmw_xor_i64_16u(receiver_, node, address, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public long atomic_rmw_xor_i64_32u(WasmMemory receiver_, Node node, long address, int value) {
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).atomic_rmw_xor_i64_32u(receiver_, node, address, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public long atomic_rmw_xor_i64(WasmMemory receiver_, Node node, long address, long value) {
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).atomic_rmw_xor_i64(receiver_, node, address, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public int atomic_rmw_xchg_i32_8u(WasmMemory receiver_, Node node, long address, byte value) {
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).atomic_rmw_xchg_i32_8u(receiver_, node, address, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public int atomic_rmw_xchg_i32_16u(WasmMemory receiver_, Node node, long address, short value) {
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).atomic_rmw_xchg_i32_16u(receiver_, node, address, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public int atomic_rmw_xchg_i32(WasmMemory receiver_, Node node, long address, int value) {
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).atomic_rmw_xchg_i32(receiver_, node, address, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public long atomic_rmw_xchg_i64_8u(WasmMemory receiver_, Node node, long address, byte value) {
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).atomic_rmw_xchg_i64_8u(receiver_, node, address, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public long atomic_rmw_xchg_i64_16u(WasmMemory receiver_, Node node, long address, short value) {
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).atomic_rmw_xchg_i64_16u(receiver_, node, address, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public long atomic_rmw_xchg_i64_32u(WasmMemory receiver_, Node node, long address, int value) {
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).atomic_rmw_xchg_i64_32u(receiver_, node, address, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public long atomic_rmw_xchg_i64(WasmMemory receiver_, Node node, long address, long value) {
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).atomic_rmw_xchg_i64(receiver_, node, address, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public int atomic_rmw_cmpxchg_i32_8u(WasmMemory receiver_, Node node, long address, byte expected, byte replacement) {
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).atomic_rmw_cmpxchg_i32_8u(receiver_, node, address, expected, replacement);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public int atomic_rmw_cmpxchg_i32_16u(WasmMemory receiver_, Node node, long address, short expected, short replacement) {
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).atomic_rmw_cmpxchg_i32_16u(receiver_, node, address, expected, replacement);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public int atomic_rmw_cmpxchg_i32(WasmMemory receiver_, Node node, long address, int expected, int replacement) {
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).atomic_rmw_cmpxchg_i32(receiver_, node, address, expected, replacement);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public long atomic_rmw_cmpxchg_i64_8u(WasmMemory receiver_, Node node, long address, byte expected, byte replacement) {
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).atomic_rmw_cmpxchg_i64_8u(receiver_, node, address, expected, replacement);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public long atomic_rmw_cmpxchg_i64_16u(WasmMemory receiver_, Node node, long address, short expected, short replacement) {
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).atomic_rmw_cmpxchg_i64_16u(receiver_, node, address, expected, replacement);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public long atomic_rmw_cmpxchg_i64_32u(WasmMemory receiver_, Node node, long address, int expected, int replacement) {
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).atomic_rmw_cmpxchg_i64_32u(receiver_, node, address, expected, replacement);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public long atomic_rmw_cmpxchg_i64(WasmMemory receiver_, Node node, long address, long expected, long replacement) {
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).atomic_rmw_cmpxchg_i64(receiver_, node, address, expected, replacement);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public int atomic_notify(WasmMemory receiver_, Node node, long address, int count) {
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).atomic_notify(receiver_, node, address, count);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public int atomic_wait32(WasmMemory receiver_, Node node, long address, int expected, long timeout) {
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).atomic_wait32(receiver_, node, address, expected, timeout);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public int atomic_wait64(WasmMemory receiver_, Node node, long address, long expected, long timeout) {
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).atomic_wait64(receiver_, node, address, expected, timeout);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void close(WasmMemory receiver_) {
            ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).close(receiver_);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void reset(WasmMemory receiver_) {
            ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).reset(receiver_);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public ByteBuffer asByteBuffer(WasmMemory receiver_) {
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).asByteBuffer(receiver_);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public WasmMemory duplicate(WasmMemory receiver_) {
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).duplicate(receiver_);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public boolean freed(WasmMemory receiver_) {
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).freed(receiver_);
        }

        @CompilerDirectives.TruffleBoundary
        public boolean accepts(Object receiver_) {
            return true;
        }
    }

    @GeneratedBy(value=WasmMemoryLibrary.class)
    private static class MessageImpl
    extends Message {
        MessageImpl(String name, int index, boolean deprecated, Class<?> returnType, Class<?> ... parameters) {
            super(LIBRARY_CLASS, name, index, deprecated, returnType, (Class[])parameters);
        }
    }

    @GeneratedBy(value=WasmMemoryLibrary.class)
    private static final class Default
    extends LibraryExport<WasmMemoryLibrary> {
        private Default() {
            super(WasmMemoryLibrary.class, WasmMemory.class, false, false, 0);
        }

        protected WasmMemoryLibrary createUncached(Object receiver) {
            assert (receiver instanceof WasmMemory);
            Uncached uncached = new Uncached(receiver);
            return uncached;
        }

        protected WasmMemoryLibrary createCached(Object receiver) {
            assert (receiver instanceof WasmMemory);
            return new Cached(receiver);
        }

        @GeneratedBy(value=WasmMemoryLibrary.class)
        @DenyReplace
        private static final class Uncached
        extends WasmMemoryLibrary
        implements UnadoptableNode {
            private final Class<? extends WasmMemory> receiverClass_;

            protected Uncached(Object receiver) {
                this.receiverClass_ = ((WasmMemory)receiver).getClass();
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                return CompilerDirectives.isExact((Object)receiver, this.receiverClass_);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long size(WasmMemory receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long byteSize(WasmMemory receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long grow(WasmMemory receiver, long extraPageSize) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void initialize(WasmMemory receiver, Node node, byte[] source, int sourceOffset, long destinationOffset, int length) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void fill(WasmMemory receiver, Node node, long offset, long length, byte value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void copyFrom(WasmMemory receiver, Node node, WasmMemory source, long sourceOffset, long destinationOffset, long length) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int copyFromStream(WasmMemory receiver, Node node, InputStream stream, int offset, int length) throws IOException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void copyToStream(WasmMemory receiver, Node node, OutputStream stream, int offset, int length) throws IOException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void copyToBuffer(WasmMemory receiver, Node node, byte[] dst, long srcOffset, int dstOffset, int length) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int load_i32(WasmMemory receiver, Node node, long address) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long load_i64(WasmMemory receiver, Node node, long address) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public float load_f32(WasmMemory receiver, Node node, long address) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public double load_f64(WasmMemory receiver, Node node, long address) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int load_i32_8s(WasmMemory receiver, Node node, long address) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int load_i32_8u(WasmMemory receiver, Node node, long address) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int load_i32_16s(WasmMemory receiver, Node node, long address) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int load_i32_16u(WasmMemory receiver, Node node, long address) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long load_i64_8s(WasmMemory receiver, Node node, long address) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long load_i64_8u(WasmMemory receiver, Node node, long address) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long load_i64_16s(WasmMemory receiver, Node node, long address) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long load_i64_16u(WasmMemory receiver, Node node, long address) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long load_i64_32s(WasmMemory receiver, Node node, long address) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long load_i64_32u(WasmMemory receiver, Node node, long address) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object load_i128(WasmMemory receiver, Node node, long address) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void store_i32(WasmMemory receiver, Node node, long address, int value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void store_i64(WasmMemory receiver, Node node, long address, long value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void store_f32(WasmMemory receiver, Node node, long address, float value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void store_f64(WasmMemory receiver, Node node, long address, double value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void store_i32_8(WasmMemory receiver, Node node, long address, byte value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void store_i32_16(WasmMemory receiver, Node node, long address, short value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void store_i64_8(WasmMemory receiver, Node node, long address, byte value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void store_i64_16(WasmMemory receiver, Node node, long address, short value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void store_i64_32(WasmMemory receiver, Node node, long address, int value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void store_i128(WasmMemory receiver, Node node, long address, Object value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int atomic_load_i32(WasmMemory receiver, Node node, long address) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long atomic_load_i64(WasmMemory receiver, Node node, long address) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int atomic_load_i32_8u(WasmMemory receiver, Node node, long address) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int atomic_load_i32_16u(WasmMemory receiver, Node node, long address) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long atomic_load_i64_8u(WasmMemory receiver, Node node, long address) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long atomic_load_i64_16u(WasmMemory receiver, Node node, long address) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long atomic_load_i64_32u(WasmMemory receiver, Node node, long address) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void atomic_store_i32(WasmMemory receiver, Node node, long address, int value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void atomic_store_i64(WasmMemory receiver, Node node, long address, long value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void atomic_store_i32_8(WasmMemory receiver, Node node, long address, byte value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void atomic_store_i32_16(WasmMemory receiver, Node node, long address, short value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void atomic_store_i64_8(WasmMemory receiver, Node node, long address, byte value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void atomic_store_i64_16(WasmMemory receiver, Node node, long address, short value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void atomic_store_i64_32(WasmMemory receiver, Node node, long address, int value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int atomic_rmw_add_i32_8u(WasmMemory receiver, Node node, long address, byte value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int atomic_rmw_add_i32_16u(WasmMemory receiver, Node node, long address, short value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int atomic_rmw_add_i32(WasmMemory receiver, Node node, long address, int value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long atomic_rmw_add_i64_8u(WasmMemory receiver, Node node, long address, byte value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long atomic_rmw_add_i64_16u(WasmMemory receiver, Node node, long address, short value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long atomic_rmw_add_i64_32u(WasmMemory receiver, Node node, long address, int value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long atomic_rmw_add_i64(WasmMemory receiver, Node node, long address, long value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int atomic_rmw_sub_i32_8u(WasmMemory receiver, Node node, long address, byte value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int atomic_rmw_sub_i32_16u(WasmMemory receiver, Node node, long address, short value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int atomic_rmw_sub_i32(WasmMemory receiver, Node node, long address, int value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long atomic_rmw_sub_i64_8u(WasmMemory receiver, Node node, long address, byte value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long atomic_rmw_sub_i64_16u(WasmMemory receiver, Node node, long address, short value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long atomic_rmw_sub_i64_32u(WasmMemory receiver, Node node, long address, int value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long atomic_rmw_sub_i64(WasmMemory receiver, Node node, long address, long value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int atomic_rmw_and_i32_8u(WasmMemory receiver, Node node, long address, byte value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int atomic_rmw_and_i32_16u(WasmMemory receiver, Node node, long address, short value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int atomic_rmw_and_i32(WasmMemory receiver, Node node, long address, int value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long atomic_rmw_and_i64_8u(WasmMemory receiver, Node node, long address, byte value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long atomic_rmw_and_i64_16u(WasmMemory receiver, Node node, long address, short value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long atomic_rmw_and_i64_32u(WasmMemory receiver, Node node, long address, int value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long atomic_rmw_and_i64(WasmMemory receiver, Node node, long address, long value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int atomic_rmw_or_i32_8u(WasmMemory receiver, Node node, long address, byte value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int atomic_rmw_or_i32_16u(WasmMemory receiver, Node node, long address, short value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int atomic_rmw_or_i32(WasmMemory receiver, Node node, long address, int value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long atomic_rmw_or_i64_8u(WasmMemory receiver, Node node, long address, byte value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long atomic_rmw_or_i64_16u(WasmMemory receiver, Node node, long address, short value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long atomic_rmw_or_i64_32u(WasmMemory receiver, Node node, long address, int value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long atomic_rmw_or_i64(WasmMemory receiver, Node node, long address, long value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int atomic_rmw_xor_i32_8u(WasmMemory receiver, Node node, long address, byte value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int atomic_rmw_xor_i32_16u(WasmMemory receiver, Node node, long address, short value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int atomic_rmw_xor_i32(WasmMemory receiver, Node node, long address, int value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long atomic_rmw_xor_i64_8u(WasmMemory receiver, Node node, long address, byte value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long atomic_rmw_xor_i64_16u(WasmMemory receiver, Node node, long address, short value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long atomic_rmw_xor_i64_32u(WasmMemory receiver, Node node, long address, int value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long atomic_rmw_xor_i64(WasmMemory receiver, Node node, long address, long value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int atomic_rmw_xchg_i32_8u(WasmMemory receiver, Node node, long address, byte value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int atomic_rmw_xchg_i32_16u(WasmMemory receiver, Node node, long address, short value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int atomic_rmw_xchg_i32(WasmMemory receiver, Node node, long address, int value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long atomic_rmw_xchg_i64_8u(WasmMemory receiver, Node node, long address, byte value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long atomic_rmw_xchg_i64_16u(WasmMemory receiver, Node node, long address, short value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long atomic_rmw_xchg_i64_32u(WasmMemory receiver, Node node, long address, int value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long atomic_rmw_xchg_i64(WasmMemory receiver, Node node, long address, long value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int atomic_rmw_cmpxchg_i32_8u(WasmMemory receiver, Node node, long address, byte expected, byte replacement) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int atomic_rmw_cmpxchg_i32_16u(WasmMemory receiver, Node node, long address, short expected, short replacement) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int atomic_rmw_cmpxchg_i32(WasmMemory receiver, Node node, long address, int expected, int replacement) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long atomic_rmw_cmpxchg_i64_8u(WasmMemory receiver, Node node, long address, byte expected, byte replacement) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long atomic_rmw_cmpxchg_i64_16u(WasmMemory receiver, Node node, long address, short expected, short replacement) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long atomic_rmw_cmpxchg_i64_32u(WasmMemory receiver, Node node, long address, int expected, int replacement) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long atomic_rmw_cmpxchg_i64(WasmMemory receiver, Node node, long address, long expected, long replacement) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int atomic_notify(WasmMemory receiver, Node node, long address, int count) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int atomic_wait32(WasmMemory receiver, Node node, long address, int expected, long timeout) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int atomic_wait64(WasmMemory receiver, Node node, long address, long expected, long timeout) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void close(WasmMemory receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void reset(WasmMemory receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public ByteBuffer asByteBuffer(WasmMemory receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return super.asByteBuffer(receiver);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public WasmMemory duplicate(WasmMemory receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean freed(WasmMemory receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }
        }

        @GeneratedBy(value=WasmMemoryLibrary.class)
        private static final class Cached
        extends WasmMemoryLibrary {
            private final Class<? extends WasmMemory> receiverClass_;

            protected Cached(Object receiver) {
                WasmMemory castReceiver = (WasmMemory)receiver;
                this.receiverClass_ = castReceiver.getClass();
            }

            public boolean accepts(Object receiver) {
                return CompilerDirectives.isExact((Object)receiver, this.receiverClass_);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long size(WasmMemory receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long byteSize(WasmMemory receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long grow(WasmMemory receiver, long extraPageSize) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void initialize(WasmMemory receiver, Node node, byte[] source, int sourceOffset, long destinationOffset, int length) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void fill(WasmMemory receiver, Node node, long offset, long length, byte value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void copyFrom(WasmMemory receiver, Node node, WasmMemory source, long sourceOffset, long destinationOffset, long length) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int copyFromStream(WasmMemory receiver, Node node, InputStream stream, int offset, int length) throws IOException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void copyToStream(WasmMemory receiver, Node node, OutputStream stream, int offset, int length) throws IOException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void copyToBuffer(WasmMemory receiver, Node node, byte[] dst, long srcOffset, int dstOffset, int length) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int load_i32(WasmMemory receiver, Node node, long address) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long load_i64(WasmMemory receiver, Node node, long address) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public float load_f32(WasmMemory receiver, Node node, long address) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public double load_f64(WasmMemory receiver, Node node, long address) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int load_i32_8s(WasmMemory receiver, Node node, long address) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int load_i32_8u(WasmMemory receiver, Node node, long address) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int load_i32_16s(WasmMemory receiver, Node node, long address) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int load_i32_16u(WasmMemory receiver, Node node, long address) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long load_i64_8s(WasmMemory receiver, Node node, long address) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long load_i64_8u(WasmMemory receiver, Node node, long address) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long load_i64_16s(WasmMemory receiver, Node node, long address) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long load_i64_16u(WasmMemory receiver, Node node, long address) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long load_i64_32s(WasmMemory receiver, Node node, long address) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long load_i64_32u(WasmMemory receiver, Node node, long address) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object load_i128(WasmMemory receiver, Node node, long address) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void store_i32(WasmMemory receiver, Node node, long address, int value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void store_i64(WasmMemory receiver, Node node, long address, long value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void store_f32(WasmMemory receiver, Node node, long address, float value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void store_f64(WasmMemory receiver, Node node, long address, double value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void store_i32_8(WasmMemory receiver, Node node, long address, byte value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void store_i32_16(WasmMemory receiver, Node node, long address, short value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void store_i64_8(WasmMemory receiver, Node node, long address, byte value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void store_i64_16(WasmMemory receiver, Node node, long address, short value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void store_i64_32(WasmMemory receiver, Node node, long address, int value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void store_i128(WasmMemory receiver, Node node, long address, Object value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int atomic_load_i32(WasmMemory receiver, Node node, long address) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long atomic_load_i64(WasmMemory receiver, Node node, long address) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int atomic_load_i32_8u(WasmMemory receiver, Node node, long address) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int atomic_load_i32_16u(WasmMemory receiver, Node node, long address) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long atomic_load_i64_8u(WasmMemory receiver, Node node, long address) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long atomic_load_i64_16u(WasmMemory receiver, Node node, long address) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long atomic_load_i64_32u(WasmMemory receiver, Node node, long address) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void atomic_store_i32(WasmMemory receiver, Node node, long address, int value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void atomic_store_i64(WasmMemory receiver, Node node, long address, long value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void atomic_store_i32_8(WasmMemory receiver, Node node, long address, byte value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void atomic_store_i32_16(WasmMemory receiver, Node node, long address, short value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void atomic_store_i64_8(WasmMemory receiver, Node node, long address, byte value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void atomic_store_i64_16(WasmMemory receiver, Node node, long address, short value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void atomic_store_i64_32(WasmMemory receiver, Node node, long address, int value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int atomic_rmw_add_i32_8u(WasmMemory receiver, Node node, long address, byte value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int atomic_rmw_add_i32_16u(WasmMemory receiver, Node node, long address, short value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int atomic_rmw_add_i32(WasmMemory receiver, Node node, long address, int value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long atomic_rmw_add_i64_8u(WasmMemory receiver, Node node, long address, byte value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long atomic_rmw_add_i64_16u(WasmMemory receiver, Node node, long address, short value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long atomic_rmw_add_i64_32u(WasmMemory receiver, Node node, long address, int value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long atomic_rmw_add_i64(WasmMemory receiver, Node node, long address, long value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int atomic_rmw_sub_i32_8u(WasmMemory receiver, Node node, long address, byte value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int atomic_rmw_sub_i32_16u(WasmMemory receiver, Node node, long address, short value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int atomic_rmw_sub_i32(WasmMemory receiver, Node node, long address, int value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long atomic_rmw_sub_i64_8u(WasmMemory receiver, Node node, long address, byte value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long atomic_rmw_sub_i64_16u(WasmMemory receiver, Node node, long address, short value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long atomic_rmw_sub_i64_32u(WasmMemory receiver, Node node, long address, int value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long atomic_rmw_sub_i64(WasmMemory receiver, Node node, long address, long value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int atomic_rmw_and_i32_8u(WasmMemory receiver, Node node, long address, byte value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int atomic_rmw_and_i32_16u(WasmMemory receiver, Node node, long address, short value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int atomic_rmw_and_i32(WasmMemory receiver, Node node, long address, int value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long atomic_rmw_and_i64_8u(WasmMemory receiver, Node node, long address, byte value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long atomic_rmw_and_i64_16u(WasmMemory receiver, Node node, long address, short value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long atomic_rmw_and_i64_32u(WasmMemory receiver, Node node, long address, int value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long atomic_rmw_and_i64(WasmMemory receiver, Node node, long address, long value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int atomic_rmw_or_i32_8u(WasmMemory receiver, Node node, long address, byte value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int atomic_rmw_or_i32_16u(WasmMemory receiver, Node node, long address, short value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int atomic_rmw_or_i32(WasmMemory receiver, Node node, long address, int value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long atomic_rmw_or_i64_8u(WasmMemory receiver, Node node, long address, byte value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long atomic_rmw_or_i64_16u(WasmMemory receiver, Node node, long address, short value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long atomic_rmw_or_i64_32u(WasmMemory receiver, Node node, long address, int value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long atomic_rmw_or_i64(WasmMemory receiver, Node node, long address, long value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int atomic_rmw_xor_i32_8u(WasmMemory receiver, Node node, long address, byte value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int atomic_rmw_xor_i32_16u(WasmMemory receiver, Node node, long address, short value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int atomic_rmw_xor_i32(WasmMemory receiver, Node node, long address, int value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long atomic_rmw_xor_i64_8u(WasmMemory receiver, Node node, long address, byte value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long atomic_rmw_xor_i64_16u(WasmMemory receiver, Node node, long address, short value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long atomic_rmw_xor_i64_32u(WasmMemory receiver, Node node, long address, int value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long atomic_rmw_xor_i64(WasmMemory receiver, Node node, long address, long value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int atomic_rmw_xchg_i32_8u(WasmMemory receiver, Node node, long address, byte value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int atomic_rmw_xchg_i32_16u(WasmMemory receiver, Node node, long address, short value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int atomic_rmw_xchg_i32(WasmMemory receiver, Node node, long address, int value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long atomic_rmw_xchg_i64_8u(WasmMemory receiver, Node node, long address, byte value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long atomic_rmw_xchg_i64_16u(WasmMemory receiver, Node node, long address, short value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long atomic_rmw_xchg_i64_32u(WasmMemory receiver, Node node, long address, int value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long atomic_rmw_xchg_i64(WasmMemory receiver, Node node, long address, long value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int atomic_rmw_cmpxchg_i32_8u(WasmMemory receiver, Node node, long address, byte expected, byte replacement) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int atomic_rmw_cmpxchg_i32_16u(WasmMemory receiver, Node node, long address, short expected, short replacement) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int atomic_rmw_cmpxchg_i32(WasmMemory receiver, Node node, long address, int expected, int replacement) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long atomic_rmw_cmpxchg_i64_8u(WasmMemory receiver, Node node, long address, byte expected, byte replacement) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long atomic_rmw_cmpxchg_i64_16u(WasmMemory receiver, Node node, long address, short expected, short replacement) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long atomic_rmw_cmpxchg_i64_32u(WasmMemory receiver, Node node, long address, int expected, int replacement) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long atomic_rmw_cmpxchg_i64(WasmMemory receiver, Node node, long address, long expected, long replacement) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int atomic_notify(WasmMemory receiver, Node node, long address, int count) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int atomic_wait32(WasmMemory receiver, Node node, long address, int expected, long timeout) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int atomic_wait64(WasmMemory receiver, Node node, long address, long expected, long timeout) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void close(WasmMemory receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void reset(WasmMemory receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            public ByteBuffer asByteBuffer(WasmMemory receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return super.asByteBuffer((WasmMemory)CompilerDirectives.castExact((Object)receiver, this.receiverClass_));
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public WasmMemory duplicate(WasmMemory receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean freed(WasmMemory receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }
        }
    }

    @GeneratedBy(value=WasmMemoryLibrary.class)
    private static final class CachedDispatchNext
    extends CachedDispatch {
        CachedDispatchNext(WasmMemoryLibrary library, CachedDispatch next) {
            super(library, next);
        }

        @Override
        int getLimit() {
            throw CompilerDirectives.shouldNotReachHere();
        }
    }

    @GeneratedBy(value=WasmMemoryLibrary.class)
    private static final class CachedToUncachedDispatch
    extends WasmMemoryLibrary {
        private CachedToUncachedDispatch() {
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public long size(WasmMemory receiver_) {
            assert (WasmMemoryLibraryGen.assertAdopted((Node)((Node)this)));
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).size(receiver_);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public long byteSize(WasmMemory receiver_) {
            assert (WasmMemoryLibraryGen.assertAdopted((Node)((Node)this)));
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).byteSize(receiver_);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public long grow(WasmMemory receiver_, long extraPageSize) {
            assert (WasmMemoryLibraryGen.assertAdopted((Node)((Node)this)));
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).grow(receiver_, extraPageSize);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void initialize(WasmMemory receiver_, Node node, byte[] source, int sourceOffset, long destinationOffset, int length) {
            assert (WasmMemoryLibraryGen.assertAdopted((Node)((Node)this)));
            ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).initialize(receiver_, node, source, sourceOffset, destinationOffset, length);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void fill(WasmMemory receiver_, Node node, long offset, long length, byte value) {
            assert (WasmMemoryLibraryGen.assertAdopted((Node)((Node)this)));
            ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).fill(receiver_, node, offset, length, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void copyFrom(WasmMemory receiver_, Node node, WasmMemory source, long sourceOffset, long destinationOffset, long length) {
            assert (WasmMemoryLibraryGen.assertAdopted((Node)((Node)this)));
            ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).copyFrom(receiver_, node, source, sourceOffset, destinationOffset, length);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public int copyFromStream(WasmMemory receiver_, Node node, InputStream stream, int offset, int length) throws IOException {
            assert (WasmMemoryLibraryGen.assertAdopted((Node)((Node)this)));
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).copyFromStream(receiver_, node, stream, offset, length);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void copyToStream(WasmMemory receiver_, Node node, OutputStream stream, int offset, int length) throws IOException {
            assert (WasmMemoryLibraryGen.assertAdopted((Node)((Node)this)));
            ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).copyToStream(receiver_, node, stream, offset, length);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void copyToBuffer(WasmMemory receiver_, Node node, byte[] dst, long srcOffset, int dstOffset, int length) {
            assert (WasmMemoryLibraryGen.assertAdopted((Node)((Node)this)));
            ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).copyToBuffer(receiver_, node, dst, srcOffset, dstOffset, length);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public int load_i32(WasmMemory receiver_, Node node, long address) {
            assert (WasmMemoryLibraryGen.assertAdopted((Node)((Node)this)));
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).load_i32(receiver_, node, address);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public long load_i64(WasmMemory receiver_, Node node, long address) {
            assert (WasmMemoryLibraryGen.assertAdopted((Node)((Node)this)));
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).load_i64(receiver_, node, address);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public float load_f32(WasmMemory receiver_, Node node, long address) {
            assert (WasmMemoryLibraryGen.assertAdopted((Node)((Node)this)));
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).load_f32(receiver_, node, address);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public double load_f64(WasmMemory receiver_, Node node, long address) {
            assert (WasmMemoryLibraryGen.assertAdopted((Node)((Node)this)));
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).load_f64(receiver_, node, address);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public int load_i32_8s(WasmMemory receiver_, Node node, long address) {
            assert (WasmMemoryLibraryGen.assertAdopted((Node)((Node)this)));
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).load_i32_8s(receiver_, node, address);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public int load_i32_8u(WasmMemory receiver_, Node node, long address) {
            assert (WasmMemoryLibraryGen.assertAdopted((Node)((Node)this)));
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).load_i32_8u(receiver_, node, address);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public int load_i32_16s(WasmMemory receiver_, Node node, long address) {
            assert (WasmMemoryLibraryGen.assertAdopted((Node)((Node)this)));
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).load_i32_16s(receiver_, node, address);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public int load_i32_16u(WasmMemory receiver_, Node node, long address) {
            assert (WasmMemoryLibraryGen.assertAdopted((Node)((Node)this)));
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).load_i32_16u(receiver_, node, address);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public long load_i64_8s(WasmMemory receiver_, Node node, long address) {
            assert (WasmMemoryLibraryGen.assertAdopted((Node)((Node)this)));
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).load_i64_8s(receiver_, node, address);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public long load_i64_8u(WasmMemory receiver_, Node node, long address) {
            assert (WasmMemoryLibraryGen.assertAdopted((Node)((Node)this)));
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).load_i64_8u(receiver_, node, address);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public long load_i64_16s(WasmMemory receiver_, Node node, long address) {
            assert (WasmMemoryLibraryGen.assertAdopted((Node)((Node)this)));
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).load_i64_16s(receiver_, node, address);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public long load_i64_16u(WasmMemory receiver_, Node node, long address) {
            assert (WasmMemoryLibraryGen.assertAdopted((Node)((Node)this)));
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).load_i64_16u(receiver_, node, address);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public long load_i64_32s(WasmMemory receiver_, Node node, long address) {
            assert (WasmMemoryLibraryGen.assertAdopted((Node)((Node)this)));
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).load_i64_32s(receiver_, node, address);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public long load_i64_32u(WasmMemory receiver_, Node node, long address) {
            assert (WasmMemoryLibraryGen.assertAdopted((Node)((Node)this)));
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).load_i64_32u(receiver_, node, address);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public Object load_i128(WasmMemory receiver_, Node node, long address) {
            assert (WasmMemoryLibraryGen.assertAdopted((Node)((Node)this)));
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).load_i128(receiver_, node, address);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void store_i32(WasmMemory receiver_, Node node, long address, int value) {
            assert (WasmMemoryLibraryGen.assertAdopted((Node)((Node)this)));
            ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).store_i32(receiver_, node, address, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void store_i64(WasmMemory receiver_, Node node, long address, long value) {
            assert (WasmMemoryLibraryGen.assertAdopted((Node)((Node)this)));
            ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).store_i64(receiver_, node, address, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void store_f32(WasmMemory receiver_, Node node, long address, float value) {
            assert (WasmMemoryLibraryGen.assertAdopted((Node)((Node)this)));
            ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).store_f32(receiver_, node, address, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void store_f64(WasmMemory receiver_, Node node, long address, double value) {
            assert (WasmMemoryLibraryGen.assertAdopted((Node)((Node)this)));
            ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).store_f64(receiver_, node, address, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void store_i32_8(WasmMemory receiver_, Node node, long address, byte value) {
            assert (WasmMemoryLibraryGen.assertAdopted((Node)((Node)this)));
            ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).store_i32_8(receiver_, node, address, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void store_i32_16(WasmMemory receiver_, Node node, long address, short value) {
            assert (WasmMemoryLibraryGen.assertAdopted((Node)((Node)this)));
            ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).store_i32_16(receiver_, node, address, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void store_i64_8(WasmMemory receiver_, Node node, long address, byte value) {
            assert (WasmMemoryLibraryGen.assertAdopted((Node)((Node)this)));
            ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).store_i64_8(receiver_, node, address, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void store_i64_16(WasmMemory receiver_, Node node, long address, short value) {
            assert (WasmMemoryLibraryGen.assertAdopted((Node)((Node)this)));
            ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).store_i64_16(receiver_, node, address, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void store_i64_32(WasmMemory receiver_, Node node, long address, int value) {
            assert (WasmMemoryLibraryGen.assertAdopted((Node)((Node)this)));
            ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).store_i64_32(receiver_, node, address, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void store_i128(WasmMemory receiver_, Node node, long address, Object value) {
            assert (WasmMemoryLibraryGen.assertAdopted((Node)((Node)this)));
            ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).store_i128(receiver_, node, address, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public int atomic_load_i32(WasmMemory receiver_, Node node, long address) {
            assert (WasmMemoryLibraryGen.assertAdopted((Node)((Node)this)));
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).atomic_load_i32(receiver_, node, address);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public long atomic_load_i64(WasmMemory receiver_, Node node, long address) {
            assert (WasmMemoryLibraryGen.assertAdopted((Node)((Node)this)));
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).atomic_load_i64(receiver_, node, address);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public int atomic_load_i32_8u(WasmMemory receiver_, Node node, long address) {
            assert (WasmMemoryLibraryGen.assertAdopted((Node)((Node)this)));
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).atomic_load_i32_8u(receiver_, node, address);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public int atomic_load_i32_16u(WasmMemory receiver_, Node node, long address) {
            assert (WasmMemoryLibraryGen.assertAdopted((Node)((Node)this)));
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).atomic_load_i32_16u(receiver_, node, address);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public long atomic_load_i64_8u(WasmMemory receiver_, Node node, long address) {
            assert (WasmMemoryLibraryGen.assertAdopted((Node)((Node)this)));
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).atomic_load_i64_8u(receiver_, node, address);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public long atomic_load_i64_16u(WasmMemory receiver_, Node node, long address) {
            assert (WasmMemoryLibraryGen.assertAdopted((Node)((Node)this)));
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).atomic_load_i64_16u(receiver_, node, address);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public long atomic_load_i64_32u(WasmMemory receiver_, Node node, long address) {
            assert (WasmMemoryLibraryGen.assertAdopted((Node)((Node)this)));
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).atomic_load_i64_32u(receiver_, node, address);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void atomic_store_i32(WasmMemory receiver_, Node node, long address, int value) {
            assert (WasmMemoryLibraryGen.assertAdopted((Node)((Node)this)));
            ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).atomic_store_i32(receiver_, node, address, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void atomic_store_i64(WasmMemory receiver_, Node node, long address, long value) {
            assert (WasmMemoryLibraryGen.assertAdopted((Node)((Node)this)));
            ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).atomic_store_i64(receiver_, node, address, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void atomic_store_i32_8(WasmMemory receiver_, Node node, long address, byte value) {
            assert (WasmMemoryLibraryGen.assertAdopted((Node)((Node)this)));
            ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).atomic_store_i32_8(receiver_, node, address, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void atomic_store_i32_16(WasmMemory receiver_, Node node, long address, short value) {
            assert (WasmMemoryLibraryGen.assertAdopted((Node)((Node)this)));
            ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).atomic_store_i32_16(receiver_, node, address, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void atomic_store_i64_8(WasmMemory receiver_, Node node, long address, byte value) {
            assert (WasmMemoryLibraryGen.assertAdopted((Node)((Node)this)));
            ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).atomic_store_i64_8(receiver_, node, address, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void atomic_store_i64_16(WasmMemory receiver_, Node node, long address, short value) {
            assert (WasmMemoryLibraryGen.assertAdopted((Node)((Node)this)));
            ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).atomic_store_i64_16(receiver_, node, address, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void atomic_store_i64_32(WasmMemory receiver_, Node node, long address, int value) {
            assert (WasmMemoryLibraryGen.assertAdopted((Node)((Node)this)));
            ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).atomic_store_i64_32(receiver_, node, address, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public int atomic_rmw_add_i32_8u(WasmMemory receiver_, Node node, long address, byte value) {
            assert (WasmMemoryLibraryGen.assertAdopted((Node)((Node)this)));
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).atomic_rmw_add_i32_8u(receiver_, node, address, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public int atomic_rmw_add_i32_16u(WasmMemory receiver_, Node node, long address, short value) {
            assert (WasmMemoryLibraryGen.assertAdopted((Node)((Node)this)));
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).atomic_rmw_add_i32_16u(receiver_, node, address, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public int atomic_rmw_add_i32(WasmMemory receiver_, Node node, long address, int value) {
            assert (WasmMemoryLibraryGen.assertAdopted((Node)((Node)this)));
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).atomic_rmw_add_i32(receiver_, node, address, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public long atomic_rmw_add_i64_8u(WasmMemory receiver_, Node node, long address, byte value) {
            assert (WasmMemoryLibraryGen.assertAdopted((Node)((Node)this)));
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).atomic_rmw_add_i64_8u(receiver_, node, address, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public long atomic_rmw_add_i64_16u(WasmMemory receiver_, Node node, long address, short value) {
            assert (WasmMemoryLibraryGen.assertAdopted((Node)((Node)this)));
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).atomic_rmw_add_i64_16u(receiver_, node, address, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public long atomic_rmw_add_i64_32u(WasmMemory receiver_, Node node, long address, int value) {
            assert (WasmMemoryLibraryGen.assertAdopted((Node)((Node)this)));
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).atomic_rmw_add_i64_32u(receiver_, node, address, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public long atomic_rmw_add_i64(WasmMemory receiver_, Node node, long address, long value) {
            assert (WasmMemoryLibraryGen.assertAdopted((Node)((Node)this)));
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).atomic_rmw_add_i64(receiver_, node, address, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public int atomic_rmw_sub_i32_8u(WasmMemory receiver_, Node node, long address, byte value) {
            assert (WasmMemoryLibraryGen.assertAdopted((Node)((Node)this)));
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).atomic_rmw_sub_i32_8u(receiver_, node, address, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public int atomic_rmw_sub_i32_16u(WasmMemory receiver_, Node node, long address, short value) {
            assert (WasmMemoryLibraryGen.assertAdopted((Node)((Node)this)));
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).atomic_rmw_sub_i32_16u(receiver_, node, address, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public int atomic_rmw_sub_i32(WasmMemory receiver_, Node node, long address, int value) {
            assert (WasmMemoryLibraryGen.assertAdopted((Node)((Node)this)));
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).atomic_rmw_sub_i32(receiver_, node, address, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public long atomic_rmw_sub_i64_8u(WasmMemory receiver_, Node node, long address, byte value) {
            assert (WasmMemoryLibraryGen.assertAdopted((Node)((Node)this)));
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).atomic_rmw_sub_i64_8u(receiver_, node, address, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public long atomic_rmw_sub_i64_16u(WasmMemory receiver_, Node node, long address, short value) {
            assert (WasmMemoryLibraryGen.assertAdopted((Node)((Node)this)));
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).atomic_rmw_sub_i64_16u(receiver_, node, address, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public long atomic_rmw_sub_i64_32u(WasmMemory receiver_, Node node, long address, int value) {
            assert (WasmMemoryLibraryGen.assertAdopted((Node)((Node)this)));
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).atomic_rmw_sub_i64_32u(receiver_, node, address, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public long atomic_rmw_sub_i64(WasmMemory receiver_, Node node, long address, long value) {
            assert (WasmMemoryLibraryGen.assertAdopted((Node)((Node)this)));
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).atomic_rmw_sub_i64(receiver_, node, address, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public int atomic_rmw_and_i32_8u(WasmMemory receiver_, Node node, long address, byte value) {
            assert (WasmMemoryLibraryGen.assertAdopted((Node)((Node)this)));
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).atomic_rmw_and_i32_8u(receiver_, node, address, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public int atomic_rmw_and_i32_16u(WasmMemory receiver_, Node node, long address, short value) {
            assert (WasmMemoryLibraryGen.assertAdopted((Node)((Node)this)));
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).atomic_rmw_and_i32_16u(receiver_, node, address, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public int atomic_rmw_and_i32(WasmMemory receiver_, Node node, long address, int value) {
            assert (WasmMemoryLibraryGen.assertAdopted((Node)((Node)this)));
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).atomic_rmw_and_i32(receiver_, node, address, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public long atomic_rmw_and_i64_8u(WasmMemory receiver_, Node node, long address, byte value) {
            assert (WasmMemoryLibraryGen.assertAdopted((Node)((Node)this)));
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).atomic_rmw_and_i64_8u(receiver_, node, address, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public long atomic_rmw_and_i64_16u(WasmMemory receiver_, Node node, long address, short value) {
            assert (WasmMemoryLibraryGen.assertAdopted((Node)((Node)this)));
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).atomic_rmw_and_i64_16u(receiver_, node, address, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public long atomic_rmw_and_i64_32u(WasmMemory receiver_, Node node, long address, int value) {
            assert (WasmMemoryLibraryGen.assertAdopted((Node)((Node)this)));
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).atomic_rmw_and_i64_32u(receiver_, node, address, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public long atomic_rmw_and_i64(WasmMemory receiver_, Node node, long address, long value) {
            assert (WasmMemoryLibraryGen.assertAdopted((Node)((Node)this)));
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).atomic_rmw_and_i64(receiver_, node, address, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public int atomic_rmw_or_i32_8u(WasmMemory receiver_, Node node, long address, byte value) {
            assert (WasmMemoryLibraryGen.assertAdopted((Node)((Node)this)));
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).atomic_rmw_or_i32_8u(receiver_, node, address, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public int atomic_rmw_or_i32_16u(WasmMemory receiver_, Node node, long address, short value) {
            assert (WasmMemoryLibraryGen.assertAdopted((Node)((Node)this)));
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).atomic_rmw_or_i32_16u(receiver_, node, address, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public int atomic_rmw_or_i32(WasmMemory receiver_, Node node, long address, int value) {
            assert (WasmMemoryLibraryGen.assertAdopted((Node)((Node)this)));
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).atomic_rmw_or_i32(receiver_, node, address, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public long atomic_rmw_or_i64_8u(WasmMemory receiver_, Node node, long address, byte value) {
            assert (WasmMemoryLibraryGen.assertAdopted((Node)((Node)this)));
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).atomic_rmw_or_i64_8u(receiver_, node, address, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public long atomic_rmw_or_i64_16u(WasmMemory receiver_, Node node, long address, short value) {
            assert (WasmMemoryLibraryGen.assertAdopted((Node)((Node)this)));
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).atomic_rmw_or_i64_16u(receiver_, node, address, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public long atomic_rmw_or_i64_32u(WasmMemory receiver_, Node node, long address, int value) {
            assert (WasmMemoryLibraryGen.assertAdopted((Node)((Node)this)));
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).atomic_rmw_or_i64_32u(receiver_, node, address, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public long atomic_rmw_or_i64(WasmMemory receiver_, Node node, long address, long value) {
            assert (WasmMemoryLibraryGen.assertAdopted((Node)((Node)this)));
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).atomic_rmw_or_i64(receiver_, node, address, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public int atomic_rmw_xor_i32_8u(WasmMemory receiver_, Node node, long address, byte value) {
            assert (WasmMemoryLibraryGen.assertAdopted((Node)((Node)this)));
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).atomic_rmw_xor_i32_8u(receiver_, node, address, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public int atomic_rmw_xor_i32_16u(WasmMemory receiver_, Node node, long address, short value) {
            assert (WasmMemoryLibraryGen.assertAdopted((Node)((Node)this)));
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).atomic_rmw_xor_i32_16u(receiver_, node, address, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public int atomic_rmw_xor_i32(WasmMemory receiver_, Node node, long address, int value) {
            assert (WasmMemoryLibraryGen.assertAdopted((Node)((Node)this)));
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).atomic_rmw_xor_i32(receiver_, node, address, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public long atomic_rmw_xor_i64_8u(WasmMemory receiver_, Node node, long address, byte value) {
            assert (WasmMemoryLibraryGen.assertAdopted((Node)((Node)this)));
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).atomic_rmw_xor_i64_8u(receiver_, node, address, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public long atomic_rmw_xor_i64_16u(WasmMemory receiver_, Node node, long address, short value) {
            assert (WasmMemoryLibraryGen.assertAdopted((Node)((Node)this)));
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).atomic_rmw_xor_i64_16u(receiver_, node, address, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public long atomic_rmw_xor_i64_32u(WasmMemory receiver_, Node node, long address, int value) {
            assert (WasmMemoryLibraryGen.assertAdopted((Node)((Node)this)));
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).atomic_rmw_xor_i64_32u(receiver_, node, address, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public long atomic_rmw_xor_i64(WasmMemory receiver_, Node node, long address, long value) {
            assert (WasmMemoryLibraryGen.assertAdopted((Node)((Node)this)));
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).atomic_rmw_xor_i64(receiver_, node, address, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public int atomic_rmw_xchg_i32_8u(WasmMemory receiver_, Node node, long address, byte value) {
            assert (WasmMemoryLibraryGen.assertAdopted((Node)((Node)this)));
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).atomic_rmw_xchg_i32_8u(receiver_, node, address, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public int atomic_rmw_xchg_i32_16u(WasmMemory receiver_, Node node, long address, short value) {
            assert (WasmMemoryLibraryGen.assertAdopted((Node)((Node)this)));
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).atomic_rmw_xchg_i32_16u(receiver_, node, address, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public int atomic_rmw_xchg_i32(WasmMemory receiver_, Node node, long address, int value) {
            assert (WasmMemoryLibraryGen.assertAdopted((Node)((Node)this)));
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).atomic_rmw_xchg_i32(receiver_, node, address, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public long atomic_rmw_xchg_i64_8u(WasmMemory receiver_, Node node, long address, byte value) {
            assert (WasmMemoryLibraryGen.assertAdopted((Node)((Node)this)));
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).atomic_rmw_xchg_i64_8u(receiver_, node, address, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public long atomic_rmw_xchg_i64_16u(WasmMemory receiver_, Node node, long address, short value) {
            assert (WasmMemoryLibraryGen.assertAdopted((Node)((Node)this)));
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).atomic_rmw_xchg_i64_16u(receiver_, node, address, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public long atomic_rmw_xchg_i64_32u(WasmMemory receiver_, Node node, long address, int value) {
            assert (WasmMemoryLibraryGen.assertAdopted((Node)((Node)this)));
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).atomic_rmw_xchg_i64_32u(receiver_, node, address, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public long atomic_rmw_xchg_i64(WasmMemory receiver_, Node node, long address, long value) {
            assert (WasmMemoryLibraryGen.assertAdopted((Node)((Node)this)));
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).atomic_rmw_xchg_i64(receiver_, node, address, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public int atomic_rmw_cmpxchg_i32_8u(WasmMemory receiver_, Node node, long address, byte expected, byte replacement) {
            assert (WasmMemoryLibraryGen.assertAdopted((Node)((Node)this)));
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).atomic_rmw_cmpxchg_i32_8u(receiver_, node, address, expected, replacement);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public int atomic_rmw_cmpxchg_i32_16u(WasmMemory receiver_, Node node, long address, short expected, short replacement) {
            assert (WasmMemoryLibraryGen.assertAdopted((Node)((Node)this)));
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).atomic_rmw_cmpxchg_i32_16u(receiver_, node, address, expected, replacement);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public int atomic_rmw_cmpxchg_i32(WasmMemory receiver_, Node node, long address, int expected, int replacement) {
            assert (WasmMemoryLibraryGen.assertAdopted((Node)((Node)this)));
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).atomic_rmw_cmpxchg_i32(receiver_, node, address, expected, replacement);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public long atomic_rmw_cmpxchg_i64_8u(WasmMemory receiver_, Node node, long address, byte expected, byte replacement) {
            assert (WasmMemoryLibraryGen.assertAdopted((Node)((Node)this)));
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).atomic_rmw_cmpxchg_i64_8u(receiver_, node, address, expected, replacement);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public long atomic_rmw_cmpxchg_i64_16u(WasmMemory receiver_, Node node, long address, short expected, short replacement) {
            assert (WasmMemoryLibraryGen.assertAdopted((Node)((Node)this)));
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).atomic_rmw_cmpxchg_i64_16u(receiver_, node, address, expected, replacement);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public long atomic_rmw_cmpxchg_i64_32u(WasmMemory receiver_, Node node, long address, int expected, int replacement) {
            assert (WasmMemoryLibraryGen.assertAdopted((Node)((Node)this)));
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).atomic_rmw_cmpxchg_i64_32u(receiver_, node, address, expected, replacement);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public long atomic_rmw_cmpxchg_i64(WasmMemory receiver_, Node node, long address, long expected, long replacement) {
            assert (WasmMemoryLibraryGen.assertAdopted((Node)((Node)this)));
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).atomic_rmw_cmpxchg_i64(receiver_, node, address, expected, replacement);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public int atomic_notify(WasmMemory receiver_, Node node, long address, int count) {
            assert (WasmMemoryLibraryGen.assertAdopted((Node)((Node)this)));
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).atomic_notify(receiver_, node, address, count);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public int atomic_wait32(WasmMemory receiver_, Node node, long address, int expected, long timeout) {
            assert (WasmMemoryLibraryGen.assertAdopted((Node)((Node)this)));
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).atomic_wait32(receiver_, node, address, expected, timeout);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public int atomic_wait64(WasmMemory receiver_, Node node, long address, long expected, long timeout) {
            assert (WasmMemoryLibraryGen.assertAdopted((Node)((Node)this)));
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).atomic_wait64(receiver_, node, address, expected, timeout);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void close(WasmMemory receiver_) {
            assert (WasmMemoryLibraryGen.assertAdopted((Node)((Node)this)));
            ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).close(receiver_);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void reset(WasmMemory receiver_) {
            assert (WasmMemoryLibraryGen.assertAdopted((Node)((Node)this)));
            ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).reset(receiver_);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public ByteBuffer asByteBuffer(WasmMemory receiver_) {
            assert (WasmMemoryLibraryGen.assertAdopted((Node)((Node)this)));
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).asByteBuffer(receiver_);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public WasmMemory duplicate(WasmMemory receiver_) {
            assert (WasmMemoryLibraryGen.assertAdopted((Node)((Node)this)));
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).duplicate(receiver_);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public boolean freed(WasmMemory receiver_) {
            assert (WasmMemoryLibraryGen.assertAdopted((Node)((Node)this)));
            return ((WasmMemoryLibrary)INSTANCE.getUncached(receiver_)).freed(receiver_);
        }

        public boolean accepts(Object receiver_) {
            return true;
        }
    }
}

