/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.globals;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnadoptableNode;
import java.lang.invoke.VarHandle;
import java.util.Objects;
import org.graalvm.wasm.globals.WasmGlobal;

@GeneratedBy(value=WasmGlobal.class)
final class WasmGlobalGen {
    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    private WasmGlobalGen() {
    }

    static {
        LibraryExport.register(WasmGlobal.class, (LibraryExport[])new LibraryExport[]{new InteropLibraryExports()});
    }

    @GeneratedBy(value=WasmGlobal.class)
    private static final class InteropLibraryExports
    extends LibraryExport<InteropLibrary> {
        private InteropLibraryExports() {
            super(InteropLibrary.class, WasmGlobal.class, false, false, 0);
        }

        protected InteropLibrary createUncached(Object receiver) {
            assert (receiver instanceof WasmGlobal);
            Uncached uncached = new Uncached();
            return uncached;
        }

        protected InteropLibrary createCached(Object receiver) {
            assert (receiver instanceof WasmGlobal);
            return new Cached();
        }

        @GeneratedBy(value=WasmGlobal.class)
        @DenyReplace
        private static final class Uncached
        extends InteropLibrary
        implements UnadoptableNode {
            protected Uncached() {
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof WasmGlobal) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof WasmGlobal;
            }

            @CompilerDirectives.TruffleBoundary
            public boolean hasMembers(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((WasmGlobal)receiver).hasMembers();
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isMemberReadable(Object receiver, String member) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((WasmGlobal)receiver).isMemberReadable(member);
            }

            @CompilerDirectives.TruffleBoundary
            public Object readMember(Object receiver, String member) throws UnsupportedMessageException, UnknownIdentifierException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((WasmGlobal)receiver).readMember(member);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isMemberModifiable(Object receiver, String member) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((WasmGlobal)receiver).isMemberModifiable(member);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isMemberInsertable(Object receiver, String member) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((WasmGlobal)receiver).isMemberInsertable(member);
            }

            @CompilerDirectives.TruffleBoundary
            public void writeMember(Object arg0Value_, String arg1Value, Object arg2Value) throws UnknownIdentifierException, UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                WasmGlobal arg0Value = (WasmGlobal)arg0Value_;
                arg0Value.writeMember(arg1Value, arg2Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public Object getMembers(Object receiver, boolean includeInternal) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((WasmGlobal)receiver).getMembers(includeInternal);
            }
        }

        @GeneratedBy(value=WasmGlobal.class)
        private static final class Cached
        extends InteropLibrary {
            @CompilerDirectives.CompilationFinal
            private int state_0_;
            @Node.Child
            private InteropLibrary valueLibrary_;

            protected Cached() {
            }

            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof WasmGlobal) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof WasmGlobal;
            }

            public boolean hasMembers(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((WasmGlobal)receiver).hasMembers();
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isMemberReadable(Object receiver, String member) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((WasmGlobal)receiver).isMemberReadable(member);
            }

            @CompilerDirectives.TruffleBoundary
            public Object readMember(Object receiver, String member) throws UnsupportedMessageException, UnknownIdentifierException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((WasmGlobal)receiver).readMember(member);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isMemberModifiable(Object receiver, String member) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((WasmGlobal)receiver).isMemberModifiable(member);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isMemberInsertable(Object receiver, String member) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((WasmGlobal)receiver).isMemberInsertable(member);
            }

            public void writeMember(Object arg0Value_, String arg1Value, Object arg2Value) throws UnsupportedMessageException, UnknownIdentifierException, UnsupportedTypeException {
                InteropLibrary valueLibrary__;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                WasmGlobal arg0Value = (WasmGlobal)arg0Value_;
                int state_0 = this.state_0_;
                if (state_0 != 0 && (valueLibrary__ = this.valueLibrary_) != null) {
                    arg0Value.writeMember(arg1Value, arg2Value, valueLibrary__);
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.executeAndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            private void executeAndSpecialize(WasmGlobal arg0Value, String arg1Value, Object arg2Value) throws UnknownIdentifierException, UnsupportedMessageException {
                int state_0 = this.state_0_;
                InteropLibrary valueLibrary__ = (InteropLibrary)this.insert((Node)((InteropLibrary)INTEROP_LIBRARY_.createDispatched(5)));
                Objects.requireNonNull(valueLibrary__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                VarHandle.storeStoreFence();
                this.valueLibrary_ = valueLibrary__;
                this.state_0_ = state_0 |= 1;
                arg0Value.writeMember(arg1Value, arg2Value, valueLibrary__);
            }

            @CompilerDirectives.TruffleBoundary
            public Object getMembers(Object receiver, boolean includeInternal) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((WasmGlobal)receiver).getMembers(includeInternal);
            }
        }
    }
}

