/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.debugging.representation;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.source.SourceSection;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.graalvm.collections.EconomicMap;
import org.graalvm.wasm.WasmLanguage;
import org.graalvm.wasm.debugging.DebugLocation;
import org.graalvm.wasm.debugging.data.DebugContext;
import org.graalvm.wasm.debugging.data.DebugFunction;
import org.graalvm.wasm.debugging.data.DebugObject;
import org.graalvm.wasm.debugging.representation.DebugConstantDisplayValue;
import org.graalvm.wasm.debugging.representation.DebugDisplayValue;
import org.graalvm.wasm.debugging.representation.WasmVariableNamesObject;
import org.graalvm.wasm.nodes.WasmDataAccess;

@ExportLibrary(value=InteropLibrary.class)
public final class DebugScopeDisplayValue
extends DebugDisplayValue
implements TruffleObject {
    private final String name;
    private final DebugContext context;
    private final DebugLocation location;
    private final EconomicMap<String, DebugObject> members;
    private final DebugScopeDisplayValue parentScope;
    private final SourceSection sourceSection;

    public DebugScopeDisplayValue(String name, DebugContext context, DebugLocation location, EconomicMap<String, DebugObject> members, DebugScopeDisplayValue parentScope, SourceSection sourceSection) {
        this.name = Objects.requireNonNull(name);
        this.context = context;
        this.location = location;
        this.members = members;
        this.parentScope = parentScope;
        this.sourceSection = sourceSection;
    }

    private static DebugScopeDisplayValue createScope(String name, DebugContext context, DebugLocation location, DebugObject object, DebugScopeDisplayValue parentScope, SourceSection sourceSection) {
        EconomicMap members = EconomicMap.create();
        int count = object.memberCount();
        for (int i = 0; i < count; ++i) {
            DebugObject member = object.readMember(context, location, i);
            if (!member.isVisible(context.sourceCodeLocation())) continue;
            members.put((Object)member.toDisplayString(), (Object)member);
        }
        return new DebugScopeDisplayValue(name, context, location, (EconomicMap<String, DebugObject>)members, parentScope, sourceSection);
    }

    @CompilerDirectives.TruffleBoundary
    public static Object fromDebugFunction(DebugFunction function, DebugContext context, MaterializedFrame frame, WasmDataAccess dataAccess, SourceSection sourceSection) {
        DebugLocation frameBase = function.frameBaseOrNull(frame, dataAccess);
        if (frameBase == null) {
            return DebugConstantDisplayValue.UNDEFINED;
        }
        DebugScopeDisplayValue scope = null;
        if (function.hasGlobals()) {
            scope = DebugScopeDisplayValue.createScope("Globals", context, frameBase, function.globals(), scope, null);
        }
        return DebugScopeDisplayValue.createScope("Locals", context, frameBase, function.locals(), scope, sourceSection);
    }

    @ExportMessage
    boolean isScope() {
        return true;
    }

    @ExportMessage
    boolean hasScopeParent() {
        return this.parentScope != null;
    }

    @ExportMessage
    Object getScopeParent() throws UnsupportedMessageException {
        if (this.parentScope == null) {
            throw UnsupportedMessageException.create();
        }
        return this.parentScope;
    }

    @ExportMessage
    boolean hasSourceLocation() {
        return this.sourceSection != null;
    }

    @ExportMessage
    SourceSection getSourceLocation() {
        return this.sourceSection;
    }

    @ExportMessage
    boolean hasLanguage() {
        return true;
    }

    @ExportMessage
    Class<? extends TruffleLanguage<?>> getLanguage() {
        return WasmLanguage.class;
    }

    @ExportMessage
    Object toDisplayString(boolean allowSideEffects) {
        return this.name;
    }

    @ExportMessage
    boolean hasMembers() {
        return true;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    Object readMember(String member) throws UnknownIdentifierException {
        if (!this.isMemberReadable(member)) {
            throw UnknownIdentifierException.create((String)member);
        }
        DebugObject memberObject = (DebugObject)this.members.get((Object)member);
        return this.resolveDebugObject(memberObject, this.context, this.location);
    }

    private List<String> memberNames() {
        ArrayList<String> names = new ArrayList<String>(0);
        for (String member : this.members.getKeys()) {
            names.add(member);
        }
        return names;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    Object getMembers(boolean includeInternal) {
        List<String> names = this.memberNames();
        if (this.parentScope != null) {
            names.addAll(this.parentScope.memberNames());
        }
        return new WasmVariableNamesObject(names);
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    boolean isMemberReadable(String member) {
        return this.members.containsKey((Object)member);
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    boolean isMemberModifiable(String member) {
        return this.members.containsKey((Object)member);
    }

    @ExportMessage(limit="5")
    @CompilerDirectives.TruffleBoundary
    void writeMember(String member, Object value, @CachedLibrary(value="value") InteropLibrary lib) throws UnknownIdentifierException {
        if (!this.isMemberModifiable(member)) {
            throw UnknownIdentifierException.create((String)member);
        }
        DebugObject memberObject = (DebugObject)this.members.get((Object)member);
        if (memberObject.isModifiableValue()) {
            memberObject.setValue(this.context, this.location, value, lib);
        }
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    boolean isMemberInsertable(String member) {
        return false;
    }
}

