/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.debugging.parser;

import com.oracle.truffle.api.CompilerDirectives;
import java.nio.file.Path;
import org.graalvm.collections.EconomicMap;
import org.graalvm.wasm.debugging.DebugLineMap;
import org.graalvm.wasm.debugging.data.DebugDataUtil;
import org.graalvm.wasm.debugging.data.DebugFunction;
import org.graalvm.wasm.debugging.data.DebugObjectFactory;
import org.graalvm.wasm.debugging.languages.DebugLanguageSupport;
import org.graalvm.wasm.debugging.parser.DebugData;
import org.graalvm.wasm.debugging.parser.DebugParseUnit;
import org.graalvm.wasm.debugging.parser.DebugParser;
import org.graalvm.wasm.debugging.parser.DebugParserContext;
import org.graalvm.wasm.debugging.parser.DebugParserScope;
import org.graalvm.wasm.debugging.parser.DebugUtil;

public class DebugTranslator {
    private final DebugParser parser;

    public DebugTranslator(byte[] data) {
        this.parser = new DebugParser(data);
    }

    @CompilerDirectives.TruffleBoundary
    public EconomicMap<Integer, DebugFunction> readCompilationUnits(byte[] customData, int debugInfoOffset) {
        assert (customData != null) : "the array containing the debug information must not be null when trying to parse the information";
        assert (debugInfoOffset != -1) : "the offset of the debug information must be valid";
        EconomicMap debugFunctions = EconomicMap.create();
        int unitOffset = 0;
        DebugParseUnit unit = this.parser.readCompilationUnit(debugInfoOffset, unitOffset);
        while (unit != null) {
            DebugData compilationUnit;
            DebugParserContext context = this.parseCompilationUnit(unit, customData, debugInfoOffset);
            if (context != null && (compilationUnit = this.parser.readCompilationUnitChildren(unit, debugInfoOffset)) != null && DebugTranslator.parseFunctions(context, compilationUnit)) {
                debugFunctions.putAll(context.functions());
            }
            if ((unitOffset = this.parser.getNextCompilationUnitOffset(debugInfoOffset, unitOffset)) == -1) continue;
            unit = this.parser.readCompilationUnit(debugInfoOffset, unitOffset);
        }
        return debugFunctions;
    }

    private DebugParserContext parseCompilationUnit(DebugParseUnit parseUnit, byte[] customData, int debugInfoOffset) {
        DebugData data = parseUnit.rootData();
        EconomicMap<Integer, DebugData> entries = parseUnit.entries();
        int languageId = data.asI32OrDefault(19, -1);
        DebugObjectFactory objectFactory = DebugLanguageSupport.getObjectFactory(languageId);
        if (objectFactory == null) {
            return null;
        }
        String languageName = objectFactory.languageName();
        int stmtList = data.asI32OrDefault(16, -1);
        if (stmtList == -1) {
            return null;
        }
        String compDir = data.asStringOrNull(27);
        if (compDir == null) {
            return null;
        }
        int lineOffset = DebugUtil.getLineOffsetOrUndefined(customData, debugInfoOffset);
        int lineLength = DebugUtil.getLineLengthOrUndefined(customData, debugInfoOffset);
        if (lineOffset == -1 || lineLength == -1) {
            return null;
        }
        DebugLineMap[] fileLineMaps = this.parser.readLineSectionOrNull(lineOffset + stmtList, lineLength, compDir);
        if (fileLineMaps == null) {
            return null;
        }
        int nullSources = 0;
        Path[] filePaths = new Path[fileLineMaps.length];
        for (int i = 0; i < filePaths.length; ++i) {
            DebugLineMap lineMap = fileLineMaps[i];
            if (lineMap != null) {
                filePaths[i] = lineMap.getFilePath();
            }
            if (filePaths[i] != null) continue;
            ++nullSources;
        }
        if (nullSources == filePaths.length) {
            return null;
        }
        return new DebugParserContext(customData, debugInfoOffset, entries, fileLineMaps, filePaths, languageName, objectFactory);
    }

    private static boolean parseFunctions(DebugParserContext context, DebugData data) {
        int[] pcs = DebugDataUtil.readPcsOrNull(data, context);
        if (pcs == null) {
            return false;
        }
        assert (pcs.length == 2) : "the pc range of a debug compilation unit must contain exactly two values (start pc and end pc)";
        int scopeStart = pcs[0];
        int scopeEnd = pcs[1];
        DebugParserScope scope = context.globalScope().with(null, scopeStart, scopeEnd);
        for (DebugData child : data.children()) {
            context.objectFactory().parse(context, scope, child);
        }
        return true;
    }
}

