/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.debugging.parser;

import java.util.ArrayList;
import java.util.List;
import org.graalvm.wasm.debugging.data.DebugObject;

public final class DebugParserScope {
    private final int fileIndex;
    private final String name;
    private final int startLocation;
    private final int endLocation;
    private final List<DebugObject> variables;

    private DebugParserScope(String name, int startLocation, int endLocation, int fileIndex, List<DebugObject> variables) {
        assert (variables != null) : "the list of variables in a debug parser scope must not be null";
        this.name = name;
        this.fileIndex = fileIndex;
        this.startLocation = startLocation;
        this.endLocation = endLocation;
        this.variables = variables;
    }

    public static DebugParserScope createFunctionScope(int startLocation, int endLocation, int fileIndex) {
        return new DebugParserScope(null, startLocation, endLocation, fileIndex, new ArrayList<DebugObject>());
    }

    public static DebugParserScope createGlobalScope() {
        return new DebugParserScope(null, -1, -1, -1, new ArrayList<DebugObject>());
    }

    public DebugParserScope with(String newName) {
        return new DebugParserScope(newName, this.startLocation, this.endLocation, this.fileIndex, this.variables);
    }

    public DebugParserScope with(String newName, int newStartLocation, int newEndLocation) {
        return new DebugParserScope(newName, newStartLocation, newEndLocation, this.fileIndex, this.variables);
    }

    public String nameOrNull() {
        return this.name;
    }

    public int startLocation() {
        return this.startLocation;
    }

    public int endLocation() {
        return this.endLocation;
    }

    public int fileIndex() {
        return this.fileIndex;
    }

    public void addVariable(DebugObject variable) {
        this.variables.add(variable);
    }

    public List<DebugObject> variables() {
        return this.variables;
    }
}

