/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.debugging.parser;

import org.graalvm.wasm.debugging.encoding.DataEncoding;

public class DebugData {
    private final int tag;
    private final int offset;
    private final long[] attributeInfo;
    private final Object[] attributes;
    private final DebugData[] children;

    public DebugData(int tag, int offset, long[] attributeInfo, Object[] attributes, DebugData[] children) {
        assert (attributes != null) : "The attribute values of a debug data entry must not be null";
        assert (children != null) : "The children of a debug data entry must not be null";
        this.tag = tag;
        this.offset = offset;
        this.attributeInfo = attributeInfo;
        this.attributes = attributes;
        this.children = children;
    }

    public int tag() {
        return this.tag;
    }

    public int offset() {
        return this.offset;
    }

    public DebugData[] children() {
        return this.children;
    }

    private static int attributeValue(long a) {
        return (int)a;
    }

    private static int attributeEncoding(long a) {
        return (int)(a >> 32);
    }

    private int attributeIndex(int attribute) {
        for (int i = 0; i < this.attributeInfo.length; ++i) {
            if (DebugData.attributeValue(this.attributeInfo[i]) != attribute) continue;
            return i;
        }
        return -1;
    }

    public int asI32OrDefault(int attribute, int defaultValue) {
        int value;
        int index = this.attributeIndex(attribute);
        if (index == -1) {
            return defaultValue;
        }
        int encoding = DebugData.attributeEncoding(this.attributeInfo[index]);
        if (DataEncoding.isByte(encoding)) {
            value = ((Byte)this.attributes[index]).byteValue();
        } else if (DataEncoding.isShort(encoding)) {
            value = ((Short)this.attributes[index]).shortValue();
        } else if (DataEncoding.isInt(encoding)) {
            value = (Integer)this.attributes[index];
        } else {
            return defaultValue;
        }
        return value;
    }

    public int asI32OrDefault(int attribute) {
        return this.asI32OrDefault(attribute, -1);
    }

    public int asU32OrDefault(int attribute, int defaultValue) {
        int value;
        int index = this.attributeIndex(attribute);
        if (index == -1) {
            return defaultValue;
        }
        int encoding = DebugData.attributeEncoding(this.attributeInfo[index]);
        if (DataEncoding.isByte(encoding)) {
            value = Byte.toUnsignedInt((Byte)this.attributes[index]);
        } else if (DataEncoding.isShort(encoding)) {
            value = Short.toUnsignedInt((Short)this.attributes[index]);
        } else if (DataEncoding.isInt(encoding)) {
            value = (Integer)this.attributes[index];
        } else {
            return defaultValue;
        }
        return value;
    }

    public int asU32OrDefault(int attribute) {
        return this.asU32OrDefault(attribute, -1);
    }

    public long asI64OrDefault(int attribute, long defaultValue) {
        long value;
        int index = this.attributeIndex(attribute);
        if (index == -1) {
            return defaultValue;
        }
        int encoding = DebugData.attributeEncoding(this.attributeInfo[index]);
        if (DataEncoding.isByte(encoding)) {
            value = ((Byte)this.attributes[index]).byteValue();
        } else if (DataEncoding.isShort(encoding)) {
            value = ((Short)this.attributes[index]).shortValue();
        } else if (DataEncoding.isInt(encoding)) {
            value = ((Integer)this.attributes[index]).intValue();
        } else if (DataEncoding.isLong(encoding)) {
            value = (Long)this.attributes[index];
        } else {
            return defaultValue;
        }
        return value;
    }

    public long asI64OrDefault(int attribute) {
        return this.asI64OrDefault(attribute, -1L);
    }

    public String asStringOrNull(int attribute) {
        int index = this.attributeIndex(attribute);
        if (index == -1) {
            return null;
        }
        int encoding = DebugData.attributeEncoding(this.attributeInfo[index]);
        if (DataEncoding.isString(encoding)) {
            return (String)this.attributes[index];
        }
        return null;
    }

    public String asStringOrEmpty(int attribute) {
        int index = this.attributeIndex(attribute);
        if (index == -1) {
            return "";
        }
        int encoding = DebugData.attributeEncoding(this.attributeInfo[index]);
        if (DataEncoding.isString(encoding)) {
            return (String)this.attributes[index];
        }
        return "";
    }

    public byte[] asByteArrayOrNull(int attribute) {
        int index = this.attributeIndex(attribute);
        if (index == -1) {
            return null;
        }
        int encoding = DebugData.attributeEncoding(this.attributeInfo[index]);
        if (DataEncoding.isByteArray(encoding)) {
            return (byte[])this.attributes[index];
        }
        return null;
    }

    public boolean isConstant(int attribute) {
        int index = this.attributeIndex(attribute);
        if (index == -1) {
            return false;
        }
        return DataEncoding.isConstant(DebugData.attributeEncoding(this.attributeInfo[index]));
    }

    public boolean exists(int attribute) {
        int index = this.attributeIndex(attribute);
        if (index == -1) {
            return false;
        }
        int encoding = DebugData.attributeEncoding(this.attributeInfo[index]);
        if (DataEncoding.isBoolean(encoding)) {
            return (Boolean)this.attributes[index];
        }
        return false;
    }

    public boolean hasAttribute(int attribute) {
        return this.attributeIndex(attribute) != -1;
    }
}

