/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.debugging.languages.cpp;

import org.graalvm.wasm.debugging.DebugLocation;
import org.graalvm.wasm.debugging.data.DebugContext;
import org.graalvm.wasm.debugging.data.DebugType;
import org.graalvm.wasm.debugging.languages.c.CConstants;

public class CppString
extends DebugType {
    private static final int STRING_REP_LENGTH = 12;
    private static final int LONG_INDICATOR_VALUE = 128;
    private static final int LENGTH_OFFSET = 11;
    private static final int LONG_LENGTH_OFFSET = 4;

    @Override
    public String asTypeName() {
        return "string";
    }

    @Override
    public int valueLength() {
        return 12;
    }

    @Override
    public boolean isValue() {
        return true;
    }

    @Override
    public Object asValue(DebugContext context, DebugLocation location) {
        DebugLocation stringLocation;
        DebugLocation lengthLocation = location.addOffset(11L);
        int length = lengthLocation.loadU8();
        if (length == 128) {
            stringLocation = location.loadAsLocation();
            if (stringLocation.isZero()) {
                return CConstants.NULL;
            }
            long longLength = location.addOffset(4L).loadU32();
            length = (int)longLength;
        } else {
            stringLocation = location;
        }
        return stringLocation.loadString(length);
    }
}

