/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.debugging.data.types;

import org.graalvm.collections.EconomicMap;
import org.graalvm.wasm.debugging.DebugLocation;
import org.graalvm.wasm.debugging.data.DebugContext;
import org.graalvm.wasm.debugging.data.DebugObject;
import org.graalvm.wasm.debugging.data.DebugType;
import org.graalvm.wasm.debugging.data.objects.DebugConstantObject;
import org.graalvm.wasm.debugging.data.objects.DebugLink;

public class DebugVariantType
extends DebugType {
    private final String name;
    private final DebugObject discriminant;
    private final EconomicMap<Long, DebugObject> values;

    public DebugVariantType(String name, DebugObject discriminant, EconomicMap<Long, DebugObject> values) {
        assert (discriminant != null) : "the discriminant of a debug variant type must not be null";
        assert (values != null) : "the possible values of a debug variant type must not be null";
        this.name = name;
        this.discriminant = discriminant;
        this.values = values;
    }

    @Override
    public String asTypeName() {
        return this.name;
    }

    @Override
    public int valueLength() {
        return this.discriminant.valueLength();
    }

    @Override
    public boolean isDebugObject() {
        return true;
    }

    @Override
    public DebugObject asDebugObject(DebugContext context, DebugLocation location) {
        if (!this.discriminant.fitsIntoLong()) {
            return DebugConstantObject.UNSUPPORTED;
        }
        DebugLocation discLocation = this.discriminant.getLocation(location);
        long valueIndex = this.discriminant.asLong(context, discLocation);
        if (!this.values.containsKey((Object)valueIndex)) {
            return DebugConstantObject.UNSUPPORTED;
        }
        DebugObject value = (DebugObject)this.values.get((Object)valueIndex);
        return new DebugLink(this.name + "::" + value.asTypeName(), value);
    }
}

