/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.debugging.data.objects;

import org.graalvm.wasm.debugging.DebugLocation;
import org.graalvm.wasm.debugging.data.DebugContext;
import org.graalvm.wasm.debugging.data.DebugObject;
import org.graalvm.wasm.debugging.representation.DebugConstantDisplayValue;

public class DebugConstantObject
extends DebugObject {
    public static final DebugConstantObject UNDEFINED = new DebugConstantObject("undefined", DebugConstantDisplayValue.UNDEFINED);
    public static final DebugConstantObject UNSUPPORTED = new DebugConstantObject("unsupported", DebugConstantDisplayValue.UNSUPPORTED);
    public static final DebugConstantObject UNSPECIFIED = new DebugConstantObject("unspecified", DebugConstantDisplayValue.UNSPECIFIED);
    private final String name;
    private final Object constant;

    public DebugConstantObject(String name, Object constant) {
        this.name = name;
        this.constant = constant;
    }

    @Override
    public String toDisplayString() {
        return this.name;
    }

    @Override
    public String asTypeName() {
        return this.name;
    }

    @Override
    public int valueLength() {
        return 0;
    }

    @Override
    public boolean isValue() {
        return true;
    }

    @Override
    public Object asValue(DebugContext context, DebugLocation location) {
        return this.constant;
    }

    @Override
    public DebugLocation getLocation(DebugLocation location) {
        return location;
    }

    @Override
    public DebugContext getContext(DebugContext context) {
        return context;
    }
}

