/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.debugging.data;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import java.nio.file.Path;
import java.util.List;
import org.graalvm.wasm.debugging.DebugLineMap;
import org.graalvm.wasm.debugging.DebugLocation;
import org.graalvm.wasm.debugging.data.DebugObject;
import org.graalvm.wasm.debugging.data.DebugType;
import org.graalvm.wasm.debugging.data.objects.DebugScopeValue;
import org.graalvm.wasm.debugging.parser.DebugSourceLoader;
import org.graalvm.wasm.nodes.WasmDataAccess;

public class DebugFunction
extends DebugType {
    private final String name;
    private final DebugLineMap lineMap;
    private final Path filePath;
    private final String language;
    private final int startLine;
    private SourceSection sourceSection;
    private final byte[] frameBaseExpression;
    private final List<DebugObject> variables;
    private final List<DebugObject> globals;

    public DebugFunction(String name, DebugLineMap lineMap, Path filePath, String language, int startLine, byte[] frameBaseExpression, List<DebugObject> variables, List<DebugObject> globals) {
        assert (lineMap != null) : "the source code to bytecode line map of a debug function must not be null";
        assert (frameBaseExpression != null) : "the expression for calculating the frame base of a debug function must not be null";
        assert (variables != null) : "the list of variables of a debug function must not be null";
        assert (globals != null) : "the list of globals of a debug function must not be null";
        this.name = name;
        this.lineMap = lineMap;
        this.filePath = filePath;
        this.language = language;
        this.startLine = startLine;
        this.frameBaseExpression = frameBaseExpression;
        this.variables = variables;
        this.globals = globals;
    }

    @Override
    public String asTypeName() {
        return "function";
    }

    @Override
    public int valueLength() {
        return 0;
    }

    public boolean hasGlobals() {
        return !this.globals.isEmpty();
    }

    public DebugObject globals() {
        return new DebugScopeValue("globals", this.globals);
    }

    public DebugObject locals() {
        return new DebugScopeValue("locals", this.variables);
    }

    public DebugLocation frameBaseOrNull(MaterializedFrame frame, WasmDataAccess dataAccess) {
        return DebugLocation.createFrameBaseOrNull(frame, dataAccess, this.frameBaseExpression);
    }

    public Path filePath() {
        return this.filePath;
    }

    public String language() {
        return this.language;
    }

    public boolean hasSourceSection() {
        return this.sourceSection != null;
    }

    public SourceSection getSourceSection() {
        assert (this.hasSourceSection());
        return this.sourceSection;
    }

    @CompilerDirectives.TruffleBoundary
    public SourceSection createSourceSection(TruffleLanguage.Env env) {
        Source source;
        if (this.sourceSection == null && (source = DebugSourceLoader.create(this.filePath, this.language, env)) != null) {
            this.sourceSection = source.createSection(this.startLine);
        }
        return this.sourceSection;
    }

    @CompilerDirectives.TruffleBoundary
    public SourceSection loadSourceSection(TruffleLanguage.Env env) {
        Source source = DebugSourceLoader.load(this.filePath, this.language, env);
        if (source != null) {
            SourceSection section;
            this.sourceSection = section = source.createSection(this.startLine);
            return section;
        }
        return null;
    }

    public DebugLineMap lineMap() {
        return this.lineMap;
    }

    public String name() {
        return this.name;
    }
}

