/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.constants;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.graalvm.wasm.constants.Instructions;

public class Bytecode {
    public static final int UNREACHABLE = 0;
    public static final int NOP = 1;
    public static final int SKIP_LABEL_U8 = 2;
    public static final int SKIP_LABEL_U16 = 3;
    public static final int RETURN = 4;
    public static final int LABEL_U8 = 5;
    public static final int LABEL_U16 = 6;
    public static final int LABEL_I32 = 7;
    public static final int LOOP = 8;
    public static final int IF = 9;
    public static final int SKIP_LABEL_I32 = 10;
    public static final int BR_U8 = 11;
    public static final int BR_I32 = 12;
    public static final int BR_IF_U8 = 13;
    public static final int BR_IF_I32 = 14;
    public static final int BR_TABLE_U8 = 15;
    public static final int BR_TABLE_I32 = 16;
    public static final int CALL_U8 = 17;
    public static final int CALL_I32 = 18;
    public static final int CALL_INDIRECT_U8 = 19;
    public static final int CALL_INDIRECT_I32 = 20;
    public static final int DROP = 21;
    public static final int DROP_OBJ = 22;
    public static final int SELECT = 23;
    public static final int SELECT_OBJ = 24;
    public static final int LOCAL_GET_U8 = 25;
    public static final int LOCAL_GET_I32 = 26;
    public static final int LOCAL_GET_OBJ_U8 = 27;
    public static final int LOCAL_GET_OBJ_I32 = 28;
    public static final int LOCAL_SET_U8 = 29;
    public static final int LOCAL_SET_I32 = 30;
    public static final int LOCAL_SET_OBJ_U8 = 31;
    public static final int LOCAL_SET_OBJ_I32 = 32;
    public static final int LOCAL_TEE_U8 = 33;
    public static final int LOCAL_TEE_I32 = 34;
    public static final int LOCAL_TEE_OBJ_U8 = 35;
    public static final int LOCAL_TEE_OBJ_I32 = 36;
    public static final int GLOBAL_GET_U8 = 37;
    public static final int GLOBAL_GET_I32 = 38;
    public static final int GLOBAL_SET_U8 = 39;
    public static final int GLOBAL_SET_I32 = 40;
    public static final int I32_LOAD = 41;
    public static final int I32_LOAD_U8 = 42;
    public static final int I32_LOAD_I32 = 43;
    public static final int I64_LOAD = 44;
    public static final int I64_LOAD_U8 = 45;
    public static final int I64_LOAD_I32 = 46;
    public static final int F32_LOAD = 47;
    public static final int F32_LOAD_U8 = 48;
    public static final int F32_LOAD_I32 = 49;
    public static final int F64_LOAD = 50;
    public static final int F64_LOAD_U8 = 51;
    public static final int F64_LOAD_I32 = 52;
    public static final int I32_LOAD8_S = 53;
    public static final int I32_LOAD8_S_U8 = 54;
    public static final int I32_LOAD8_S_I32 = 55;
    public static final int I32_LOAD8_U = 56;
    public static final int I32_LOAD8_U_U8 = 57;
    public static final int I32_LOAD8_U_I32 = 58;
    public static final int I32_LOAD16_S = 59;
    public static final int I32_LOAD16_S_U8 = 60;
    public static final int I32_LOAD16_S_I32 = 61;
    public static final int I32_LOAD16_U = 62;
    public static final int I32_LOAD16_U_U8 = 63;
    public static final int I32_LOAD16_U_I32 = 64;
    public static final int I64_LOAD8_S = 65;
    public static final int I64_LOAD8_S_U8 = 66;
    public static final int I64_LOAD8_S_I32 = 67;
    public static final int I64_LOAD8_U = 68;
    public static final int I64_LOAD8_U_U8 = 69;
    public static final int I64_LOAD8_U_I32 = 70;
    public static final int I64_LOAD16_S = 71;
    public static final int I64_LOAD16_S_U8 = 72;
    public static final int I64_LOAD16_S_I32 = 73;
    public static final int I64_LOAD16_U = 74;
    public static final int I64_LOAD16_U_U8 = 75;
    public static final int I64_LOAD16_U_I32 = 76;
    public static final int I64_LOAD32_S = 77;
    public static final int I64_LOAD32_S_U8 = 78;
    public static final int I64_LOAD32_S_I32 = 79;
    public static final int I64_LOAD32_U = 80;
    public static final int I64_LOAD32_U_U8 = 81;
    public static final int I64_LOAD32_U_I32 = 82;
    public static final int I32_STORE = 83;
    public static final int I32_STORE_U8 = 84;
    public static final int I32_STORE_I32 = 85;
    public static final int I64_STORE = 86;
    public static final int I64_STORE_U8 = 87;
    public static final int I64_STORE_I32 = 88;
    public static final int F32_STORE = 89;
    public static final int F32_STORE_U8 = 90;
    public static final int F32_STORE_I32 = 91;
    public static final int F64_STORE = 92;
    public static final int F64_STORE_U8 = 93;
    public static final int F64_STORE_I32 = 94;
    public static final int I32_STORE_8 = 95;
    public static final int I32_STORE_8_U8 = 96;
    public static final int I32_STORE_8_I32 = 97;
    public static final int I32_STORE_16 = 98;
    public static final int I32_STORE_16_U8 = 99;
    public static final int I32_STORE_16_I32 = 100;
    public static final int I64_STORE_8 = 101;
    public static final int I64_STORE_8_U8 = 102;
    public static final int I64_STORE_8_I32 = 103;
    public static final int I64_STORE_16 = 104;
    public static final int I64_STORE_16_U8 = 105;
    public static final int I64_STORE_16_I32 = 106;
    public static final int I64_STORE_32 = 107;
    public static final int I64_STORE_32_U8 = 108;
    public static final int I64_STORE_32_I32 = 109;
    public static final int MEMORY_SIZE = 110;
    public static final int MEMORY_GROW = 111;
    public static final int I32_CONST_I8 = 112;
    public static final int I32_CONST_I32 = 113;
    public static final int I64_CONST_I8 = 114;
    public static final int I64_CONST_I64 = 115;
    public static final int F32_CONST = 116;
    public static final int F64_CONST = 117;
    public static final int I32_EQZ = 118;
    public static final int I32_EQ = 119;
    public static final int I32_NE = 120;
    public static final int I32_LT_S = 121;
    public static final int I32_LT_U = 122;
    public static final int I32_GT_S = 123;
    public static final int I32_GT_U = 124;
    public static final int I32_LE_S = 125;
    public static final int I32_LE_U = 126;
    public static final int I32_GE_S = 127;
    public static final int I32_GE_U = 128;
    public static final int I64_EQZ = 129;
    public static final int I64_EQ = 130;
    public static final int I64_NE = 131;
    public static final int I64_LT_S = 132;
    public static final int I64_LT_U = 133;
    public static final int I64_GT_S = 134;
    public static final int I64_GT_U = 135;
    public static final int I64_LE_S = 136;
    public static final int I64_LE_U = 137;
    public static final int I64_GE_S = 138;
    public static final int I64_GE_U = 139;
    public static final int F32_EQ = 140;
    public static final int F32_NE = 141;
    public static final int F32_LT = 142;
    public static final int F32_GT = 143;
    public static final int F32_LE = 144;
    public static final int F32_GE = 145;
    public static final int F64_EQ = 146;
    public static final int F64_NE = 147;
    public static final int F64_LT = 148;
    public static final int F64_GT = 149;
    public static final int F64_LE = 150;
    public static final int F64_GE = 151;
    public static final int I32_CLZ = 152;
    public static final int I32_CTZ = 153;
    public static final int I32_POPCNT = 154;
    public static final int I32_ADD = 155;
    public static final int I32_SUB = 156;
    public static final int I32_MUL = 157;
    public static final int I32_DIV_S = 158;
    public static final int I32_DIV_U = 159;
    public static final int I32_REM_S = 160;
    public static final int I32_REM_U = 161;
    public static final int I32_AND = 162;
    public static final int I32_OR = 163;
    public static final int I32_XOR = 164;
    public static final int I32_SHL = 165;
    public static final int I32_SHR_S = 166;
    public static final int I32_SHR_U = 167;
    public static final int I32_ROTL = 168;
    public static final int I32_ROTR = 169;
    public static final int I64_CLZ = 170;
    public static final int I64_CTZ = 171;
    public static final int I64_POPCNT = 172;
    public static final int I64_ADD = 173;
    public static final int I64_SUB = 174;
    public static final int I64_MUL = 175;
    public static final int I64_DIV_S = 176;
    public static final int I64_DIV_U = 177;
    public static final int I64_REM_S = 178;
    public static final int I64_REM_U = 179;
    public static final int I64_AND = 180;
    public static final int I64_OR = 181;
    public static final int I64_XOR = 182;
    public static final int I64_SHL = 183;
    public static final int I64_SHR_S = 184;
    public static final int I64_SHR_U = 185;
    public static final int I64_ROTL = 186;
    public static final int I64_ROTR = 187;
    public static final int F32_ABS = 188;
    public static final int F32_NEG = 189;
    public static final int F32_CEIL = 190;
    public static final int F32_FLOOR = 191;
    public static final int F32_TRUNC = 192;
    public static final int F32_NEAREST = 193;
    public static final int F32_SQRT = 194;
    public static final int F32_ADD = 195;
    public static final int F32_SUB = 196;
    public static final int F32_MUL = 197;
    public static final int F32_DIV = 198;
    public static final int F32_MIN = 199;
    public static final int F32_MAX = 200;
    public static final int F32_COPYSIGN = 201;
    public static final int F64_ABS = 202;
    public static final int F64_NEG = 203;
    public static final int F64_CEIL = 204;
    public static final int F64_FLOOR = 205;
    public static final int F64_TRUNC = 206;
    public static final int F64_NEAREST = 207;
    public static final int F64_SQRT = 208;
    public static final int F64_ADD = 209;
    public static final int F64_SUB = 210;
    public static final int F64_MUL = 211;
    public static final int F64_DIV = 212;
    public static final int F64_MIN = 213;
    public static final int F64_MAX = 214;
    public static final int F64_COPYSIGN = 215;
    public static final int I32_WRAP_I64 = 216;
    public static final int I32_TRUNC_F32_S = 217;
    public static final int I32_TRUNC_F32_U = 218;
    public static final int I32_TRUNC_F64_S = 219;
    public static final int I32_TRUNC_F64_U = 220;
    public static final int I64_EXTEND_I32_S = 221;
    public static final int I64_EXTEND_I32_U = 222;
    public static final int I64_TRUNC_F32_S = 223;
    public static final int I64_TRUNC_F32_U = 224;
    public static final int I64_TRUNC_F64_S = 225;
    public static final int I64_TRUNC_F64_U = 226;
    public static final int F32_CONVERT_I32_S = 227;
    public static final int F32_CONVERT_I32_U = 228;
    public static final int F32_CONVERT_I64_S = 229;
    public static final int F32_CONVERT_I64_U = 230;
    public static final int F32_DEMOTE_F64 = 231;
    public static final int F64_CONVERT_I32_S = 232;
    public static final int F64_CONVERT_I32_U = 233;
    public static final int F64_CONVERT_I64_S = 234;
    public static final int F64_CONVERT_I64_U = 235;
    public static final int F64_PROMOTE_F32 = 236;
    public static final int I32_REINTERPRET_F32 = 237;
    public static final int I64_REINTERPRET_F64 = 238;
    public static final int F32_REINTERPRET_I32 = 239;
    public static final int F64_REINTERPRET_I64 = 240;
    public static final int I32_EXTEND8_S = 241;
    public static final int I32_EXTEND16_S = 242;
    public static final int I64_EXTEND8_S = 243;
    public static final int I64_EXTEND16_S = 244;
    public static final int I64_EXTEND32_S = 245;
    public static final int REF_NULL = 246;
    public static final int REF_IS_NULL = 247;
    public static final int REF_FUNC = 248;
    public static final int TABLE_GET = 249;
    public static final int TABLE_SET = 250;
    public static final int MISC = 251;
    public static final int ATOMIC = 252;
    public static final int VECTOR = 253;
    public static final int NOTIFY = 254;
    public static final int I32_TRUNC_SAT_F32_S = 0;
    public static final int I32_TRUNC_SAT_F32_U = 1;
    public static final int I32_TRUNC_SAT_F64_S = 2;
    public static final int I32_TRUNC_SAT_F64_U = 3;
    public static final int I64_TRUNC_SAT_F32_S = 4;
    public static final int I64_TRUNC_SAT_F32_U = 5;
    public static final int I64_TRUNC_SAT_F64_S = 6;
    public static final int I64_TRUNC_SAT_F64_U = 7;
    public static final int MEMORY_INIT = 8;
    public static final int MEMORY64_INIT = 10;
    public static final int DATA_DROP = 12;
    public static final int DATA_DROP_UNSAFE = 13;
    public static final int MEMORY_COPY = 14;
    public static final int MEMORY64_COPY_D32_S64 = 15;
    public static final int MEMORY64_COPY_D64_S32 = 16;
    public static final int MEMORY64_COPY_D64_S64 = 17;
    public static final int MEMORY_FILL = 18;
    public static final int MEMORY64_FILL = 19;
    public static final int MEMORY64_SIZE = 20;
    public static final int MEMORY64_GROW = 21;
    public static final int TABLE_INIT = 22;
    public static final int ELEM_DROP = 23;
    public static final int TABLE_COPY = 24;
    public static final int TABLE_GROW = 25;
    public static final int TABLE_SIZE = 26;
    public static final int TABLE_FILL = 27;
    public static final int ATOMIC_I32_LOAD = 0;
    public static final int ATOMIC_I64_LOAD = 1;
    public static final int ATOMIC_I32_LOAD8_U = 2;
    public static final int ATOMIC_I32_LOAD16_U = 3;
    public static final int ATOMIC_I64_LOAD8_U = 4;
    public static final int ATOMIC_I64_LOAD16_U = 5;
    public static final int ATOMIC_I64_LOAD32_U = 6;
    public static final int ATOMIC_I32_STORE = 7;
    public static final int ATOMIC_I64_STORE = 8;
    public static final int ATOMIC_I32_STORE8 = 9;
    public static final int ATOMIC_I32_STORE16 = 10;
    public static final int ATOMIC_I64_STORE8 = 11;
    public static final int ATOMIC_I64_STORE16 = 12;
    public static final int ATOMIC_I64_STORE32 = 13;
    public static final int ATOMIC_I32_RMW_ADD = 14;
    public static final int ATOMIC_I64_RMW_ADD = 15;
    public static final int ATOMIC_I32_RMW8_U_ADD = 16;
    public static final int ATOMIC_I32_RMW16_U_ADD = 17;
    public static final int ATOMIC_I64_RMW8_U_ADD = 18;
    public static final int ATOMIC_I64_RMW16_U_ADD = 19;
    public static final int ATOMIC_I64_RMW32_U_ADD = 20;
    public static final int ATOMIC_I32_RMW_SUB = 21;
    public static final int ATOMIC_I64_RMW_SUB = 22;
    public static final int ATOMIC_I32_RMW8_U_SUB = 23;
    public static final int ATOMIC_I32_RMW16_U_SUB = 24;
    public static final int ATOMIC_I64_RMW8_U_SUB = 25;
    public static final int ATOMIC_I64_RMW16_U_SUB = 26;
    public static final int ATOMIC_I64_RMW32_U_SUB = 27;
    public static final int ATOMIC_I32_RMW_AND = 28;
    public static final int ATOMIC_I64_RMW_AND = 29;
    public static final int ATOMIC_I32_RMW8_U_AND = 30;
    public static final int ATOMIC_I32_RMW16_U_AND = 31;
    public static final int ATOMIC_I64_RMW8_U_AND = 32;
    public static final int ATOMIC_I64_RMW16_U_AND = 33;
    public static final int ATOMIC_I64_RMW32_U_AND = 34;
    public static final int ATOMIC_I32_RMW_OR = 35;
    public static final int ATOMIC_I64_RMW_OR = 36;
    public static final int ATOMIC_I32_RMW8_U_OR = 37;
    public static final int ATOMIC_I32_RMW16_U_OR = 38;
    public static final int ATOMIC_I64_RMW8_U_OR = 39;
    public static final int ATOMIC_I64_RMW16_U_OR = 40;
    public static final int ATOMIC_I64_RMW32_U_OR = 41;
    public static final int ATOMIC_I32_RMW_XOR = 42;
    public static final int ATOMIC_I64_RMW_XOR = 43;
    public static final int ATOMIC_I32_RMW8_U_XOR = 44;
    public static final int ATOMIC_I32_RMW16_U_XOR = 45;
    public static final int ATOMIC_I64_RMW8_U_XOR = 46;
    public static final int ATOMIC_I64_RMW16_U_XOR = 47;
    public static final int ATOMIC_I64_RMW32_U_XOR = 48;
    public static final int ATOMIC_I32_RMW_XCHG = 49;
    public static final int ATOMIC_I64_RMW_XCHG = 50;
    public static final int ATOMIC_I32_RMW8_U_XCHG = 51;
    public static final int ATOMIC_I32_RMW16_U_XCHG = 52;
    public static final int ATOMIC_I64_RMW8_U_XCHG = 53;
    public static final int ATOMIC_I64_RMW16_U_XCHG = 54;
    public static final int ATOMIC_I64_RMW32_U_XCHG = 55;
    public static final int ATOMIC_I32_RMW_CMPXCHG = 56;
    public static final int ATOMIC_I64_RMW_CMPXCHG = 57;
    public static final int ATOMIC_I32_RMW8_U_CMPXCHG = 58;
    public static final int ATOMIC_I32_RMW16_U_CMPXCHG = 59;
    public static final int ATOMIC_I64_RMW8_U_CMPXCHG = 60;
    public static final int ATOMIC_I64_RMW16_U_CMPXCHG = 61;
    public static final int ATOMIC_I64_RMW32_U_CMPXCHG = 62;
    public static final int ATOMIC_FENCE = 63;
    public static final int ATOMIC_NOTIFY = 64;
    public static final int ATOMIC_WAIT32 = 65;
    public static final int ATOMIC_WAIT64 = 66;
    public static final int VECTOR_V128_LOAD = 0;
    public static final int VECTOR_V128_LOAD8X8_S = 1;
    public static final int VECTOR_V128_LOAD8X8_U = 2;
    public static final int VECTOR_V128_LOAD16X4_S = 3;
    public static final int VECTOR_V128_LOAD16X4_U = 4;
    public static final int VECTOR_V128_LOAD32X2_S = 5;
    public static final int VECTOR_V128_LOAD32X2_U = 6;
    public static final int VECTOR_V128_LOAD8_SPLAT = 7;
    public static final int VECTOR_V128_LOAD16_SPLAT = 8;
    public static final int VECTOR_V128_LOAD32_SPLAT = 9;
    public static final int VECTOR_V128_LOAD64_SPLAT = 10;
    public static final int VECTOR_V128_LOAD32_ZERO = 92;
    public static final int VECTOR_V128_LOAD64_ZERO = 93;
    public static final int VECTOR_V128_STORE = 11;
    public static final int VECTOR_V128_LOAD8_LANE = 84;
    public static final int VECTOR_V128_LOAD16_LANE = 85;
    public static final int VECTOR_V128_LOAD32_LANE = 86;
    public static final int VECTOR_V128_LOAD64_LANE = 87;
    public static final int VECTOR_V128_STORE8_LANE = 88;
    public static final int VECTOR_V128_STORE16_LANE = 89;
    public static final int VECTOR_V128_STORE32_LANE = 90;
    public static final int VECTOR_V128_STORE64_LANE = 91;
    public static final int VECTOR_V128_CONST = 12;
    public static final int VECTOR_I8X16_SHUFFLE = 13;
    public static final int VECTOR_I8X16_EXTRACT_LANE_S = 21;
    public static final int VECTOR_I8X16_EXTRACT_LANE_U = 22;
    public static final int VECTOR_I8X16_REPLACE_LANE = 23;
    public static final int VECTOR_I16X8_EXTRACT_LANE_S = 24;
    public static final int VECTOR_I16X8_EXTRACT_LANE_U = 25;
    public static final int VECTOR_I16X8_REPLACE_LANE = 26;
    public static final int VECTOR_I32X4_EXTRACT_LANE = 27;
    public static final int VECTOR_I32X4_REPLACE_LANE = 28;
    public static final int VECTOR_I64X2_EXTRACT_LANE = 29;
    public static final int VECTOR_I64X2_REPLACE_LANE = 30;
    public static final int VECTOR_F32X4_EXTRACT_LANE = 31;
    public static final int VECTOR_F32X4_REPLACE_LANE = 32;
    public static final int VECTOR_F64X2_EXTRACT_LANE = 33;
    public static final int VECTOR_F64X2_REPLACE_LANE = 34;
    public static final int VECTOR_I8X16_SWIZZLE = 14;
    public static final int VECTOR_I8X16_SPLAT = 15;
    public static final int VECTOR_I16X8_SPLAT = 16;
    public static final int VECTOR_I32X4_SPLAT = 17;
    public static final int VECTOR_I64X2_SPLAT = 18;
    public static final int VECTOR_F32X4_SPLAT = 19;
    public static final int VECTOR_F64X2_SPLAT = 20;
    public static final int VECTOR_I8X16_EQ = 35;
    public static final int VECTOR_I8X16_NE = 36;
    public static final int VECTOR_I8X16_LT_S = 37;
    public static final int VECTOR_I8X16_LT_U = 38;
    public static final int VECTOR_I8X16_GT_S = 39;
    public static final int VECTOR_I8X16_GT_U = 40;
    public static final int VECTOR_I8X16_LE_S = 41;
    public static final int VECTOR_I8X16_LE_U = 42;
    public static final int VECTOR_I8X16_GE_S = 43;
    public static final int VECTOR_I8X16_GE_U = 44;
    public static final int VECTOR_I16X8_EQ = 45;
    public static final int VECTOR_I16X8_NE = 46;
    public static final int VECTOR_I16X8_LT_S = 47;
    public static final int VECTOR_I16X8_LT_U = 48;
    public static final int VECTOR_I16X8_GT_S = 49;
    public static final int VECTOR_I16X8_GT_U = 50;
    public static final int VECTOR_I16X8_LE_S = 51;
    public static final int VECTOR_I16X8_LE_U = 52;
    public static final int VECTOR_I16X8_GE_S = 53;
    public static final int VECTOR_I16X8_GE_U = 54;
    public static final int VECTOR_I32X4_EQ = 55;
    public static final int VECTOR_I32X4_NE = 56;
    public static final int VECTOR_I32X4_LT_S = 57;
    public static final int VECTOR_I32X4_LT_U = 58;
    public static final int VECTOR_I32X4_GT_S = 59;
    public static final int VECTOR_I32X4_GT_U = 60;
    public static final int VECTOR_I32X4_LE_S = 61;
    public static final int VECTOR_I32X4_LE_U = 62;
    public static final int VECTOR_I32X4_GE_S = 63;
    public static final int VECTOR_I32X4_GE_U = 64;
    public static final int VECTOR_I64X2_EQ = 214;
    public static final int VECTOR_I64X2_NE = 215;
    public static final int VECTOR_I64X2_LT_S = 216;
    public static final int VECTOR_I64X2_GT_S = 217;
    public static final int VECTOR_I64X2_LE_S = 218;
    public static final int VECTOR_I64X2_GE_S = 219;
    public static final int VECTOR_F32X4_EQ = 65;
    public static final int VECTOR_F32X4_NE = 66;
    public static final int VECTOR_F32X4_LT = 67;
    public static final int VECTOR_F32X4_GT = 68;
    public static final int VECTOR_F32X4_LE = 69;
    public static final int VECTOR_F32X4_GE = 70;
    public static final int VECTOR_F64X2_EQ = 71;
    public static final int VECTOR_F64X2_NE = 72;
    public static final int VECTOR_F64X2_LT = 73;
    public static final int VECTOR_F64X2_GT = 74;
    public static final int VECTOR_F64X2_LE = 75;
    public static final int VECTOR_F64X2_GE = 76;
    public static final int VECTOR_V128_NOT = 77;
    public static final int VECTOR_V128_AND = 78;
    public static final int VECTOR_V128_ANDNOT = 79;
    public static final int VECTOR_V128_OR = 80;
    public static final int VECTOR_V128_XOR = 81;
    public static final int VECTOR_V128_BITSELECT = 82;
    public static final int VECTOR_V128_ANY_TRUE = 83;
    public static final int VECTOR_I8X16_ABS = 96;
    public static final int VECTOR_I8X16_NEG = 97;
    public static final int VECTOR_I8X16_POPCNT = 98;
    public static final int VECTOR_I8X16_ALL_TRUE = 99;
    public static final int VECTOR_I8X16_BITMASK = 100;
    public static final int VECTOR_I8X16_NARROW_I16X8_S = 101;
    public static final int VECTOR_I8X16_NARROW_I16X8_U = 102;
    public static final int VECTOR_I8X16_SHL = 107;
    public static final int VECTOR_I8X16_SHR_S = 108;
    public static final int VECTOR_I8X16_SHR_U = 109;
    public static final int VECTOR_I8X16_ADD = 110;
    public static final int VECTOR_I8X16_ADD_SAT_S = 111;
    public static final int VECTOR_I8X16_ADD_SAT_U = 112;
    public static final int VECTOR_I8X16_SUB = 113;
    public static final int VECTOR_I8X16_SUB_SAT_S = 114;
    public static final int VECTOR_I8X16_SUB_SAT_U = 115;
    public static final int VECTOR_I8X16_MIN_S = 118;
    public static final int VECTOR_I8X16_MIN_U = 119;
    public static final int VECTOR_I8X16_MAX_S = 120;
    public static final int VECTOR_I8X16_MAX_U = 121;
    public static final int VECTOR_I8X16_AVGR_U = 123;
    public static final int VECTOR_I16X8_EXTADD_PAIRWISE_I8X16_S = 124;
    public static final int VECTOR_I16X8_EXTADD_PAIRWISE_I8X16_U = 125;
    public static final int VECTOR_I16X8_ABS = 128;
    public static final int VECTOR_I16X8_NEG = 129;
    public static final int VECTOR_I16X8_Q15MULR_SAT_S = 130;
    public static final int VECTOR_I16X8_ALL_TRUE = 131;
    public static final int VECTOR_I16X8_BITMASK = 132;
    public static final int VECTOR_I16X8_NARROW_I32X4_S = 133;
    public static final int VECTOR_I16X8_NARROW_I32X4_U = 134;
    public static final int VECTOR_I16X8_EXTEND_LOW_I8X16_S = 135;
    public static final int VECTOR_I16X8_EXTEND_HIGH_I8X16_S = 136;
    public static final int VECTOR_I16X8_EXTEND_LOW_I8X16_U = 137;
    public static final int VECTOR_I16X8_EXTEND_HIGH_I8X16_U = 138;
    public static final int VECTOR_I16X8_SHL = 139;
    public static final int VECTOR_I16X8_SHR_S = 140;
    public static final int VECTOR_I16X8_SHR_U = 141;
    public static final int VECTOR_I16X8_ADD = 142;
    public static final int VECTOR_I16X8_ADD_SAT_S = 143;
    public static final int VECTOR_I16X8_ADD_SAT_U = 144;
    public static final int VECTOR_I16X8_SUB = 145;
    public static final int VECTOR_I16X8_SUB_SAT_S = 146;
    public static final int VECTOR_I16X8_SUB_SAT_U = 147;
    public static final int VECTOR_I16X8_MUL = 149;
    public static final int VECTOR_I16X8_MIN_S = 150;
    public static final int VECTOR_I16X8_MIN_U = 151;
    public static final int VECTOR_I16X8_MAX_S = 152;
    public static final int VECTOR_I16X8_MAX_U = 153;
    public static final int VECTOR_I16X8_AVGR_U = 155;
    public static final int VECTOR_I16X8_EXTMUL_LOW_I8X16_S = 156;
    public static final int VECTOR_I16X8_EXTMUL_HIGH_I8X16_S = 157;
    public static final int VECTOR_I16X8_EXTMUL_LOW_I8X16_U = 158;
    public static final int VECTOR_I16X8_EXTMUL_HIGH_I8X16_U = 159;
    public static final int VECTOR_I32X4_EXTADD_PAIRWISE_I16X8_S = 126;
    public static final int VECTOR_I32X4_EXTADD_PAIRWISE_I16X8_U = 127;
    public static final int VECTOR_I32X4_ABS = 160;
    public static final int VECTOR_I32X4_NEG = 161;
    public static final int VECTOR_I32X4_ALL_TRUE = 163;
    public static final int VECTOR_I32X4_BITMASK = 164;
    public static final int VECTOR_I32X4_EXTEND_LOW_I16X8_S = 167;
    public static final int VECTOR_I32X4_EXTEND_HIGH_I16X8_S = 168;
    public static final int VECTOR_I32X4_EXTEND_LOW_I16X8_U = 169;
    public static final int VECTOR_I32X4_EXTEND_HIGH_I16X8_U = 170;
    public static final int VECTOR_I32X4_SHL = 171;
    public static final int VECTOR_I32X4_SHR_S = 172;
    public static final int VECTOR_I32X4_SHR_U = 173;
    public static final int VECTOR_I32X4_ADD = 174;
    public static final int VECTOR_I32X4_SUB = 177;
    public static final int VECTOR_I32X4_MUL = 181;
    public static final int VECTOR_I32X4_MIN_S = 182;
    public static final int VECTOR_I32X4_MIN_U = 183;
    public static final int VECTOR_I32X4_MAX_S = 184;
    public static final int VECTOR_I32X4_MAX_U = 185;
    public static final int VECTOR_I32X4_DOT_I16X8_S = 186;
    public static final int VECTOR_I32X4_EXTMUL_LOW_I16X8_S = 188;
    public static final int VECTOR_I32X4_EXTMUL_HIGH_I16X8_S = 189;
    public static final int VECTOR_I32X4_EXTMUL_LOW_I16X8_U = 190;
    public static final int VECTOR_I32X4_EXTMUL_HIGH_I16X8_U = 191;
    public static final int VECTOR_I64X2_ABS = 192;
    public static final int VECTOR_I64X2_NEG = 193;
    public static final int VECTOR_I64X2_ALL_TRUE = 195;
    public static final int VECTOR_I64X2_BITMASK = 196;
    public static final int VECTOR_I64X2_EXTEND_LOW_I32X4_S = 199;
    public static final int VECTOR_I64X2_EXTEND_HIGH_I32X4_S = 200;
    public static final int VECTOR_I64X2_EXTEND_LOW_I32X4_U = 201;
    public static final int VECTOR_I64X2_EXTEND_HIGH_I32X4_U = 202;
    public static final int VECTOR_I64X2_SHL = 203;
    public static final int VECTOR_I64X2_SHR_S = 204;
    public static final int VECTOR_I64X2_SHR_U = 205;
    public static final int VECTOR_I64X2_ADD = 206;
    public static final int VECTOR_I64X2_SUB = 209;
    public static final int VECTOR_I64X2_MUL = 213;
    public static final int VECTOR_I64X2_EXTMUL_LOW_I32X4_S = 220;
    public static final int VECTOR_I64X2_EXTMUL_HIGH_I32X4_S = 221;
    public static final int VECTOR_I64X2_EXTMUL_LOW_I32X4_U = 222;
    public static final int VECTOR_I64X2_EXTMUL_HIGH_I32X4_U = 223;
    public static final int VECTOR_F32X4_CEIL = 103;
    public static final int VECTOR_F32X4_FLOOR = 104;
    public static final int VECTOR_F32X4_TRUNC = 105;
    public static final int VECTOR_F32X4_NEAREST = 106;
    public static final int VECTOR_F32X4_ABS = 224;
    public static final int VECTOR_F32X4_NEG = 225;
    public static final int VECTOR_F32X4_SQRT = 227;
    public static final int VECTOR_F32X4_ADD = 228;
    public static final int VECTOR_F32X4_SUB = 229;
    public static final int VECTOR_F32X4_MUL = 230;
    public static final int VECTOR_F32X4_DIV = 231;
    public static final int VECTOR_F32X4_MIN = 232;
    public static final int VECTOR_F32X4_MAX = 233;
    public static final int VECTOR_F32X4_PMIN = 234;
    public static final int VECTOR_F32X4_PMAX = 235;
    public static final int VECTOR_F64X2_CEIL = 116;
    public static final int VECTOR_F64X2_FLOOR = 117;
    public static final int VECTOR_F64X2_TRUNC = 122;
    public static final int VECTOR_F64X2_NEAREST = 148;
    public static final int VECTOR_F64X2_ABS = 236;
    public static final int VECTOR_F64X2_NEG = 237;
    public static final int VECTOR_F64X2_SQRT = 239;
    public static final int VECTOR_F64X2_ADD = 240;
    public static final int VECTOR_F64X2_SUB = 241;
    public static final int VECTOR_F64X2_MUL = 242;
    public static final int VECTOR_F64X2_DIV = 243;
    public static final int VECTOR_F64X2_MIN = 244;
    public static final int VECTOR_F64X2_MAX = 245;
    public static final int VECTOR_F64X2_PMIN = 246;
    public static final int VECTOR_F64X2_PMAX = 247;
    public static final int VECTOR_I32X4_TRUNC_SAT_F32X4_S = 248;
    public static final int VECTOR_I32X4_TRUNC_SAT_F32X4_U = 249;
    public static final int VECTOR_F32X4_CONVERT_I32X4_S = 250;
    public static final int VECTOR_F32X4_CONVERT_I32X4_U = 251;
    public static final int VECTOR_I32X4_TRUNC_SAT_F64X2_S_ZERO = 252;
    public static final int VECTOR_I32X4_TRUNC_SAT_F64X2_U_ZERO = 253;
    public static final int VECTOR_F64X2_CONVERT_LOW_I32X4_S = 254;
    public static final int VECTOR_F64X2_CONVERT_LOW_I32X4_U = 255;
    public static final int VECTOR_F32X4_DEMOTE_F64X2_ZERO = 94;
    public static final int VECTOR_F64X2_PROMOTE_LOW_F32X4 = 95;
    public static final int VECTOR_I8X16_RELAXED_SWIZZLE = 162;
    public static final int VECTOR_I32X4_RELAXED_TRUNC_F32X4_S = 165;
    public static final int VECTOR_I32X4_RELAXED_TRUNC_F32X4_U = 166;
    public static final int VECTOR_I32X4_RELAXED_TRUNC_F64X2_S_ZERO = 197;
    public static final int VECTOR_I32X4_RELAXED_TRUNC_F64X2_U_ZERO = 198;
    public static final int VECTOR_F32X4_RELAXED_MADD = 175;
    public static final int VECTOR_F32X4_RELAXED_NMADD = 176;
    public static final int VECTOR_F64X2_RELAXED_MADD = 207;
    public static final int VECTOR_F64X2_RELAXED_NMADD = 208;
    public static final int VECTOR_I8X16_RELAXED_LANESELECT = 178;
    public static final int VECTOR_I16X8_RELAXED_LANESELECT = 179;
    public static final int VECTOR_I32X4_RELAXED_LANESELECT = 210;
    public static final int VECTOR_I64X2_RELAXED_LANESELECT = 211;
    public static final int VECTOR_F32X4_RELAXED_MIN = 180;
    public static final int VECTOR_F32X4_RELAXED_MAX = 226;
    public static final int VECTOR_F64X2_RELAXED_MIN = 212;
    public static final int VECTOR_F64X2_RELAXED_MAX = 238;
    public static final int VECTOR_I16X8_RELAXED_Q15MULR_S = 154;
    public static final int VECTOR_I16X8_RELAXED_DOT_I8X16_I7X16_S = 187;
    public static final int VECTOR_I32X4_RELAXED_DOT_I8X16_I7X16_ADD_S = 194;
    public static final byte[] EMPTY_BYTES = new byte[0];
    public static final int COMMON_BYTECODE_OFFSET = 49;
    private static final byte[] VECTOR_OPCODE_TO_BYTECODE;

    public static final int vectorOpcodeToBytecode(int opcode) {
        return Byte.toUnsignedInt(VECTOR_OPCODE_TO_BYTECODE[opcode]);
    }

    static {
        try {
            int opcode;
            int maxOpcode = 0;
            for (Field f : Instructions.class.getDeclaredFields()) {
                if (!Modifier.isStatic(f.getModifiers()) || f.getType() != Integer.TYPE || !f.getName().startsWith("VECTOR_")) continue;
                opcode = f.getInt(null);
                maxOpcode = Math.max(maxOpcode, opcode);
            }
            VECTOR_OPCODE_TO_BYTECODE = new byte[maxOpcode + 1];
            for (Field f : Instructions.class.getDeclaredFields()) {
                if (!Modifier.isStatic(f.getModifiers()) || f.getType() != Integer.TYPE || !f.getName().startsWith("VECTOR_")) continue;
                opcode = f.getInt(null);
                int bytecode = Bytecode.class.getDeclaredField(f.getName()).getInt(null);
                assert (bytecode >= 0 && bytecode <= 255);
                Bytecode.VECTOR_OPCODE_TO_BYTECODE[opcode] = (byte)bytecode;
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }
}

