/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.collection;

public final class LongArrayList {
    private static final long[] EMPTY_LONG_ARRAY = new long[0];
    private long[] array = null;
    private int offset = 0;

    public void add(long n) {
        this.ensureSize();
        this.array[this.offset] = n;
        ++this.offset;
    }

    public long popBack() {
        --this.offset;
        return this.array[this.offset];
    }

    public long get(int index) {
        return this.array[index];
    }

    public int size() {
        return this.offset;
    }

    private void ensureSize() {
        if (this.array == null) {
            this.array = new long[4];
        } else if (this.offset == this.array.length) {
            long[] narray = new long[this.array.length * 2];
            System.arraycopy(this.array, 0, narray, 0, this.offset);
            this.array = narray;
        }
    }

    public long[] toArray() {
        long[] result = new long[this.offset];
        if (this.array != null) {
            System.arraycopy(this.array, 0, result, 0, this.offset);
            return result;
        }
        return EMPTY_LONG_ARRAY;
    }
}

