/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import java.util.List;
import org.graalvm.wasm.LinkAction;
import org.graalvm.wasm.RuntimeState;
import org.graalvm.wasm.WasmFunction;
import org.graalvm.wasm.WasmFunctionInstance;
import org.graalvm.wasm.WasmInstanceExports;
import org.graalvm.wasm.WasmModule;
import org.graalvm.wasm.WasmNamesObject;
import org.graalvm.wasm.WasmStore;

@ExportLibrary(value=InteropLibrary.class)
public final class WasmInstance
extends RuntimeState
implements TruffleObject {
    private List<LinkAction> linkActions;
    private static final String EXPORTS_MEMBER = "exports";

    public WasmInstance(WasmStore store, WasmModule module) {
        this(store, module, module.numFunctions(), module.droppedDataInstanceOffset());
    }

    private WasmInstance(WasmStore store, WasmModule module, int numberOfFunctions, int droppedDataInstanceAddress) {
        super(store, module, numberOfFunctions, droppedDataInstanceAddress);
    }

    public String name() {
        return this.module().name();
    }

    public WasmFunctionInstance inferEntryPoint() {
        WasmFunction mainFunction = (WasmFunction)this.symbolTable().exportedFunctions().get((Object)"_main");
        if (mainFunction != null) {
            return this.functionInstance(mainFunction);
        }
        WasmFunction startFunction = (WasmFunction)this.symbolTable().exportedFunctions().get((Object)"_start");
        if (startFunction != null) {
            return this.functionInstance(startFunction);
        }
        if (this.symbolTable().startFunction() != null) {
            return this.functionInstance(this.symbolTable().startFunction());
        }
        return null;
    }

    private void ensureLinked() {
        this.store().linker().tryLink(this);
    }

    public List<LinkAction> linkActions() {
        return this.linkActions;
    }

    public List<LinkAction> createLinkActions() {
        this.linkActions = this.module().getOrRecreateLinkActions();
        return this.linkActions;
    }

    public void addLinkAction(LinkAction action) {
        this.linkActions.add(action);
    }

    public void removeLinkActions() {
        this.linkActions = null;
    }

    @Override
    protected WasmInstance instance() {
        return this;
    }

    @ExportMessage
    boolean hasMembers() {
        return true;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    boolean isMemberReadable(String member) {
        return EXPORTS_MEMBER.equals(member);
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    Object readMember(String member) throws UnknownIdentifierException {
        if (!this.isMemberReadable(member)) {
            throw UnknownIdentifierException.create((String)member);
        }
        this.ensureLinked();
        assert (EXPORTS_MEMBER.equals(member)) : member;
        return new WasmInstanceExports(this);
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    Object getMembers(boolean includeInternal) {
        return new WasmNamesObject(new String[]{EXPORTS_MEMBER});
    }

    public String toString() {
        return "wasm-module-instance(" + this.name() + ")";
    }
}

