/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tck.impl;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.source.Source;

@TruffleLanguage.Registration(characterMimeTypes={"application/x-tck"}, id="TCK", name="TCK", version="1.0")
public final class TckLanguage
extends TruffleLanguage<TruffleLanguage.Env> {
    private static final TruffleLanguage.ContextReference<TruffleLanguage.Env> CONTEXT_REF = TruffleLanguage.ContextReference.create(TckLanguage.class);

    protected TruffleLanguage.Env createContext(TruffleLanguage.Env env) {
        return env;
    }

    protected CallTarget parse(TruffleLanguage.ParsingRequest request) throws Exception {
        RootNode root;
        Source code = request.getSource();
        String txt = code.getCharacters().toString();
        if (txt.startsWith("TCK42:")) {
            int nextColon = txt.indexOf(":", 6);
            String mimeType = txt.substring(6, nextColon);
            Source toParse = Source.newBuilder((String)code.getLanguage(), (CharSequence)txt.substring(nextColon + 1), (String)"src.tck").mimeType(mimeType).build();
            root = new MultiplyNode(this, toParse);
        } else {
            double value = Double.parseDouble(txt);
            root = RootNode.createConstantNode((Object)value);
        }
        return Truffle.getRuntime().createCallTarget(root);
    }

    public static Number expectNumber(Object o) {
        if (o instanceof Number) {
            return (Number)o;
        }
        CompilerDirectives.transferToInterpreter();
        throw new IllegalArgumentException(o + " not a Number");
    }

    public static String expectString(Object o) {
        if (o instanceof String) {
            return (String)o;
        }
        CompilerDirectives.transferToInterpreter();
        throw new IllegalArgumentException(o + " not a String");
    }

    public static TruffleObject expectTruffleObject(Object o) {
        if (o instanceof TruffleObject) {
            return (TruffleObject)o;
        }
        CompilerDirectives.transferToInterpreter();
        throw new IllegalArgumentException(o + " not a TruffleObject");
    }

    public static int checkBounds(int idx, int size) {
        if (idx < 0 || idx >= size) {
            CompilerDirectives.transferToInterpreter();
            throw new IndexOutOfBoundsException("Index: " + idx + " Size: " + size);
        }
        return idx;
    }

    @ExportLibrary(value=InteropLibrary.class)
    static final class MultiplyNode
    extends RootNode
    implements TruffleObject {
        private final Source code;

        MultiplyNode(TckLanguage language, Source toParse) {
            super((TruffleLanguage)language);
            this.code = toParse;
        }

        @ExportMessage.Ignore
        public Object execute(VirtualFrame frame) {
            TruffleLanguage.Env env = (TruffleLanguage.Env)CONTEXT_REF.get((Node)this);
            Object[] arguments = frame.getArguments();
            return this.parseAndEval(env, arguments);
        }

        @CompilerDirectives.TruffleBoundary
        private Object parseAndEval(TruffleLanguage.Env env, Object[] arguments) {
            CallTarget call;
            if (arguments.length == 0) {
                return this;
            }
            try {
                call = env.parsePublic(this.code, new String[]{(String)arguments[1], (String)arguments[2]});
            }
            catch (Exception ex) {
                throw new AssertionError("Cannot parse " + this.code, ex);
            }
            return call.call(new Object[]{6, 7});
        }

        @ExportMessage
        boolean isExecutable() {
            return true;
        }

        @ExportMessage
        Object execute(Object[] arguments) {
            return this.execute(Truffle.getRuntime().createVirtualFrame(arguments, this.getFrameDescriptor()));
        }
    }
}

