/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tck.impl;

import com.oracle.truffle.tck.impl.TruffleLanguageRunner;
import java.util.List;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.HostAccess;
import org.graalvm.polyglot.Source;
import org.graalvm.polyglot.Value;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=TruffleLanguageRunner.JavaScriptRunner.class)
public class PolyglotEngineWithJavaScript {
    private Context context;

    @Before
    public void initEngine() {
        this.context = Context.newBuilder((String[])new String[0]).allowHostAccess(HostAccess.ALL).build();
    }

    @After
    public void disposeEngine() {
        this.context.close();
    }

    @Test
    public void testCallJavaScriptFunctionFromJava() {
        this.callJavaScriptFunctionFromJava();
    }

    public void callJavaScriptFunctionFromJava() {
        Source src = Source.newBuilder((String)"js", (CharSequence)"(function (a, b) {\n  return a * b;\n})\n", (String)"mul.js").buildLiteral();
        Value jsFunction = this.context.eval(src);
        Multiplier mul = (Multiplier)jsFunction.as(Multiplier.class);
        Assert.assertEquals((long)42L, (long)mul.multiply(6, 7));
        Assert.assertEquals((long)144L, (long)mul.multiply(12, 12));
        Assert.assertEquals((long)256L, (long)mul.multiply(32, 8));
    }

    @Test
    public void testCallJavaScriptFunctionsWithSharedStateFromJava() {
        this.callJavaScriptFunctionsWithSharedStateFromJava();
    }

    public void callJavaScriptFunctionsWithSharedStateFromJava() {
        Source src = Source.newBuilder((String)"js", (CharSequence)"(function() {\n  var seconds = 0;\n  function addTime(h, m, s) {\n    seconds += 3600 * h;\n    seconds += 60 * m;\n    seconds += s;\n  }\n  function time() {\n    return seconds;\n  }\n  return {\n    'addTime': addTime,\n    'timeInSeconds': time\n  }\n})\n", (String)"CountSeconds.js").buildLiteral();
        Value jsFunction = this.context.eval(src);
        Value jsObject = jsFunction.execute(new Object[0]);
        Counter counter = (Counter)jsObject.as(Counter.class);
        counter.addTime(6, 30, 0);
        counter.addTime(9, 0, 0);
        counter.addTime(12, 5, 30);
        Assert.assertEquals((long)99330L, (long)counter.timeInSeconds());
    }

    @Test
    public void testAccessFieldsOfJavaObject() {
        this.accessFieldsOfJavaObject();
    }

    @Test
    public void testAccessFieldsOfJavaObjectWithConverter() {
        this.accessFieldsOfJavaObjectWithConverter();
    }

    public void accessFieldsOfJavaObject() {
        Source src = Source.newBuilder((String)"js", (CharSequence)"(function(t) {\n  return 3600 * t.hours + 60 * t.minutes + t.seconds;\n})\n", (String)"MomentToSeconds.js").buildLiteral();
        Moment javaMoment = new Moment(6, 30, 10);
        Value jsFunction = this.context.eval(src);
        Value jsSeconds = jsFunction.execute(new Object[]{javaMoment});
        int seconds = ((Number)jsSeconds.as(Number.class)).intValue();
        Assert.assertEquals((long)23410L, (long)seconds);
    }

    public void accessFieldsOfJavaObjectWithConverter() {
        Source src = Source.newBuilder((String)"js", (CharSequence)"(function(t) {\n  return 3600 * t.hours + 60 * t.minutes + t.seconds;\n})\n", (String)"MomentToSeconds.js").buildLiteral();
        Moment javaMoment = new Moment(6, 30, 10);
        Value jsFunction = this.context.eval(src);
        MomentConverter converter = (MomentConverter)jsFunction.as(MomentConverter.class);
        int seconds = converter.toSeconds(javaMoment);
        Assert.assertEquals((long)23410L, (long)seconds);
    }

    @Test
    public void testCreateJavaScriptFactoryForJavaClass() {
        this.createJavaScriptFactoryForJavaClass();
    }

    public void createJavaScriptFactoryForJavaClass() {
        Source src = Source.newBuilder((String)"js", (CharSequence)"(function(Moment) {\n  return function(h, m, s) {\n     return new Moment(h, m, s);\n  };\n})\n", (String)"ConstructMoment.js").buildLiteral();
        Value jsFunction = this.context.eval(src);
        Value jsFactory = jsFunction.execute(new Object[]{Moment.class});
        MomentFactory momentFactory = (MomentFactory)jsFactory.as(MomentFactory.class);
        Moment javaMoment = momentFactory.create(6, 30, 10);
        Assert.assertEquals((String)"Hours", (long)6L, (long)javaMoment.hours);
        Assert.assertEquals((String)"Minutes", (long)30L, (long)javaMoment.minutes);
        Assert.assertEquals((String)"Seconds", (long)10L, (long)javaMoment.seconds);
    }

    @Test
    public void testCallJavaScriptClassFactoryFromJava() {
        this.callJavaScriptClassFactoryFromJava();
    }

    public void callJavaScriptClassFactoryFromJava() {
        Source src = Source.newBuilder((String)"js", (CharSequence)"(function() {\n  class JSIncrementor {\n     constructor(init) {\n       this.value = init;\n     }\n     inc() {\n       return ++this.value;\n     }\n     dec() {\n       return --this.value;\n     }\n  }\n  return function(init) {\n    return new JSIncrementor(init);\n  }\n})\n", (String)"Incrementor.js").buildLiteral();
        Value jsFunction = this.context.eval(src);
        Value jsFactory = jsFunction.execute(new Object[0]);
        Incrementor initFive = (Incrementor)jsFactory.execute(new Object[]{5}).as(Incrementor.class);
        Incrementor initTen = (Incrementor)jsFactory.execute(new Object[]{10}).as(Incrementor.class);
        initFive.inc();
        Assert.assertEquals((String)"Now at seven", (long)7L, (long)initFive.inc());
        initTen.dec();
        Assert.assertEquals((String)"Now at eight", (long)8L, (long)initTen.dec());
        initTen.dec();
        Assert.assertEquals((String)"Values are the same", (long)initFive.value(), (long)initTen.value());
    }

    @Test
    public void testAccessJavaScriptArrayWithTypedElementsFromJava() {
        this.accessJavaScriptArrayWithTypedElementsFromJava();
    }

    public void accessJavaScriptArrayWithTypedElementsFromJava() {
        Source src = Source.newBuilder((String)"js", (CharSequence)"(function() {\n  class Point {\n     constructor(x, y) {\n       this.x = x;\n       this.y = y;\n     }\n  }\n  return [ new Point(30, 15), new Point(5, 7) ];\n})\n", (String)"ArrayOfPoints.js").buildLiteral();
        Value jsFunction = this.context.eval(src);
        PointProvider pointProvider = (PointProvider)jsFunction.as(PointProvider.class);
        List<Point> points = pointProvider.createPoints();
        Assert.assertEquals((String)"Two points", (long)2L, (long)points.size());
        Point first = points.get(0);
        Assert.assertEquals((long)30L, (long)first.x());
        Assert.assertEquals((long)15L, (long)first.y());
        Point second = points.get(1);
        Assert.assertEquals((long)5L, (long)second.x());
        Assert.assertEquals((long)7L, (long)second.y());
    }

    @Test
    public void tetsAccessJSONObjectProperties() {
        this.accessJavaScriptJSONObjectFromJava();
    }

    public void accessJavaScriptJSONObjectFromJava() {
        Source src = Source.newBuilder((String)"js", (CharSequence)"(function () { \n  return function() {\n    return [\n      {\n        \"id\": 6109440,\n        \"name\": \"holssewebsocket\",\n        \"owner\": {\n          \"login\": \"jersey\",\n          \"id\": 399710,\n          \"site_admin\": false\n        },\n        \"urls\": [\n          \"https://api.github.com/repos/jersey/hol\",\n          \"https://api.github.com/repos/jersey/hol/forks\",\n          \"https://api.github.com/repos/jersey/hol/teams\",\n        ],\n        \"has_wiki\": true\n      }\n    ]\n  };\n})\n", (String)"github-api-value.js").buildLiteral();
        Value jsFunction = this.context.eval(src);
        Value jsMockParser = jsFunction.execute(new Object[0]);
        ParseJSON mockParser = (ParseJSON)jsMockParser.as(ParseJSON.class);
        List<Repository> repos = mockParser.parse();
        Assert.assertEquals((String)"One repo", (long)1L, (long)repos.size());
        Assert.assertEquals((Object)"holssewebsocket", (Object)repos.get(0).name());
        Assert.assertTrue((String)"wiki", (boolean)repos.get(0).has_wiki());
        Assert.assertEquals((String)"3 urls", (long)3L, (long)repos.get(0).urls().size());
        String url1 = repos.get(0).urls().get(0);
        Assert.assertEquals((String)"1st", (Object)"https://api.github.com/repos/jersey/hol", (Object)url1);
        Owner owner = repos.get(0).owner();
        Assert.assertNotNull((String)"Owner exists", (Object)owner);
        Assert.assertEquals((String)"login", (Object)"jersey", (Object)owner.login());
        Assert.assertEquals((String)"id", (long)399710L, (long)owner.id());
        Assert.assertFalse((boolean)owner.site_admin());
    }

    @FunctionalInterface
    static interface ParseJSON {
        public List<Repository> parse();
    }

    static interface Owner {
        public int id();

        public String login();

        public boolean site_admin();
    }

    static interface Repository {
        public int id();

        public String name();

        public Owner owner();

        public boolean has_wiki();

        public List<String> urls();
    }

    @FunctionalInterface
    static interface PointProvider {
        public List<Point> createPoints();
    }

    static interface Point {
        public int x();

        public int y();
    }

    static interface Incrementor {
        public int inc();

        public int dec();

        public int value();
    }

    @FunctionalInterface
    static interface MomentFactory {
        public Moment create(int var1, int var2, int var3);
    }

    @FunctionalInterface
    static interface MomentConverter {
        public int toSeconds(Moment var1);
    }

    public static final class Moment {
        public final int hours;
        public final int minutes;
        public final int seconds;

        public Moment(int hours, int minutes, int seconds) {
            this.hours = hours;
            this.minutes = minutes;
            this.seconds = seconds;
        }
    }

    static interface Counter {
        public void addTime(int var1, int var2, int var3);

        public int timeInSeconds();
    }

    @FunctionalInterface
    static interface Multiplier {
        public int multiply(int var1, int var2);
    }
}

