/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tck;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.impl.TVMCI;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.tck.TruffleRunner;
import java.io.Closeable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.PolyglotAccess;
import org.junit.Test;
import org.junit.runners.model.FrameworkField;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;
import org.junit.runners.model.TestClass;

final class TruffleTestInvoker<C extends Closeable, T extends CallTarget>
extends TVMCI.TestAccessor<C, T> {
    static TruffleTestInvoker<?, ?> create() {
        TVMCI.Test testTvmci = (TVMCI.Test)Truffle.getRuntime().getCapability(TVMCI.Test.class);
        return new TruffleTestInvoker(testTvmci);
    }

    private TruffleTestInvoker(TVMCI.Test<C, T> testTvmci) {
        super(testTvmci);
    }

    Statement createStatement(final String testName, FrameworkMethod method, final Object test) {
        final TruffleFrameworkMethod truffleMethod = (TruffleFrameworkMethod)method;
        if (!truffleMethod.hasNodeConstructors()) {
            return null;
        }
        return new Statement(){

            public void evaluate() throws Throwable {
                try (Closeable testContext = TruffleTestInvoker.this.createTestContext(testName);){
                    RootNode[] testNodes = truffleMethod.createTestRootNodes(test);
                    ArrayList<CallTarget> callTargets = new ArrayList<CallTarget>(testNodes.length);
                    for (RootNode testNode : testNodes) {
                        if (testNode != null) {
                            callTargets.add(TruffleTestInvoker.this.createTestCallTarget(testContext, testNode));
                            continue;
                        }
                        callTargets.add(null);
                    }
                    Object[] args = callTargets.toArray();
                    for (int i = 0; i < truffleMethod.warmupIterations; ++i) {
                        truffleMethod.invokeExplosively(test, args);
                    }
                    for (CallTarget callTarget : callTargets) {
                        TruffleTestInvoker.this.finishWarmup(testContext, callTarget);
                    }
                    truffleMethod.invokeExplosively(test, args);
                }
            }
        };
    }

    static Statement withTruffleContext(TruffleRunner.RunWithPolyglotRule rule, Statement stmt) {
        return new TestStatement(rule, stmt);
    }

    private static TruffleRunner.Inject findRootNodeAnnotation(Annotation[] annotations) {
        for (Annotation a : annotations) {
            if (!(a instanceof TruffleRunner.Inject)) continue;
            return (TruffleRunner.Inject)a;
        }
        return null;
    }

    private static NodeConstructor getNodeConstructor(TruffleRunner.Inject annotation, TestClass testClass) {
        Class<? extends RootNode> nodeClass = annotation.value();
        try {
            Constructor<? extends RootNode> cons = nodeClass.getConstructor(testClass.getJavaClass());
            return obj -> {
                try {
                    return (RootNode)cons.newInstance(obj);
                }
                catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException ex) {
                    throw new AssertionError((Object)ex);
                }
            };
        }
        catch (NoSuchMethodException e) {
            try {
                Constructor<? extends RootNode> cons = nodeClass.getConstructor(new Class[0]);
                return obj -> {
                    try {
                        return (RootNode)cons.newInstance(new Object[0]);
                    }
                    catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException ex) {
                        throw new AssertionError((Object)ex);
                    }
                };
            }
            catch (NoSuchMethodException ex) {
                return null;
            }
        }
    }

    static void validateTestMethods(TestClass testClass, List<Throwable> errors) {
        List methods = testClass.getAnnotatedMethods(Test.class);
        for (FrameworkMethod method : methods) {
            method.validatePublicVoid(false, errors);
            Annotation[][] parameterAnnotations = method.getMethod().getParameterAnnotations();
            Class<?>[] parameterTypes = method.getMethod().getParameterTypes();
            for (int i = 0; i < parameterTypes.length; ++i) {
                if (parameterTypes[i] == CallTarget.class) {
                    TruffleRunner.Inject testRootNode = TruffleTestInvoker.findRootNodeAnnotation(parameterAnnotations[i]);
                    if (testRootNode == null) {
                        errors.add(new Exception("CallTarget parameter of test method " + method.getName() + " should have @Inject annotation"));
                        continue;
                    }
                    if (TruffleTestInvoker.getNodeConstructor(testRootNode, testClass) != null) continue;
                    errors.add(new Exception("Node " + testRootNode.value().getName() + " should have a default constructor or a constructor taking a " + testClass.getName()));
                    continue;
                }
                errors.add(new Exception("Invalid parameter type " + parameterTypes[i].getSimpleName() + " on test method " + method.getName()));
            }
        }
    }

    private static class TruffleFrameworkMethod
    extends FrameworkMethod {
        private final int warmupIterations;
        private final NodeConstructor[] nodeConstructors;

        TruffleFrameworkMethod(TestClass testClass, Method method) {
            super(method);
            int paramCount = method.getParameterCount();
            if (paramCount == 0) {
                this.nodeConstructors = null;
            } else {
                this.nodeConstructors = new NodeConstructor[paramCount];
                for (int i = 0; i < paramCount; ++i) {
                    TruffleRunner.Inject testRootNode = TruffleTestInvoker.findRootNodeAnnotation(method.getParameterAnnotations()[i]);
                    if (testRootNode == null) continue;
                    this.nodeConstructors[i] = TruffleTestInvoker.getNodeConstructor(testRootNode, testClass);
                }
            }
            TruffleRunner.Warmup warmup = method.getAnnotation(TruffleRunner.Warmup.class);
            this.warmupIterations = warmup != null ? warmup.value() : 3;
        }

        boolean hasNodeConstructors() {
            return this.nodeConstructors != null;
        }

        RootNode[] createTestRootNodes(Object test) {
            RootNode[] ret = new RootNode[this.nodeConstructors.length];
            for (int i = 0; i < ret.length; ++i) {
                if (this.nodeConstructors[i] == null) continue;
                ret[i] = (RootNode)this.nodeConstructors[i].apply(test);
            }
            return ret;
        }
    }

    static class TruffleTestClass
    extends TestClass {
        TruffleTestClass(Class<?> cls) {
            super(cls);
        }

        protected void scanAnnotatedMembers(Map<Class<? extends Annotation>, List<FrameworkMethod>> methodsForAnnotations, Map<Class<? extends Annotation>, List<FrameworkField>> fieldsForAnnotations) {
            super.scanAnnotatedMembers(methodsForAnnotations, fieldsForAnnotations);
            for (List<FrameworkMethod> methods : methodsForAnnotations.values()) {
                methods.replaceAll(m -> new TruffleFrameworkMethod(this, m.getMethod()));
            }
        }
    }

    private static interface NodeConstructor
    extends Function<Object, RootNode> {
    }

    private static class TestStatement
    extends Statement {
        private final TruffleRunner.RunWithPolyglotRule rule;
        private final Statement stmt;

        TestStatement(TruffleRunner.RunWithPolyglotRule rule, Statement stmt) {
            this.rule = rule;
            this.stmt = stmt;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void evaluate() throws Throwable {
            Context prevContext = this.rule.context;
            try (Context context = this.rule.contextBuilder.allowPolyglotAccess(PolyglotAccess.ALL).build();){
                this.rule.context = context;
                context.initialize("truffletestinvoker");
                context.enter();
                TruffleLanguage<?> prevLang = this.rule.testLanguage;
                TruffleLanguage.Env prevEnv = this.rule.testEnv;
                try {
                    this.rule.testLanguage = (TruffleLanguage)context.getPolyglotBindings().getMember("language").asHostObject();
                    this.rule.testEnv = (TruffleLanguage.Env)context.getPolyglotBindings().getMember("env").asHostObject();
                    this.stmt.evaluate();
                }
                catch (Throwable t) {
                    throw t;
                }
                finally {
                    this.rule.testLanguage = prevLang;
                    this.rule.testEnv = prevEnv;
                    context.leave();
                }
            }
            finally {
                this.rule.context = prevContext;
            }
        }
    }

    @TruffleLanguage.Registration(id="truffletestinvoker", name="truffletestinvoker", version="", contextPolicy=TruffleLanguage.ContextPolicy.SHARED)
    public static class TruffleTestInvokerLanguage
    extends TruffleLanguage<TruffleLanguage.Env> {
        protected TruffleLanguage.Env createContext(TruffleLanguage.Env env) {
            return env;
        }

        protected void initializeContext(TruffleLanguage.Env context) throws Exception {
            context.exportSymbol("language", context.asGuestValue((Object)this));
            context.exportSymbol("env", context.asGuestValue((Object)context));
        }

        protected boolean isThreadAccessAllowed(Thread thread, boolean singleThreaded) {
            return true;
        }
    }
}

