/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tck.instrumentation;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.impl.Accessor;
import com.oracle.truffle.api.instrumentation.EventBinding;
import com.oracle.truffle.api.instrumentation.EventContext;
import com.oracle.truffle.api.instrumentation.ExecutionEventListener;
import com.oracle.truffle.api.instrumentation.ExecutionEventNode;
import com.oracle.truffle.api.instrumentation.ExecutionEventNodeFactory;
import com.oracle.truffle.api.instrumentation.InstrumentableNode;
import com.oracle.truffle.api.instrumentation.SourceSectionFilter;
import com.oracle.truffle.api.instrumentation.StandardTags;
import com.oracle.truffle.api.instrumentation.TruffleInstrument;
import com.oracle.truffle.api.library.Library;
import com.oracle.truffle.api.nodes.ExecutableNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.NodeVisitor;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.tck.common.inline.InlineVerifier;
import java.util.function.Predicate;
import org.graalvm.polyglot.PolyglotException;
import org.graalvm.polyglot.tck.InlineSnippet;
import org.junit.Assert;

@TruffleInstrument.Registration(name="TckVerifierInstrument", id="TckVerifierInstrument", services={InlineVerifier.class})
public class VerifierInstrument
extends TruffleInstrument
implements InlineVerifier {
    private TruffleInstrument.Env env;
    private InlineScriptFactory inlineScriptFactory;
    private EventBinding<InlineScriptFactory> inlineBinding;
    private static final ThreadLocal<Boolean> ENTERED = new ThreadLocal();
    static final TruffleTCKAccessor ACCESSOR = new TruffleTCKAccessor();

    protected void onCreate(TruffleInstrument.Env instrumentEnv) {
        this.env = instrumentEnv;
        instrumentEnv.registerService((Object)this);
        instrumentEnv.getInstrumenter().attachExecutionEventListener(SourceSectionFilter.newBuilder().tagIs(new Class[]{StandardTags.RootTag.class}).build(), (ExecutionEventListener)new RootFrameChecker());
        instrumentEnv.getInstrumenter().attachExecutionEventListener(SourceSectionFilter.newBuilder().tagIs(new Class[]{StandardTags.RootTag.class}).build(), (ExecutionEventListener)new NodePropertyChecker());
        instrumentEnv.getInstrumenter().attachExecutionEventFactory(SourceSectionFilter.newBuilder().tagIs(new Class[]{StandardTags.RootTag.class}).build(), (ExecutionEventNodeFactory)new LibraryChecker());
        instrumentEnv.getInstrumenter().attachExecutionEventListener(SourceSectionFilter.newBuilder().build(), (ExecutionEventListener)new EmptyExecutionEventListener());
    }

    public void setInlineSnippet(String languageId, InlineSnippet inlineSnippet, InlineVerifier.ResultVerifier verifier) {
        if (inlineSnippet != null) {
            this.inlineScriptFactory = new InlineScriptFactory(languageId, inlineSnippet, verifier);
            this.inlineBinding = this.env.getInstrumenter().attachExecutionEventFactory(SourceSectionFilter.newBuilder().tagIs(new Class[]{StandardTags.StatementTag.class, StandardTags.CallTag.class}).build(), (ExecutionEventNodeFactory)this.inlineScriptFactory);
        } else if (this.inlineBinding != null) {
            if (!this.inlineScriptFactory.snippetExecuted) {
                Assert.fail((String)"Inline snippet was not executed.");
            }
            this.inlineBinding.dispose();
            this.inlineBinding = null;
            this.inlineScriptFactory = null;
        }
    }

    @CompilerDirectives.TruffleBoundary
    private static void leave() {
        ENTERED.set(Boolean.FALSE);
    }

    @CompilerDirectives.TruffleBoundary
    private static void enter() {
        ENTERED.set(Boolean.TRUE);
    }

    @CompilerDirectives.TruffleBoundary
    private static boolean isEntered() {
        return Boolean.TRUE == ENTERED.get();
    }

    private static class RootFrameChecker
    implements ExecutionEventListener {
        private RootFrameChecker() {
        }

        public void onEnter(EventContext context, VirtualFrame frame) {
            RootFrameChecker.checkFrameIsEmpty(context, frame.materialize());
        }

        @CompilerDirectives.TruffleBoundary
        private static void checkFrameIsEmpty(EventContext context, MaterializedFrame frame) {
            Node node = context.getInstrumentedNode();
            if (!RootFrameChecker.hasParentRootTag(node) && node.getRootNode().getFrameDescriptor() == frame.getFrameDescriptor()) {
                Object defaultValue = frame.getFrameDescriptor().getDefaultValue();
                for (int slot = 0; slot < frame.getFrameDescriptor().getNumberOfSlots(); ++slot) {
                    if (frame.isStatic(slot)) {
                        Assert.assertEquals((String)"Top-most nodes tagged with RootTag should have clean frames.", (Object)defaultValue, (Object)frame.getObjectStatic(slot));
                        Assert.assertEquals((String)"Top-most nodes tagged with RootTag should have clean frames.", (long)0L, (long)frame.getLongStatic(slot));
                        continue;
                    }
                    Assert.assertEquals((String)"Top-most nodes tagged with RootTag should have clean frames.", (Object)defaultValue, (Object)frame.getValue(slot));
                }
            }
        }

        private static boolean hasParentRootTag(Node node) {
            Node parent = node.getParent();
            if (parent == null) {
                return false;
            }
            if (parent instanceof InstrumentableNode && ((InstrumentableNode)parent).hasTag(StandardTags.RootTag.class)) {
                return true;
            }
            return RootFrameChecker.hasParentRootTag(parent);
        }

        public void onReturnValue(EventContext context, VirtualFrame frame, Object result) {
        }

        public void onReturnExceptional(EventContext context, VirtualFrame frame, Throwable exception) {
        }
    }

    private static class NodePropertyChecker
    implements ExecutionEventListener {
        private NodePropertyChecker() {
        }

        public void onEnter(EventContext context, VirtualFrame frame) {
            Node instrumentedNode = context.getInstrumentedNode();
            RootNode root = instrumentedNode.getRootNode();
            NodePropertyChecker.checkRootNames(root);
        }

        @CompilerDirectives.TruffleBoundary
        private static void checkRootNames(RootNode root) {
            Assert.assertNotNull((Object)root);
            root.getName();
            root.getQualifiedName();
        }

        public void onReturnValue(EventContext context, VirtualFrame frame, Object result) {
        }

        public void onReturnExceptional(EventContext context, VirtualFrame frame, Throwable exception) {
        }
    }

    private static class LibraryChecker
    implements ExecutionEventNodeFactory {
        private LibraryChecker() {
        }

        public ExecutionEventNode create(EventContext context) {
            return new LibraryCheckerNode(context);
        }

        private static final class LibraryCheckerNode
        extends ExecutionEventNode {
            private final EventContext context;
            @CompilerDirectives.CompilationFinal
            private boolean checked;

            LibraryCheckerNode(EventContext context) {
                this.context = context;
            }

            protected void onReturnValue(VirtualFrame frame, Object result) {
                if (!this.checked) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.checked = true;
                    this.check();
                }
            }

            protected void onReturnExceptional(VirtualFrame frame, Throwable exception) {
                if (!this.checked) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.checked = true;
                    this.check();
                }
            }

            private void check() {
                Node rootNode = this.context.getInstrumentedNode();
                new InstrumentableNodeInLibrary().visit(rootNode);
            }

            private static final class InstrumentableNodeInLibrary
            implements NodeVisitor {
                private int inLibrary;

                private InstrumentableNodeInLibrary() {
                }

                public boolean visit(Node node) {
                    this.preEnter(node);
                    this.checkInstrumentable(node);
                    NodeUtil.forEachChild((Node)node, (NodeVisitor)this);
                    this.postEnter(node);
                    return true;
                }

                private void checkInstrumentable(Node node) {
                    if (this.inLibrary > 0 && node instanceof InstrumentableNode && ((InstrumentableNode)node).isInstrumentable()) {
                        Assert.assertFalse((String)("Node \"" + String.valueOf(node) + "\" of class " + String.valueOf(node.getClass()) + " is instrumentable, but used in Library. " + String.valueOf(node.getSourceSection()) + "\nLibrary implementation nodes ought not to be instrumentable, because library may be rewritten to uncached and therefore no longer be able to be instrumented.\nInstrumentableNode.isInstrumentable() should return false in the context of a Library."), (boolean)true);
                    }
                }

                private void preEnter(Node node) {
                    if (node instanceof Library) {
                        ++this.inLibrary;
                    }
                }

                private void postEnter(Node node) {
                    if (node instanceof Library) {
                        --this.inLibrary;
                    }
                }
            }
        }
    }

    private static final class EmptyExecutionEventListener
    implements ExecutionEventListener {
        private EmptyExecutionEventListener() {
        }

        public void onEnter(EventContext context, VirtualFrame frame) {
        }

        public void onReturnValue(EventContext context, VirtualFrame frame, Object result) {
        }

        public void onReturnExceptional(EventContext context, VirtualFrame frame, Throwable exception) {
        }
    }

    private class InlineScriptFactory
    implements ExecutionEventNodeFactory {
        private final Source snippet;
        private final Predicate<org.graalvm.polyglot.SourceSection> predicate;
        private final InlineVerifier.ResultVerifier resultVerifier;
        volatile boolean snippetExecuted = false;

        InlineScriptFactory(String languageId, InlineSnippet inlineSnippet, InlineVerifier.ResultVerifier verifier) {
            CharSequence code = inlineSnippet.getCode();
            this.snippet = Source.newBuilder((String)languageId, (CharSequence)code, (String)"inline_source").build();
            this.predicate = inlineSnippet.getLocationPredicate();
            this.resultVerifier = verifier;
        }

        public ExecutionEventNode create(EventContext context) {
            if (!VerifierInstrument.isEntered() && (this.predicate == null || this.canRunAt(context.getInstrumentedSourceSection()))) {
                return new InlineScriptNode(context);
            }
            return null;
        }

        private boolean canRunAt(SourceSection ss) {
            org.graalvm.polyglot.SourceSection section = (org.graalvm.polyglot.SourceSection)TruffleTCKAccessor.instrumentAccess().createPolyglotSourceSection((Object)VerifierInstrument.this.env, null, ss);
            return this.predicate.test(section);
        }

        private class InlineScriptNode
        extends ExecutionEventNode {
            private final Node instrumentedNode;
            @CompilerDirectives.CompilationFinal
            private volatile ExecutableNode inlineNode;

            InlineScriptNode(EventContext context) {
                this.instrumentedNode = context.getInstrumentedNode();
            }

            protected void onEnter(VirtualFrame frame) {
                this.executeSnippet(frame);
            }

            protected void onReturnValue(VirtualFrame frame, Object result) {
                this.executeSnippet(frame);
            }

            protected void onReturnExceptional(VirtualFrame frame, Throwable exception) {
                this.executeSnippet(frame);
            }

            private void executeSnippet(VirtualFrame frame) {
                if (this.inlineNode == null) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    try {
                        this.inlineNode = VerifierInstrument.this.env.parseInline(InlineScriptFactory.this.snippet, this.instrumentedNode, frame.materialize());
                    }
                    catch (ThreadDeath t) {
                        throw t;
                    }
                    catch (Throwable t) {
                        this.verify(t);
                        throw t;
                    }
                    this.insert((Node)this.inlineNode);
                    InlineScriptFactory.this.snippetExecuted = true;
                }
                VerifierInstrument.enter();
                try {
                    Object ret = this.inlineNode.execute(frame);
                    if (InlineScriptFactory.this.resultVerifier != null) {
                        this.verify(ret);
                    }
                }
                catch (ThreadDeath t) {
                    throw t;
                }
                catch (Throwable t) {
                    CompilerDirectives.transferToInterpreter();
                    this.verify(t);
                    throw t;
                }
                finally {
                    VerifierInstrument.leave();
                }
            }

            @CompilerDirectives.TruffleBoundary
            private void verify(Throwable exception) {
                PolyglotException pe = (PolyglotException)TruffleTCKAccessor.engineAccess().wrapGuestException(InlineScriptFactory.this.snippet.getLanguage(), exception);
                InlineScriptFactory.this.resultVerifier.verify(pe);
            }

            @CompilerDirectives.TruffleBoundary
            private void verify(Object result) {
                InlineScriptFactory.this.resultVerifier.verify(result);
            }
        }
    }

    static final class TruffleTCKAccessor
    extends Accessor {
        TruffleTCKAccessor() {
        }

        static Accessor.EngineSupport engineAccess() {
            return ACCESSOR.engineSupport();
        }

        static Accessor.NodeSupport nodesAccess() {
            return ACCESSOR.nodeSupport();
        }

        static Accessor.InstrumentSupport instrumentAccess() {
            return ACCESSOR.instrumentSupport();
        }
    }
}

