/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.sl.parser;

import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.FrameSlotKind;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.sl.SLLanguage;
import com.oracle.truffle.sl.nodes.SLAstRootNode;
import com.oracle.truffle.sl.nodes.SLExpressionNode;
import com.oracle.truffle.sl.nodes.SLStatementNode;
import com.oracle.truffle.sl.nodes.controlflow.SLBlockNode;
import com.oracle.truffle.sl.nodes.controlflow.SLBreakNode;
import com.oracle.truffle.sl.nodes.controlflow.SLContinueNode;
import com.oracle.truffle.sl.nodes.controlflow.SLDebuggerNode;
import com.oracle.truffle.sl.nodes.controlflow.SLFunctionBodyNode;
import com.oracle.truffle.sl.nodes.controlflow.SLIfNode;
import com.oracle.truffle.sl.nodes.controlflow.SLReturnNode;
import com.oracle.truffle.sl.nodes.controlflow.SLWhileNode;
import com.oracle.truffle.sl.nodes.expression.SLAddNodeGen;
import com.oracle.truffle.sl.nodes.expression.SLBigIntegerLiteralNode;
import com.oracle.truffle.sl.nodes.expression.SLDivNodeGen;
import com.oracle.truffle.sl.nodes.expression.SLEqualNodeGen;
import com.oracle.truffle.sl.nodes.expression.SLFunctionLiteralNodeGen;
import com.oracle.truffle.sl.nodes.expression.SLInvokeNode;
import com.oracle.truffle.sl.nodes.expression.SLLessOrEqualNodeGen;
import com.oracle.truffle.sl.nodes.expression.SLLessThanNodeGen;
import com.oracle.truffle.sl.nodes.expression.SLLogicalAndNode;
import com.oracle.truffle.sl.nodes.expression.SLLogicalNotNodeGen;
import com.oracle.truffle.sl.nodes.expression.SLLogicalOrNode;
import com.oracle.truffle.sl.nodes.expression.SLLongLiteralNode;
import com.oracle.truffle.sl.nodes.expression.SLMulNodeGen;
import com.oracle.truffle.sl.nodes.expression.SLParenExpressionNode;
import com.oracle.truffle.sl.nodes.expression.SLReadPropertyNode;
import com.oracle.truffle.sl.nodes.expression.SLReadPropertyNodeGen;
import com.oracle.truffle.sl.nodes.expression.SLStringLiteralNode;
import com.oracle.truffle.sl.nodes.expression.SLSubNodeGen;
import com.oracle.truffle.sl.nodes.expression.SLWritePropertyNodeGen;
import com.oracle.truffle.sl.nodes.local.SLReadArgumentNode;
import com.oracle.truffle.sl.nodes.local.SLReadLocalVariableNodeGen;
import com.oracle.truffle.sl.nodes.local.SLWriteLocalVariableNode;
import com.oracle.truffle.sl.nodes.local.SLWriteLocalVariableNodeGen;
import com.oracle.truffle.sl.nodes.util.SLUnboxNode;
import com.oracle.truffle.sl.nodes.util.SLUnboxNodeGen;
import com.oracle.truffle.sl.parser.SLBaseParser;
import com.oracle.truffle.sl.parser.SimpleLanguageBaseVisitor;
import com.oracle.truffle.sl.parser.SimpleLanguageParser;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.RuleNode;
import org.antlr.v4.runtime.tree.TerminalNode;

public class SLNodeParser
extends SLBaseParser {
    private FrameDescriptor.Builder frameDescriptorBuilder;
    private SLStatementVisitor statementVisitor = new SLStatementVisitor();
    private SLExpressionVisitor expressionVisitor = new SLExpressionVisitor();
    private int loopDepth = 0;
    private final Map<TruffleString, RootCallTarget> functions = new HashMap<TruffleString, RootCallTarget>();

    public static Map<TruffleString, RootCallTarget> parseSL(SLLanguage language, Source source) {
        SLNodeParser visitor = new SLNodeParser(language, source);
        SLNodeParser.parseSLImpl(source, visitor);
        return visitor.functions;
    }

    protected SLNodeParser(SLLanguage language, Source source) {
        super(language, source);
    }

    @Override
    public Void visitFunction(SimpleLanguageParser.FunctionContext ctx) {
        Token nameToken = ctx.IDENTIFIER(0).getSymbol();
        TruffleString functionName = this.asTruffleString(nameToken, false);
        int functionStartPos = nameToken.getStartIndex();
        this.frameDescriptorBuilder = FrameDescriptor.newBuilder();
        ArrayList<SLStatementNode> methodNodes = new ArrayList<SLStatementNode>();
        int parameterCount = this.enterFunction(ctx).size();
        for (int i = 0; i < parameterCount; ++i) {
            Token paramToken = ctx.IDENTIFIER(i + 1).getSymbol();
            TruffleString paramName = this.asTruffleString(paramToken, false);
            int localIndex = this.frameDescriptorBuilder.addSlot(FrameSlotKind.Illegal, (Object)paramName, null);
            assert (localIndex == i);
            SLReadArgumentNode readArg = new SLReadArgumentNode(i);
            readArg.setSourceSection(paramToken.getStartIndex(), paramToken.getText().length());
            SLExpressionNode assignment = this.createAssignment(this.createString(paramToken, false), readArg, i);
            methodNodes.add(assignment);
        }
        SLBlockNode bodyNode = (SLBlockNode)this.statementVisitor.visitBlock(ctx.body);
        this.exitFunction();
        methodNodes.addAll(bodyNode.getStatements());
        int bodyEndPos = bodyNode.getSourceEndIndex();
        SourceSection functionSrc = this.source.createSection(functionStartPos, bodyEndPos - functionStartPos);
        SLBlockNode methodBlock = new SLBlockNode(methodNodes.toArray(new SLStatementNode[methodNodes.size()]));
        methodBlock.setSourceSection(functionStartPos, bodyEndPos - functionStartPos);
        SLFunctionBodyNode functionBodyNode = new SLFunctionBodyNode(methodBlock);
        functionBodyNode.setSourceSection(functionSrc.getCharIndex(), functionSrc.getCharLength());
        SLAstRootNode rootNode = new SLAstRootNode(this.language, this.frameDescriptorBuilder.build(), functionBodyNode, functionSrc, functionName);
        this.functions.put(functionName, rootNode.getCallTarget());
        this.frameDescriptorBuilder = null;
        return null;
    }

    private SLStringLiteralNode createString(Token name, boolean removeQuotes) {
        SLStringLiteralNode node = new SLStringLiteralNode(this.asTruffleString(name, removeQuotes));
        node.setSourceSection(name.getStartIndex(), name.getStopIndex() - name.getStartIndex() + 1);
        return node;
    }

    private SLExpressionNode createRead(SLExpressionNode nameTerm) {
        TruffleString name = ((SLStringLiteralNode)nameTerm).executeGeneric(null);
        int frameSlot = this.getLocalIndex(name);
        SLExpressionNode result = frameSlot != -1 ? SLReadLocalVariableNodeGen.create(frameSlot) : SLFunctionLiteralNodeGen.create(new SLStringLiteralNode(name));
        result.setSourceSection(nameTerm.getSourceCharIndex(), nameTerm.getSourceLength());
        result.addExpressionTag();
        return result;
    }

    private SLExpressionNode createAssignment(SLStringLiteralNode assignmentName, SLExpressionNode valueNode, Integer index) {
        TruffleString name = assignmentName.executeGeneric(null);
        int frameSlot = this.getLocalIndex(name);
        assert (frameSlot != -1);
        boolean newVariable = this.initializeLocal(name);
        SLWriteLocalVariableNode result = SLWriteLocalVariableNodeGen.create(valueNode, frameSlot, assignmentName, newVariable);
        assert (index != null || valueNode.hasSource());
        if (valueNode.hasSource()) {
            int start = assignmentName.getSourceCharIndex();
            int length = valueNode.getSourceEndIndex() - start;
            result.setSourceSection(start, length);
        }
        if (index == null) {
            result.addExpressionTag();
        }
        return result;
    }

    private static boolean isHaltInCondition(SLStatementNode statement) {
        return statement instanceof SLIfNode || statement instanceof SLWhileNode;
    }

    private static void srcFromToken(SLStatementNode node, Token token) {
        node.setSourceSection(token.getStartIndex(), token.getText().length());
    }

    private class SLStatementVisitor
    extends SimpleLanguageBaseVisitor<SLStatementNode> {
        private SLStatementVisitor() {
        }

        @Override
        public SLStatementNode visitBlock(SimpleLanguageParser.BlockContext ctx) {
            List<TruffleString> newLocals = SLNodeParser.this.enterBlock(ctx);
            for (TruffleString newLocal : newLocals) {
                SLNodeParser.this.frameDescriptorBuilder.addSlot(FrameSlotKind.Illegal, (Object)newLocal, null);
            }
            int startPos = ctx.s.getStartIndex();
            int endPos = ctx.e.getStopIndex() + 1;
            ArrayList<SLStatementNode> bodyNodes = new ArrayList<SLStatementNode>();
            for (SimpleLanguageParser.StatementContext child : ctx.statement()) {
                bodyNodes.add(this.visitStatement(child));
            }
            SLNodeParser.this.exitBlock();
            ArrayList<SLStatementNode> flattenedNodes = new ArrayList<SLStatementNode>(bodyNodes.size());
            this.flattenBlocks(bodyNodes, flattenedNodes);
            int n = flattenedNodes.size();
            for (int i = 0; i < n; ++i) {
                SLStatementNode statement = (SLStatementNode)((Object)flattenedNodes.get(i));
                if (!statement.hasSource() || SLNodeParser.isHaltInCondition(statement)) continue;
                statement.addStatementTag();
            }
            SLBlockNode blockNode = new SLBlockNode(flattenedNodes.toArray(new SLStatementNode[flattenedNodes.size()]));
            blockNode.setSourceSection(startPos, endPos - startPos);
            return blockNode;
        }

        private void flattenBlocks(Iterable<? extends SLStatementNode> bodyNodes, List<SLStatementNode> flattenedNodes) {
            for (SLStatementNode sLStatementNode : bodyNodes) {
                if (sLStatementNode instanceof SLBlockNode) {
                    this.flattenBlocks(((SLBlockNode)sLStatementNode).getStatements(), flattenedNodes);
                    continue;
                }
                flattenedNodes.add(sLStatementNode);
            }
        }

        @Override
        public SLStatementNode visitDebugger_statement(SimpleLanguageParser.Debugger_statementContext ctx) {
            SLDebuggerNode debuggerNode = new SLDebuggerNode();
            SLNodeParser.srcFromToken(debuggerNode, ctx.d);
            return debuggerNode;
        }

        @Override
        public SLStatementNode visitBreak_statement(SimpleLanguageParser.Break_statementContext ctx) {
            if (SLNodeParser.this.loopDepth == 0) {
                SLNodeParser.this.semErr(ctx.b, "break used outside of loop");
            }
            SLBreakNode breakNode = new SLBreakNode();
            SLNodeParser.srcFromToken(breakNode, ctx.b);
            return breakNode;
        }

        @Override
        public SLStatementNode visitContinue_statement(SimpleLanguageParser.Continue_statementContext ctx) {
            if (SLNodeParser.this.loopDepth == 0) {
                SLNodeParser.this.semErr(ctx.c, "continue used outside of loop");
            }
            SLContinueNode continueNode = new SLContinueNode();
            SLNodeParser.srcFromToken(continueNode, ctx.c);
            return continueNode;
        }

        @Override
        public SLStatementNode visitWhile_statement(SimpleLanguageParser.While_statementContext ctx) {
            SLExpressionNode conditionNode = SLNodeParser.this.expressionVisitor.visitExpression(ctx.condition);
            ++SLNodeParser.this.loopDepth;
            SLStatementNode bodyNode = this.visitBlock(ctx.body);
            --SLNodeParser.this.loopDepth;
            conditionNode.addStatementTag();
            int start = ctx.w.getStartIndex();
            int end = bodyNode.getSourceEndIndex();
            SLWhileNode whileNode = new SLWhileNode(conditionNode, bodyNode);
            whileNode.setSourceSection(start, end - start);
            return whileNode;
        }

        @Override
        public SLStatementNode visitIf_statement(SimpleLanguageParser.If_statementContext ctx) {
            SLExpressionNode conditionNode = SLNodeParser.this.expressionVisitor.visitExpression(ctx.condition);
            SLStatementNode thenPartNode = this.visitBlock(ctx.then);
            SLStatementNode elsePartNode = ctx.alt == null ? null : this.visitBlock(ctx.alt);
            conditionNode.addStatementTag();
            int start = ctx.i.getStartIndex();
            int end = elsePartNode == null ? thenPartNode.getSourceEndIndex() : elsePartNode.getSourceEndIndex();
            SLIfNode ifNode = new SLIfNode(conditionNode, thenPartNode, elsePartNode);
            ifNode.setSourceSection(start, end - start);
            return ifNode;
        }

        @Override
        public SLStatementNode visitReturn_statement(SimpleLanguageParser.Return_statementContext ctx) {
            SLExpressionNode valueNode = ctx.expression() != null ? SLNodeParser.this.expressionVisitor.visitExpression(ctx.expression()) : null;
            int start = ctx.r.getStartIndex();
            int length = valueNode == null ? ctx.r.getText().length() : valueNode.getSourceEndIndex() - start;
            SLReturnNode returnNode = new SLReturnNode(valueNode);
            returnNode.setSourceSection(start, length);
            return returnNode;
        }

        @Override
        public SLStatementNode visitStatement(SimpleLanguageParser.StatementContext ctx) {
            return (SLStatementNode)((Object)this.visit(ctx.getChild(0)));
        }

        @Override
        public SLStatementNode visitExpression_statement(SimpleLanguageParser.Expression_statementContext ctx) {
            return SLNodeParser.this.expressionVisitor.visitExpression(ctx.expression());
        }

        public SLStatementNode visitChildren(RuleNode arg0) {
            throw new UnsupportedOperationException("node: " + arg0.getClass().getSimpleName());
        }
    }

    private class SLExpressionVisitor
    extends SimpleLanguageBaseVisitor<SLExpressionNode> {
        private SLExpressionVisitor() {
        }

        @Override
        public SLExpressionNode visitExpression(SimpleLanguageParser.ExpressionContext ctx) {
            return this.createBinary(ctx.logic_term(), ctx.OP_OR());
        }

        @Override
        public SLExpressionNode visitLogic_term(SimpleLanguageParser.Logic_termContext ctx) {
            return this.createBinary(ctx.logic_factor(), ctx.OP_AND());
        }

        @Override
        public SLExpressionNode visitLogic_factor(SimpleLanguageParser.Logic_factorContext ctx) {
            return this.createBinary(ctx.arithmetic(), ctx.OP_COMPARE());
        }

        @Override
        public SLExpressionNode visitArithmetic(SimpleLanguageParser.ArithmeticContext ctx) {
            return this.createBinary(ctx.term(), ctx.OP_ADD());
        }

        @Override
        public SLExpressionNode visitTerm(SimpleLanguageParser.TermContext ctx) {
            return this.createBinary(ctx.factor(), ctx.OP_MUL());
        }

        private SLExpressionNode createBinary(List<? extends ParserRuleContext> children, TerminalNode op) {
            if (op == null) {
                assert (children.size() == 1);
                return (SLExpressionNode)((Object)this.visit((ParseTree)children.get(0)));
            }
            assert (children.size() == 2);
            return this.createBinary(op.getSymbol(), (SLExpressionNode)((Object)this.visit((ParseTree)children.get(0))), (SLExpressionNode)((Object)this.visit((ParseTree)children.get(1))));
        }

        private SLExpressionNode createBinary(List<? extends ParserRuleContext> children, List<TerminalNode> ops) {
            assert (children.size() == ops.size() + 1);
            SLExpressionNode result = (SLExpressionNode)((Object)this.visit((ParseTree)children.get(0)));
            for (int i = 0; i < ops.size(); ++i) {
                result = this.createBinary(ops.get(i).getSymbol(), result, (SLExpressionNode)((Object)this.visit((ParseTree)children.get(i + 1))));
            }
            return result;
        }

        private SLExpressionNode createBinary(Token opToken, SLExpressionNode leftNode, SLExpressionNode rightNode) {
            SLUnboxNode leftUnboxed = SLUnboxNodeGen.create(leftNode);
            SLUnboxNode rightUnboxed = SLUnboxNodeGen.create(rightNode);
            SLExpressionNode result = switch (opToken.getText()) {
                case "+" -> SLAddNodeGen.create(leftUnboxed, rightUnboxed);
                case "*" -> SLMulNodeGen.create(leftUnboxed, rightUnboxed);
                case "/" -> SLDivNodeGen.create(leftUnboxed, rightUnboxed);
                case "-" -> SLSubNodeGen.create(leftUnboxed, rightUnboxed);
                case "<" -> SLLessThanNodeGen.create(leftUnboxed, rightUnboxed);
                case "<=" -> SLLessOrEqualNodeGen.create(leftUnboxed, rightUnboxed);
                case ">" -> SLLogicalNotNodeGen.create(SLLessOrEqualNodeGen.create(leftUnboxed, rightUnboxed));
                case ">=" -> SLLogicalNotNodeGen.create(SLLessThanNodeGen.create(leftUnboxed, rightUnboxed));
                case "==" -> SLEqualNodeGen.create(leftUnboxed, rightUnboxed);
                case "!=" -> SLLogicalNotNodeGen.create(SLEqualNodeGen.create(leftUnboxed, rightUnboxed));
                case "&&" -> new SLLogicalAndNode(leftUnboxed, rightUnboxed);
                case "||" -> new SLLogicalOrNode(leftUnboxed, rightUnboxed);
                default -> throw new RuntimeException("unexpected operation: " + opToken.getText());
            };
            int start = leftNode.getSourceCharIndex();
            int length = rightNode.getSourceEndIndex() - start;
            result.setSourceSection(start, length);
            result.addExpressionTag();
            return result;
        }

        @Override
        public SLExpressionNode visitNameAccess(SimpleLanguageParser.NameAccessContext ctx) {
            if (ctx.member_expression().isEmpty()) {
                return SLNodeParser.this.createRead(SLNodeParser.this.createString(ctx.IDENTIFIER().getSymbol(), false));
            }
            MemberExpressionVisitor visitor = new MemberExpressionVisitor(null, null, SLNodeParser.this.createString(ctx.IDENTIFIER().getSymbol(), false));
            for (SimpleLanguageParser.Member_expressionContext child : ctx.member_expression()) {
                visitor.visit((ParseTree)child);
            }
            return visitor.receiver;
        }

        @Override
        public SLExpressionNode visitStringLiteral(SimpleLanguageParser.StringLiteralContext ctx) {
            return SLNodeParser.this.createString(ctx.STRING_LITERAL().getSymbol(), true);
        }

        @Override
        public SLExpressionNode visitNumericLiteral(SimpleLanguageParser.NumericLiteralContext ctx) {
            SLExpressionNode result;
            Token literalToken = ctx.NUMERIC_LITERAL().getSymbol();
            try {
                result = new SLLongLiteralNode(Long.parseLong(literalToken.getText()));
            }
            catch (NumberFormatException ex) {
                result = new SLBigIntegerLiteralNode(new BigInteger(literalToken.getText()));
            }
            SLNodeParser.srcFromToken(result, literalToken);
            result.addExpressionTag();
            return result;
        }

        @Override
        public SLExpressionNode visitParenExpression(SimpleLanguageParser.ParenExpressionContext ctx) {
            SLExpressionNode expressionNode = this.visitExpression(ctx.expression());
            if (expressionNode == null) {
                return null;
            }
            int start = ctx.start.getStartIndex();
            int length = ctx.stop.getStopIndex() - start + 1;
            SLParenExpressionNode result = new SLParenExpressionNode(expressionNode);
            result.setSourceSection(start, length);
            return result;
        }
    }

    private class MemberExpressionVisitor
    extends SimpleLanguageBaseVisitor<SLExpressionNode> {
        SLExpressionNode receiver;
        private SLExpressionNode assignmentReceiver;
        private SLExpressionNode assignmentName;

        MemberExpressionVisitor(SLExpressionNode r, SLExpressionNode assignmentReceiver, SLExpressionNode assignmentName) {
            this.receiver = r;
            this.assignmentReceiver = assignmentReceiver;
            this.assignmentName = assignmentName;
        }

        @Override
        public SLExpressionNode visitMemberCall(SimpleLanguageParser.MemberCallContext ctx) {
            ArrayList<SLExpressionNode> parameters = new ArrayList<SLExpressionNode>();
            if (this.receiver == null) {
                this.receiver = SLNodeParser.this.createRead(this.assignmentName);
            }
            for (SimpleLanguageParser.ExpressionContext child : ctx.expression()) {
                parameters.add(SLNodeParser.this.expressionVisitor.visitExpression(child));
            }
            SLInvokeNode result = new SLInvokeNode(this.receiver, parameters.toArray(new SLExpressionNode[parameters.size()]));
            int startPos = this.receiver.getSourceCharIndex();
            int endPos = ctx.stop.getStopIndex() + 1;
            result.setSourceSection(startPos, endPos - startPos);
            result.addExpressionTag();
            this.assignmentReceiver = this.receiver;
            this.receiver = result;
            this.assignmentName = null;
            return result;
        }

        @Override
        public SLExpressionNode visitMemberAssign(SimpleLanguageParser.MemberAssignContext ctx) {
            SLExpressionNode result;
            if (this.assignmentName == null) {
                SLNodeParser.this.semErr(ctx.expression().start, "invalid assignment target");
                result = null;
            } else if (this.assignmentReceiver == null) {
                SLExpressionNode valueNode = SLNodeParser.this.expressionVisitor.visitExpression(ctx.expression());
                result = SLNodeParser.this.createAssignment((SLStringLiteralNode)this.assignmentName, valueNode, null);
            } else {
                SLExpressionNode valueNode = SLNodeParser.this.expressionVisitor.visitExpression(ctx.expression());
                result = SLWritePropertyNodeGen.create(this.assignmentReceiver, this.assignmentName, valueNode);
                int start = this.assignmentReceiver.getSourceCharIndex();
                int length = valueNode.getSourceEndIndex() - start;
                result.setSourceSection(start, length);
                result.addExpressionTag();
            }
            this.assignmentReceiver = this.receiver;
            this.receiver = result;
            this.assignmentName = null;
            return result;
        }

        @Override
        public SLExpressionNode visitMemberField(SimpleLanguageParser.MemberFieldContext ctx) {
            if (this.receiver == null) {
                this.receiver = SLNodeParser.this.createRead(this.assignmentName);
            }
            SLStringLiteralNode nameNode = SLNodeParser.this.createString(ctx.IDENTIFIER().getSymbol(), false);
            this.assignmentName = nameNode;
            SLReadPropertyNode result = SLReadPropertyNodeGen.create(this.receiver, nameNode);
            int startPos = this.receiver.getSourceCharIndex();
            int endPos = nameNode.getSourceEndIndex();
            result.setSourceSection(startPos, endPos - startPos);
            result.addExpressionTag();
            this.assignmentReceiver = this.receiver;
            this.receiver = result;
            return result;
        }

        @Override
        public SLExpressionNode visitMemberIndex(SimpleLanguageParser.MemberIndexContext ctx) {
            SLExpressionNode nameNode;
            if (this.receiver == null) {
                this.receiver = SLNodeParser.this.createRead(this.assignmentName);
            }
            this.assignmentName = nameNode = SLNodeParser.this.expressionVisitor.visitExpression(ctx.expression());
            SLReadPropertyNode result = SLReadPropertyNodeGen.create(this.receiver, nameNode);
            int startPos = this.receiver.getSourceCharIndex();
            int endPos = nameNode.getSourceEndIndex();
            result.setSourceSection(startPos, endPos - startPos);
            result.addExpressionTag();
            this.assignmentReceiver = this.receiver;
            this.receiver = result;
            return result;
        }
    }
}

