/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.sl.nodes.expression;

import com.oracle.truffle.api.bytecode.OperationProxy;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.sl.SLLanguage;
import com.oracle.truffle.sl.nodes.SLExpressionNode;
import com.oracle.truffle.sl.runtime.SLContext;
import com.oracle.truffle.sl.runtime.SLFunction;

@NodeInfo(shortName="func")
@NodeChild(value="functionName")
@OperationProxy.Proxyable(allowUncached=true)
public abstract class SLFunctionLiteralNode
extends SLExpressionNode {
    @Specialization
    public static SLFunction perform(TruffleString functionName, @Bind Node node, @Cached(value="lookupFunctionCached(functionName, node)", uncached="lookupFunction(functionName, node)") SLFunction result) {
        if (result == null) {
            return SLFunctionLiteralNode.lookupFunction(functionName, node);
        }
        assert (result.getName().equals((Object)functionName)) : "function name should be compilation constant";
        return result;
    }

    public static SLFunction lookupFunction(TruffleString functionName, Node node) {
        return SLContext.get(node).getFunctionRegistry().lookup(functionName, true);
    }

    public static SLFunction lookupFunctionCached(TruffleString functionName, Node node) {
        if (SLLanguage.get(node).isSingleContext()) {
            return SLFunctionLiteralNode.lookupFunction(functionName, node);
        }
        return null;
    }
}

